/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui;

import edu.geophys.commons.ui.AbstractPainter;
import edu.geophys.commons.util.SwingUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.apache.log4j.Logger;

public abstract class AbstractBufferedPainter<T>
extends AbstractPainter<T> {
    static Logger logger = Logger.getLogger(AbstractBufferedPainter.class);
    private boolean useBackBufffer = true;
    private BufferedImage backBuffer = null;
    private int backBufferTransparency = 2;
    private boolean bufferInvalid = true;

    @Override
    public void setModel(T t) {
        super.setModel(t);
        this.invalidateBuffer();
    }

    @Override
    public void setRenderQuality(SwingUtil.RenderQuality renderQuality) {
        super.setRenderQuality(renderQuality);
        this.setBackBufferAlpha(renderQuality.isAntialiasing());
        this.invalidateBuffer();
    }

    protected void setBackBufferAlpha(boolean bl) {
        this.backBufferTransparency = bl ? 3 : 2;
        this.invalidateBuffer();
    }

    @Override
    protected final void preparePaint(Graphics2D graphics2D, int n, int n2, int n3, int n4, T t) {
        if (this.useBackBufffer) {
            if (this.bufferInvalid || n3 != this.backBuffer.getWidth() || n4 != this.backBuffer.getHeight()) {
                this.backBuffer = graphics2D.getDeviceConfiguration().createCompatibleImage(n3, n4, this.backBufferTransparency);
                logger.debug((Object)String.format("Created Buffer using %d Kb", this.backBuffer.getHeight() * this.backBuffer.getWidth() * this.backBuffer.getColorModel().getPixelSize() / 8 / 1024));
                Graphics2D graphics2D2 = this.backBuffer.createGraphics();
                graphics2D2.setColor(graphics2D.getColor());
                SwingUtil.setRenderingQuality(graphics2D2, this.getRenderQuality());
                this.doPaint(graphics2D2, n3, n4);
                graphics2D2.dispose();
                this.bufferInvalid = false;
            }
            graphics2D.drawImage(this.backBuffer, null, n, n2);
        } else {
            super.preparePaint(graphics2D, n, n2, n3, n4, t);
        }
    }

    public final boolean isUseBackBuffer() {
        return this.useBackBufffer;
    }

    public final void setUseBackBuffer(boolean bl) {
        this.useBackBufffer = bl;
        this.invalidateBuffer();
        if (!this.useBackBufffer) {
            this.backBuffer = null;
        }
    }

    protected final void invalidateBuffer() {
        this.bufferInvalid = true;
    }
}

