/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui;

import edu.geophys.commons.themes.SuiteTheme;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.ComponentActivationControler;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ActivateableComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static SuiteTheme currentTheme = null;
    private static Border activeBorder;
    private static Border inactiveBorder;
    private final ComponentActivationControler _activationControler;
    private boolean _isActive = true;
    protected int _width = this.getWidth();
    protected int _height = this.getHeight();
    protected int _minX = 0;
    protected int _minY = 0;
    protected int _maxX;
    protected int _maxY;

    public ActivateableComponent() {
        this.updateTheme();
        this._activationControler = ComponentActivationControler.getDefaultActivatonControler();
        this._initiallize();
    }

    private void _initiallize() {
        this.setFocusable(true);
        this.setOpaque(true);
        this.setActive(false);
        this._activationControler.add(this);
    }

    public void setActive(boolean bl) {
        if (bl != this._isActive) {
            this._isActive = bl;
            if (this._isActive) {
                this.setBorder(activeBorder);
                this.requestFocusInWindow();
            } else {
                this.setBorder(inactiveBorder);
            }
        }
    }

    public final boolean isActive() {
        return this._isActive;
    }

    public void dispose() {
        this._activationControler.remove(this);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.updateTheme();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics2D.getColor();
        this._minX = this.getInsets().left;
        this._minY = this.getInsets().top;
        this._width = this.getWidth() - (this._minX + this.getInsets().right);
        this._height = this.getHeight() - (this._minY + this.getInsets().bottom);
        this._maxX = this._minX + this._width - 1;
        this._maxY = this._minY + this._height - 1;
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(this._minX, this._minY, this._width, this._height);
            graphics2D.setColor(color);
        }
    }

    private void updateTheme() {
        if (currentTheme == ThemeManager.getInstance().getTheme()) {
            return;
        }
        currentTheme = ThemeManager.getInstance().getTheme();
        activeBorder = BorderFactory.createLineBorder(currentTheme.getHypolineRed(), 2);
        inactiveBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(currentTheme.getUIBorderColor(), 1), BorderFactory.createLineBorder(currentTheme.getSecondaryUIBorderColor(), 1));
        this.repaint();
    }

    @Override
    public String toString() {
        String string = "minX=" + this._minX + ", minY=" + this._minY + ", maxX=" + this._maxX + ", maxY=" + this._maxY + ", width=" + this._width + ", height=" + this._height + ", active=" + this.isActive() + ", super=" + super.toString();
        return this.getClass().getName() + "[" + string + "]";
    }
}

