/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui;

import edu.geophys.commons.util.MathUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.border.AbstractBorder;

public class SimpleTraceBorder
extends AbstractBorder {
    private static final long serialVersionUID = 2580041907244591076L;
    protected int leftoffset;
    protected int bottomoffset;
    protected Color lineColor;
    protected boolean roundedCorners;
    private final int topoffset = 5;
    private double scale = 1.0;
    private int numberFontSize = 25;
    private int letterFontSize = 25;
    private String freqCaption;
    private String ampCaption;
    private float end = 1.0f;
    private float start = 0.0f;
    private boolean onlypositive;
    private boolean logAmp = false;
    private boolean logTime = false;
    private double minval = 0.0;
    private boolean drawAmpAxis = true;
    final DecimalFormat OUTPUT_FORMAT = new DecimalFormat("#.#E0");
    final DecimalFormat OUTPUT_FORMAT2 = new DecimalFormat("#.#");

    public SimpleTraceBorder(Color color, int n, int n2, double d, String string, String string2, float f, boolean bl, boolean bl2, boolean bl3, double d2) {
        this(color, n, n2, d, string, string2, f, bl);
        this.logAmp = bl2;
        this.logTime = bl3;
        this.minval = d2;
    }

    public SimpleTraceBorder(Color color, int n, int n2, double d, String string, String string2, float f, boolean bl) {
        this.lineColor = color;
        this.leftoffset = n;
        this.bottomoffset = n2;
        this.scale = d;
        this.freqCaption = string;
        this.ampCaption = string2;
        this.end = f;
        this.onlypositive = bl;
    }

    public SimpleTraceBorder(Color color, int n, int n2, double d, String string, String string2, float f, boolean bl, boolean bl2) {
        this(color, n, n2, d, string, string2, f, bl);
        this.drawAmpAxis = bl2;
    }

    public SimpleTraceBorder(Color color, int n, int n2, double d, String string, String string2, float f, float f2, boolean bl, boolean bl2, boolean bl3, double d2) {
        this(color, n, n2, d, string, string2, f2, bl, bl2, bl3, d2);
        this.start = f;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.lineColor);
        graphics.drawLine(n, n2, n + n3 - 1, n2);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4 - 1);
        if (this.drawAmpAxis) {
            this.drawAmplitudeAxis(graphics, n, n2 + 5, this.leftoffset, n4 - this.bottomoffset - 5);
        }
        this.drawHorizontalAxis(graphics, n + this.leftoffset, n2 - this.bottomoffset + n4, n3 - this.leftoffset, this.bottomoffset);
        graphics.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.set(5, this.leftoffset, this.bottomoffset, 0);
        return insets;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(5, this.leftoffset, this.bottomoffset, 0);
    }

    private void drawAmplitudeAxis(Graphics graphics, int n, int n2, int n3, int n4) {
        double d;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(300.0);
        graphics2D.setFont(new Font("Arial", 1, this.letterFontSize));
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(this.ampCaption, graphics);
        graphics2D.drawString(this.ampCaption, -n2 - (int)(((double)n4 + rectangle2D.getWidth()) / 2.0), n + (int)rectangle2D.getHeight());
        graphics2D.setFont(new Font("Arial", 0, this.numberFontSize));
        graphics2D.rotate(-300.0);
        graphics2D.drawLine(n + n3, n2, n + n3, n2 + n4);
        double d2 = 1.0 / this.scale;
        int n5 = 4;
        int n6 = 0;
        int n7 = 4;
        if (d2 > 1.0) {
            while (Math.pow(10.0, n6) < d2) {
                ++n6;
            }
            d = Math.floor(d2 / Math.pow(10.0, n6 - 1)) * (Math.pow(10.0, n6 - 1) / (double)n7);
        } else {
            while (Math.pow(10.0, n6) > d2) {
                --n6;
            }
            d = Math.floor(d2 / Math.pow(10.0, n6)) * (Math.pow(10.0, n6) / (double)n7);
        }
        int n8 = 0;
        if (this.logAmp) {
            while (Math.pow(10.0, n8) > this.minval) {
                --n8;
            }
            n7 = n6;
        }
        for (int i = -n7; i <= -n8; ++i) {
            double d3 = this.logAmp ? -Math.pow(10.0, -i) : (double)i * d;
            int n9 = this.onlypositive ? (this.logAmp ? (int)Math.rint(MathUtil.convertFromTo(i, -n7, -n8, n2, n2 + n4)) : (int)Math.rint(MathUtil.convertFromTo(d3, -d2, -n8, n2, n2 + n4))) : (this.logAmp ? (int)Math.rint(MathUtil.convertFromTo(i, -n7, -n8, n2, n2 + n4 / 2 - 1)) : (int)Math.rint(MathUtil.convertFromTo(d3, -d2, -n8, n2, n2 + n4 / 2 - 1)));
            String string = this.OUTPUT_FORMAT.format(-d3);
            Rectangle2D rectangle2D2 = graphics.getFontMetrics().getStringBounds(string, graphics);
            graphics.drawString(string, (int)((double)(n + n3) - rectangle2D2.getWidth() - (double)(n5 / 2) - 2.0), n9 + (int)(rectangle2D2.getHeight() / 3.0));
            graphics.drawLine(n + n3 - n5 / 2, n9, n + n3 + n5 / 2, n9);
        }
    }

    private void drawHorizontalAxis(Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(this.freqCaption, graphics);
        graphics2D.setFont(new Font("Arial", 0, this.numberFontSize));
        String string = Float.toString(this.end);
        Rectangle2D rectangle2D2 = graphics.getFontMetrics().getStringBounds(string, graphics);
        int n5 = graphics.getFontMetrics().getAscent();
        int n6 = 10;
        int n7 = (int)Math.floor((double)n4 - rectangle2D2.getHeight() - rectangle2D.getHeight());
        float f = 0.0f;
        int n8 = (int)this.end;
        int n9 = (int)this.start;
        int n10 = !this.logTime ? 10 : n8 - n9;
        for (int i = 0; i <= n10; ++i) {
            int n11 = (int)Math.rint(MathUtil.convertFromTo(i, 0.0, n10, n, n + n3 - 1));
            if (!this.logTime) {
                f = this.start + this.end / 10.0f * (float)i;
                string = this.OUTPUT_FORMAT2.format(f);
            } else {
                f = (float)Math.pow(10.0, i + n9);
                string = this.OUTPUT_FORMAT.format(f);
            }
            Rectangle2D rectangle2D3 = graphics.getFontMetrics().getStringBounds(string, graphics);
            graphics.drawString(string, n11 - (int)rectangle2D3.getWidth(), n2 + n5 + n7);
            graphics.drawLine(n11, n2 + 1, n11, n2 + n7 + (int)rectangle2D2.getHeight());
        }
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.setFont(new Font("Arial", 1, this.letterFontSize));
        graphics.drawString(this.freqCaption, n + n3 / 2 - (int)(rectangle2D.getWidth() / 2.0), n2 + (int)(rectangle2D.getHeight() + rectangle2D2.getHeight() + (double)n7 - 1.0));
    }
}

