/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui;

import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.MathUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.border.AbstractBorder;

public class TraceBorder
extends AbstractBorder {
    private static final long serialVersionUID = 2580041907244591076L;
    protected int thickness;
    protected Color lineColor;
    protected boolean roundedCorners;
    private double scale = 1.0;
    private long timestart = 0L;
    private long timeend = 10000L;
    private int numberFontSize = 14;
    private int letterFontSize = 12;
    private boolean timeAxis;
    private boolean ampAxis;
    private boolean sonoAxis;
    private String timeCaption;
    private String ampCaption;
    private float samplerate = 1.0f;
    final DecimalFormat OUTPUT_FORMAT = new DecimalFormat("0E0");

    public TraceBorder(Color color, int n, double d, long l, long l2, boolean bl, boolean bl2, String string, String string2, float f) {
        this.lineColor = color;
        this.thickness = n;
        this.timestart = l;
        this.timeend = l2;
        this.scale = d;
        this.timeAxis = bl;
        this.ampAxis = bl2;
        this.timeCaption = string;
        this.ampCaption = string2;
        this.sonoAxis = true;
        this.samplerate = f;
    }

    public TraceBorder(Color color, int n, double d, long l, long l2, boolean bl, boolean bl2, String string, String string2, float f, int n2, int n3) {
        this.lineColor = color;
        this.thickness = n;
        this.timestart = l;
        this.timeend = l2;
        this.scale = d;
        this.timeAxis = bl;
        this.ampAxis = bl2;
        this.timeCaption = string;
        this.ampCaption = string2;
        this.sonoAxis = true;
        this.samplerate = f;
        this.numberFontSize = n2;
        this.letterFontSize = n3;
    }

    public TraceBorder(Color color, int n, double d, long l, long l2, boolean bl, boolean bl2, String string, String string2) {
        this.lineColor = color;
        this.thickness = n;
        this.timestart = l;
        this.timeend = l2;
        this.scale = d;
        this.timeAxis = bl;
        this.ampAxis = bl2;
        this.timeCaption = string;
        this.ampCaption = string2;
        this.sonoAxis = false;
    }

    public TraceBorder(Color color, int n, double d, long l, long l2, boolean bl, boolean bl2, String string, String string2, int n2, int n3) {
        this.lineColor = color;
        this.thickness = n;
        this.timestart = l;
        this.timeend = l2;
        this.scale = d;
        this.timeAxis = bl;
        this.ampAxis = bl2;
        this.timeCaption = string;
        this.ampCaption = string2;
        this.sonoAxis = false;
        this.numberFontSize = n2;
        this.letterFontSize = n3;
    }

    public TraceBorder(Color color, int n, double d, long l, long l2, boolean bl, boolean bl2) {
        this.lineColor = color;
        this.thickness = n;
        this.timestart = l;
        this.timeend = l2;
        this.scale = d;
        this.timeAxis = bl;
        this.ampAxis = bl2;
        this.timeCaption = "";
        this.ampCaption = "";
        this.sonoAxis = false;
    }

    public TraceBorder(Color color, int n, double d, long l, long l2) {
        this.lineColor = color;
        this.thickness = n;
        this.timestart = l;
        this.timeend = l2;
        this.scale = d;
        this.timeAxis = true;
        this.ampAxis = true;
        this.timeCaption = "";
        this.ampCaption = "";
        this.sonoAxis = false;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.lineColor);
        graphics.drawLine(n, n2, n + n3 - 1, n2);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4 - 1);
        if (this.ampAxis) {
            if (this.sonoAxis) {
                this.drawFreqAmplitudeAxis(graphics, n - 60 + this.thickness, n2, 60, n4);
            } else {
                this.drawAmplitudeAxis(graphics, n - 60 + this.thickness, n2, 60, n4);
            }
        }
        if (this.timeAxis) {
            this.drawTimeAxis(graphics, n, n2 + n4, n3, 20);
        }
        graphics.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.set(0, this.thickness, 0, 0);
        return insets;
    }

    private void drawAmplitudeAxis(Graphics graphics, int n, int n2, int n3, int n4) {
        double d;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawLine(0, 0, 0, n4);
        graphics2D.setFont(new Font("Arial", 1, this.letterFontSize));
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(this.ampCaption, graphics2D);
        graphics2D.rotate(300.0);
        graphics2D.drawString(this.ampCaption, -n2 - (int)(((double)n4 + rectangle2D.getWidth()) / 2.0), (int)rectangle2D.getHeight());
        graphics2D.setFont(new Font("Arial", 0, this.numberFontSize));
        graphics2D.rotate(-300.0);
        graphics2D.drawLine(n + n3, n2, n + n3, n2 + n4);
        double d2 = 1.0 / this.scale;
        int n5 = 6;
        int n6 = 0;
        if (d2 > 1.0) {
            while (Math.pow(10.0, n6) < d2) {
                ++n6;
            }
            d = Math.floor(d2 / Math.pow(10.0, n6 - 1)) * (Math.pow(10.0, n6 - 1) / 2.0);
        } else {
            while (Math.pow(10.0, n6) > d2) {
                --n6;
            }
            d = Math.floor(d2 / Math.pow(10.0, n6)) * (Math.pow(10.0, n6) / 2.0);
        }
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i = -2; i <= 2; ++i) {
            double d3 = (double)i * d;
            int n11 = (int)Math.rint(MathUtil.convertFromTo(d3, -d2, d2, n2, n2 + n4 - 1));
            String string = i != 0 ? this.scaleFormat(-d3) : "0";
            Rectangle2D rectangle2D2 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            int n12 = (int)((double)(n + n3) - rectangle2D2.getWidth() - (double)(n5 / 2) - 2.0);
            int n13 = (int)rectangle2D2.getHeight() * 2 / 3;
            if (i == -2) {
                n7 = n11 + (int)(rectangle2D2.getHeight() / 3.0);
                if (n7 < n13) {
                    n7 = n13;
                }
                graphics2D.drawString(string, n12, n7);
            } else if (i == -1) {
                n8 = n11 + (int)(rectangle2D2.getHeight() / 3.0);
                if (n8 < n13 + n7) {
                    n8 = n13 + n7;
                }
                graphics2D.drawString(string, n12, n8);
            } else if (i == 0) {
                n10 = n11 + (int)(rectangle2D2.getHeight() / 3.0);
                graphics2D.drawString(string, n12, n10);
            } else if (i == 1) {
                n9 = n11 + (int)(rectangle2D2.getHeight() / 3.0);
                if (n9 < n13 + n10) {
                    n9 = n13 + n10;
                }
                graphics2D.drawString(string, n12, n9);
            } else if (i == 2) {
                int n14 = n11 + (int)(rectangle2D2.getHeight() / 3.0);
                if (n14 > n2 + n4 - 1) {
                    n14 = n2 + n4 - 1;
                }
                graphics2D.drawString(string, n12, n14);
            }
            graphics2D.drawLine(n + n3 - n5 / 2, n11, n + n3 + n5 / 2, n11);
        }
    }

    private String scaleFormat(double d) {
        return this.OUTPUT_FORMAT.format(d);
    }

    private void drawFreqAmplitudeAxis(Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawLine(0, 0, 0, n4);
        graphics2D.setFont(new Font("Arial", 1, this.letterFontSize));
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(this.ampCaption, graphics);
        graphics2D.rotate(300.0);
        graphics2D.drawString(this.ampCaption, -n2 - n4 / 2 - (int)(rectangle2D.getWidth() / 2.0), (int)rectangle2D.getHeight());
        graphics2D.setFont(new Font("Arial", 0, this.numberFontSize));
        graphics2D.rotate(-300.0);
        graphics2D.drawLine(n + n3, n2, n + n3, n2 + n4);
        int n5 = 4;
        float f = this.samplerate / 256.0f;
        float[] fArray = new float[]{f * 96.0f, f * 9.6f, f};
        int n6 = 0;
        Locale locale = Locale.ENGLISH;
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(locale);
        decimalFormat.applyPattern("0.0");
        for (int i = 0; i <= 2; ++i) {
            double d = fArray[i];
            String string = decimalFormat.format(d);
            Rectangle2D rectangle2D2 = graphics.getFontMetrics().getStringBounds(string, graphics);
            if (i == 0) {
                n6 = n2 + 2;
                graphics.drawString(string, (int)((double)(n + n3) - rectangle2D2.getWidth() - (double)(n5 / 2) - 2.0), n6 + (int)(rectangle2D2.getHeight() - 2.0));
            } else if (i == 1) {
                n6 = n2 + n4 / 2;
                graphics.drawString(string, (int)((double)(n + n3) - rectangle2D2.getWidth() - (double)(n5 / 2) - 2.0), n6 + (int)(rectangle2D2.getHeight() / 3.0));
            } else if (i == 2) {
                n6 = n2 + n4 / 2 * 2 - 2;
                graphics.drawString(string, (int)((double)(n + n3) - rectangle2D2.getWidth() - (double)(n5 / 2) - 2.0), n6);
            }
            graphics.drawLine(n + n3 - n5 / 2, n6, n + n3 + n5 / 2, n6 - 1);
        }
    }

    private void drawTimeAxis(Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(this.timeCaption, graphics);
        graphics.setFont(new Font("Arial", 1, this.letterFontSize));
        graphics.drawString(this.timeCaption, n + n3 / 2 - (int)(rectangle2D.getWidth() / 2.0), n2 + (int)rectangle2D.getHeight() + 10);
        graphics2D.setFont(new Font("Arial", 0, this.numberFontSize));
        String string = DateTimeUtil.formatTime(this.timeend);
        Rectangle2D rectangle2D2 = graphics.getFontMetrics().getStringBounds(string, graphics);
        int n5 = graphics.getFontMetrics().getAscent();
        int n6 = (int)Math.floor((double)n4 - rectangle2D2.getHeight());
        int n7 = (int)Math.floor((double)n4 - rectangle2D2.getHeight() / 2.0);
        long l = DateTimeUtil.incrementMs(100L * Math.round((double)(this.timeend - this.timestart) / (double)n3));
        double d = (double)n3 / (double)(this.timeend - this.timestart);
        long l2 = l / 2L;
        if (l2 < 1L) {
            l2 = 1L;
        }
        for (long i = MathUtil.ceil(this.timestart, l2); i <= this.timeend; i += l2) {
            int n8 = n + (int)(((double)i - (double)this.timestart) * d + 0.5);
            if (i == i / l * l) {
                graphics.drawLine(n8, n2 + 1, n8, n2 + n7);
                if (i != i / l / 2L * l * 2L || n8 >= n3) continue;
                string = Math.abs(i - MathUtil.floor(i, 86400000L)) < 1000L ? DateTimeUtil.formatDateISO(i) : DateTimeUtil.formatTime(i);
                Rectangle2D rectangle2D3 = graphics.getFontMetrics().getStringBounds(string, graphics);
                graphics.drawString(string, n8 - (int)(rectangle2D3.getWidth() / 2.0), n2 + n5 + n7);
                continue;
            }
            graphics.drawLine(n8, n2 + 1, n8, n2 + n6);
        }
        graphics.drawLine(n, n2, n + n3, n2);
    }
}

