/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.map.mapimageloader;

import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.map.mapimageloader.SupportedFileTypeList;
import edu.geophys.commons.util.CoordinateUtil;
import edu.geophys.commons.util.LogUtil;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;

public class MapImage {
    private File imageFile;
    private Image image;
    private int xImgOffset;
    private int yImgOffset;
    private int origImageWidth;
    private int origImageHeight;
    private double mxPerPixel;
    private double myPerPixel;
    private CampaignKnowledge.MapPoint refPoint;
    private int newWidth;
    private int newHeight;
    private final File imgDir = SuiteManager.INSTANCE.getKnowledgebase().getKnowledgeFolder();
    private double imgLon;
    private double imgLat;
    private CoordinateUtil.RelativeResult relRes;

    public MapImage(CampaignKnowledge.MapPoint mapPoint) {
        this.refPoint = mapPoint;
        this.createStandardImage();
    }

    public void createStandardImage() {
        this.imageFile = null;
        File file = null;
        if (this.imgDir.exists() && this.imgDir.isDirectory()) {
            for (int i = 0; i < SupportedFileTypeList.IMAGEFILEENDINGS.length; ++i) {
                this.imageFile = new File(this.imgDir + File.separator + "map." + SupportedFileTypeList.IMAGEFILEENDINGS[i]);
                if (this.imageFile.exists()) break;
            }
            file = new File(this.imgDir + File.separator + "map.jgw");
        }
        this.setImage(null);
        if (this.imageFile != null && this.imageFile.exists() && file != null && file.exists()) {
            BufferedReader bufferedReader = null;
            try {
                this.image = ImageIO.read(this.imageFile);
                FileInputStream fileInputStream = new FileInputStream(file);
                DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
                this.mxPerPixel = Double.parseDouble(bufferedReader.readLine());
                bufferedReader.readLine();
                bufferedReader.readLine();
                this.myPerPixel = Double.parseDouble(bufferedReader.readLine());
                this.imgLon = Double.parseDouble(bufferedReader.readLine());
                this.imgLat = Double.parseDouble(bufferedReader.readLine());
                this.origImageHeight = -this.image.getHeight(null);
                this.origImageWidth = this.image.getWidth(null);
                this.relRes = CoordinateUtil.convertAbsoluteToRelative(this.refPoint.getLatitude(), this.refPoint.getLongitude(), this.imgLat, this.imgLon);
                bufferedReader.close();
            }
            catch (Exception exception) {
                this.setImage(null);
                LogUtil.info(this.getClass(), "Problem reading map image (world) file " + exception.getMessage(), false);
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    public void update(double d, double d2, double d3, int n) {
        this.newWidth = (int)((double)this.origImageWidth * this.mxPerPixel * d / 1000.0);
        this.newHeight = (int)((double)this.origImageHeight * this.myPerPixel * d / 1000.0);
        this.xImgOffset = (int)Math.round(d * this.relRes.xOffset + d2);
        this.yImgOffset = (int)((long)n - Math.round(d * this.relRes.yOffset + d3));
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public int getNewWidth() {
        return this.newWidth;
    }

    public void setNewWidth(int n) {
        this.newWidth = n;
    }

    public int getNewHeight() {
        return this.newHeight;
    }

    public void setNewHeight(int n) {
        this.newHeight = n;
    }

    public int getxImgOffset() {
        return this.xImgOffset;
    }

    public void setxImgOffset(int n) {
        this.xImgOffset = n;
    }

    public int getyImgOffset() {
        return this.yImgOffset;
    }

    public void setyImgOffset(int n) {
        this.yImgOffset = n;
    }
}

