/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.range;

import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.DefaultBoundedLongRangeModel;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.commons.util.SwingUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractRangeSelection
extends JComponent {
    private static final long serialVersionUID = 3622854106357530217L;
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_SELECTION_BACKGROUND = "selectionBackground";
    public static final String PROPERTY_INNER_SELECTION_BACKGROUND = "innerSelectionBackground";
    public static final String PROPERTY_SELECTION_FOREGROUND = "selectionForeground";
    public static final String PROPERTY_SNAP_TO_INCREMENT = "snapToIncrement";
    private BoundedLongRangeModel model = AbstractRangeSelection.createDefaultModel();
    private Color selectionForeground = Color.BLACK;
    private Color selectionBackground = Color.CYAN;
    private Color innerSelectionBackground = new Color(120, 120, 255);
    private long snapToIncrement = -1L;
    private final ChangeListener modelChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AbstractRangeSelection.this.repaint();
        }
    };

    private static final BoundedLongRangeModel createDefaultModel() {
        return new DefaultBoundedLongRangeModel(0x1FFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0L, Long.MAX_VALUE, 1L);
    }

    public AbstractRangeSelection() {
        this.initComponent();
    }

    private void initComponent() {
        this.setOpaque(true);
        this.setMinimumSize(new Dimension(100, 20));
        this.setPreferredSize(new Dimension(100, 20));
        this.getModel().addChangeListener(this.modelChangeListener);
    }

    public final BoundedLongRangeModel getModel() {
        return this.model;
    }

    public final void setModel(BoundedLongRangeModel boundedLongRangeModel) {
        BoundedLongRangeModel boundedLongRangeModel2 = boundedLongRangeModel;
        BoundedLongRangeModel boundedLongRangeModel3 = boundedLongRangeModel != null ? boundedLongRangeModel : AbstractRangeSelection.createDefaultModel();
        this.model.removeChangeListener(this.modelChangeListener);
        this.model = boundedLongRangeModel3;
        this.model.addChangeListener(this.modelChangeListener);
        this.revalidate();
        this.repaint();
        this.firePropertyChange(PROPERTY_MODEL, boundedLongRangeModel2, boundedLongRangeModel3);
    }

    public final Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public final void setSelectionForeground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cannot be null");
        }
        Color color2 = color;
        this.selectionForeground = color;
        this.repaint();
        this.firePropertyChange(PROPERTY_SELECTION_FOREGROUND, color2, color);
    }

    public final Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public final Color getInnerSelectionBackground() {
        return this.innerSelectionBackground;
    }

    public final void setInnerSelectionBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cannot be null");
        }
        Color color2 = color;
        this.innerSelectionBackground = color;
        this.repaint();
        this.firePropertyChange(PROPERTY_INNER_SELECTION_BACKGROUND, color2, color);
    }

    public final void setSelectionBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cannot be null");
        }
        Color color2 = color;
        this.selectionBackground = color;
        this.repaint();
        this.firePropertyChange(PROPERTY_SELECTION_BACKGROUND, color2, color);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Rectangle2D rectangle2D = SwingUtil.componentDrawingArea(this);
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setColor(this.getForeground());
        }
        this.drawSelectionMarker(graphics2D, rectangle2D);
        graphics2D.dispose();
    }

    protected final int getLowerBound(Rectangle2D rectangle2D) {
        return (int)MathUtil.convertFromTo(this.getModel().getValue(), this.getModel().getMinimum(), this.getModel().getMaximum(), rectangle2D.getX(), rectangle2D.getX() + rectangle2D.getWidth());
    }

    protected final int getUpperBound(Rectangle2D rectangle2D) {
        return (int)MathUtil.convertFromTo(this.getModel().getValue() + this.getModel().getExtent(), this.getModel().getMinimum(), this.getModel().getMaximum(), rectangle2D.getX(), rectangle2D.getX() + rectangle2D.getWidth());
    }

    protected void drawSelectionMarker(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        int n = this.getLowerBound(rectangle2D);
        int n2 = this.getUpperBound(rectangle2D) - n - 1;
        graphics2D.setColor(this.getSelectionBackground());
        graphics2D.fillRect(n, (int)rectangle2D.getY(), n2, (int)rectangle2D.getHeight() - 1);
        graphics2D.setColor(this.getSelectionForeground());
        graphics2D.drawRect(n, (int)rectangle2D.getY(), n2, (int)rectangle2D.getHeight() - 1);
    }
}

