/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.range;

import edu.geophys.commons.suite.EventWindowModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.ActivateableComponent;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.range.JTimeRangeSelection;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class JTimeRangeInteractive
extends ActivateableComponent {
    private static final long serialVersionUID = 1L;
    private final EventWindowModel ewm = SuiteManager.INSTANCE.getGlobalEventWindowModel();
    JTimeRangeSelection timeSel;
    private MouseWheelListener mouseWheelListener = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = mouseWheelEvent.getWheelRotation();
            long l = JTimeRangeInteractive.this.ewm.getLength();
            if (n < 0) {
                JTimeRangeInteractive.this.ewm.setStartEpochTimeMs(JTimeRangeInteractive.this.ewm.getStartEpochTimeMs() + l);
            } else {
                JTimeRangeInteractive.this.ewm.setStartEpochTimeMs(JTimeRangeInteractive.this.ewm.getStartEpochTimeMs() - l);
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            long l = JTimeRangeInteractive.this.ewm.getLength();
            long l2 = JTimeRangeInteractive.this.ewm.getStartEpochTimeMs();
            long l3 = 10000L;
            if (keyEvent.getKeyCode() == 37 && !keyEvent.isControlDown()) {
                JTimeRangeInteractive.this.ewm.setStartEpochTimeMs(JTimeRangeInteractive.this.ewm.getStartEpochTimeMs() - l / 2L);
            } else if (keyEvent.getKeyCode() == 39 && !keyEvent.isControlDown()) {
                JTimeRangeInteractive.this.ewm.setStartEpochTimeMs(JTimeRangeInteractive.this.ewm.getStartEpochTimeMs() + l / 2L);
            } else if (keyEvent.getKeyCode() == 37 && keyEvent.isControlDown()) {
                JTimeRangeInteractive.this.ewm.setStartEpochTimeMs(JTimeRangeInteractive.this.ewm.getStartEpochTimeMs() - l / 20L);
            } else if (keyEvent.getKeyCode() == 39 && keyEvent.isControlDown()) {
                JTimeRangeInteractive.this.ewm.setStartEpochTimeMs(JTimeRangeInteractive.this.ewm.getStartEpochTimeMs() + l / 20L);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }
    };

    public JTimeRangeInteractive() {
        this.timeSel = new JTimeRangeSelection();
        this.timeSel.setShowEventMarkers(true);
        this.setLayout(new GridLayout(0, 1));
        this.addKeyListener(this.keyListener);
        this.addMouseWheelListener(this.mouseWheelListener);
        this.add(this.timeSel);
    }

    public void setModel(BoundedLongRangeModel boundedLongRangeModel) {
        this.timeSel.setModel(boundedLongRangeModel);
    }
}

