/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.time;

import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.DefaultBoundedLongRangeModel;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.commons.util.SwingUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JTimeAxis
extends JComponent {
    public static final String PROPERTY_MODEL = "model";
    protected int selectionStartX;
    protected int selectionEndX;
    private BoundedLongRangeModel model = new DefaultBoundedLongRangeModel();
    protected final Alignment axisAlignment;
    private ChangeListener modelChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JTimeAxis.this.repaint();
        }
    };

    public JTimeAxis() {
        this.axisAlignment = Alignment.NORTH;
        this.initComponent();
    }

    public JTimeAxis(Alignment alignment) {
        this.axisAlignment = alignment;
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(null);
        this.setOpaque(true);
        this.setMinimumSize(new Dimension(100, 20));
        this.setPreferredSize(new Dimension(100, 20));
        this.setModel(null);
    }

    public final BoundedLongRangeModel getModel() {
        return this.model;
    }

    public final void setModel(BoundedLongRangeModel boundedLongRangeModel) {
        BoundedLongRangeModel boundedLongRangeModel2 = boundedLongRangeModel;
        BoundedLongRangeModel boundedLongRangeModel3 = boundedLongRangeModel != null ? boundedLongRangeModel : new DefaultBoundedLongRangeModel();
        this.model.removeChangeListener(this.modelChangeListener);
        this.model = boundedLongRangeModel3;
        this.model.addChangeListener(this.modelChangeListener);
        this.revalidate();
        this.repaint();
        this.firePropertyChange(PROPERTY_MODEL, boundedLongRangeModel2, this.model);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Rectangle2D rectangle2D = SwingUtil.componentDrawingArea(this);
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setColor(this.getForeground());
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.clip(rectangle2D);
        this.drawVerticalAxis(graphics2D, rectangle2D);
        graphics2D.dispose();
    }

    private void drawVerticalAxis(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Line2D.Double double_ = new Line2D.Double();
        long l = this.model.getMinimum();
        long l2 = this.model.getMaximum();
        String string = DateTimeUtil.formatTime(l2);
        Rectangle2D rectangle2D2 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
        int n = graphics2D.getFontMetrics().getAscent();
        int n2 = (int)Math.floor(rectangle2D.getHeight() - rectangle2D2.getHeight());
        int n3 = (int)Math.floor(rectangle2D.getHeight() - rectangle2D2.getHeight() / 2.0);
        int n4 = (int)(rectangle2D.getMaxY() - 1.0);
        long l3 = DateTimeUtil.incrementMs(Math.round(50.0 * ((double)(l2 - l) / rectangle2D.getWidth())));
        long l4 = 4L * l3;
        for (long i = MathUtil.ceil(l, l3); i <= l2; i += l3) {
            int n5;
            int n6 = (int)Math.rint(MathUtil.convertFromTo(i, l, l2, rectangle2D.getMinX(), rectangle2D.getMaxX() - 1.0));
            if (Math.abs(i - MathUtil.floor(i, l4)) < 1000L) {
                n5 = n3;
                if (Math.abs(i - MathUtil.floor(i, l4)) < 1000L) {
                    string = Math.abs(i - MathUtil.floor(i, 86400000L)) < 1000L ? DateTimeUtil.formatDateISO(i) : DateTimeUtil.formatTime(i);
                    if (this.selectionEndX <= n6 || (double)this.selectionStartX > (double)n6 + rectangle2D2.getWidth()) {
                        graphics2D.drawString(string, n6 + 2, this.axisAlignment == Alignment.NORTH ? n + n2 : n4 - n2);
                    }
                }
            } else {
                n5 = n2;
            }
            if (this.axisAlignment == Alignment.NORTH) {
                ((Line2D)double_).setLine(n6, rectangle2D.getMinY(), n6, n5);
            } else {
                ((Line2D)double_).setLine(n6, n4 - n5, n6, n4);
            }
            graphics2D.draw(double_);
        }
        if (this.axisAlignment == Alignment.NORTH) {
            ((Line2D)double_).setLine(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMinY());
        } else {
            ((Line2D)double_).setLine(rectangle2D.getMinX(), n4, rectangle2D.getMaxX(), n4);
        }
        graphics2D.draw(double_);
    }

    public static enum Alignment {
        NORTH,
        SOUTH;

    }
}

