/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import Jama.Matrix;
import java.text.DecimalFormat;
import java.util.Random;

public class MathUtil {
    public static final double RELATIVE_MAXIMUM = 1.0;
    public static final double RELATIVE_MINIMUM = 0.0;
    public static final DecimalFormat df2digits = new DecimalFormat("#.##");
    public static final DecimalFormat df3digits = new DecimalFormat("#.###");

    public static final double floor(double d, double d2) {
        return Math.floor(d / d2) * d2;
    }

    public static final long floor(long l, long l2) {
        return l - l % l2;
    }

    public static final double ceil(double d, double d2) {
        double d3 = MathUtil.floor(d, d2);
        return d > d3 ? d3 + d2 : d3;
    }

    public static final long ceil(long l, long l2) {
        long l3 = MathUtil.floor(l, l2);
        return l > l3 ? l3 + l2 : l3;
    }

    public static final double round(double d, double d2) {
        double d3 = MathUtil.floor(d, d2);
        return d - d3 + (d - d3) > d2 ? d3 + d2 : d3;
    }

    public static final long round(long l, long l2) {
        long l3 = MathUtil.floor(l, l2);
        return l - l3 + (l - l3) > l2 ? l3 + l2 : l3;
    }

    public static final double convertFromTo(double d, double d2, double d3, double d4, double d5) {
        return MathUtil.convertToAbsolute(MathUtil.convertToRelative(d, d2, d3), d4, d5);
    }

    public static final double convertToAbsolute(double d, double d2, double d3) {
        return d2 + d * (d3 - d2);
    }

    public static final double convertToAbsolute(double d, float f, float f2) {
        return MathUtil.convertToAbsolute(d, (double)f, (double)f2);
    }

    public static final double convertToAbsolute(double d, int n, int n2) {
        return MathUtil.convertToAbsolute(d, (double)n, (double)n2);
    }

    public static final double convertToAbsolute(double d, long l, long l2) {
        return MathUtil.convertToAbsolute(d, (double)l, (double)l2);
    }

    public static final double convertToRelative(double d, double d2) {
        return d / d2;
    }

    public static final double convertToRelative(double d, double d2, double d3) {
        return MathUtil.convertToRelative(d - d2, d3 - d2);
    }

    public static final double convertToRelative(float f, float f2) {
        return MathUtil.convertToRelative((double)f, (double)f2);
    }

    public static final double convertToRelative(float f, float f2, float f3) {
        return MathUtil.convertToRelative((double)f, (double)f2, (double)f3);
    }

    public static final double convertToRelative(int n, int n2) {
        return MathUtil.convertToRelative((double)n, (double)n2);
    }

    public static final double convertToRelative(int n, int n2, int n3) {
        return MathUtil.convertToRelative((double)n, (double)n2, (double)n3);
    }

    public static final double convertToRelative(long l, long l2) {
        return MathUtil.convertToRelative((double)l, (double)l2);
    }

    public static final double convertToRelative(long l, long l2, long l3) {
        return MathUtil.convertToRelative((double)l, (double)l2, (double)l3);
    }

    public static float calcMaximum(float[] fArray) {
        float f = -3.4028235E38f;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] > f)) continue;
            f = fArray[i];
        }
        return f;
    }

    public static double calcMaximum(double[] dArray) {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static float calcMinimum(float[] fArray) {
        float f = Float.MAX_VALUE;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            f = fArray[i];
        }
        return f;
    }

    public static double calcMinimum(double[] dArray) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static int calcAbsMaximum(int[] nArray) {
        int n = -2147483647;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = Math.abs(nArray[i]);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static float calcAbsMaximum(float[] fArray) {
        return MathUtil.calcAbsMaximum(fArray, 0);
    }

    public static float calcAbsMaximum(float[] fArray, int n) {
        float f = -3.4028235E38f;
        for (int i = n; i < fArray.length; ++i) {
            float f2 = Math.abs(fArray[i]);
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public static int calcAbsMaximum(int[][] nArray) {
        int n = -2147483647;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                int n2 = Math.abs(nArray[i][j]);
                if (n2 <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    public static float calcAbsMaximum(float[][] fArray) {
        float f = -3.4028235E38f;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                float f2 = Math.abs(fArray[i][j]);
                if (!(f2 > f)) continue;
                f = f2;
            }
        }
        return f;
    }

    public static double calcAbsMaximum(double[][] dArray) {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                double d2 = Math.abs(dArray[i][j]);
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public static double calcMinimum(double[][][] dArray) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                for (int k = 0; k < dArray[i][j].length; ++k) {
                    double d2 = dArray[i][j][k];
                    if (!(d2 < d)) continue;
                    d = d2;
                }
            }
        }
        return d;
    }

    public static double calcMaximum(double[][][] dArray) {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                for (int k = 0; k < dArray[i][j].length; ++k) {
                    double d2 = dArray[i][j][k];
                    if (!(d2 > d)) continue;
                    d = d2;
                }
            }
        }
        return d;
    }

    public static double calcMaximum(double[][] dArray) {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (!(dArray[i][j] > d)) continue;
                d = dArray[i][j];
            }
        }
        return d;
    }

    public static double calcMinimum(double[][] dArray) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (!(dArray[i][j] < d)) continue;
                d = dArray[i][j];
            }
        }
        return d;
    }

    public static int calcMaximum(int[] nArray) {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static int calcMinimum(int[] nArray) {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static float calcAbsMaximumNoNaN(float[] fArray) {
        float f = -3.4028235E38f;
        for (int i = 0; i < fArray.length; ++i) {
            float f2;
            if (Float.isNaN(fArray[i]) || !((f2 = Math.abs(fArray[i])) > f)) continue;
            f = f2;
        }
        return f;
    }

    public static double calcAbsMaximum(double[] dArray) {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = Math.abs(dArray[i]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double calcAbsMinimum(double[] dArray) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = Math.abs(dArray[i]);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static double calcMean(int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)nArray[i];
        }
        return d / (double)nArray.length;
    }

    public static double calcVariance(float[] fArray, double d) {
        double d2 = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            d2 += (d - (double)fArray[i]) * (d - (double)fArray[i]);
        }
        return d2 / (double)fArray.length;
    }

    public static double calcVariance(int[] nArray, double d) {
        double d2 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d2 += (d - (double)nArray[i]) * (d - (double)nArray[i]);
        }
        return d2 / (double)nArray.length;
    }

    public static double calcMean(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d / (double)dArray.length;
    }

    public static float calcMean(float[] fArray) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
        }
        return f / (float)fArray.length;
    }

    public static float calcAbsMean(float[] fArray) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += Math.abs(fArray[i]);
        }
        return f / (float)fArray.length;
    }

    public static float[] subMean(float[] fArray) {
        int n;
        float f = 0.0f;
        for (n = 0; n < fArray.length; ++n) {
            f += fArray[n];
        }
        f /= (float)fArray.length;
        n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] - f;
        }
        return fArray;
    }

    public static float[] subMeanIgnoreNaN(float[] fArray) {
        int n;
        float f = 0.0f;
        int n2 = 0;
        for (n = 0; n < fArray.length; ++n) {
            if (Float.isNaN(fArray[n])) continue;
            f += fArray[n];
            ++n2;
        }
        f /= (float)n2;
        for (n = 0; n < fArray.length; ++n) {
            if (Float.isNaN(fArray[n])) continue;
            int n3 = n;
            fArray[n3] = fArray[n3] - f;
        }
        return fArray;
    }

    public static float[] subMeanZeroNaN(float[] fArray) {
        int n;
        float f = 0.0f;
        int n2 = 0;
        for (n = 0; n < fArray.length; ++n) {
            if (Float.isNaN(fArray[n])) continue;
            f += fArray[n];
            ++n2;
        }
        f /= (float)n2;
        for (n = 0; n < fArray.length; ++n) {
            if (!Float.isNaN(fArray[n])) {
                int n3 = n;
                fArray[n3] = fArray[n3] - f;
                continue;
            }
            fArray[n] = 0.0f;
        }
        return fArray;
    }

    public static float[] zeroNaN(float[] fArray) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.isNaN(fArray[i]) ? 0.0f : fArray[i];
        }
        return fArray;
    }

    public static double[] subMean(double[] dArray) {
        int n;
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n];
        }
        d /= (double)dArray.length;
        n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] - d;
        }
        return dArray;
    }

    public static double[] subMeanIgnoreNaN(double[] dArray) {
        int n;
        double d = 0.0;
        int n2 = 0;
        for (n = 0; n < dArray.length; ++n) {
            if (Double.isNaN(dArray[n])) continue;
            d += dArray[n];
            ++n2;
        }
        d /= (double)n2;
        for (n = 0; n < dArray.length; ++n) {
            if (Double.isNaN(dArray[n])) continue;
            int n3 = n;
            dArray[n3] = dArray[n3] - d;
        }
        return dArray;
    }

    public static double[] subMeanZeroNaN(double[] dArray) {
        int n;
        double d = 0.0;
        int n2 = 0;
        for (n = 0; n < dArray.length; ++n) {
            if (Double.isNaN(dArray[n])) continue;
            d += dArray[n];
            ++n2;
        }
        d /= (double)n2;
        for (n = 0; n < dArray.length; ++n) {
            if (!Double.isNaN(dArray[n])) {
                int n3 = n;
                dArray[n3] = dArray[n3] - d;
                continue;
            }
            dArray[n] = 0.0;
        }
        return dArray;
    }

    public static double[] zeroNaN(double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = Double.isNaN(dArray[i]) ? 0.0 : dArray[i];
        }
        return dArray;
    }

    public static int getNextPowerOfTwo(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n3 = (int)Math.pow(2.0, ++n2);
        }
        return n3;
    }

    public static double[] floatArrayToDoubleArray(float[] fArray) {
        double[] dArray = new double[fArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = fArray[i];
        }
        return dArray;
    }

    public static float[] doubleArrayToFloatArray(double[] dArray) {
        float[] fArray = new float[dArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    public static int[] doubleArrayToIntArray(double[] dArray) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)Math.round(dArray[i]);
        }
        return nArray;
    }

    public static double[] intArrayToDoubleArray(int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = nArray[i];
        }
        return dArray;
    }

    public static String format2Digits(double d) {
        return df2digits.format(d);
    }

    public static String format3Digits(double d) {
        return df3digits.format(d);
    }

    public static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    public static double compareAngles(double d, double d2) {
        return 180.0 - Math.abs(Math.abs(d - d2) - 180.0);
    }

    public static double convertMathAngleToAzimuth(double d) {
        double d2 = 90.0 - d;
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        return d2;
    }

    public static void hannWindow(float[] fArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            int n3 = i - n;
            fArray[i] = (float)((double)fArray[i] * 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)n3 / (double)n2)));
        }
    }

    public static float hannWindow(float f, int n, int n2) {
        return (float)((double)f * 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)n / (double)n2)));
    }

    public static double euclideanDistance(float[] fArray, float[] fArray2) {
        double d = 0.0;
        for (int i = 0; i < fArray2.length; ++i) {
            d += Math.pow(fArray[i] - fArray2[i], 2.0);
        }
        return Math.sqrt(d);
    }

    public static boolean isFinite(double d) {
        return !Double.isInfinite(d) && !Double.isNaN(d);
    }

    public static boolean isFinite(float f) {
        return !Float.isInfinite(f) && !Float.isNaN(f);
    }

    public static float[] derivative(float[] fArray, float f) {
        float[] fArray2 = new float[fArray.length];
        for (int i = 1; i < fArray.length; ++i) {
            fArray2[i] = (fArray[i] - fArray[i - 1]) / f;
        }
        if (fArray.length > 0) {
            fArray2[0] = fArray2[1];
        }
        return fArray2;
    }

    public static float xCor(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i] * fArray2[i];
            f2 += fArray[i] * fArray[i];
            f3 += fArray2[i] * fArray2[i];
        }
        if (f == 0.0f) {
            return 0.0f;
        }
        return f / (float)Math.sqrt(f2 * f3);
    }

    @Deprecated
    public static float[][] rotateNorthEastToRadialTransversal(float[] fArray, float[] fArray2, float f) {
        float[] fArray3 = new float[fArray.length];
        float[] fArray4 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray3[i] = (float)((double)fArray2[i] * Math.sin(((double)f + 180.0) * 2.0 * Math.PI / 360.0) + (double)fArray[i] * Math.cos(((double)f + 180.0) * 2.0 * Math.PI / 360.0));
            fArray4[i] = (float)((double)fArray2[i] * Math.cos(((double)f + 180.0) * 2.0 * Math.PI / 360.0) - (double)fArray[i] * Math.sin(((double)f + 180.0) * 2.0 * Math.PI / 360.0));
        }
        return new float[][]{fArray3, fArray4};
    }

    public static float[][] rotateZNE(float f, float f2, float[] fArray, float[] fArray2, float[] fArray3, boolean bl) {
        double d = (double)f / 180.0 * Math.PI;
        double d2 = (double)f2 / 180.0 * Math.PI;
        Matrix matrix = new Matrix((double[][])new double[][]{{Math.cos(d2), -Math.sin(d2) * Math.sin(d), -Math.sin(d2) * Math.cos(d)}, {Math.sin(d2), Math.cos(d2) * Math.sin(d), Math.cos(d2) * Math.cos(d)}, {0.0, -Math.cos(d), Math.sin(d)}});
        Matrix matrix2 = new Matrix((double[][])new double[][]{{Math.cos(d), Math.sin(d)}, {-Math.sin(d), Math.cos(d)}});
        float[] fArray4 = new float[fArray2.length];
        float[] fArray5 = new float[fArray.length];
        float[] fArray6 = new float[fArray3.length];
        for (int i = 0; i < fArray.length; ++i) {
            double[][] dArray;
            Matrix matrix3;
            if (bl) {
                matrix3 = new Matrix((double[][])new double[][]{{fArray[i]}, {fArray3[i]}, {fArray2[i]}});
                dArray = matrix.times(matrix3).getArray();
                fArray5[i] = (float)dArray[0][0];
                fArray4[i] = (float)dArray[1][0];
                fArray6[i] = (float)dArray[2][0];
                continue;
            }
            matrix3 = new Matrix((double[][])new double[][]{{fArray2[i]}, {fArray3[i]}});
            dArray = matrix2.times(matrix3).getArray();
            fArray5[i] = fArray[i];
            fArray4[i] = (float)dArray[0][0];
            fArray6[i] = (float)dArray[1][0];
        }
        return new float[][]{fArray5, fArray4, fArray6};
    }

    public static double getFisher(float[][] fArray) {
        int n = fArray.length;
        int n2 = fArray[0].length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d4 = 0.0;
            for (int j = 0; j < n; ++j) {
                d4 += (double)fArray[j][i];
                d2 += (double)fArray[j][i];
                d3 += (double)(fArray[j][i] * fArray[j][i]);
            }
            d += d4 * d4;
        }
        d2 *= d2;
        double d5 = (double)n2 * ((double)n - 1.0) * (d - d2 / (double)n2);
        double d6 = (double)n * ((double)n2 - 1.0) * (d3 - d / (double)n);
        return d5 / d6;
    }

    public static double getFK(float[][] fArray) {
        int n = fArray.length;
        int n2 = fArray[0].length;
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                d2 += (double)fArray[j][i];
            }
            d += (d2 /= (double)n) * d2;
        }
        return d / (double)n2;
    }

    private void test() {
        int n;
        float[] fArray = new float[10];
        float[] fArray2 = new float[10];
        float[] fArray3 = new float[10];
        Random random = new Random();
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = random.nextFloat();
            fArray2[i] = random.nextFloat();
            fArray3[i] = random.nextFloat();
        }
        float[][] fArray4 = MathUtil.rotateNorthEastToRadialTransversal(fArray2, fArray3, 15.0f);
        for (int i = 0; i < fArray4.length; ++i) {
            for (n = 0; n < fArray4[i].length; ++n) {
                System.out.print(fArray4[i][n] + "\t");
            }
            System.out.println();
        }
        System.out.println();
        float[][] fArray5 = MathUtil.rotateZNE(15.0f, -1.0f, fArray, fArray2, fArray3, false);
        for (n = 0; n < fArray5.length; ++n) {
            for (int i = 0; i < fArray5[n].length; ++i) {
                System.out.print(fArray5[n][i] + "\t");
            }
            System.out.println();
        }
    }
}

