/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

public class SiPrefixedValue<T extends Number> {
    private final T originalValue;
    private float prefixedValue;
    private String prefix;
    private static final String[] PREFIX_LIST = new String[]{"n", "\u03bc", "m", "", "k"};
    private static final float[] VALUE_LIST = new float[]{1.0E-9f, 1.0E-6f, 0.001f, 1.0f, 1000.0f};

    public SiPrefixedValue(T t) {
        this.originalValue = t;
        this.init();
    }

    private void init() {
        int n = 0;
        float f = ((Number)this.originalValue).floatValue();
        float f2 = Math.abs(f);
        if (f2 < VALUE_LIST[0]) {
            n = 0;
        } else if (f2 >= VALUE_LIST[VALUE_LIST.length - 1]) {
            n = VALUE_LIST.length - 1;
        } else {
            for (int i = 1; i < PREFIX_LIST.length; ++i) {
                if (!(f2 >= VALUE_LIST[i - 1]) || !(f2 < VALUE_LIST[i])) continue;
                n = i - 1;
                break;
            }
        }
        this.prefixedValue = f / VALUE_LIST[n];
        this.prefix = PREFIX_LIST[n];
    }

    public T getOriginalValue() {
        return this.originalValue;
    }

    public float getPrefixedValue() {
        return this.prefixedValue;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

