/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.AbstractBean;
import edu.geophys.commons.util.JAXBSerializable;
import edu.geophys.commons.util.JAXBUtil;
import edu.geophys.commons.util.LogUtil;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;

@XmlRootElement(name="StaLtaConfig")
public class StaLtaConfig
extends AbstractBean
implements JAXBSerializable {
    private static final long serialVersionUID = 1L;
    @XmlTransient
    public final String DEFAULT_CONFIGFILE = SuiteManager.INSTANCE.getKnowledgebase().getKnowledgeFolder().getAbsolutePath() + File.separator + "stalta.xml";
    private int packageLen = 120;
    private int overlap = 50;
    private float fl = 4.0f;
    private float fu = 40.0f;
    private int order = 2;
    private double nsta = 0.8;
    private double nlta = 10.0;
    private int coincidence = 1;
    private double maxDiff = 2.0;
    private double minDiff = 20.0;
    private float uplevel = 25.0f;
    private float downlevel = 1.0f;
    private int[] snsNr = new int[0];
    private boolean overwrite = true;
    private double globalstart = 0.0;
    private double globalend = 0.0;
    private float jmean = 3.0f;
    private float jvari = 0.0f;
    private float jrise = 2.5f;
    private float jfall = 0.7f;
    private float thr = 1.0f;
    private StaLtaTriggerMethod triggerMethod = StaLtaTriggerMethod.RECURSIVE;

    private final void shallowCopyFrom(StaLtaConfig staLtaConfig) {
        this.fl = staLtaConfig.fl;
        this.fu = staLtaConfig.fu;
        this.order = staLtaConfig.order;
        this.nsta = staLtaConfig.nsta;
        this.nlta = staLtaConfig.nlta;
        this.coincidence = staLtaConfig.coincidence;
        this.maxDiff = staLtaConfig.maxDiff;
        this.minDiff = staLtaConfig.minDiff;
        this.uplevel = staLtaConfig.uplevel;
        this.downlevel = staLtaConfig.downlevel;
        this.packageLen = staLtaConfig.packageLen;
        this.overlap = staLtaConfig.overlap;
        this.snsNr = staLtaConfig.snsNr;
        this.overwrite = staLtaConfig.overwrite;
        this.globalstart = staLtaConfig.globalstart;
        this.globalend = staLtaConfig.globalend;
        this.jmean = staLtaConfig.jmean;
        this.jvari = staLtaConfig.jvari;
        this.jrise = staLtaConfig.jrise;
        this.jfall = staLtaConfig.jfall;
        this.thr = staLtaConfig.thr;
        this.triggerMethod = staLtaConfig.triggerMethod;
    }

    public void load() {
        try {
            StaLtaConfig staLtaConfig = (StaLtaConfig)JAXBUtil.readXML(new File(this.DEFAULT_CONFIGFILE), this.getClass());
            this.shallowCopyFrom(staLtaConfig);
        }
        catch (Exception exception) {
            LogUtil.info(this.getClass(), "Failed to load STALTA config file, using default values", false);
        }
    }

    public void store() {
        try {
            JAXBUtil.writeXML(this, new File(this.DEFAULT_CONFIGFILE));
        }
        catch (Exception exception) {
            LogUtil.fatal(this.getClass(), "Failed to store STALTA config file", exception);
        }
    }

    public int getPackageLen() {
        return this.packageLen;
    }

    public void setPackageLen(int n) {
        int n2 = this.packageLen;
        this.packageLen = n;
        this.firePropertyChange("packageLen", n2, this.packageLen);
    }

    public int getOverlap() {
        return this.overlap;
    }

    public void setOverlap(int n) {
        int n2 = this.overlap;
        this.overlap = n;
        this.firePropertyChange("overlap", n2, this.overlap);
    }

    public float getFl() {
        return this.fl;
    }

    public void setFl(float f) {
        float f2 = this.fl;
        this.fl = f;
        this.firePropertyChange("fl", Float.valueOf(f2), Float.valueOf(this.fl));
    }

    public float getFu() {
        return this.fu;
    }

    public void setFu(float f) {
        float f2 = this.fu;
        this.fu = f;
        this.firePropertyChange("fu", Float.valueOf(f2), Float.valueOf(this.fu));
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        int n2 = this.order;
        this.order = n;
        this.firePropertyChange("order", n2, this.order);
    }

    public double getNsta() {
        return this.nsta;
    }

    public void setNsta(double d) {
        double d2 = this.nsta;
        this.nsta = d;
        this.firePropertyChange("nsta", d2, this.nsta);
    }

    public double getNlta() {
        return this.nlta;
    }

    public void setNlta(double d) {
        double d2 = this.nlta;
        this.nlta = d;
        this.firePropertyChange("nlta", d2, this.nlta);
    }

    public int getCoincidence() {
        return this.coincidence;
    }

    public void setCoincidence(int n) {
        int n2 = this.coincidence;
        this.coincidence = n;
        this.firePropertyChange("coincidence", n2, this.coincidence);
    }

    public double getMaxDiff() {
        return this.maxDiff;
    }

    public void setMaxDiff(double d) {
        double d2 = this.maxDiff;
        this.maxDiff = d;
        this.firePropertyChange("maxDiff", d2, this.maxDiff);
    }

    public double getMinDiff() {
        return this.minDiff;
    }

    public void setMinDiff(double d) {
        double d2 = this.minDiff;
        this.minDiff = d;
        this.firePropertyChange("minDiff", d2, this.minDiff);
    }

    public float getUplevel() {
        return this.uplevel;
    }

    public void setUplevel(float f) {
        float f2 = this.uplevel;
        this.uplevel = f;
        this.firePropertyChange("uplevel", Float.valueOf(f2), Float.valueOf(this.uplevel));
    }

    public float getDownlevel() {
        return this.downlevel;
    }

    public void setDownlevel(float f) {
        float f2 = this.downlevel;
        this.downlevel = f;
        this.firePropertyChange("downlevel", Float.valueOf(f2), Float.valueOf(this.downlevel));
    }

    public int[] getSnsNr() {
        return this.snsNr;
    }

    public void setSnsNr(int[] nArray) {
        this.snsNr = nArray;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public double getGlobalstart() {
        return this.globalstart;
    }

    public void setGlobalstart(double d) {
        this.globalstart = d;
    }

    public double getGlobalend() {
        return this.globalend;
    }

    public void setGlobalend(double d) {
        this.globalend = d;
    }

    public String toString() {
        return "Package length: " + this.getPackageLen() + " Overlap: " + this.getOverlap() + " Fl: " + this.getFl() + " Fu: " + this.getFu() + " Nsta: " + this.getNsta() + " Nlta: " + this.getNlta() + " Coincidence: " + this.getCoincidence() + " MaxDiff: " + this.getMaxDiff() + " MinDiff: " + this.getMinDiff() + " Uplevel: " + this.getUplevel() + " Downlevel: " + this.getDownlevel();
    }

    public float getJmean() {
        return this.jmean;
    }

    public void setJmean(float f) {
        float f2 = this.jmean;
        this.jmean = f;
        this.firePropertyChange("jmean", Float.valueOf(f2), Float.valueOf(this.jmean));
    }

    public float getJvari() {
        return this.jvari;
    }

    public void setJvari(float f) {
        float f2 = this.jvari;
        this.jvari = f;
        this.firePropertyChange("jvari", Float.valueOf(f2), Float.valueOf(this.jvari));
    }

    public float getJrise() {
        return this.jrise;
    }

    public void setJrise(float f) {
        float f2 = this.jrise;
        this.jrise = f;
        this.firePropertyChange("jrise", Float.valueOf(f2), Float.valueOf(this.jrise));
    }

    public float getJfall() {
        return this.jfall;
    }

    public void setJfall(float f) {
        float f2 = this.jfall;
        this.jfall = f;
        this.firePropertyChange("jfall", Float.valueOf(f2), Float.valueOf(this.jfall));
    }

    public float getThr() {
        return this.thr;
    }

    public void setThr(float f) {
        float f2 = this.thr;
        this.thr = f;
        this.firePropertyChange("thr", Float.valueOf(f2), Float.valueOf(this.thr));
    }

    public StaLtaTriggerMethod getTriggerMethod() {
        return this.triggerMethod;
    }

    public void setTriggerMethod(StaLtaTriggerMethod staLtaTriggerMethod) {
        StaLtaTriggerMethod staLtaTriggerMethod2 = this.triggerMethod;
        this.triggerMethod = staLtaTriggerMethod;
        this.firePropertyChange("triggerMethod", (Object)staLtaTriggerMethod2, (Object)this.triggerMethod);
    }

    public static enum StaLtaTriggerMethod {
        SONODET,
        SEISCOMP3,
        SEISMIC_HANDLER,
        RECURSIVE,
        CARL,
        DELAYED,
        CLASSIC,
        COINCIDENCE,
        KURTOSIS;

    }
}

