/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.suite.TraceProvider;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import obspy.FiltUtil;

public class StaLtaDetector {
    private List<Long> detections = new ArrayList<Long>();
    private List<Float> detectionslevels = new ArrayList<Float>();
    private List<Integer> detectionslengths = new ArrayList<Integer>();
    private List<String> detectionstriggerids = new ArrayList<String>();
    private TraceProvider traceProvider = SuiteManager.INSTANCE.getTraceProvider();
    private CampaignKnowledge ck = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();

    public float[][] getSingleTriggers(double d, double d2, String[] stringArray, float f, float f2, double d3, double d4, float f3, float f4) {
        DefaultTrace[] defaultTraceArray = this.traceProvider.requestTrace(d, d + d2, this.ck.getGlobalSamplerate(), stringArray);
        float[][] fArrayArray = new float[defaultTraceArray.length][];
        int n = 0;
        for (DefaultTrace defaultTrace : defaultTraceArray) {
            defaultTrace.setSamples(MathUtil.subMeanZeroNaN(defaultTrace.getSamples()));
            float[] fArray = defaultTrace.getSamples();
            FiltUtil.spr_bp_fast_bworth((float[])fArray, (int)fArray.length, (float)(1.0f / defaultTrace.getSamplerate()), (float)f, (float)f2, (int)4, (boolean)false);
            float[] fArray2 = StaLtaDetector.recursiveStalta(fArray, (float)d3 * defaultTrace.getSamplerate(), (float)d4 * defaultTrace.getSamplerate());
            fArrayArray[n] = fArray2;
            ++n;
        }
        return fArrayArray;
    }

    public boolean[] combinedDetection(float[][] fArray, int n, double d, double d2, double d3, double d4, double d5, String[] stringArray) {
        int n2 = fArray[0].length;
        boolean[] blArray = new boolean[n2];
        int n3 = (int)(d3 * (double)blArray.length / d);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < fArray.length; ++j) {
                int n4;
                int n5;
                int n6;
                if (!((double)fArray[j][i] > d4)) continue;
                float[] fArray2 = new float[fArray.length];
                boolean[] blArray2 = new boolean[fArray.length];
                if (n > 1) {
                    for (n6 = 0; n6 < n3 && i + n6 < n2; ++n6) {
                        for (n5 = 0; n5 < fArray.length; ++n5) {
                            if (!((double)fArray[n5][i + n6] > d4)) continue;
                            if (fArray[n5][i + n6] > fArray2[n5]) {
                                fArray2[n5] = fArray[n5][i + n6];
                            }
                            blArray2[n5] = true;
                        }
                    }
                } else {
                    fArray2[j] = fArray[j][i];
                    blArray2[j] = true;
                }
                n6 = 0;
                for (n5 = 0; n5 < blArray2.length; ++n5) {
                    if (!blArray2[n5]) continue;
                    ++n6;
                }
                if (n6 < n) continue;
                double d6 = d2 + (double)i * d / (double)blArray.length;
                int n7 = i + 1;
                boolean bl = false;
                for (n4 = i + 1; n4 < n2; ++n4) {
                    if (!((double)fArray[j][n4] < d5)) continue;
                    n7 = n4;
                    bl = true;
                    break;
                }
                if (!bl) {
                    n7 = Math.max(n2, n7);
                }
                n4 = (int)((double)(n7 - i) * d / (double)blArray.length * 1000.0);
                float f = 0.0f;
                for (int k = 0; k < fArray.length; ++k) {
                    if (!blArray2[k]) continue;
                    f += fArray2[k];
                }
                blArray[i] = true;
                LogUtil.debug(this.getClass(), "Detection: " + DateTimeUtil.formatDateTimeISOHighPrecision(d6) + " with level " + (f /= (float)n6) + " and length[ms]" + n4 + " coincCount: " + n6);
                this.detections.add((long)(d6 * 1000.0));
                this.detectionslevels.add(Float.valueOf(f));
                this.detectionslengths.add(n4);
                Object object = "";
                for (int k = 0; k < blArray2.length; ++k) {
                    if (!blArray2[k]) continue;
                    object = (String)object + stringArray[k] + ",";
                }
                this.detectionstriggerids.add(((String)object).substring(0, ((String)object).length() - 1));
            }
        }
        return blArray;
    }

    public boolean[] combinedDetectionOld(float[][] fArray, int n, double d, double d2, double d3) {
        int n2;
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Float> arrayList2 = new ArrayList<Float>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList arrayList4 = new ArrayList();
        boolean[] blArray = new boolean[fArray[0].length];
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        ArrayList<Float> arrayList7 = new ArrayList<Float>();
        ArrayList<Integer> arrayList8 = new ArrayList<Integer>();
        int n4 = (int)((double)(10 * blArray.length) / d);
        for (n3 = 0; n3 < fArray.length; ++n3) {
            if (n3 != 0) {
                arrayList4.add(new ArrayList());
            }
            for (n2 = n4; n2 < fArray[0].length; ++n2) {
                if (n3 == 0) {
                    if (fArray[n3][n2] > 0.0f) {
                        arrayList.add(n2);
                        arrayList2.add(Float.valueOf(fArray[n3][n2]));
                        continue;
                    }
                    if (fArray[n3][n2] != -1.0f) continue;
                    arrayList3.add(n2);
                    continue;
                }
                if (!(fArray[n3][n2] > 0.0f)) continue;
                ((List)arrayList4.get(n3 - 1)).add(n2);
            }
        }
        if (arrayList3.size() != arrayList.size()) {
            arrayList3.add((Integer)arrayList.get(arrayList.size() - 1) + 1);
        }
        if (arrayList3.size() != arrayList.size()) {
            LogUtil.error(this.getClass(), "Problem with STA/LTA the list of trigger starts is different from the list of trigger ends");
        }
        n3 = (int)(d3 * (double)blArray.length / d);
        n2 = 0;
        for (Integer object : arrayList) {
            LogUtil.debug(this.getClass(), "Possible: " + object);
            int n5 = 1;
            arrayList5.add(object);
            LogUtil.debug(this.getClass(), "Detec1: " + object);
            boolean[] d4 = new boolean[arrayList4.size()];
            int n6 = 0;
            for (List list : arrayList4) {
                d4[n6] = false;
                for (Integer object2 : list) {
                    LogUtil.debug(this.getClass(), "Detec2: " + object2);
                    if (Math.abs(object - object2) >= n3) continue;
                    LogUtil.debug(this.getClass(), "Smaller maxDiff: " + Math.abs(object - object2));
                    LogUtil.debug(this.getClass(), "Detection: " + arrayList5.size() + " " + object);
                    d4[n6] = true;
                }
                ++n6;
            }
            for (Object object2 : (Object)d4) {
                if (object2 == false) continue;
                ++n5;
            }
            if (n5 >= n) {
                arrayList6.add(object);
                arrayList7.add((Float)arrayList2.get(n2));
                arrayList8.add((Integer)arrayList3.get(n2));
            }
            ++n2;
        }
        int n8 = 0;
        for (Integer n7 : arrayList6) {
            double d4 = d2 + (double)n7.intValue() * d / (double)blArray.length;
            blArray[n7.intValue()] = true;
            LogUtil.info(this.getClass(), "Detection: " + DateTimeUtil.formatDateTimeISO(d4));
            this.detections.add((long)(d4 * 1000.0));
            this.detectionslevels.add((Float)arrayList7.get(n8));
            this.detectionslengths.add((int)((double)((Integer)arrayList8.get(n8) - n7) * d / (double)blArray.length * 1000.0));
            ++n8;
        }
        return blArray;
    }

    public static float[] recursiveStalta(float[] fArray, float f, float f2) {
        int n = fArray.length;
        double d = 1.0 / (double)f;
        double d2 = 1.0 / (double)f2;
        double d3 = 0.0;
        double d4 = Double.MIN_VALUE;
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            double d5 = Math.pow(fArray[i], 2.0);
            d3 = d * d5 + (1.0 - d) * d3;
            d4 = d2 * d5 + (1.0 - d2) * d4;
            fArray2[i] = (float)i < f2 ? 0.0f : (float)(d3 / d4);
        }
        return fArray2;
    }

    public List<Long> getDetections() {
        return this.detections;
    }

    public void setDetections(List<Long> list) {
        this.detections = list;
    }

    public List<Float> getDetectionslevels() {
        return this.detectionslevels;
    }

    public void setDetectionslevels(List<Float> list) {
        this.detectionslevels = list;
    }

    public List<Integer> getDetectionslengths() {
        return this.detectionslengths;
    }

    public void setDetectionslengths(List<Integer> list) {
        this.detectionslengths = list;
    }

    public List<String> getDetectionstriggerids() {
        return this.detectionstriggerids;
    }

    public void setDetectionstriggerids(List<String> list) {
        this.detectionstriggerids = list;
    }
}

