/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.CriticalDepth;
import edu.sc.seis.TauP.DepthRange;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import java.io.Serializable;
import java.util.List;

public class SphericalSModel
extends SlownessModel
implements Serializable {
    public SphericalSModel(VelocityModel vMod) throws NoSuchMatPropException, NoSuchLayerException, SlownessModelException {
        this(vMod, 0.1, 11.0, 115.0, 0.04363323129985824, 0.05, true, 1.0E-16);
    }

    public SphericalSModel(VelocityModel vMod, double minDeltaP, double maxDeltaP, double maxDepthInterval, double maxRangeInterval, double maxInterpError, boolean allowInnerCoreS, double slownessTolerance) throws NoSuchMatPropException, NoSuchLayerException, SlownessModelException {
        super(vMod, minDeltaP, maxDeltaP, maxDepthInterval, maxRangeInterval, maxInterpError, allowInnerCoreS, slownessTolerance);
    }

    public SphericalSModel(double radiusOfEarth, VelocityModel vMod, List<CriticalDepth> criticalDepths, List<DepthRange> highSlownessLayerDepthsP, List<DepthRange> highSlownessLayerDepthsS, List<DepthRange> fluidLayerDepths, List<SlownessLayer> pLayers, List<SlownessLayer> sLayers, double minDeltaP, double maxDeltaP, double maxDepthInterval, double maxRangeInterval, double maxInterpError, boolean allowInnerCoreS, double slownessTolerance) {
        super(radiusOfEarth, vMod, criticalDepths, highSlownessLayerDepthsP, highSlownessLayerDepthsS, fluidLayerDepths, pLayers, sLayers, minDeltaP, maxDeltaP, maxDepthInterval, maxRangeInterval, maxInterpError, allowInnerCoreS, slownessTolerance);
    }

    @Override
    public double toSlowness(double velocity, double depth) throws SlownessModelException {
        if (velocity == 0.0) {
            throw new SlownessModelException("Divide by zero in toSlowness()\ndepth = " + depth + "\nThis likely has to do with using S velocities in the outer core");
        }
        return (this.radiusOfEarth - depth) / velocity;
    }

    @Override
    public double toVelocity(double slowness, double depth) throws SlownessModelException {
        if (slowness == 0.0) {
            throw new SlownessModelException("Divide by zero in toVelocity()\ndepth = " + depth + "\nPossibly this is due to depth at center of the earth?");
        }
        return (this.radiusOfEarth - depth) / slowness;
    }

    @Override
    public SlownessLayer toSlownessLayer(VelocityLayer vLayer, boolean isPWave) throws SlownessModelException {
        return new SlownessLayer(vLayer, true, this.radiusOfEarth, isPWave);
    }

    @Override
    public double interpolate(double p, double topVelocity, double topDepth, double slope) throws SlownessModelException {
        double denominator = p * slope + 1.0;
        if (denominator == 0.0) {
            double depth = Double.MAX_VALUE;
            throw new SlownessModelException("Neg velocity gradient just balances the earth flattening! What should I do?!?!?!? topDepth= " + topDepth);
        }
        double depth = (this.radiusOfEarth + p * (topDepth * slope - topVelocity)) / denominator;
        return depth;
    }

    @Override
    public TimeDist layerTimeDist(double sphericalRayParam, int layerNum, boolean isPWave, boolean downgoing) throws SlownessModelException {
        SlownessLayer sphericalLayer = this.getSlownessLayer(layerNum, isPWave);
        double topRadius = this.radiusOfEarth - sphericalLayer.getTopDepth();
        double botRadius = this.radiusOfEarth - sphericalLayer.getBotDepth();
        if (sphericalRayParam > Math.min(sphericalLayer.getTopP(), sphericalLayer.getBotP())) {
            if (DEBUG) {
                System.out.println("Ray Turns in layer, velocities: " + topRadius / sphericalRayParam + " " + topRadius / sphericalLayer.getTopP() + " " + botRadius / sphericalLayer.getBotP());
                System.out.println("depths        top " + sphericalLayer.getTopDepth() + "  bot " + sphericalLayer.getBotDepth());
            }
            throw new SlownessModelException((isPWave ? "P" : "S") + " Ray turns in the middle of this layer. \nlayerNum = " + layerNum + " sphericalRayParam " + sphericalRayParam + " sphericalLayer =  " + sphericalLayer + "\n");
        }
        return this.layerTimeDistAllowTurn(sphericalRayParam, layerNum, isPWave, downgoing);
    }

    @Override
    public TimeDist layerTimeDistAllowTurn(double sphericalRayParam, int layerNum, boolean isPWave, boolean downgoing) throws SlownessModelException {
        SlownessLayer sphericalLayer = this.getSlownessLayer(layerNum, isPWave);
        if (sphericalRayParam > sphericalLayer.getTopP()) {
            throw new SlownessModelException("Ray cannot propagate within this layer. layerNum = " + layerNum + " sphericalRayParam=" + sphericalRayParam + "\n" + sphericalLayer);
        }
        if (sphericalRayParam > sphericalLayer.getBotP()) {
            double turnDepth = sphericalLayer.bullenDepthFor(sphericalRayParam, this.radiusOfEarth);
            sphericalLayer = new SlownessLayer(sphericalLayer.getTopP(), sphericalLayer.getTopDepth(), sphericalRayParam, turnDepth);
        }
        double topRadius = this.radiusOfEarth - sphericalLayer.getTopDepth();
        double botRadius = this.radiusOfEarth - sphericalLayer.getBotDepth();
        double outDepth = downgoing ? sphericalLayer.getBotDepth() : sphericalLayer.getTopDepth();
        if (sphericalRayParam > Math.max(sphericalLayer.getTopP(), sphericalLayer.getBotP())) {
            throw new SlownessModelException("Ray cannot propagate within this layer. layerNum = " + layerNum + " sphericalRayParam=" + sphericalRayParam + "\n" + sphericalLayer);
        }
        if (sphericalRayParam < 0.0) {
            throw new SlownessModelException("Ray Parameter is negative!!! " + sphericalRayParam);
        }
        if (sphericalLayer.getTopDepth() == sphericalLayer.getBotDepth()) {
            return new TimeDist(sphericalRayParam, 0.0, 0.0, outDepth);
        }
        if (sphericalRayParam == 0.0 && sphericalLayer.getBotDepth() == this.radiusOfEarth) {
            if (layerNum != this.getNumLayers(isPWave) - 1) {
                throw new SlownessModelException("There are layers deeper than the center of the earth!");
            }
            double distRadian = 1.5707963267948966;
            double time = sphericalLayer.getTopP();
            if (DEBUG) {
                System.out.println("Center of Earth: dist " + distRadian + " time " + time);
            }
            if (distRadian < 0.0 || time < 0.0 || Double.isNaN(time) || Double.isNaN(distRadian)) {
                throw new SlownessModelException("CoE timedist <0.0 or NaN: sphericalRayParam= " + sphericalRayParam + " botDepth = " + sphericalLayer.getBotDepth() + " dist=" + distRadian + " time=" + time);
            }
            return new TimeDist(sphericalRayParam, time, distRadian, outDepth);
        }
        if (Math.abs(topRadius / sphericalLayer.getTopP() - botRadius / sphericalLayer.getBotP()) < this.slownessTolerance) {
            double vel = botRadius / sphericalLayer.getBotP();
            double topTerm = topRadius * topRadius - sphericalRayParam * sphericalRayParam * vel * vel;
            if (Math.abs(topTerm) < this.slownessTolerance) {
                topTerm = 0.0;
            }
            double botTerm = sphericalRayParam == sphericalLayer.getBotP() ? 0.0 : botRadius * botRadius - sphericalRayParam * sphericalRayParam * vel * vel;
            double b = Math.sqrt(topTerm) - Math.sqrt(botTerm);
            double time = b / vel;
            double distRadian = Math.asin(b * sphericalRayParam * vel / (topRadius * botRadius));
            if (distRadian < 0.0 || time < 0.0 || Double.isNaN(time) || Double.isNaN(distRadian)) {
                throw new SlownessModelException("CVL timedist <0.0 or NaN: \nsphericalRayParam= " + sphericalRayParam + "\n botDepth = " + sphericalLayer.getBotDepth() + "\n topDepth = " + sphericalLayer.getTopDepth() + "\n topRadius=" + topRadius + " botRadius=" + botRadius + "\n dist=" + distRadian + "\n time=" + time + "\n b=" + b + "\n topTerm=" + topTerm + "\n botTerm=" + botTerm + "\n vel    =" + vel + "\n\n bR^2   =" + botRadius * botRadius + "\n p^2v^2 =" + sphericalRayParam * sphericalRayParam * vel * vel + "\n tR^2   =" + topRadius * topRadius + "\n p^2v^2 =" + sphericalRayParam * sphericalRayParam * vel * vel);
            }
            return new TimeDist(sphericalRayParam, time, distRadian, outDepth);
        }
        return sphericalLayer.bullenRadialSlowness(sphericalRayParam, this.radiusOfEarth, downgoing);
    }

    @Override
    public boolean validate() throws SlownessModelException {
        boolean isOK = super.validate();
        double prevDepth = 0.0;
        boolean isPWave = true;
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < this.getNumLayers(isPWave); ++i) {
                SlownessLayer sLayer = this.getSlownessLayer(i, isPWave);
                prevDepth = sLayer.getBotDepth();
                if (prevDepth > this.radiusOfEarth) {
                    isOK = false;
                    throw new SlownessModelException("Slowness layer has a depth larger than the radius of the earth in a spherical model. max depth = " + prevDepth + " radiusOfEarth = " + this.radiusOfEarth);
                }
                isOK |= true;
            }
            isPWave = false;
        }
        return isOK;
    }

    @Override
    public String toString() {
        String desc = "spherical model:\n" + super.toString();
        return desc;
    }
}

