/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.TauP_Tool;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;

public class TauPDaemon
extends Thread {
    Socket theConnection;
    protected static TauModel[] tauModels = new TauModel[10];

    public TauPDaemon(Socket s) {
        this.theConnection = s;
    }

    static TauModel getTauModel(String modelName) throws FileNotFoundException, InvalidClassException, OptionalDataException, StreamCorruptedException, ClassNotFoundException, IOException, TauModelException {
        for (int i = 0; i < tauModels.length; ++i) {
            if (tauModels[i] == null || !tauModels[i].getModelName().equals(modelName)) continue;
            TauModel tMod = tauModels[i];
            for (int j = i; j > 0; --j) {
                TauPDaemon.tauModels[j] = tauModels[j - 1];
            }
            TauPDaemon.tauModels[0] = tMod;
            return tMod;
        }
        TauModel tMod = TauModelLoader.load(modelName, System.getProperty("taup.model.path"));
        for (int j = tauModels.length - 1; j > 0; --j) {
            TauPDaemon.tauModels[j] = tauModels[j - 1];
        }
        TauPDaemon.tauModels[0] = tMod;
        return tMod;
    }

    public static void main(String[] args) {
        int thePort;
        try {
            thePort = Integer.parseInt(args[0]);
            if (thePort < 0 || thePort > 65535) {
                thePort = 6371;
            }
        }
        catch (Exception e) {
            thePort = 6371;
        }
        String[] modelnames = new String[]{"ak135", "prem", "iasp91"};
        for (int i = 0; i < modelnames.length; ++i) {
            try {
                TauModel tempTMod = TauPDaemon.getTauModel(modelnames[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Couldn't load tau model. " + e.getMessage());
            }
        }
        try {
            ServerSocket server = new ServerSocket(thePort);
            System.out.println("Accepting connections on port " + server.getLocalPort());
            while (true) {
                TauPDaemon taupd = new TauPDaemon(server.accept());
                taupd.start();
            }
        }
        catch (IOException e) {
            System.err.println("Server aborted prematurely. " + e.getMessage());
            return;
        }
    }

    @Override
    public void run() {
        try {
            String line;
            DataOutputStream out = new DataOutputStream(this.theConnection.getOutputStream());
            BufferedReader in = new BufferedReader(new InputStreamReader(this.theConnection.getInputStream()));
            out.writeBytes("Welcome to TauP Travel Time Daemon, version 0.92\n");
            String modelName = "iasp91";
            String phaseString = "P,S,PKP,SKS,PKIKP,SKIKS";
            double depth = 0.0;
            TauModel tMod = null;
            String toolString = "TauP_Time";
            Object tool = null;
            while ((line = in.readLine()) != null) {
                StringTokenizer tokenIn = new StringTokenizer(line);
                String word = tokenIn.nextToken();
                if (word.equals("MODEL")) {
                    try {
                        String tempModelName = tokenIn.nextToken();
                        tMod = TauPDaemon.getTauModel(tempModelName);
                        modelName = tempModelName;
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("Couldn't load tau model. " + e.getMessage());
                    }
                    continue;
                }
                if (word.equals("TOOL")) {
                    toolString = tokenIn.nextToken();
                    continue;
                }
                if (word.equals("PHASES")) {
                    phaseString = tokenIn.nextToken();
                    continue;
                }
                if (word.equals("DEPTH")) {
                    depth = Double.valueOf(tokenIn.nextToken());
                    continue;
                }
                if (!word.equals("DISTANCE")) continue;
                double distance = Double.valueOf(tokenIn.nextToken());
                if (tMod == null) {
                    try {
                        tMod = TauPDaemon.getTauModel(modelName);
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("Couldn't load tau model. " + e.getMessage());
                    }
                }
                if (tool == null || !tool.getClass().getName().endsWith(toolString)) {
                    tool = this.loadTool(toolString, tMod);
                    ((TauP_Time)tool).setSourceDepth(depth);
                }
                if (!tMod.equals(((TauP_Time)tool).getTauModel())) {
                    ((TauP_Time)tool).setTauModel(tMod);
                    System.out.println("Changing tmods");
                }
                if (phaseString != ((TauP_Time)tool).getPhaseNameString()) {
                    ((TauP_Time)tool).parsePhaseList(phaseString);
                    ((TauP_Time)tool).setSourceDepth(depth);
                    phaseString = ((TauP_Time)tool).getPhaseNameString();
                }
                ((TauP_Time)tool).calculate(distance);
                ((TauP_Time)tool).printResult(((TauP_Tool)tool).getWriter());
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        catch (TauModelException e) {
            System.err.println(e.getMessage());
        }
    }

    TauP_Time loadTool(String toolName, TauModel tMod) {
        try {
            Class<?> toolClass = Class.forName("edu.sc.seis.TauP." + toolName);
            Class[] argClasses = new Class[]{Class.forName("edu.sc.seis.TauP.TauModel")};
            Object[] argObjects = new Object[]{tMod};
            Constructor<?> toolConstructor = toolClass.getConstructor(argClasses);
            TauP_Time tool = (TauP_Time)toolConstructor.newInstance(argObjects);
            return tool;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }
}

