/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class VelocityModel
implements Cloneable,
Serializable {
    protected String modelName = "unknown";
    protected double radiusOfEarth = 6371.0;
    public static final double DEFAULT_MOHO = 35.0;
    public static final double DEFAULT_CMB = 2889.0;
    public static final double DEFAULT_IOCB = 5153.9;
    protected double mohoDepth = 35.0;
    protected double cmbDepth = 2889.0;
    protected double iocbDepth = 5153.9;
    protected double minRadius = 0.0;
    protected double maxRadius = 6371.0;
    protected boolean spherical = true;
    protected static int vectorLength = 16;
    protected List<VelocityLayer> layer;

    public VelocityModel(String modelName, double radiusOfEarth, double mohoDepth, double cmbDepth, double iocbDepth, double minRadius, double maxRadius, boolean spherical, List<VelocityLayer> layer) {
        this.modelName = modelName;
        this.radiusOfEarth = radiusOfEarth;
        this.mohoDepth = mohoDepth;
        this.cmbDepth = cmbDepth;
        this.iocbDepth = iocbDepth;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.spherical = spherical;
        this.layer = layer;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName.length() > 0 ? modelName : "unknown";
    }

    public void setRadiusOfEarth(double radiusOfEarth) {
        this.radiusOfEarth = radiusOfEarth;
    }

    public double getRadiusOfEarth() {
        return this.radiusOfEarth;
    }

    public boolean isDisconDepth(double depth) {
        double[] discons = this.getDisconDepths();
        for (int i = 0; i < discons.length; ++i) {
            if (depth != discons[i]) continue;
            return true;
        }
        return false;
    }

    public double[] getDisconDepths() {
        double[] disconDepths = new double[this.getNumLayers() + 2];
        int numFound = 0;
        disconDepths[numFound++] = this.getVelocityLayer(0).getTopDepth();
        for (int layerNum = 0; layerNum < this.getNumLayers() - 1; ++layerNum) {
            VelocityLayer aboveLayer = this.getVelocityLayer(layerNum);
            VelocityLayer belowLayer = this.getVelocityLayer(layerNum + 1);
            if (aboveLayer.getBotPVelocity() == belowLayer.getTopPVelocity() && aboveLayer.getBotSVelocity() == belowLayer.getTopSVelocity()) continue;
            disconDepths[numFound++] = aboveLayer.getBotDepth();
        }
        disconDepths[numFound++] = this.getVelocityLayer(this.getNumLayers() - 1).getBotDepth();
        double[] temp = new double[numFound];
        System.arraycopy(disconDepths, 0, temp, 0, numFound);
        return temp;
    }

    public double getMohoDepth() {
        return this.mohoDepth;
    }

    public void setMohoDepth(double mohoDepth) {
        this.mohoDepth = mohoDepth;
    }

    public double getCmbDepth() {
        return this.cmbDepth;
    }

    public void setCmbDepth(double cmbDepth) {
        this.cmbDepth = cmbDepth;
    }

    public double getIocbDepth() {
        return this.iocbDepth;
    }

    public void setIocbDepth(double iocbDepth) {
        this.iocbDepth = iocbDepth;
    }

    public double getMinRadius() {
        return this.minRadius;
    }

    public void setMinRadius(double minRadius) {
        this.minRadius = minRadius;
    }

    public double getMaxRadius() {
        return this.maxRadius;
    }

    public void setMaxRadius(double maxRadius) {
        this.maxRadius = maxRadius;
    }

    public boolean getSpherical() {
        return this.spherical;
    }

    public void setSpherical(boolean spherical) {
        this.spherical = spherical;
    }

    public VelocityLayer getVelocityLayerClone(int layerNum) {
        return (VelocityLayer)this.layer.get(layerNum).clone();
    }

    public VelocityLayer getVelocityLayer(int layerNum) {
        return this.layer.get(layerNum);
    }

    public int getNumLayers() {
        return this.layer.size();
    }

    public VelocityLayer[] getLayers() {
        return this.layer.toArray(new VelocityLayer[0]);
    }

    public int layerNumberAbove(double depth) throws NoSuchLayerException {
        VelocityLayer tempLayer = this.getVelocityLayer(0);
        if (depth == tempLayer.getTopDepth()) {
            return 0;
        }
        int tooSmallNum = 0;
        int tooLargeNum = this.getNumLayers() - 1;
        int currentNum = 0;
        boolean found = false;
        if (depth < tempLayer.getTopDepth() || this.getVelocityLayer(tooLargeNum).getBotDepth() < depth) {
            throw new NoSuchLayerException(depth);
        }
        while (!found) {
            currentNum = Math.round((float)(tooSmallNum + tooLargeNum) / 2.0f);
            tempLayer = this.getVelocityLayer(currentNum);
            if (tempLayer.getTopDepth() >= depth) {
                tooLargeNum = currentNum - 1;
                continue;
            }
            if (tempLayer.getBotDepth() < depth) {
                tooSmallNum = currentNum + 1;
                continue;
            }
            found = true;
        }
        return currentNum;
    }

    public int layerNumberBelow(double depth) throws NoSuchLayerException {
        VelocityLayer tempLayer = this.getVelocityLayer(0);
        int tooSmallNum = 0;
        int tooLargeNum = this.getNumLayers() - 1;
        int currentNum = 0;
        boolean found = false;
        if (depth == tempLayer.getTopDepth()) {
            return 0;
        }
        if (this.getVelocityLayer(tooLargeNum).getBotDepth() == depth) {
            return tooLargeNum;
        }
        if (depth < tempLayer.getTopDepth() || this.getVelocityLayer(tooLargeNum).getBotDepth() < depth) {
            throw new NoSuchLayerException(depth);
        }
        while (!found) {
            currentNum = Math.round((float)(tooSmallNum + tooLargeNum) / 2.0f);
            tempLayer = this.getVelocityLayer(currentNum);
            if (tempLayer.getTopDepth() > depth) {
                tooLargeNum = currentNum - 1;
                continue;
            }
            if (tempLayer.getBotDepth() <= depth) {
                tooSmallNum = currentNum + 1;
                continue;
            }
            found = true;
        }
        return currentNum;
    }

    public double evaluateAbove(double depth, char materialProperty) throws NoSuchLayerException, NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(this.layerNumberAbove(depth));
        return tempLayer.evaluateAt(depth, materialProperty);
    }

    public double evaluateBelow(double depth, char materialProperty) throws NoSuchLayerException, NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(this.layerNumberBelow(depth));
        return tempLayer.evaluateAt(depth, materialProperty);
    }

    public double evaluateAtTop(int layerNumber, char materialProperty) throws NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(layerNumber);
        return tempLayer.evaluateAtTop(materialProperty);
    }

    public double evaluateAtBottom(int layerNumber, char materialProperty) throws NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(layerNumber);
        return tempLayer.evaluateAtBottom(materialProperty);
    }

    public double depthAtTop(int layerNumber) {
        VelocityLayer tempLayer = this.getVelocityLayer(layerNumber);
        return tempLayer.getTopDepth();
    }

    public double depthAtBottom(int layerNumber) throws NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(layerNumber);
        return tempLayer.getBotDepth();
    }

    public VelocityModel replaceLayers(VelocityLayer[] newLayers, String name, boolean smoothTop, boolean smoothBot) throws VelocityModelException {
        try {
            ArrayList<VelocityLayer> outLayers = new ArrayList<VelocityLayer>();
            int topLayerNum = this.layerNumberBelow(newLayers[0].getTopDepth());
            int numAdded = 0;
            for (int i = 0; i < topLayerNum; ++i) {
                ++numAdded;
                outLayers.add(this.getVelocityLayer(i));
            }
            VelocityLayer topLayer = this.getVelocityLayer(topLayerNum);
            int botLayerNum = this.layerNumberAbove(newLayers[newLayers.length - 1].getBotDepth());
            VelocityLayer botLayer = this.getVelocityLayer(botLayerNum);
            if (topLayer.getTopDepth() < newLayers[0].getTopDepth() && topLayer.getBotDepth() > newLayers[0].getTopDepth()) {
                outLayers.add(new VelocityLayer(numAdded++, topLayer.getTopDepth(), newLayers[0].getTopDepth(), topLayer.getTopPVelocity(), topLayer.evaluateAt(newLayers[0].getTopDepth(), 'P'), topLayer.getTopSVelocity(), topLayer.evaluateAt(newLayers[0].getTopDepth(), 'S'), topLayer.getTopDensity(), topLayer.evaluateAt(newLayers[0].getTopDepth(), 'R')));
                outLayers.add(new VelocityLayer(numAdded++, newLayers[0].getTopDepth(), topLayer.getBotDepth(), topLayer.evaluateAt(newLayers[0].getTopDepth(), 'P'), topLayer.getBotPVelocity(), topLayer.evaluateAt(newLayers[0].getTopDepth(), 'S'), topLayer.getBotSVelocity(), topLayer.evaluateAt(newLayers[0].getTopDepth(), 'R'), topLayer.getBotDensity()));
            } else {
                outLayers.add(topLayer.cloneRenumber(numAdded++));
            }
            for (int i = topLayerNum + 1; i < botLayerNum; ++i) {
                outLayers.add(this.getVelocityLayer(i).cloneRenumber(numAdded++));
            }
            VelocityLayer lastNewLayer = newLayers[newLayers.length - 1];
            if (botLayer.getTopDepth() < lastNewLayer.getBotDepth() && botLayer.getBotDepth() > lastNewLayer.getBotDepth()) {
                outLayers.add(new VelocityLayer(numAdded++, botLayer.getTopDepth(), lastNewLayer.getBotDepth(), botLayer.getTopPVelocity(), botLayer.evaluateAt(lastNewLayer.getBotDepth(), 'P'), botLayer.getTopSVelocity(), botLayer.evaluateAt(lastNewLayer.getBotDepth(), 'S'), botLayer.getTopDensity(), botLayer.evaluateAt(lastNewLayer.getBotDepth(), 'R')));
                outLayers.add(new VelocityLayer(numAdded++, lastNewLayer.getBotDepth(), botLayer.getBotDepth(), botLayer.evaluateAt(lastNewLayer.getBotDepth(), 'P'), botLayer.getBotPVelocity(), botLayer.evaluateAt(lastNewLayer.getBotDepth(), 'S'), botLayer.getBotSVelocity(), botLayer.evaluateAt(lastNewLayer.getBotDepth(), 'R'), botLayer.getBotDensity()));
            } else {
                outLayers.add(botLayer.cloneRenumber(numAdded++));
            }
            for (int i = botLayerNum + 1; i < this.getNumLayers(); ++i) {
                outLayers.add(this.getVelocityLayer(i).cloneRenumber(numAdded++));
            }
            ArrayList<VelocityLayer> replaceoutLayers = new ArrayList<VelocityLayer>();
            numAdded = 0;
            for (VelocityLayer vlay : outLayers) {
                if (!(vlay.getTopDepth() < newLayers[0].getTopDepth())) continue;
                vlay = vlay.cloneRenumber(numAdded++);
                if (smoothTop && vlay.getBotDepth() == newLayers[0].getTopDepth()) {
                    vlay.setBotPVelocity(newLayers[0].getTopPVelocity());
                    vlay.setBotSVelocity(newLayers[0].getTopSVelocity());
                    vlay.setBotDensity(newLayers[0].getTopDensity());
                }
                replaceoutLayers.add(vlay);
            }
            for (VelocityLayer vlay : newLayers) {
                replaceoutLayers.add(vlay.cloneRenumber(numAdded++));
            }
            for (VelocityLayer vlay : outLayers) {
                if (!(vlay.getBotDepth() > lastNewLayer.getBotDepth())) continue;
                vlay = vlay.cloneRenumber(numAdded++);
                if (smoothBot && vlay.getTopDepth() == lastNewLayer.getBotDepth()) {
                    vlay.setTopPVelocity(lastNewLayer.getBotPVelocity());
                    vlay.setTopSVelocity(lastNewLayer.getBotSVelocity());
                    vlay.setTopDensity(lastNewLayer.getBotDensity());
                }
                replaceoutLayers.add(vlay);
            }
            VelocityModel outVMod = new VelocityModel(name, this.getRadiusOfEarth(), this.getMohoDepth(), this.getCmbDepth(), this.getIocbDepth(), this.getMinRadius(), this.getMaxRadius(), this.getSpherical(), replaceoutLayers);
            outVMod.fixDisconDepths();
            boolean isValid = outVMod.validate();
            if (!isValid) {
                throw new VelocityModelException("replace layers but now is not valid.");
            }
            return outVMod;
        }
        catch (NoSuchMatPropException e) {
            throw new RuntimeException(e);
        }
    }

    public void printGMT(String filename) throws IOException {
        String psFile = filename == "stdout" ? "taup_velocitymodel" : (filename.endsWith(".gmt") ? filename.substring(0, filename.length() - 4) + ".ps" : filename + ".ps");
        PrintWriter dos = filename == "stdout" ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        dos.println("#!/bin/sh");
        dos.println("#\n# This script will plot the " + this.getModelName() + " velocity model using GMT. If you want to\n#use this as a data file for psxy in another script, delete these\n# first lines, as well as the last line.\n#");
        dos.println("/bin/rm -f " + psFile + " gmt.history\n");
        double maxVel = 0.0;
        for (VelocityLayer vLayer : this.layer) {
            if (vLayer.getTopPVelocity() > maxVel) {
                maxVel = vLayer.getTopPVelocity();
            }
            if (vLayer.getBotPVelocity() > maxVel) {
                maxVel = vLayer.getBotPVelocity();
            }
            if (vLayer.getTopSVelocity() > maxVel) {
                maxVel = vLayer.getTopSVelocity();
            }
            if (!(vLayer.getBotSVelocity() > maxVel)) continue;
            maxVel = vLayer.getBotSVelocity();
        }
        dos.println("PCOLOR=0/0/255");
        dos.println("SCOLOR=255/0/0");
        dos.println();
        dos.println("gmt psbasemap -JX6i/-9i -P -R0/" + (maxVel *= 1.05) + "/0/" + this.getMaxRadius() + " -Bxa2f1+l'Velocity (km/s)' -Byf200a400+l'Depth (km)' -BWSen+t'" + this.getModelName() + "'  -K > " + psFile);
        dos.println();
        dos.println("gmt psxy -JX -P -R -W2p,${PCOLOR} -: -m -O -K >> " + psFile + " <<END");
        this.printGMTforP(dos);
        dos.println("END\n");
        dos.println("gmt psxy -JX -P -R -W2p,${SCOLOR} -: -m -O >> " + psFile + " <<END");
        this.printGMTforS(dos);
        dos.println("END\n");
        dos.println("# convert ps to pdf, clean up .ps file");
        dos.println("gmt psconvert -P -Tf  " + psFile + " && rm " + psFile);
        dos.println("# clean up after gmt...");
        dos.println("/bin/rm gmt.history");
        dos.close();
    }

    public void printGMT(PrintWriter dos) throws IOException {
        dos.println("> P velocity for " + this.modelName + "  below");
        this.printGMTforP(dos);
        dos.println("> S velocity for " + this.modelName + "  below");
        this.printGMTforP(dos);
    }

    void printGMTforP(PrintWriter dos) throws IOException {
        double pVel = -1.0;
        for (int layerNum = 0; layerNum < this.getNumLayers(); ++layerNum) {
            VelocityLayer currVelocityLayer = this.getVelocityLayer(layerNum);
            if (currVelocityLayer.getTopPVelocity() != pVel) {
                dos.println((float)currVelocityLayer.getTopDepth() + " " + (float)currVelocityLayer.getTopPVelocity());
            }
            dos.println((float)currVelocityLayer.getBotDepth() + " " + (float)currVelocityLayer.getBotPVelocity());
            pVel = currVelocityLayer.getBotPVelocity();
        }
    }

    void printGMTforS(PrintWriter dos) throws IOException {
        double sVel = -1.0;
        for (int layerNum = 0; layerNum < this.getNumLayers(); ++layerNum) {
            VelocityLayer currVelocityLayer = this.getVelocityLayer(layerNum);
            if (currVelocityLayer.getTopSVelocity() != sVel) {
                dos.println((float)currVelocityLayer.getTopDepth() + " " + (float)currVelocityLayer.getTopSVelocity());
            }
            dos.println((float)currVelocityLayer.getBotDepth() + " " + (float)currVelocityLayer.getBotSVelocity());
            sVel = currVelocityLayer.getBotSVelocity();
        }
    }

    public boolean validate() {
        if (this.radiusOfEarth <= 0.0) {
            System.err.println("Radius of earth is not positive. radiusOfEarth = " + this.radiusOfEarth);
            return false;
        }
        if (this.mohoDepth < 0.0) {
            System.err.println("mohoDepth is not non-negative. mohoDepth = " + this.mohoDepth);
            return false;
        }
        if (this.cmbDepth < this.mohoDepth) {
            System.err.println("cmbDepth < mohoDepth. cmbDepth = " + this.cmbDepth + " mohoDepth = " + this.mohoDepth);
            return false;
        }
        if (this.cmbDepth < 0.0) {
            System.err.println("cmbDepth is negative. cmbDepth = " + this.cmbDepth);
            return false;
        }
        if (this.iocbDepth < this.cmbDepth) {
            System.err.println("iocbDepth < cmbDepth. iocbDepth = " + this.iocbDepth + " cmbDepth = " + this.cmbDepth);
            return false;
        }
        if (this.iocbDepth < 0.0) {
            System.err.println("iocbDepth is negative. iocbDepth = " + this.iocbDepth);
            return false;
        }
        if (this.minRadius < 0.0) {
            System.err.println("minRadius is not non-negative. minRadius = " + this.minRadius);
            return false;
        }
        if (this.maxRadius <= 0.0) {
            System.err.println("maxRadius is not positive. maxRadius = " + this.maxRadius);
            return false;
        }
        if (this.maxRadius <= this.minRadius) {
            System.err.println("maxRadius <= minRadius. maxRadius = " + this.maxRadius + " minRadius = " + this.minRadius);
            return false;
        }
        VelocityLayer currVelocityLayer = this.getVelocityLayer(0);
        VelocityLayer prevVelocityLayer = new VelocityLayer(0, currVelocityLayer.getTopDepth(), currVelocityLayer.getTopDepth(), currVelocityLayer.getTopPVelocity(), currVelocityLayer.getTopPVelocity(), currVelocityLayer.getTopSVelocity(), currVelocityLayer.getTopSVelocity(), currVelocityLayer.getTopDensity(), currVelocityLayer.getTopDensity());
        for (int layerNum = 0; layerNum < this.getNumLayers(); ++layerNum) {
            currVelocityLayer = this.getVelocityLayer(layerNum);
            if (prevVelocityLayer.getBotDepth() != currVelocityLayer.getTopDepth()) {
                System.err.println("There is a gap in the velocity model between layers " + (layerNum - 1) + " and " + layerNum);
                System.err.println("prevVelocityLayer=" + prevVelocityLayer);
                System.err.println("currVelocityLayer=" + currVelocityLayer);
                return false;
            }
            if (currVelocityLayer.getBotDepth() == currVelocityLayer.getTopDepth()) {
                System.err.println("There is a zero thickness layer in the velocity model at layer " + layerNum);
                System.err.println("prevVelocityLayer=" + prevVelocityLayer);
                System.err.println("currVelocityLayer=" + currVelocityLayer);
                return false;
            }
            if (currVelocityLayer.getTopPVelocity() <= 0.0 || currVelocityLayer.getBotPVelocity() <= 0.0) {
                System.err.println("There is a negative P velocity layer in the velocity model at layer " + layerNum);
                return false;
            }
            if (currVelocityLayer.getTopSVelocity() < 0.0 || currVelocityLayer.getBotSVelocity() < 0.0) {
                System.err.println("There is a negative S velocity layer in the velocity model at layer " + layerNum);
                return false;
            }
            if (currVelocityLayer.getTopPVelocity() != 0.0 && currVelocityLayer.getBotPVelocity() == 0.0 || currVelocityLayer.getTopPVelocity() == 0.0 && currVelocityLayer.getBotPVelocity() != 0.0) {
                System.err.println("There is a layer that goes to zero P velocity without a discontinuity in the velocity model at layer " + layerNum + "\nThis would cause a divide by zero within this depth range. Try making the velocity small, followed by a discontinuity to zero velocity.");
                return false;
            }
            if (currVelocityLayer.getTopSVelocity() != 0.0 && currVelocityLayer.getBotSVelocity() == 0.0 || currVelocityLayer.getTopSVelocity() == 0.0 && currVelocityLayer.getBotSVelocity() != 0.0) {
                System.err.println("There is a layer that goes to zero S velocity without a discontinuity in the velocity model at layer " + layerNum + "\nThis would cause a divide by zero within this depth range. Try making the velocity small, followed by a discontinuity to zero velocity.");
                return false;
            }
            prevVelocityLayer = currVelocityLayer;
        }
        return true;
    }

    public String toString() {
        String desc = "modelName=" + this.modelName + "\n\n radiusOfEarth=" + this.radiusOfEarth + "\n mohoDepth=" + this.mohoDepth + "\n cmbDepth=" + this.cmbDepth + "\n iocbDepth=" + this.iocbDepth + "\n minRadius=" + this.minRadius + "\n maxRadius=" + this.maxRadius + "\n spherical=" + this.spherical;
        desc = desc + "\ngetNumLayers()=" + this.getNumLayers() + "\n";
        return desc;
    }

    public void writeToND(Writer out) throws IOException {
        VelocityLayer prev = null;
        for (VelocityLayer vlay : this.getLayers()) {
            if (prev == null || prev.getBotPVelocity() != vlay.getTopPVelocity() || prev.getBotSVelocity() != vlay.getTopSVelocity() || prev.getBotDensity() != vlay.getTopDensity()) {
                out.write(vlay.getTopDepth() + " " + vlay.getTopPVelocity() + " " + vlay.getTopSVelocity() + " " + vlay.getTopDensity() + "\n");
            }
            out.write(vlay.getBotDepth() + " " + vlay.getBotPVelocity() + " " + vlay.getBotSVelocity() + " " + vlay.getBotDensity() + "\n");
            if (vlay.getBotDepth() == this.getMohoDepth()) {
                out.write("mantle\n");
            }
            if (vlay.getBotDepth() == this.getCmbDepth()) {
                out.write("outer-core\n");
            }
            if (vlay.getBotDepth() == this.getIocbDepth()) {
                out.write("inner-core\n");
            }
            prev = vlay;
        }
    }

    public void print() {
        for (int i = 0; i < this.getNumLayers(); ++i) {
            System.out.println(this.getVelocityLayer(i));
        }
    }

    public static String getModelNameFromFileName(String filename) {
        String modelFilename;
        int j = filename.lastIndexOf(System.getProperty("file.separator"));
        String modelName = modelFilename = filename.substring(j + 1);
        modelName = modelFilename.endsWith("tvel") ? modelFilename.substring(0, modelFilename.length() - 5) : (modelFilename.endsWith(".nd") ? modelFilename.substring(0, modelFilename.length() - 3) : (modelFilename.startsWith("GB.") ? modelFilename.substring(3, modelFilename.length()) : modelFilename));
        return modelName;
    }

    public static VelocityModel readVelocityFile(String filename, String fileType) throws IOException, VelocityModelException {
        VelocityModel vMod;
        File f;
        if (fileType == null || fileType.equals("")) {
            if (filename.endsWith(".nd")) {
                fileType = ".nd";
            } else if (filename.endsWith(".tvel")) {
                fileType = ".tvel";
            }
        }
        if (fileType.startsWith(".")) {
            fileType = fileType.substring(1, fileType.length());
        }
        if (!(f = new File(filename)).exists() && !filename.endsWith("." + fileType) && new File(filename + "." + fileType).exists()) {
            f = new File(filename + "." + fileType);
        }
        if (fileType.equalsIgnoreCase("nd")) {
            vMod = VelocityModel.readNDFile(f);
        } else if (fileType.equalsIgnoreCase("tvel")) {
            vMod = VelocityModel.readTVelFile(f);
        } else {
            throw new VelocityModelException("What type of velocity file, .tvel or .nd?");
        }
        return vMod;
    }

    public static VelocityModel readTVelFile(File file) throws IOException, VelocityModelException {
        FileReader fileIn = new FileReader(file);
        VelocityModel vmod = VelocityModel.readTVelFile(fileIn, VelocityModel.getModelNameFromFileName(file.getName()));
        fileIn.close();
        return vmod;
    }

    public static VelocityModel readTVelFile(Reader in, String modelName) throws IOException, VelocityModelException {
        double topDensity;
        StreamTokenizer tokenIn = new StreamTokenizer(in);
        tokenIn.commentChar(35);
        tokenIn.slashStarComments(true);
        tokenIn.slashSlashComments(true);
        tokenIn.eolIsSignificant(true);
        tokenIn.parseNumbers();
        while (tokenIn.nextToken() != 10) {
        }
        while (tokenIn.nextToken() != 10) {
        }
        int myLayerNumber = 0;
        tokenIn.nextToken();
        double topDepth = tokenIn.nval;
        tokenIn.nextToken();
        double topPVel = tokenIn.nval;
        tokenIn.nextToken();
        double topSVel = tokenIn.nval;
        if (topSVel > topPVel) {
            throw new VelocityModelException("S velocity, " + topSVel + " at depth " + topDepth + " is greater than the P velocity, " + topPVel);
        }
        tokenIn.nextToken();
        if (tokenIn.ttype != 10) {
            topDensity = tokenIn.nval;
            tokenIn.nextToken();
        } else {
            topDensity = 5571.0;
        }
        if (tokenIn.ttype != 10) {
            throw new VelocityModelException("Should have found an EOL but didn't Layer=" + myLayerNumber + " tokenIn=" + tokenIn);
        }
        tokenIn.nextToken();
        ArrayList<VelocityLayer> layers = new ArrayList<VelocityLayer>();
        while (tokenIn.ttype != -1) {
            double botDensity;
            double botDepth = tokenIn.nval;
            tokenIn.nextToken();
            double botPVel = tokenIn.nval;
            tokenIn.nextToken();
            double botSVel = tokenIn.nval;
            if (botSVel > botPVel) {
                throw new VelocityModelException("S velocity, " + botSVel + " at depth " + botDepth + " is greater than the P velocity, " + botPVel);
            }
            tokenIn.nextToken();
            if (tokenIn.ttype != 10) {
                botDensity = tokenIn.nval;
                tokenIn.nextToken();
            } else {
                botDensity = topDensity;
            }
            VelocityLayer tempLayer = new VelocityLayer(myLayerNumber, topDepth, botDepth, topPVel, botPVel, topSVel, botSVel, topDensity, botDensity);
            topDepth = botDepth;
            topPVel = botPVel;
            topSVel = botSVel;
            topDensity = botDensity;
            if (tokenIn.ttype != 10) {
                throw new VelocityModelException("Should have found an EOL but didn't Layer=" + myLayerNumber + " tokenIn=" + tokenIn);
            }
            tokenIn.nextToken();
            if (tempLayer.getTopDepth() == tempLayer.getBotDepth()) continue;
            layers.add(tempLayer);
            ++myLayerNumber;
        }
        double radiusOfEarth = topDepth;
        double maxRadius = topDepth;
        VelocityModel vMod = new VelocityModel(modelName, radiusOfEarth, 35.0, 2889.0, 5153.9, 0.0, maxRadius, true, layers);
        vMod.fixDisconDepths();
        return vMod;
    }

    public static VelocityModel readNDFile(File file) throws IOException, VelocityModelException {
        FileReader fileIn = new FileReader(file);
        VelocityModel vmod = VelocityModel.readNDFile(fileIn, VelocityModel.getModelNameFromFileName(file.getName()));
        fileIn.close();
        return vmod;
    }

    static double readNumber(StreamTokenizer tokenIn) throws IOException, VelocityModelException {
        if (tokenIn.ttype == -2) {
            double out = tokenIn.nval;
            tokenIn.nextToken();
            return out;
        }
        throw new VelocityModelException("expected number but saw " + tokenIn);
    }

    static void readTillEOL(StreamTokenizer tokenIn) throws IOException {
        while (tokenIn.ttype != 10) {
            tokenIn.nextToken();
        }
        tokenIn.nextToken();
    }

    public static VelocityModel readNDFile(Reader in, String modelName) throws IOException, VelocityModelException {
        StreamTokenizer tokenIn = new StreamTokenizer(in);
        tokenIn.commentChar(35);
        tokenIn.slashStarComments(true);
        tokenIn.slashSlashComments(true);
        tokenIn.eolIsSignificant(true);
        tokenIn.parseNumbers();
        int myLayerNumber = 0;
        double topDensity = 2.6;
        double topQp = 1000.0;
        double topQs = 2000.0;
        double botDensity = topDensity;
        double botQp = topQp;
        double botQs = topQs;
        double mohoDepth = 35.0;
        double cmbDepth = 2889.0;
        double iocbDepth = 5153.9;
        boolean previousLineNamedDiscon = false;
        tokenIn.nextToken();
        while (tokenIn.ttype == 10) {
            tokenIn.nextToken();
        }
        while (tokenIn.ttype == -3) {
            if (tokenIn.sval.equalsIgnoreCase("mantle") || tokenIn.sval.equalsIgnoreCase("moho")) {
                mohoDepth = 0.0;
                VelocityModel.readTillEOL(tokenIn);
                continue;
            }
            if (tokenIn.sval.equalsIgnoreCase("outer-core") || tokenIn.sval.equalsIgnoreCase("cmb")) {
                throw new VelocityModelException("Cannot have model with only outer and inner core due to phase naming rules. Use model with all mantle instead.");
            }
            if (tokenIn.sval.equalsIgnoreCase("inner-core") || tokenIn.sval.equalsIgnoreCase("icocb")) {
                throw new VelocityModelException("Cannot have model with only inner core due to phase naming rules. Use model with all mantle instead.");
            }
            throw new VelocityModelException("expected number as first depth but saw word: " + tokenIn.sval);
        }
        double topDepth = VelocityModel.readNumber(tokenIn);
        double topPVel = VelocityModel.readNumber(tokenIn);
        double topSVel = VelocityModel.readNumber(tokenIn);
        if (topSVel > topPVel) {
            throw new VelocityModelException("S velocity, " + topSVel + " at depth " + topDepth + " is greater than the P velocity, " + topPVel);
        }
        if (tokenIn.ttype != 10) {
            topDensity = VelocityModel.readNumber(tokenIn);
            if (tokenIn.ttype != 10) {
                topQp = VelocityModel.readNumber(tokenIn);
                if (tokenIn.ttype != 10) {
                    topQs = VelocityModel.readNumber(tokenIn);
                }
            }
        }
        if (tokenIn.ttype != 10) {
            throw new VelocityModelException("Should have found an EOL but didn't Layer=" + myLayerNumber + " tokenIn=" + tokenIn);
        }
        tokenIn.nextToken();
        ArrayList<VelocityLayer> layers = new ArrayList<VelocityLayer>();
        while (tokenIn.ttype != -1) {
            if (tokenIn.ttype == 10) {
                tokenIn.nextToken();
                continue;
            }
            if (tokenIn.ttype == -3) {
                previousLineNamedDiscon = true;
                if (tokenIn.sval.equalsIgnoreCase("mantle") || tokenIn.sval.equalsIgnoreCase("moho")) {
                    mohoDepth = topDepth;
                }
                if (tokenIn.sval.equalsIgnoreCase("outer-core") || tokenIn.sval.equalsIgnoreCase("cmb")) {
                    cmbDepth = topDepth;
                }
                if (tokenIn.sval.equalsIgnoreCase("inner-core") || tokenIn.sval.equalsIgnoreCase("icocb")) {
                    iocbDepth = topDepth;
                }
                while (tokenIn.ttype != 10) {
                    tokenIn.nextToken();
                }
                tokenIn.nextToken();
                continue;
            }
            double botDepth = VelocityModel.readNumber(tokenIn);
            double botPVel = VelocityModel.readNumber(tokenIn);
            double botSVel = VelocityModel.readNumber(tokenIn);
            if (botSVel > botPVel) {
                throw new VelocityModelException("S velocity, " + botSVel + " at depth " + botDepth + " is greater than the P velocity, " + botPVel);
            }
            if (tokenIn.ttype != 10) {
                botDensity = VelocityModel.readNumber(tokenIn);
                if (tokenIn.ttype != 10) {
                    botQp = VelocityModel.readNumber(tokenIn);
                    if (tokenIn.ttype != 10) {
                        botQs = VelocityModel.readNumber(tokenIn);
                    }
                }
            }
            if (previousLineNamedDiscon && topDepth != botDepth) {
                throw new VelocityModelException("Named discontinuities must be between a repeated depth, but was top=" + topDepth + " bot=" + botDepth);
            }
            if (previousLineNamedDiscon && topPVel == botPVel && topSVel == botSVel) {
                throw new VelocityModelException("Named discontinuities must be a velocity contrast (a very small one is sufficient), but at depth=" + topDepth + " P=" + topPVel + ", " + botPVel + " S=" + topSVel + ", " + botSVel);
            }
            VelocityLayer tempLayer = new VelocityLayer(myLayerNumber, topDepth, botDepth, topPVel, botPVel, topSVel, botSVel, topDensity, botDensity, topQp, botQp, topQs, botQs);
            topDepth = botDepth;
            topPVel = botPVel;
            topSVel = botSVel;
            topDensity = botDensity;
            topQp = botQp;
            topQs = botQs;
            previousLineNamedDiscon = false;
            if (tokenIn.ttype != 10) {
                throw new VelocityModelException("Should have found an EOL but didn't Layer=" + myLayerNumber + " tokenIn=" + tokenIn);
            }
            tokenIn.nextToken();
            if (tempLayer.getTopDepth() == tempLayer.getBotDepth()) continue;
            layers.add(tempLayer);
            ++myLayerNumber;
        }
        double radiusOfEarth = topDepth;
        double maxRadius = topDepth;
        VelocityModel vMod = new VelocityModel(modelName, radiusOfEarth, mohoDepth, cmbDepth, iocbDepth, 0.0, maxRadius, true, layers);
        vMod.fixDisconDepths();
        return vMod;
    }

    public boolean fixDisconDepths() {
        boolean changeMade = false;
        double mohoMin = 65.0;
        double cmbMin = this.radiusOfEarth;
        double iocbMin = this.radiusOfEarth - 100.0;
        double tempMohoDepth = 0.0;
        double tempCmbDepth = this.radiusOfEarth;
        double tempIocbDepth = this.radiusOfEarth;
        VelocityLayer topLayer = this.getVelocityLayer(0);
        double deltaV = 1.0E-4;
        VelocityLayer belowLayer = new VelocityLayer(-1, -1.0, 0.0, topLayer.getTopPVelocity() - deltaV, topLayer.getTopPVelocity() - deltaV, topLayer.getTopSVelocity(), topLayer.getTopSVelocity(), topLayer.getTopDensity(), topLayer.getTopDensity());
        for (int layerNum = 0; layerNum < this.getNumLayers(); ++layerNum) {
            VelocityLayer aboveLayer = belowLayer;
            belowLayer = this.getVelocityLayer(layerNum);
            if (aboveLayer.getBotPVelocity() == belowLayer.getTopPVelocity() && aboveLayer.getBotSVelocity() == belowLayer.getTopSVelocity()) continue;
            if (Math.abs(this.mohoDepth - aboveLayer.getBotDepth()) < mohoMin) {
                tempMohoDepth = aboveLayer.getBotDepth();
                mohoMin = Math.abs(this.mohoDepth - aboveLayer.getBotDepth());
            }
            if (aboveLayer.getBotDepth() > tempMohoDepth && Math.abs(this.cmbDepth - aboveLayer.getBotDepth()) < cmbMin) {
                tempCmbDepth = aboveLayer.getBotDepth();
                cmbMin = Math.abs(this.cmbDepth - aboveLayer.getBotDepth());
            }
            if (aboveLayer.getBotDepth() != tempCmbDepth && (aboveLayer.getBotSVelocity() != 0.0 || !(belowLayer.getTopSVelocity() > 0.0) || !(Math.abs(this.iocbDepth - aboveLayer.getBotDepth()) < iocbMin))) continue;
            tempIocbDepth = aboveLayer.getBotDepth();
            iocbMin = Math.abs(this.iocbDepth - aboveLayer.getBotDepth());
        }
        if (belowLayer.getBotDepth() > tempMohoDepth && Math.abs(this.cmbDepth - belowLayer.getBotDepth()) < cmbMin) {
            tempCmbDepth = belowLayer.getBotDepth();
            cmbMin = Math.abs(this.cmbDepth - belowLayer.getBotDepth());
        }
        if (belowLayer.getBotDepth() == tempCmbDepth || belowLayer.getBotSVelocity() == 0.0 && tempIocbDepth == tempCmbDepth) {
            tempIocbDepth = belowLayer.getBotDepth();
            iocbMin = Math.abs(this.iocbDepth - belowLayer.getBotDepth());
        }
        if (this.mohoDepth != tempMohoDepth || this.cmbDepth != tempCmbDepth || this.iocbDepth != tempIocbDepth) {
            changeMade = true;
        }
        this.mohoDepth = tempMohoDepth;
        this.cmbDepth = tempCmbDepth;
        this.iocbDepth = tempIocbDepth;
        return changeMade;
    }

    public VelocityModel earthFlattenTransform() throws VelocityModelException {
        boolean spherical = false;
        ArrayList<VelocityLayer> layers = new ArrayList<VelocityLayer>(vectorLength);
        for (int i = 0; i < this.getNumLayers(); ++i) {
            VelocityLayer oldLayer = this.getVelocityLayer(i);
            VelocityLayer newLayer = new VelocityLayer(i, this.radiusOfEarth * Math.log(oldLayer.getTopDepth() / this.radiusOfEarth), this.radiusOfEarth * Math.log(oldLayer.getBotDepth() / this.radiusOfEarth), this.radiusOfEarth * oldLayer.getTopPVelocity() / oldLayer.getTopDepth(), this.radiusOfEarth * oldLayer.getBotPVelocity() / oldLayer.getBotDepth(), this.radiusOfEarth * oldLayer.getTopSVelocity() / oldLayer.getTopDepth(), this.radiusOfEarth * oldLayer.getBotSVelocity() / oldLayer.getBotDepth());
            layers.add(newLayer);
        }
        return new VelocityModel(this.modelName, this.getRadiusOfEarth(), this.getMohoDepth(), this.getCmbDepth(), this.getIocbDepth(), this.getMinRadius(), this.getMaxRadius(), spherical, layers);
    }
}

