/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.sonogramMemory;

import edu.geophys.commons.util.Sonolib;
import edu.geophys.sonoview.SonoViewManager;
import edu.geophys.sonoview.sonogramMemory.MemoryObj;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class SonogramMemory {
    private Map<String, LinkedList<MemoryObj>> cachedChannelsMap = new HashMap<String, LinkedList<MemoryObj>>();

    private LinkedList<MemoryObj> getMemoryObjectList(String string) {
        if (!this.cachedChannelsMap.containsKey(string)) {
            this.cachedChannelsMap.put(string, new LinkedList());
        }
        return this.cachedChannelsMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryObj getMemoryObj(String string, double d, double d2, boolean bl) {
        SonogramMemory sonogramMemory = this;
        synchronized (sonogramMemory) {
            MemoryObj memoryObj = new MemoryObj();
            MemoryObj memoryObj2 = new MemoryObj();
            LinkedList<MemoryObj> linkedList = this.getMemoryObjectList(string);
            Iterator iterator = linkedList.iterator();
            if (!bl) {
                while (iterator.hasNext()) {
                    MemoryObj memoryObj3;
                    memoryObj = (MemoryObj)iterator.next();
                    if (memoryObj3.startEpochTime < d) {
                        if (!(memoryObj.startEpochTime > d - 3600.0)) continue;
                        if (memoryObj2.externalNoiseXmedian != null && memoryObj.externalNoiseXmedian != null) {
                            Sonolib.noiseMergeWithAncestor((float[])memoryObj2.externalNoiseXmedian, (float[])memoryObj.externalNoiseXmedian, (float[])memoryObj.externalNoiseXsigma, (float)0.8f);
                        }
                        memoryObj2.setExternalNoise(memoryObj.externalNoiseXmedian, memoryObj.externalNoiseXsigma);
                        continue;
                    }
                    break;
                }
            } else if (bl) {
                while (iterator.hasNext()) {
                    MemoryObj memoryObj4;
                    memoryObj = (MemoryObj)iterator.next();
                    if (memoryObj4.startEpochTime < d2) {
                        if (!(Math.abs(memoryObj.startEpochTime - d) < 1.0)) continue;
                        memoryObj2 = memoryObj;
                        continue;
                    }
                    break;
                }
            }
            return memoryObj2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData(String string, MemoryObj memoryObj) {
        SonogramMemory sonogramMemory = this;
        synchronized (sonogramMemory) {
            int n = 0;
            LinkedList<MemoryObj> linkedList = this.getMemoryObjectList(string);
            MemoryObj memoryObj2 = new MemoryObj();
            Iterator iterator = linkedList.iterator();
            n = 0;
            while (iterator.hasNext()) {
                MemoryObj memoryObj3;
                memoryObj2 = (MemoryObj)iterator.next();
                if (!(memoryObj3.startEpochTime < memoryObj.startEpochTime)) break;
                ++n;
            }
            if (Math.abs(memoryObj.startEpochTime - memoryObj2.startEpochTime) < 1.0) {
                memoryObj2.setExternalNoise(memoryObj.externalNoiseXmedian, memoryObj.externalNoiseXsigma);
            } else {
                linkedList.add(n, memoryObj);
                int n2 = linkedList.size() / SonoViewManager.getInstance().getSettingsManager().getUserConfiguration().getDynAwareDisplayedRows();
                if (n2 > 3) {
                    if (n2 - n > n) {
                        linkedList.remove(linkedList.size() - 1);
                    } else {
                        linkedList.remove(0);
                    }
                }
            }
        }
    }
}

