/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing;

import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.DefaultBoundedLongRangeModel;
import edu.geophys.sonoview.swing.largesonogram.RowDimensonModel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractCommonComponent
extends JPanel {
    public static final String PROPERTY_AXIS_MODEL = "axisModel";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";
    public static final String PROPERTY_ROW_DIMENSIONS_MODEL = "rowDimensionsModel";
    private BoundedLongRangeModel selectionModel;
    private BoundedLongRangeModel axisModel;
    private RowDimensonModel rowDimension = new RowDimensonModel();
    private final ChangeListener axisModelChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AbstractCommonComponent.this.onAxisModelChanged();
        }
    };
    private final ChangeListener selectionModelChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AbstractCommonComponent.this.onSelectionModelChanged();
        }
    };
    private final ChangeListener rowDimensionListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AbstractCommonComponent.this.onRowDimensionChanged();
        }
    };

    public AbstractCommonComponent() {
        this.selectionModel = new DefaultBoundedLongRangeModel();
        this.selectionModel.addChangeListener(this.selectionModelChangeListener);
        this.axisModel = new DefaultBoundedLongRangeModel();
        this.axisModel.addChangeListener(this.axisModelChangeListener);
    }

    public BoundedLongRangeModel getAxisModel() {
        return this.axisModel;
    }

    public void setAxisModel(BoundedLongRangeModel boundedLongRangeModel) {
        if (boundedLongRangeModel == null) {
            throw new IllegalArgumentException("axis model cannot be null");
        }
        BoundedLongRangeModel boundedLongRangeModel2 = this.axisModel;
        boundedLongRangeModel2.removeChangeListener(this.axisModelChangeListener);
        this.axisModel = boundedLongRangeModel;
        this.axisModel.addChangeListener(this.axisModelChangeListener);
        this.firePropertyChange(PROPERTY_AXIS_MODEL, boundedLongRangeModel2, this.axisModel);
    }

    public BoundedLongRangeModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(BoundedLongRangeModel boundedLongRangeModel) {
        if (boundedLongRangeModel == null) {
            throw new IllegalArgumentException("selection model cannot be null");
        }
        BoundedLongRangeModel boundedLongRangeModel2 = this.selectionModel;
        boundedLongRangeModel2.removeChangeListener(this.selectionModelChangeListener);
        this.selectionModel = boundedLongRangeModel;
        this.selectionModel.addChangeListener(this.selectionModelChangeListener);
        this.firePropertyChange(PROPERTY_SELECTION_MODEL, boundedLongRangeModel2, this.axisModel);
    }

    public RowDimensonModel getRowDimension() {
        return this.rowDimension;
    }

    public void setRowDimension(RowDimensonModel rowDimensonModel) {
        RowDimensonModel rowDimensonModel2 = rowDimensonModel;
        if (rowDimensonModel2 != null) {
            rowDimensonModel2.removeChangeListener(this.rowDimensionListener);
        }
        this.rowDimension = rowDimensonModel;
        if (rowDimensonModel != null) {
            rowDimensonModel.addChangeListener(this.rowDimensionListener);
        }
        this.firePropertyChange(PROPERTY_ROW_DIMENSIONS_MODEL, (Object)rowDimensonModel2, (Object)rowDimensonModel);
    }

    protected abstract void onAxisModelChanged();

    protected abstract void onSelectionModelChanged();

    protected abstract void onRowDimensionChanged();
}

