/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing;

import edu.geophys.commons.detection.EventClass;
import edu.geophys.commons.detection.SonoViewDetection;
import edu.geophys.commons.model.SNS;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.util.DateTimeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class EventDialogController {
    private final SonoViewDetection event;

    public EventDialogController(SonoViewDetection sonoViewDetection) {
        this.event = sonoViewDetection;
    }

    public final int showWriteEventDialog(Frame frame) {
        String string = "Save event: " + DateTimeUtil.formatDateTimeISOHighPrecision((long)this.event.getPick().getTimeMs()) + " on station " + this.event.getPick().getTraceIDs()[0];
        return JOptionPane.showOptionDialog(frame, this.getClassButtonPanel(), string, 2, -1, null, null, null);
    }

    public final int showEditEventDialog(Frame frame) {
        Object object = "Edit event ";
        if (this.event.getPick() != null) {
            object = (String)object + DateTimeUtil.formatDateTimeISOHighPrecision((long)this.event.getPick().getTimeMs()) + " on station " + this.event.getPick().getTraceIDs()[0];
        }
        return JOptionPane.showOptionDialog(frame, this.getEditPanel(), (String)object, 2, -1, null, null, null);
    }

    public final int showDeleteEventDialog(Frame frame) {
        String string = "Delete event?";
        JLabel jLabel = new JLabel(this.event.getEventClass().NAME + " event at " + DateTimeUtil.formatDateTimeISOHighPrecision((long)this.event.getPick().getTimeMs()) + " on station " + this.event.getPick().getTraceIDs()[0]);
        Object[] objectArray = new Object[]{"Delete", "Cancel"};
        return JOptionPane.showOptionDialog(frame, jLabel, string, 0, -1, null, objectArray, null);
    }

    private JPanel getClassButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3));
        jPanel.setBorder(BorderFactory.createTitledBorder("Event class"));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (EventClass eventClass : EventClass.getEventClassesSorted()) {
            JRadioButton jRadioButton = this.makeClassButton(eventClass);
            if (eventClass == this.event.getEventClass()) {
                jRadioButton.setSelected(true);
            }
            buttonGroup.add(jRadioButton);
            jPanel.add(jRadioButton);
        }
        return jPanel;
    }

    private JRadioButton makeClassButton(final EventClass eventClass) {
        final JRadioButton jRadioButton = new JRadioButton("<HTML><U>" + eventClass.NUMBER + "</U>: " + eventClass.NAME + "</HTML>");
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventDialogController.this.event.setEventClass(eventClass);
                jRadioButton.setSelected(true);
            }
        };
        if (eventClass.NUMBER >= 0 && eventClass.NUMBER <= 9) {
            jRadioButton.getInputMap(2).put(KeyStroke.getKeyStroke(48 + eventClass.NUMBER, 0), "button" + eventClass.NUMBER);
            jRadioButton.getInputMap(2).put(KeyStroke.getKeyStroke(96 + eventClass.NUMBER, 0), "button" + eventClass.NUMBER);
            jRadioButton.getActionMap().put("button" + eventClass.NUMBER, abstractAction);
        }
        jRadioButton.addActionListener(abstractAction);
        return jRadioButton;
    }

    private JPanel getEditPanel() {
        class ValLabel
        extends JLabel {
            public ValLabel() {
                super(" ", 0);
                this.setBackground(ThemeManager.getInstance().getTheme().getHypolineRed());
                this.setBorder(new EmptyBorder(5, 5, 5, 5));
            }

            public void setVal(SonoViewDetection sonoViewDetection) {
                int n = sonoViewDetection.isValid();
                if (n == 0) {
                    this.setText(" ");
                    this.setOpaque(false);
                } else {
                    this.setText((String)SonoViewDetection.VALIDITY_MESSAGES.get(n));
                    this.setOpaque(true);
                }
            }
        }
        final ValLabel valLabel = new ValLabel();
        Calendar calendar = DateTimeUtil.epochLongToCalendar((long)this.event.getPick().getTimeMs());
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        spinnerDateModel.setCalendarField(13);
        final JSpinner jSpinner = new JSpinner(spinnerDateModel);
        SimpleDateFormat simpleDateFormat = ((JSpinner.DateEditor)jSpinner.getEditor()).getFormat();
        simpleDateFormat.applyPattern("yyyy-MM-dd HH:mm:ss.SSS");
        spinnerDateModel.setValue(calendar.getTime());
        jSpinner.addChangeListener(new ChangeListener(){
            {
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                long l = ((Date)jSpinner.getValue()).getTime();
                EventDialogController.this.getEvent().getPick().setTimeMs(l);
                valLabel.setVal(EventDialogController.this.getEvent());
            }
        });
        SNS[] sNSArray = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge().getAllSNS();
        JComboBox<SNS> jComboBox = new JComboBox<SNS>(sNSArray);
        for (SNS object2 : sNSArray) {
            if (!object2.getID().equals(this.event.getPick().getTraceIDs()[0])) continue;
            jComboBox.setSelectedItem(object2);
        }
        jComboBox.addItemListener(new ItemListener(){
            {
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SNS sNS = (SNS)itemEvent.getItem();
                    EventDialogController.this.getEvent().getPick().setTraceIDs(sNS.getID());
                    valLabel.setVal(EventDialogController.this.getEvent());
                }
            }
        });
        ((JLabel)((Object)jComboBox.getRenderer())).setHorizontalAlignment(4);
        Calendar calendar2 = DateTimeUtil.epochLongToCalendar((long)this.event.getStartTimeMs());
        SpinnerDateModel spinnerDateModel2 = new SpinnerDateModel();
        spinnerDateModel2.setCalendarField(13);
        final JSpinner jSpinner2 = new JSpinner(spinnerDateModel2);
        SimpleDateFormat simpleDateFormat2 = ((JSpinner.DateEditor)jSpinner2.getEditor()).getFormat();
        simpleDateFormat2.applyPattern("yyyy-MM-dd HH:mm:ss.SSS");
        spinnerDateModel2.setValue(calendar2.getTime());
        jSpinner2.addChangeListener(new ChangeListener(){
            {
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                long l = ((Date)jSpinner2.getValue()).getTime();
                EventDialogController.this.getEvent().setStartTimeMs(l);
                valLabel.setVal(EventDialogController.this.getEvent());
            }
        });
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setValue((int)(this.event.getDurationMs() / 1000L));
        spinnerNumberModel.setMinimum(Integer.valueOf(0));
        JSpinner jSpinner3 = new JSpinner(spinnerNumberModel);
        jSpinner3.addChangeListener(new ChangeListener(){
            {
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                EventDialogController.this.getEvent().setDurationMs((long)(1000 * spinnerNumberModel.getNumber().intValue()));
                valLabel.setVal(EventDialogController.this.getEvent());
            }
        });
        JTextArea jTextArea = new JTextArea(this.event.getComment());
        jTextArea.getDocument().addDocumentListener(new DocumentListener(){
            {
            }

            private void writeEvent(DocumentEvent documentEvent) {
                Document document = documentEvent.getDocument();
                try {
                    String string = document.getText(0, document.getLength());
                    EventDialogController.this.getEvent().setComment(string);
                    valLabel.setVal(EventDialogController.this.getEvent());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.writeEvent(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.writeEvent(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        int n = 5;
        gridBagConstraints.insets = new Insets(n, n, n, n);
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)new JLabel("Pick time:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jSpinner, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)new JLabel("Pick station:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add(jComboBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.getClassButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)new JLabel("Event window start:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jSpinner2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)new JLabel("Event window length:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jSpinner3, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)new JLabel("[s]"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)new JLabel("Last modified on:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        JTextField jTextField = new JTextField(DateTimeUtil.formatDateTimeISO((long)this.event.getTimeModifiedMs()) + " UTC");
        jTextField.setEditable(false);
        jPanel.add((Component)jTextField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)new JLabel("By user:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        JTextField jTextField2 = new JTextField(this.event.getUserID());
        jTextField2.setEditable(false);
        jPanel.add((Component)jTextField2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)new JLabel("Comments:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        gridBagConstraints.weighty = 1.0;
        jScrollPane.setPreferredSize(new Dimension(40, 100));
        jScrollPane.setMinimumSize(new Dimension(40, 100));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)valLabel, gridBagConstraints);
        return jPanel;
    }

    public SonoViewDetection getEvent() {
        return this.event;
    }
}

