/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing;

import edu.geophys.commons.detection.AbstractDetection;
import edu.geophys.commons.detection.SonoViewDetection;
import edu.geophys.commons.detection.interfaces.HasOrigin;
import edu.geophys.commons.suite.EventFileManager;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.SuiteTheme;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.PlatformUtil;
import edu.geophys.sonoview.SonoViewManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class EventList
extends JFrame {
    private ArrayList<ColumnSettings> columns;
    private static final int DATELEN = 140;
    private static final String TITLE = "Event List";
    private static final String CSV_SEPARATOR = ",";
    private boolean showFullList = false;
    JTable table;
    JScrollPane scrollPane;

    public EventList() {
        super(TITLE);
        this.setDefaultCloseOperation(1);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.table = new JTable();
        this.updateModel();
        this.table.setDefaultRenderer(Object.class, new EventListCellRenderer());
        this.table.setFocusable(false);
        int n = 32;
        for (ColumnSettings object2 : this.loadColumnSettings(false)) {
            n += object2.getWidth();
        }
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    SonoViewManager.getInstance().getMainFrame().jumpToEvent(EventList.this.getSelectedEvent());
                }
            }
        });
        this.table.doLayout();
        this.table.setAutoResizeMode(0);
        this.setMinimumSize(new Dimension(n, 400));
        this.scrollPane = new JScrollPane(this.table, 22, 30);
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                EventList.this.updateColumnWidths();
            }
        });
        this.add(this.scrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton("Full list");
        jRadioButton.setFocusable(false);
        jRadioButton.addActionListener(this.getFullListAction(true));
        jRadioButton.setSelected(this.showFullList);
        jPanel.add(jRadioButton);
        buttonGroup.add(jRadioButton);
        JRadioButton jRadioButton2 = new JRadioButton("Short list");
        jRadioButton2.setFocusable(false);
        jRadioButton2.addActionListener(this.getFullListAction(false));
        jRadioButton2.setSelected(!this.showFullList);
        jPanel.add(jRadioButton2);
        buttonGroup.add(jRadioButton2);
        jPanel.add(Box.createHorizontalGlue());
        JButton jButton = new JButton("Export as csv ...");
        jButton.setFocusable(false);
        jButton.addActionListener(this.getExportAction());
        jPanel.add(jButton);
        jButton = new JButton("Jump to event");
        jButton.setFocusable(false);
        jButton.addActionListener(this.getJumpAction());
        jPanel.add(jButton);
        this.add(jPanel);
        this.pack();
        this.updateColumnWidths();
    }

    private ArrayList<ColumnSettings> loadColumnSettings(boolean bl) {
        ArrayList<ColumnSettings> arrayList = new ArrayList<ColumnSettings>();
        arrayList.add(new ColumnSettings(">", 14){

            @Override
            public String getDisplayString(AbstractDetection abstractDetection) {
                if (abstractDetection == SonoViewManager.getInstance().getCurrentPattern()) {
                    return ">";
                }
                return "";
            }
        });
        arrayList.add(new ColumnSettings("Onset", 140){

            @Override
            public String getDisplayString(AbstractDetection abstractDetection) {
                return DateTimeUtil.formatDateTimeISO((long)abstractDetection.getIndexTimeMs());
            }
        });
        arrayList.add(new ColumnSettings("@Station", 70){

            @Override
            public String getDisplayString(AbstractDetection abstractDetection) {
                if (abstractDetection instanceof SonoViewDetection) {
                    try {
                        return abstractDetection.getPick().getTraceIDs()[0];
                    }
                    catch (Exception exception) {
                    }
                } else if (abstractDetection instanceof HasOrigin) {
                    return ((HasOrigin)abstractDetection).getNearestStation();
                }
                return "";
            }
        });
        if (bl) {
            arrayList.add(new ColumnSettings("user", 80){

                @Override
                public String getDisplayString(AbstractDetection abstractDetection) {
                    if (abstractDetection instanceof SonoViewDetection) {
                        return ((SonoViewDetection)abstractDetection).getUserID();
                    }
                    return "bulletin";
                }
            });
        }
        arrayList.add(new ColumnSettings("Class", 160){

            @Override
            public String getDisplayString(AbstractDetection abstractDetection) {
                if (abstractDetection instanceof SonoViewDetection) {
                    return ((SonoViewDetection)abstractDetection).getEventClass().NAME;
                }
                return "bulletin";
            }
        });
        if (bl) {
            arrayList.add(new ColumnSettings("SourceTime", 140){

                @Override
                public String getDisplayString(AbstractDetection abstractDetection) {
                    if (abstractDetection instanceof HasOrigin) {
                        return DateTimeUtil.formatDateTimeISO((long)((HasOrigin)abstractDetection).getSourceTimeMs());
                    }
                    return "";
                }
            });
            arrayList.add(new ColumnSettings("Lat.", 60){

                @Override
                public String getDisplayString(AbstractDetection abstractDetection) {
                    if (abstractDetection instanceof HasOrigin) {
                        return String.format("%.3f", ((HasOrigin)abstractDetection).getLatitude());
                    }
                    return "";
                }
            });
            arrayList.add(new ColumnSettings("Lon.", 60){

                @Override
                public String getDisplayString(AbstractDetection abstractDetection) {
                    if (abstractDetection instanceof HasOrigin) {
                        return String.format("%.3f", ((HasOrigin)abstractDetection).getLongitude());
                    }
                    return "";
                }
            });
            arrayList.add(new ColumnSettings("Depth [km]", 40){

                @Override
                public String getDisplayString(AbstractDetection abstractDetection) {
                    if (abstractDetection instanceof HasOrigin) {
                        return String.format("%.1f", ((HasOrigin)abstractDetection).getDepthKm());
                    }
                    return "";
                }
            });
            arrayList.add(new ColumnSettings("Mag.", 40){

                @Override
                public String getDisplayString(AbstractDetection abstractDetection) {
                    if (abstractDetection instanceof HasOrigin) {
                        return String.format("%.1f", ((HasOrigin)abstractDetection).getMagnitude());
                    }
                    return "";
                }
            });
        }
        arrayList.add(new ColumnSettings("Comment", 250){

            @Override
            public String getDisplayString(AbstractDetection abstractDetection) {
                return abstractDetection.getComment();
            }
        });
        return arrayList;
    }

    private ActionListener getFullListAction(final boolean bl) {
        final EventList eventList = this;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (eventList.showFullList != bl) {
                    eventList.showFullList = bl;
                    EventList.this.updateModel();
                }
            }
        };
    }

    private ActionListener getExportAction() {
        final EventList eventList = this;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogType(1);
                jFileChooser.setDialogTitle("Export to csv");
                jFileChooser.setSelectedFile(new File(SuiteManager.INSTANCE.getKnowledgebase().getKnowledgeFolder().getParentFile() + PlatformUtil.getSeparator() + "detection.csv"));
                int n = jFileChooser.showSaveDialog(eventList);
                if (n == 0) {
                    try {
                        EventList.this.writeListToFile(jFileChooser.getSelectedFile());
                        LogUtil.info(eventList.getClass(), (String)("Exported event list to " + jFileChooser.getSelectedFile()), (boolean)true);
                    }
                    catch (Exception exception) {
                        LogUtil.error(eventList.getClass(), (String)exception.toString(), (boolean)true);
                    }
                }
            }
        };
    }

    private ActionListener getJumpAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewManager.getInstance().getMainFrame().jumpToEvent(EventList.this.getSelectedEvent());
            }
        };
    }

    public AbstractDetection getSelectedEvent() {
        int n = this.table.convertRowIndexToModel(this.table.getSelectedRow());
        return ((EventTableModel)this.table.getModel()).getDetectionFromRow(n);
    }

    private void writeListToFile(File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write("#");
        int n = 0;
        for (ColumnSettings columnSettings : this.columns) {
            if (n > 0) {
                fileWriter.write(columnSettings.getTitle().replaceAll(CSV_SEPARATOR, ""));
                if (n != this.columns.size() - 1) {
                    fileWriter.write(CSV_SEPARATOR);
                }
            }
            ++n;
        }
        fileWriter.write(PlatformUtil.getNewLine());
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            int n2 = this.table.convertRowIndexToModel(i);
            AbstractDetection abstractDetection = ((EventTableModel)this.table.getModel()).getDetectionFromRow(n2);
            n = 0;
            for (ColumnSettings columnSettings : this.columns) {
                if (n > 0) {
                    fileWriter.write(columnSettings.getDisplayString(abstractDetection).replaceAll(CSV_SEPARATOR, ""));
                    if (n != this.columns.size() - 1) {
                        fileWriter.write(CSV_SEPARATOR);
                    }
                }
                ++n;
            }
            fileWriter.write(PlatformUtil.getNewLine());
        }
        fileWriter.close();
    }

    public void updateModel() {
        this.columns = this.loadColumnSettings(this.showFullList);
        EventFileManager eventFileManager = SuiteManager.INSTANCE.getEventFileManager();
        List list = eventFileManager.getAllDetectionEntries();
        ArrayList<AbstractDetection> arrayList = list instanceof ArrayList ? (ArrayList<AbstractDetection>)list : new ArrayList<AbstractDetection>(list);
        Collections.sort(arrayList);
        EventTableModel eventTableModel = new EventTableModel(arrayList);
        this.table.setModel(eventTableModel);
        this.table.setAutoCreateRowSorter(true);
        this.updateColumnWidths();
    }

    private void updateColumnWidths() {
        if (this.table == null || this.scrollPane == null) {
            return;
        }
        int n = this.table.getColumnModel().getColumnCount();
        int n2 = this.scrollPane.getViewport().getWidth();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
            int n3 = this.columns.get(i).getWidth();
            tableColumn.setMinWidth(n3);
            if (i != n - 1) {
                tableColumn.setPreferredWidth(n3);
            } else {
                tableColumn.setPreferredWidth(Math.max(n3, n2));
            }
            n2 -= n3;
        }
    }

    private class EventListCellRenderer
    extends DefaultTableCellRenderer {
        private EventListCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            EventTableModel eventTableModel = (EventTableModel)jTable.getModel();
            AbstractDetection abstractDetection = eventTableModel.getDetectionFromRow(jTable.convertRowIndexToModel(n));
            SuiteTheme suiteTheme = ThemeManager.getInstance().getTheme();
            if (n2 == 0) {
                this.setBackground(abstractDetection.getColor());
            } else {
                this.setBackground(suiteTheme.getPlotBackgroundColor());
            }
            if (abstractDetection == SonoViewManager.getInstance().getCurrentPattern() && n2 != 0) {
                this.setForeground(suiteTheme.getHypolineRed());
                this.setFont(this.getFont().deriveFont(1));
            } else {
                this.setForeground(suiteTheme.getPlotForegroundColor());
                this.setFont(this.getFont().deriveFont(0));
            }
            return this;
        }
    }

    private abstract class ColumnSettings {
        private final int width;
        private final String title;

        public ColumnSettings(String string, int n) {
            this.title = string;
            this.width = n;
        }

        public int getWidth() {
            return this.width;
        }

        public String getTitle() {
            return this.title;
        }

        public abstract String getDisplayString(AbstractDetection var1);
    }

    private class EventTableModel
    extends AbstractTableModel {
        final ArrayList<AbstractDetection> allEvents;

        protected EventTableModel(ArrayList<AbstractDetection> arrayList) {
            this.allEvents = arrayList;
        }

        @Override
        public int getRowCount() {
            return this.allEvents.size();
        }

        @Override
        public int getColumnCount() {
            return EventList.this.columns.size();
        }

        @Override
        public String getColumnName(int n) {
            return EventList.this.columns.get(n).getTitle();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return EventList.this.columns.get(n2).getDisplayString(this.allEvents.get(n));
        }

        public AbstractDetection getDetectionFromRow(int n) {
            return this.allEvents.get(n);
        }
    }
}

