/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing;

import edu.geophys.commons.detection.TraceViewState;
import edu.geophys.commons.model.AbstractTrace;
import edu.geophys.commons.model.TraceMetadata;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.sonoview.SonoViewManager;
import java.util.Arrays;
import obspy.FiltUtil;

public final class FilteringTrace
extends AbstractTrace {
    private static final long serialVersionUID = 8078536111607166803L;
    private AbstractTrace underlyingTrace;
    private float[] filteredData = null;
    public static final int PADDING_SAMPLES = 1024;

    public FilteringTrace(AbstractTrace abstractTrace) {
        super((TraceMetadata)abstractTrace);
        this.underlyingTrace = abstractTrace;
    }

    protected final float _getSample(int n) {
        return this.filteredData != null ? this.filteredData[n] : this.underlyingTrace.getSample(n);
    }

    protected final float[] _getSamples() {
        return this.filteredData != null ? this.filteredData : this.underlyingTrace.getSamples();
    }

    protected final float[] _getSamples(int n, int n2) {
        float[] fArray = this.filteredData != null ? Arrays.copyOfRange(this.filteredData, n, n + n2) : this.underlyingTrace.getSamples(n, n2);
        return fArray;
    }

    public static boolean hasHighpass(TraceViewState.FilterType filterType) {
        boolean bl = false;
        float[][] fArray = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration().getFilterBands();
        switch (filterType) {
            case NONE: {
                break;
            }
            case FIRST: {
                bl = fArray[0][0] > 0.0f;
                break;
            }
            case SECOND: {
                bl = fArray[0][1] > 0.0f;
                break;
            }
            case THIRD: {
                bl = fArray[0][2] > 0.0f;
                break;
            }
            case FOURTH: {
                bl = fArray[0][3] > 0.0f;
                break;
            }
            case FIFTH: {
                bl = fArray[0][4] > 0.0f;
            }
        }
        return bl;
    }

    public final void filter(TraceViewState.FilterType filterType) {
        float[][] fArray = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration().getFilterBands();
        switch (filterType) {
            case NONE: {
                break;
            }
            case FIRST: {
                this.filteredData = this.filter(fArray[0][0], fArray[1][0]);
                break;
            }
            case SECOND: {
                this.filteredData = this.filter(fArray[0][1], fArray[1][1]);
                break;
            }
            case THIRD: {
                this.filteredData = this.filter(fArray[0][2], fArray[1][2]);
                break;
            }
            case FOURTH: {
                this.filteredData = this.filter(fArray[0][3], fArray[1][3]);
                break;
            }
            case FIFTH: {
                this.filteredData = this.filter(fArray[0][4], fArray[1][4]);
            }
        }
    }

    public final void directFilter(float f, float f2) {
        this.filteredData = this.filter(f, f2);
    }

    private float[] filter(float f, float f2) {
        int n;
        if (f > this.underlyingTrace.getOriginalSamplerate() / 2.0f) {
            LogUtil.warn(((Object)((Object)this)).getClass(), (String)"Lower filter frequency is above Nyquist of original trace, therefore no filtering is applied.");
            return this.underlyingTrace.getSamples();
        }
        if (f2 > this.underlyingTrace.getOriginalSamplerate() / 2.0f) {
            LogUtil.warn(((Object)((Object)this)).getClass(), (String)"Upper filter frequency is above Nyquist of original trace, therefore highpass is applied.");
            f2 = 0.0f;
        }
        if ((double)f <= 0.001 && (double)f2 <= 0.001) {
            return this.underlyingTrace.getSamples();
        }
        float[] fArray = new float[1024 + this.getLength()];
        int n2 = 4;
        for (n = 0; n < this.underlyingTrace.getLength(); ++n) {
            fArray[n + 1024] = Float.isNaN(this.underlyingTrace.getSample(n)) ? 0.0f : this.underlyingTrace.getSample(n);
        }
        for (n = 0; n < 1024; ++n) {
            fArray[n] = (float)n * fArray[1024] / 1024.0f;
        }
        if ((double)f <= 0.001) {
            FiltUtil.spr_lp_fast_bworth((float[])fArray, (int)fArray.length, (float)(1.0f / this.getSamplerate()), (float)f2, (int)n2, (boolean)false);
        } else if ((double)f2 <= 0.001) {
            FiltUtil.spr_hp_fast_bworth((float[])fArray, (int)fArray.length, (float)(1.0f / this.getSamplerate()), (float)f, (int)n2, (boolean)false);
        } else {
            FiltUtil.spr_bp_fast_bworth((float[])fArray, (int)fArray.length, (float)(1.0f / this.getSamplerate()), (float)f, (float)f2, (int)n2, (boolean)false);
        }
        return Arrays.copyOfRange(fArray, 1024, fArray.length);
    }

    public float[] getFilteredData() {
        return this.filteredData;
    }

    public void setFilteredData(float[] fArray) {
        this.filteredData = fArray;
    }
}

