/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing;

import edu.geophys.commons.detection.TraceViewState;
import edu.geophys.sonoview.SonoViewConfiguration;
import edu.geophys.sonoview.SonoViewManager;
import edu.geophys.sonoview.swing.EventList;
import edu.geophys.sonoview.swing.JSonoViewMainFrame;
import edu.geophys.sonoview.traceview.TraceView;
import edu.geophys.sonoview.traceview.TraceViewModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class SonoViewHotkeyFactory {
    private final TraceView tv;
    private final JSonoViewMainFrame svFrame;
    private final EventList evFrame;

    public SonoViewHotkeyFactory(JSonoViewMainFrame jSonoViewMainFrame, TraceView traceView, EventList eventList) {
        this.tv = traceView;
        this.svFrame = jSonoViewMainFrame;
        this.evFrame = eventList;
    }

    public void register(JFrame jFrame) {
        InputMap inputMap = jFrame.getRootPane().getInputMap(2);
        ActionMap actionMap = jFrame.getRootPane().getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(112, 0), "show_help");
        actionMap.put("show_help", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.svFrame.helpDialogMenueItemActionPerformed(actionEvent);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(76, 0), "show_event_list");
        actionMap.put("show_event_list", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewManager.getInstance().forceOpenEventList();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "large_down");
        actionMap.put("large_down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.svFrame.onePageDownActionPerformed();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "large_up");
        actionMap.put("large_up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.svFrame.onePageUpActionPerformed();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(40, 2), "small_down");
        actionMap.put("small_down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.svFrame.oneLineDownActionPerformed();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(38, 2), "small_up");
        actionMap.put("small_up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.svFrame.oneLineUpActionPerformed();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "next_event");
        actionMap.put("next_event", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.svFrame.nextEventActionPerformed(actionEvent);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "prev_event");
        actionMap.put("prev_event", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.svFrame.prevEventActionPerformed(actionEvent);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(33, 0), "enlarge_selection");
        actionMap.put("enlarge_selection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.svFrame.resizeSelectionActionPerformed(true);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(34, 0), "shrink_selection");
        actionMap.put("shrink_selection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.svFrame.resizeSelectionActionPerformed(false);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(77, 0), "show_ev_markers");
        actionMap.put("show_ev_markers", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewConfiguration sonoViewConfiguration;
                sonoViewConfiguration.setShowMarkers(!(sonoViewConfiguration = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration()).getShowMarkers());
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(87, 0), "quick_pattern");
        actionMap.put("quick_pattern", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.svFrame.quickSaveEventAction(actionEvent);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(68, 0), "delete_pattern");
        actionMap.put("delete_pattern", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.svFrame.deleteEventAction();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(69, 0), "detailed_pattern");
        actionMap.put("detailed_pattern", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.svFrame.editEventAction();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(67, 0), "tv_common_scaling");
        actionMap.put("tv_common_scaling", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TraceViewModel traceViewModel;
                traceViewModel.setCommonScaling(!(traceViewModel = SonoViewHotkeyFactory.this.tv.getTraceViewModel()).isCommonScaling());
                SonoViewHotkeyFactory.this.tv.update();
                SonoViewManager.getInstance().addTraceViewStateToCurrentPattern();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(48, 0), "tv_filter_NONE");
        inputMap.put(KeyStroke.getKeyStroke(96, 0), "tv_filter_NONE");
        actionMap.put("tv_filter_NONE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TraceViewModel traceViewModel = SonoViewHotkeyFactory.this.tv.getTraceViewModel();
                traceViewModel.setFilter(TraceViewState.FilterType.NONE);
                SonoViewHotkeyFactory.this.tv.update();
                SonoViewManager.getInstance().addTraceViewStateToCurrentPattern();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(49, 0), "tv_filter_FIRST");
        inputMap.put(KeyStroke.getKeyStroke(97, 0), "tv_filter_FIRST");
        actionMap.put("tv_filter_FIRST", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TraceViewModel traceViewModel = SonoViewHotkeyFactory.this.tv.getTraceViewModel();
                TraceViewState.FilterType filterType = TraceViewState.FilterType.FIRST;
                if (traceViewModel.getFilter() != filterType) {
                    traceViewModel.setFilter(filterType);
                } else {
                    traceViewModel.setFilter(TraceViewState.FilterType.NONE);
                }
                SonoViewManager.getInstance().addTraceViewStateToCurrentPattern();
                SonoViewHotkeyFactory.this.tv.update();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(50, 0), "tv_filter_SECOND");
        inputMap.put(KeyStroke.getKeyStroke(98, 0), "tv_filter_SECOND");
        actionMap.put("tv_filter_SECOND", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TraceViewModel traceViewModel = SonoViewHotkeyFactory.this.tv.getTraceViewModel();
                TraceViewState.FilterType filterType = TraceViewState.FilterType.SECOND;
                if (traceViewModel.getFilter() != filterType) {
                    traceViewModel.setFilter(filterType);
                } else {
                    traceViewModel.setFilter(TraceViewState.FilterType.NONE);
                }
                SonoViewManager.getInstance().addTraceViewStateToCurrentPattern();
                SonoViewHotkeyFactory.this.tv.update();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(51, 0), "tv_filter_THIRD");
        inputMap.put(KeyStroke.getKeyStroke(99, 0), "tv_filter_THIRD");
        actionMap.put("tv_filter_THIRD", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TraceViewModel traceViewModel = SonoViewHotkeyFactory.this.tv.getTraceViewModel();
                TraceViewState.FilterType filterType = TraceViewState.FilterType.THIRD;
                if (traceViewModel.getFilter() != filterType) {
                    traceViewModel.setFilter(filterType);
                } else {
                    traceViewModel.setFilter(TraceViewState.FilterType.NONE);
                }
                SonoViewManager.getInstance().addTraceViewStateToCurrentPattern();
                SonoViewHotkeyFactory.this.tv.update();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(52, 0), "tv_filter_FOURTH");
        inputMap.put(KeyStroke.getKeyStroke(100, 0), "tv_filter_FOURTH");
        actionMap.put("tv_filter_FOURTH", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TraceViewModel traceViewModel = SonoViewHotkeyFactory.this.tv.getTraceViewModel();
                TraceViewState.FilterType filterType = TraceViewState.FilterType.FOURTH;
                if (traceViewModel.getFilter() != filterType) {
                    traceViewModel.setFilter(filterType);
                } else {
                    traceViewModel.setFilter(TraceViewState.FilterType.NONE);
                }
                SonoViewManager.getInstance().addTraceViewStateToCurrentPattern();
                SonoViewHotkeyFactory.this.tv.update();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(53, 0), "tv_filter_FIFTH");
        inputMap.put(KeyStroke.getKeyStroke(101, 0), "tv_filter_FIFTH");
        actionMap.put("tv_filter_FIFTH", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TraceViewModel traceViewModel = SonoViewHotkeyFactory.this.tv.getTraceViewModel();
                TraceViewState.FilterType filterType = TraceViewState.FilterType.FIFTH;
                if (traceViewModel.getFilter() != filterType) {
                    traceViewModel.setFilter(filterType);
                } else {
                    traceViewModel.setFilter(TraceViewState.FilterType.NONE);
                }
                SonoViewManager.getInstance().addTraceViewStateToCurrentPattern();
                SonoViewHotkeyFactory.this.tv.update();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(65, 0), "tv_toggle_aux_traces");
        actionMap.put("tv_toggle_aux_traces", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TraceViewModel traceViewModel;
                traceViewModel.setShowAuxTraces(!(traceViewModel = SonoViewHotkeyFactory.this.tv.getTraceViewModel()).isShowAuxTraces());
                SonoViewManager.getInstance().addTraceViewStateToCurrentPattern();
                SonoViewHotkeyFactory.this.tv.update();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(72, 0), "tv_toggle_horizontal_traces");
        actionMap.put("tv_toggle_horizontal_traces", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TraceViewModel traceViewModel;
                traceViewModel.setShowHorizontalTraces(!(traceViewModel = SonoViewHotkeyFactory.this.tv.getTraceViewModel()).isShowHorizontalTraces());
                SonoViewManager.getInstance().addTraceViewStateToCurrentPattern();
                SonoViewHotkeyFactory.this.tv.update();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(71, 0), "increase_gain");
        actionMap.put("increase_gain", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.tv.getTraceViewModel().changeGain(true);
                SonoViewManager.getInstance().addTraceViewStateToCurrentPattern();
                SonoViewHotkeyFactory.this.tv.update();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(71, 64), "decrease_gain");
        actionMap.put("decrease_gain", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.tv.getTraceViewModel().changeGain(false);
                SonoViewManager.getInstance().addTraceViewStateToCurrentPattern();
                SonoViewHotkeyFactory.this.tv.update();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(71, 128), "reset_gain");
        actionMap.put("reset_gain", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SonoViewHotkeyFactory.this.tv.getTraceViewModel().resetGain();
                SonoViewManager.getInstance().addTraceViewStateToCurrentPattern();
                SonoViewHotkeyFactory.this.tv.update();
            }
        });
    }
}

