/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing.largesonogram;

import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.DefaultBoundedLongRangeModel;
import edu.geophys.commons.ui.sonogram.ArraySonogramModel;
import edu.geophys.sonoview.SonoViewManager;
import edu.geophys.sonoview.swing.largesonogram.AbstractLargeSonogram;
import edu.geophys.sonoview.swing.largesonogram.DefaultLargeSonogramModel;
import edu.geophys.sonoview.swing.largesonogram.JLargeSonogram;
import edu.geophys.sonoview.swing.largesonogram.JRow;
import edu.geophys.sonoview.swing.largesonogram.RowDimensonModel;
import edu.geophys.sonoview.swing.largesonogram.RowSonogramModel;
import edu.geophys.sonoview.swing.largesonogram.SonoViewStationSonogram;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;

public final class JSonogramList
extends AbstractLargeSonogram {
    private static final long serialVersionUID = -2924536574847498524L;
    private final ArrayList<JRow> childComponents = new ArrayList();
    private final SpringLayout layoutManager = new SpringLayout();

    public JSonogramList(JLargeSonogram jLargeSonogram) {
        this.setLayout(this.layoutManager);
    }

    private void removeAllChilds() {
        while (this.getChildComponents().size() > 0) {
            JRow jRow = this.getChildComponents().remove(this.getChildComponents().size() - 1);
            this.remove(jRow);
            this.layoutManager.removeLayoutComponent(jRow);
        }
    }

    private void adjustChildAmount() {
        JRow jRow;
        DefaultLargeSonogramModel defaultLargeSonogramModel = this.getModel();
        int n = this.getChildComponents().size() - 1;
        while (this.getChildComponents().size() > defaultLargeSonogramModel.size()) {
            jRow = this.getChildComponents().remove(this.getChildComponents().size() - 1);
            this.remove(jRow);
            this.layoutManager.removeLayoutComponent(jRow);
            --n;
        }
        jRow = this.getChildComponents().size() > 0 ? (JComponent)this.getChildComponents().get(this.getChildComponents().size() - 1) : null;
        int n2 = this.getChildComponents().size();
        while (this.getChildComponents().size() < defaultLargeSonogramModel.size()) {
            JRow jRow2 = new JRow();
            this.getChildComponents().add(jRow2);
            if (jRow == null) {
                this.layoutManager.putConstraint("North", (Component)jRow2, 0, "North", (Component)this);
            } else {
                this.layoutManager.putConstraint("North", (Component)jRow2, 0, "South", (Component)jRow);
            }
            if (jRow2.getParent() != this) {
                jRow2.setRowDimension(this.getRowDimension());
                long l = 0L;
                if (jRow2.getModel() != null) {
                    l = jRow2.getModel().getStartEpochMs();
                }
                BoundedLongRangeModel boundedLongRangeModel = this.getAdaptedModel(l, this.getAxisModel());
                jRow2.setAxisModel(this.getAxisModel());
                jRow2.setSelectionModel(this.getSelectionModel());
                this.add(jRow2);
            }
            jRow = jRow2;
            ++n2;
        }
    }

    private void updateMinimumSizeFromState(int n) {
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        if (n > 0) {
            int n2 = 0;
            for (JRow jRow : this.getChildComponents()) {
                dimension.height += jRow.getMinimumSize().height;
                if (jRow.getMinimumSize().width <= n2) continue;
                n2 = jRow.getMinimumSize().width;
            }
            dimension.width += n2;
        }
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
    }

    @Override
    protected void onModelStateChanged() {
        DefaultLargeSonogramModel defaultLargeSonogramModel = this.getModel();
        int n = 0;
        for (int i = 0; i < this.getChildComponents().size() && i < defaultLargeSonogramModel.size(); ++i) {
            RowSonogramModel object = defaultLargeSonogramModel.get(i);
            JRow jRow = this.getChildComponents().get(i);
            if (object != null) {
                jRow.setModel(object);
                jRow.setVisible(true);
                ++n;
                continue;
            }
            jRow.setVisible(false);
        }
        this.updateMinimumSizeFromState(n);
        for (JRow jRow : this.getChildComponents()) {
            for (SonoViewStationSonogram sonoViewStationSonogram : jRow.getSonogramComponent().getChildComponents()) {
            }
        }
    }

    @Override
    public void setModel(DefaultLargeSonogramModel defaultLargeSonogramModel) {
        super.setModel(defaultLargeSonogramModel);
        if (defaultLargeSonogramModel == null) {
            this.removeAllChilds();
        } else if (this.getChildComponents().size() != defaultLargeSonogramModel.size()) {
            this.adjustChildAmount();
        }
        this.updateMinimumSizeFromState(0);
    }

    @Override
    public void setRowDimension(RowDimensonModel rowDimensonModel) {
        super.setRowDimension(rowDimensonModel);
        for (JRow jRow : this.getChildComponents()) {
            jRow.setRowDimension(rowDimensonModel);
        }
    }

    @Override
    public void setAxisModel(BoundedLongRangeModel boundedLongRangeModel) {
        super.setAxisModel(boundedLongRangeModel);
        for (JRow jRow : this.getChildComponents()) {
            jRow.setAxisModel(boundedLongRangeModel);
        }
    }

    private BoundedLongRangeModel getAdaptedModel(long l, BoundedLongRangeModel boundedLongRangeModel) {
        DefaultBoundedLongRangeModel defaultBoundedLongRangeModel = new DefaultBoundedLongRangeModel(boundedLongRangeModel.getValue() + l, boundedLongRangeModel.getExtent(), boundedLongRangeModel.getMinimum() + l, boundedLongRangeModel.getMaximum() + l, boundedLongRangeModel.getIncrement());
        return defaultBoundedLongRangeModel;
    }

    @Override
    public void setSelectionModel(BoundedLongRangeModel boundedLongRangeModel) {
        super.setSelectionModel(boundedLongRangeModel);
        for (JRow jRow : this.getChildComponents()) {
            jRow.setSelectionModel(boundedLongRangeModel);
        }
    }

    @Override
    protected void onAxisModelChanged() {
    }

    @Override
    protected void onSelectionModelChanged() {
        long l = this.getSelectionModel().getValue();
        int n = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration().getDynAwareOverlapMilliSeconds();
        long l2 = 1000L;
        for (JRow jRow : this.getChildComponents()) {
            ArraySonogramModel arraySonogramModel;
            if (jRow.getModel() == null || jRow.getModel().get(0) == null || !((double)l > (arraySonogramModel = jRow.getModel().get(0)).getStartEpochTime() * (double)l2 && (double)l < arraySonogramModel.getEndEpochTime() * (double)l2 - (double)n) && (!((double)(l + this.getSelectionModel().getExtent()) > arraySonogramModel.getStartEpochTime() * (double)l2) || !((double)(l + this.getSelectionModel().getExtent()) < arraySonogramModel.getEndEpochTime() * (double)l2 - (double)n))) continue;
            JScrollPane jScrollPane = SonoViewManager.getInstance().getMainFrame().getScrollpane();
            Rectangle rectangle = new Rectangle(jRow.getX(), jRow.getY() - (int)jScrollPane.getViewport().getViewPosition().getY(), jRow.getWidth(), jRow.getHeight());
            SonoViewManager.getInstance().getMainFrame().getScrollpane().getViewport().scrollRectToVisible(rectangle);
            return;
        }
        BoundedLongRangeModel boundedLongRangeModel = this.getModel().getTimeRangeModel();
        long l3 = boundedLongRangeModel.getIncrement();
        if (this.childComponents.size() > 2) {
            boundedLongRangeModel.setValue(l - l % l3 - l3);
        } else {
            boundedLongRangeModel.setValue(l - l % l3);
        }
        SonoViewManager.getInstance().getMainFrame().getScrollpane().getVerticalScrollBar().setValue(0);
    }

    @Override
    protected void onRowDimensionChanged() {
    }

    public ArrayList<JRow> getChildComponents() {
        return this.childComponents;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
    }
}

