/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing.largesonogram;

import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.time.JCursorTimeAxis;
import edu.geophys.commons.ui.time.JTimeAxis;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.sonoview.swing.SonoViewBorderFactory;
import edu.geophys.sonoview.swing.largesonogram.AbstractLargeSonogram;
import edu.geophys.sonoview.swing.largesonogram.RowDimensonModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

final class JSonogramListFooter
extends AbstractLargeSonogram {
    private static final long serialVersionUID = 13319884084483005L;
    protected static final int DEFAULT_CHILD_HEIGHT = 20;
    protected static final String DUMMY_DATE_STRING = DateTimeUtil.formatDateISO((double)0.0);
    private JCursorTimeAxis axisComponent;
    private JLabel dateLabel;
    private JPanel datePanel;

    public JSonogramListFooter() {
        this.setBorder(BorderFactory.createEmptyBorder());
        Dimension dimension = new Dimension(400, 25);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        springLayout.putConstraint("North", (Component)this.getDatePanel(), 0, "North", (Component)this);
        springLayout.putConstraint("South", (Component)this.getDatePanel(), 0, "South", (Component)this);
        springLayout.putConstraint("West", (Component)this.getDatePanel(), 0, "West", (Component)this);
        this.add(this.getDatePanel());
        springLayout.putConstraint("North", (Component)this.getAxisComponent(), 0, "North", (Component)this);
        springLayout.putConstraint("South", (Component)this.getAxisComponent(), 0, "South", (Component)this);
        springLayout.putConstraint("West", (Component)this.getAxisComponent(), 0, "East", (Component)this.getDatePanel());
        this.add((Component)this.getAxisComponent());
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.getDateLabel().setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.getAxisComponent().setForeground(color);
        this.getDateLabel().setForeground(color);
    }

    protected final JCursorTimeAxis getAxisComponent() {
        if (this.axisComponent == null) {
            this.axisComponent = new JCursorTimeAxis(JTimeAxis.Alignment.NORTH);
            this.axisComponent.setIgnoringCursorExtend(false);
            this.axisComponent.setBorder(SonoViewBorderFactory.getSonoViewBorder());
        }
        return this.axisComponent;
    }

    protected final JLabel getDateLabel() {
        if (this.dateLabel == null) {
            this.dateLabel = new JLabel();
        }
        return this.dateLabel;
    }

    protected final JPanel getDatePanel() {
        if (this.datePanel == null) {
            this.datePanel = new JPanel();
            this.datePanel.setLayout(new GridBagLayout());
            this.datePanel.setBorder(SonoViewBorderFactory.getSonoViewBorder());
            this.datePanel.add(this.getDateLabel());
        }
        return this.datePanel;
    }

    @Override
    public void setAxisModel(BoundedLongRangeModel boundedLongRangeModel) {
        super.setAxisModel(boundedLongRangeModel);
        this.getAxisComponent().setModel(boundedLongRangeModel);
        this.updateDateLableText();
    }

    @Override
    public void setRowDimension(RowDimensonModel rowDimensonModel) {
        super.setRowDimension(rowDimensonModel);
        this.updateDatePanelSize();
        this.updateAxisSize();
    }

    @Override
    protected void onModelStateChanged() {
        this.updateDateLableText();
    }

    @Override
    protected void onAxisModelChanged() {
        this.updateDateLableText();
    }

    @Override
    protected void onSelectionModelChanged() {
    }

    @Override
    protected void onRowDimensionChanged() {
        this.updateDatePanelSize();
        this.updateAxisSize();
        this.revalidate();
    }

    private void updateAxisSize() {
        Dimension dimension = new Dimension(this.getRowDimension().getSonogramComponentWidth(), 20);
        this.axisComponent.setMinimumSize(dimension);
        this.axisComponent.setPreferredSize(dimension);
        this.axisComponent.setMaximumSize(dimension);
    }

    private void updateDatePanelSize() {
        Dimension dimension = new Dimension(this.getRowDimension().getAxisComponentWidth(), 20);
        this.datePanel.setMinimumSize(dimension);
        this.datePanel.setPreferredSize(dimension);
        this.axisComponent.setMaximumSize(dimension);
    }

    private void updateDateLableText() {
        if (this.getAxisModel() != null) {
            this.dateLabel.setText(DateTimeUtil.formatDateISO((long)this.getAxisModel().getMinimum()));
        } else {
            this.dateLabel.setText(DUMMY_DATE_STRING);
        }
    }
}

