/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.traceview;

import edu.geophys.commons.detection.TraceViewState;
import edu.geophys.commons.model.SNS;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.sonoview.traceview.TraceView;
import edu.geophys.sonoview.traceview.TraceViewSnsModel;
import edu.geophys.sonoview.traceview.TraceViewTraceModel;
import java.util.ArrayList;

public class TraceViewModel {
    private ArrayList<TraceViewSnsModel> activeSns = new ArrayList();
    private TraceView traceView;
    private final TraceViewState intrinsicTraceViewState = new TraceViewState();
    private TraceViewState currentTraceViewState = null;
    private static final int MAXGAINSTEP = 4;

    public TraceViewModel() {
        this.traceView = null;
    }

    public TraceViewModel(TraceView traceView) {
        this.traceView = traceView;
    }

    public ArrayList<String> getAllTraceIDs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TraceViewSnsModel traceViewSnsModel : this.activeSns) {
            for (TraceViewTraceModel traceViewTraceModel : traceViewSnsModel.getAllTraces()) {
                arrayList.add(traceViewTraceModel.getTraceId());
            }
        }
        return arrayList;
    }

    public void updateActiveSns() {
        for (SNS sNS : SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge().getAllActiveSNS()) {
            this.activeSns.add(new TraceViewSnsModel(sNS, this));
        }
    }

    public TraceViewState getState() {
        if (this.currentTraceViewState != null) {
            return this.currentTraceViewState;
        }
        return this.intrinsicTraceViewState;
    }

    public void setState(TraceViewState traceViewState) {
        this.currentTraceViewState = traceViewState;
    }

    public ArrayList<TraceViewSnsModel> getActiveSns() {
        return this.activeSns;
    }

    public void setActiveSns(ArrayList<TraceViewSnsModel> arrayList) {
        this.activeSns = arrayList;
    }

    public TraceView getTraceView() {
        return this.traceView;
    }

    public TraceViewState.FilterType getFilter() {
        return this.getState().filter;
    }

    public void setFilter(TraceViewState.FilterType filterType) {
        this.getState().filter = filterType;
    }

    public boolean isCommonScaling() {
        return this.getState().commonScaling;
    }

    public void setCommonScaling(boolean bl) {
        this.getState().commonScaling = bl;
    }

    public float getAbsValueAllSns() {
        float f = 0.0f;
        for (TraceViewSnsModel traceViewSnsModel : this.getActiveSns()) {
            float f2 = traceViewSnsModel.getAbsValueAllTraces();
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public void fireSelectionChange() {
        for (TraceViewSnsModel traceViewSnsModel : this.getActiveSns()) {
            traceViewSnsModel.fireSelectionChange();
        }
    }

    public boolean isShowAuxTraces() {
        return this.getState().showAuxTraces;
    }

    public void setShowAuxTraces(boolean bl) {
        this.getState().showAuxTraces = bl;
    }

    public boolean isShowHorizontalTraces() {
        return this.getState().showHorizontalTraces;
    }

    public void setShowHorizontalTraces(boolean bl) {
        this.getState().showHorizontalTraces = bl;
    }

    public void changeGain(boolean bl) {
        if (bl && this.getState().gainStep < 4) {
            ++this.getState().gainStep;
        } else if (!bl && this.getState().gainStep > -4) {
            --this.getState().gainStep;
        }
    }

    public float getGain() {
        return (float)Math.pow(2.0, this.getState().gainStep);
    }

    public void resetGain() {
        this.getState().gainStep = 0;
    }
}

