/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.traceview;

import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.sonoview.swing.FilteringTrace;
import edu.geophys.sonoview.traceview.TraceView;
import edu.geophys.sonoview.traceview.TraceViewSnsModel;

public class TraceViewTraceModel {
    private final TraceViewSnsModel snsModel;
    private final String traceId;
    private float absValue = 0.0f;
    private float[] values;
    private boolean dataBad = false;

    public TraceViewTraceModel(String string, TraceViewSnsModel traceViewSnsModel) {
        this.traceId = string;
        this.snsModel = traceViewSnsModel;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public float getAbsValue() {
        if (this.values == null) {
            this.loadValues();
        }
        return this.absValue;
    }

    private boolean isDataBad() {
        return this.dataBad;
    }

    private void loadValues() {
        int n;
        TraceView traceView = this.snsModel.getTraceViewModel().getTraceView();
        double d = DateTimeUtil.convertLongMsToDoubleS((long)traceView.getSelection().getValue());
        double d2 = DateTimeUtil.convertLongMsToDoubleS((long)(traceView.getSelection().getValue() + traceView.getSelection().getExtent()));
        try {
            this.values = traceView.getDataStore().getTraceData(this.traceId, d, d2, traceView.getTraceViewModel().getFilter());
        }
        catch (Exception exception) {
            this.values = null;
            this.dataBad = true;
            return;
        }
        boolean bl = !FilteringTrace.hasHighpass(traceView.getTraceViewModel().getFilter());
        float f = 0.0f;
        if (bl) {
            for (n = 0; n < this.values.length; ++n) {
                f += this.values[n];
            }
            f /= (float)this.values.length;
        }
        this.absValue = 0.0f;
        for (n = 0; n < this.values.length; ++n) {
            float f2;
            if (bl) {
                int n2 = n;
                this.values[n2] = this.values[n2] - f;
            }
            if (!((f2 = Math.abs(this.values[n])) > this.absValue)) continue;
            this.absValue = f2;
        }
    }

    public float[] getValues() {
        if (this.isDataBad()) {
            return null;
        }
        if (this.values == null) {
            this.loadValues();
        }
        return this.values;
    }

    public void fireSelectionChange() {
        this.values = null;
    }
}

