/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.traceview.swing;

import edu.geophys.sonoview.traceview.swing.TraceViewSnsPlot;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;

public class TraceViewScaleBar
extends JComponent {
    private TraceViewSnsPlot snsPlot;
    private static final int WIDTH = 2;
    private double lenBarNMS = 0.0;
    private double lenPlotNMS = 1.0;
    private static final Stroke STROKE = new BasicStroke(2.0f, 0, 2);

    public TraceViewScaleBar(TraceViewSnsPlot traceViewSnsPlot) {
        this.snsPlot = traceViewSnsPlot;
        this.setMinimumSize(new Dimension(4, 1));
        this.lenPlotNMS = 2.0 / (double)traceViewSnsPlot.getScale();
        int n = (int)Math.pow(10.0, (int)Math.log10(this.lenPlotNMS));
        this.lenBarNMS = n * (int)(this.lenPlotNMS / (double)n);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.getInsets().left, this.getInsets().top, this.getWidth() - (this.getInsets().left + this.getInsets().right), this.getHeight() - (this.getInsets().top + this.getInsets().bottom));
        if (this.lenPlotNMS == 0.0) {
            this.lenPlotNMS = 1.0;
        }
        int n = (int)(((RectangularShape)double_).getHeight() * this.lenBarNMS / this.lenPlotNMS);
        int n2 = (int)((RectangularShape)double_).getHeight();
        int n3 = (int)(((RectangularShape)double_).getWidth() / 2.0);
        int n4 = (n2 - n) / 2;
        int n5 = n4 + n;
        graphics2D.setStroke(STROKE);
        graphics2D.drawLine(n3, n4, n3, n5);
        graphics2D.drawLine(n3 - 2, n4, n3 + 2, n4);
        graphics2D.drawLine(n3 - 2, n5, n3 + 2, n5);
        graphics2D.dispose();
    }

    public double getLenBarNMS() {
        return this.lenBarNMS;
    }
}

