/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.traceview.swing;

import edu.geophys.commons.themes.SuiteTheme;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.sonoview.SonoViewConfiguration;
import edu.geophys.sonoview.SonoViewManager;
import edu.geophys.sonoview.traceview.TraceViewModel;
import edu.geophys.sonoview.traceview.TraceViewSnsModel;
import edu.geophys.sonoview.traceview.TraceViewTraceModel;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.border.EmptyBorder;

public class TraceViewSnsLabel
extends JLabel {
    private TraceViewSnsModel snsModel;

    public TraceViewSnsLabel(TraceViewSnsModel traceViewSnsModel) {
        super(traceViewSnsModel.getSnsName());
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.snsModel = traceViewSnsModel;
        this.setToolTipText(this.getTooltipText());
    }

    private String toHex(Color color) {
        return "#" + Integer.toHexString(color.getRGB()).substring(2).toUpperCase();
    }

    private String getTooltipText() {
        SonoViewConfiguration sonoViewConfiguration = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration();
        SuiteTheme suiteTheme = ThemeManager.getInstance().getTheme();
        TraceViewModel traceViewModel = this.snsModel.getTraceViewModel();
        boolean bl = false;
        String string = "";
        Object object = "<html>";
        object = (String)object + "<b>Center vertical</b>:<br><font color=" + this.toHex(suiteTheme.getZCenterColor()) + ">";
        object = (String)object + this.snsModel.getZCenter().getTraceId();
        object = (String)object + "</font><br>";
        if (!traceViewModel.isShowHorizontalTraces()) {
            string = "*";
            bl = true;
        } else {
            string = "";
        }
        object = (String)object + "<b>Center horizontal" + string + "</b>:<br><font color=" + this.toHex(suiteTheme.getHCenterColor()) + ">";
        if (this.snsModel.getHCenter().size() == 0) {
            object = (String)object + "<em>none</em><br>";
        }
        for (TraceViewTraceModel traceViewTraceModel : this.snsModel.getHCenter()) {
            object = (String)object + traceViewTraceModel.getTraceId() + "<br>";
        }
        object = (String)object + "</font>";
        if (!traceViewModel.isShowAuxTraces()) {
            string = "*";
            bl = true;
        } else {
            string = "";
        }
        object = (String)object + "<b>Auxiliary vertical" + string + "</b>:<br><font color=" + this.toHex(suiteTheme.getZSatteliteColor()) + ">";
        if (this.snsModel.getZAux().size() == 0) {
            object = (String)object + "<em>none</em><br>";
        }
        for (TraceViewTraceModel traceViewTraceModel : this.snsModel.getZAux()) {
            object = (String)object + traceViewTraceModel.getTraceId() + "<br>";
        }
        object = (String)object + "</font>";
        if (bl) {
            object = (String)object + "<br>* <em>[traces hidden]</em>";
        }
        object = (String)object + "</html>";
        return object;
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip jToolTip = super.createToolTip();
        return jToolTip;
    }
}

