/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview;

import edu.geophys.commons.detection.SonoViewPick;
import edu.geophys.commons.detection.TraceViewState;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.AbstractConfiguration;
import edu.geophys.commons.ui.ScreenDimensionTool;
import edu.geophys.commons.util.JAXBSerializable;
import edu.geophys.commons.util.JAXBUtil;
import edu.geophys.commons.util.LogUtil;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;

@XmlRootElement(name="SonoView")
public final class SonoViewConfiguration
extends AbstractConfiguration
implements JAXBSerializable {
    private static final long serialVersionUID = 9198140437795823976L;
    @XmlTransient
    public String DEFAULT_CONFIGFILE = SuiteManager.INSTANCE.getKnowledgebase().getKnowledgeFolder().getAbsolutePath() + File.separator + "sonoview.xml";
    private int milliSecondsPerRow;
    private int milliSecondsPerRowDynamic = this.milliSecondsPerRow = 300000;
    private float milliSecondsPerRowSamplingRate;
    private float milliSecondsPerRowSamplingRateDynamic = this.milliSecondsPerRowSamplingRate = 250.0f;
    private int overlapMilliSeconds;
    private int overlapMilliSecondsDynamic = this.overlapMilliSeconds = 30000;
    private int displayedRows;
    private int displayedRowsDynamic = this.displayedRows = 20;
    private int prefetchedRows = 1;
    private boolean dynamicSize = false;
    private boolean showMarkers = true;
    private boolean showTimeLineMarkers = true;
    private boolean traceViewOpen = false;
    private boolean eventListOpen = true;
    private double overlapMinFactorDynamic = 0.05f;
    private float screensRenderedDynamic = 1.0f;
    private int roundSecondsPerRowDynamic = 30;
    private AbstractConfiguration.FrameSize mainFrameSize;
    private AbstractConfiguration.FrameSize traceFrameSize;
    private AbstractConfiguration.FrameSize listFrameSize;
    private AbstractConfiguration.FramePosition mainFramePosition;
    private AbstractConfiguration.FramePosition traceFramePosition;
    private AbstractConfiguration.FramePosition listFramePosition;
    private float overlapComposite = 0.1f;
    private int[] filterSettings = new int[6];
    private float[][] filterBands = new float[][]{{0.0f, 1.0f, 1.0f, 5.0f, 10.0f}, {1.0f, 5.0f, 20.0f, 40.0f, 0.0f}};
    private TraceViewState.FilterType zoomFilterSettings = TraceViewState.FilterType.NONE;
    private int jbases = 0;
    private int selectionLengthIndex = 0;
    private long selectionStart = 0L;
    private SonoViewPick selectionPick;
    private long selectionLength = 0L;
    private long lastPageStart = 0L;
    private boolean sonoviewFirstStart = true;

    public SonoViewConfiguration() {
        int n;
        ScreenDimensionTool screenDimensionTool = ScreenDimensionTool.getInstance();
        try {
            n = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge().getAllActiveSNS().length;
            n = Math.max(1, n);
        }
        catch (Exception exception) {
            n = 6;
        }
        if (screenDimensionTool.isSmallScreen()) {
            this.overlapMilliSeconds /= 2;
        }
        this.prefetchedRows = this.displayedRows = 100 / n;
        this.mainFramePosition = screenDimensionTool.getSonoViewPosition();
        this.traceFramePosition = screenDimensionTool.getTraceViewPosition();
        this.listFramePosition = screenDimensionTool.getEventListPosition();
        this.mainFrameSize = screenDimensionTool.getSonoViewSize();
        this.traceFrameSize = screenDimensionTool.getTraceViewSize();
        this.listFrameSize = screenDimensionTool.getEventListSize();
    }

    public SonoViewConfiguration(SonoViewConfiguration sonoViewConfiguration) {
        this.shallowCopyFrom(sonoViewConfiguration);
    }

    private final void shallowCopyFrom(SonoViewConfiguration sonoViewConfiguration) {
        this.milliSecondsPerRow = sonoViewConfiguration.milliSecondsPerRow;
        this.milliSecondsPerRowDynamic = sonoViewConfiguration.milliSecondsPerRowDynamic;
        this.milliSecondsPerRowSamplingRate = sonoViewConfiguration.milliSecondsPerRowSamplingRate;
        this.milliSecondsPerRowSamplingRateDynamic = sonoViewConfiguration.milliSecondsPerRowSamplingRateDynamic;
        this.overlapMilliSeconds = sonoViewConfiguration.overlapMilliSeconds;
        this.overlapMilliSecondsDynamic = sonoViewConfiguration.overlapMilliSecondsDynamic;
        this.displayedRows = sonoViewConfiguration.displayedRows;
        this.displayedRowsDynamic = sonoViewConfiguration.displayedRowsDynamic;
        this.prefetchedRows = sonoViewConfiguration.prefetchedRows;
        this.dynamicSize = sonoViewConfiguration.dynamicSize;
        this.showMarkers = sonoViewConfiguration.showMarkers;
        this.showTimeLineMarkers = sonoViewConfiguration.showTimeLineMarkers;
        this.traceViewOpen = sonoViewConfiguration.traceViewOpen;
        this.eventListOpen = sonoViewConfiguration.eventListOpen;
        this.overlapMinFactorDynamic = sonoViewConfiguration.overlapMinFactorDynamic;
        this.screensRenderedDynamic = sonoViewConfiguration.screensRenderedDynamic;
        this.roundSecondsPerRowDynamic = sonoViewConfiguration.roundSecondsPerRowDynamic;
        this.mainFrameSize = sonoViewConfiguration.mainFrameSize;
        this.traceFrameSize = sonoViewConfiguration.traceFrameSize;
        this.listFrameSize = sonoViewConfiguration.listFrameSize;
        this.mainFramePosition = sonoViewConfiguration.mainFramePosition;
        this.traceFramePosition = sonoViewConfiguration.traceFramePosition;
        this.listFramePosition = sonoViewConfiguration.listFramePosition;
        this.overlapComposite = sonoViewConfiguration.overlapComposite;
        this.filterSettings = sonoViewConfiguration.filterSettings;
        this.filterBands = sonoViewConfiguration.filterBands;
        this.zoomFilterSettings = sonoViewConfiguration.zoomFilterSettings;
        this.jbases = sonoViewConfiguration.jbases;
        this.selectionLengthIndex = sonoViewConfiguration.selectionLengthIndex;
        this.selectionStart = sonoViewConfiguration.selectionStart;
        this.selectionPick = sonoViewConfiguration.selectionPick;
        this.selectionLength = sonoViewConfiguration.selectionLength;
        this.lastPageStart = sonoViewConfiguration.lastPageStart;
        this.sonoviewFirstStart = sonoViewConfiguration.sonoviewFirstStart;
    }

    public void updateKnowbaseFolder() {
        this.DEFAULT_CONFIGFILE = SuiteManager.INSTANCE.getKnowledgebase().getKnowledgeFolder().getAbsolutePath() + File.separator + "sonoview.xml";
    }

    @XmlElement(name="mainFrameSize", required=true, nillable=true)
    private final AbstractConfiguration.FrameSize getMainFrameSizeJAXB() {
        return this.mainFrameSize;
    }

    @XmlElement(name="traceFrameSize", required=true, nillable=true)
    private final AbstractConfiguration.FrameSize getTraceFrameSizeJAXB() {
        return this.traceFrameSize;
    }

    @XmlElement(name="listFrameSize", required=true, nillable=true)
    private final AbstractConfiguration.FrameSize getListFrameSizeJAXB() {
        return this.listFrameSize;
    }

    @XmlElement(name="mainFramePosition", required=true, nillable=true)
    private final AbstractConfiguration.FramePosition getMainFramePositionJAXB() {
        return this.mainFramePosition;
    }

    @XmlElement(name="traceFramePosition", required=true, nillable=true)
    private final AbstractConfiguration.FramePosition getTraceFramePositionJAXB() {
        return this.traceFramePosition;
    }

    @XmlElement(name="listFramePosition", required=true, nillable=true)
    private final AbstractConfiguration.FramePosition getListFramePositionJAXB() {
        return this.listFramePosition;
    }

    private void setMainFrameSizeJAXB(AbstractConfiguration.FrameSize frameSize) {
        this.mainFrameSize = frameSize;
    }

    private void setTraceFrameSizeJAXB(AbstractConfiguration.FrameSize frameSize) {
        this.traceFrameSize = frameSize;
    }

    private void setListFrameSizeJAXB(AbstractConfiguration.FrameSize frameSize) {
        this.listFrameSize = frameSize;
    }

    private void setMainFramePositionJAXB(AbstractConfiguration.FramePosition framePosition) {
        this.mainFramePosition = framePosition;
    }

    private void setTraceFramePositionJAXB(AbstractConfiguration.FramePosition framePosition) {
        this.traceFramePosition = framePosition;
    }

    private void setListFramePositionJAXB(AbstractConfiguration.FramePosition framePosition) {
        this.listFramePosition = framePosition;
    }

    @XmlElement(required=true, nillable=false)
    public final int getDisplayedRows() {
        return this.displayedRows;
    }

    public final void setDisplayedRows(int n) {
        this.displayedRows = n;
    }

    @XmlElement(required=true, nillable=false)
    public final int getPrefetchedRows() {
        return this.prefetchedRows;
    }

    public final void setPrefetchedRows(int n) {
        this.prefetchedRows = n;
    }

    @XmlElement(required=true, nillable=false)
    public final boolean getDynamicSize() {
        return this.dynamicSize;
    }

    public final void setDynamicSize(boolean bl) {
        this.dynamicSize = bl;
    }

    @XmlElement(required=true, nillable=false)
    public final boolean getShowMarkers() {
        return this.showMarkers;
    }

    public final void setShowMarkers(boolean bl) {
        this.showMarkers = bl;
    }

    @XmlElement(required=true, nillable=false)
    public final int getMilliSecondsPerRow() {
        return this.milliSecondsPerRow;
    }

    public final void setMilliSecondsPerRow(int n) {
        this.milliSecondsPerRow = n;
    }

    @XmlElement(required=true, nillable=false)
    public final float getMilliSecondsPerRowSamplingRate() {
        return this.milliSecondsPerRowSamplingRate;
    }

    public final void setMilliSecondsPerRowSamplingRate(float f) {
        this.milliSecondsPerRowSamplingRate = f;
    }

    @XmlElement(required=true, nillable=false)
    public final int getOverlapMilliSeconds() {
        return this.overlapMilliSeconds;
    }

    public final void setOverlapMilliSeconds(int n) {
        this.overlapMilliSeconds = n;
    }

    public void load() {
        try {
            SonoViewConfiguration sonoViewConfiguration = (SonoViewConfiguration)JAXBUtil.readXML((File)new File(this.DEFAULT_CONFIGFILE), ((Object)((Object)this)).getClass());
            this.shallowCopyFrom(sonoViewConfiguration);
        }
        catch (Exception exception) {
            LogUtil.info(((Object)((Object)this)).getClass(), (String)"Failed to load SonoView config file, using default values", (boolean)false);
        }
    }

    public void store() {
        try {
            JAXBUtil.writeXML((JAXBSerializable)this, (File)new File(this.DEFAULT_CONFIGFILE));
        }
        catch (Exception exception) {
            LogUtil.fatal(((Object)((Object)this)).getClass(), (String)"Failed to store SonoView config file", (Throwable)exception);
        }
    }

    @XmlTransient
    public final Dimension getMainFrameSize() {
        return this.mainFrameSize.getDimension();
    }

    public final void setMainFrameSize(Dimension dimension) {
        this.mainFrameSize.setDimension(dimension);
    }

    @XmlTransient
    public final Dimension getTraceFrameSize() {
        return this.traceFrameSize.getDimension();
    }

    public final void setTraceFrameSize(Dimension dimension) {
        this.traceFrameSize.setDimension(dimension);
    }

    @XmlTransient
    public final Dimension getListFrameSize() {
        return this.listFrameSize.getDimension();
    }

    public final void setListFrameSize(Dimension dimension) {
        this.listFrameSize.setDimension(dimension);
    }

    @XmlTransient
    public final Point getTraceFramePosition() {
        return this.traceFramePosition.getPoint();
    }

    public final void setTraceFramePosition(Point point) {
        this.traceFramePosition.setPoint(point);
    }

    @XmlTransient
    public final Point getListFramePosition() {
        return this.listFramePosition.getPoint();
    }

    public final void setListFramePosition(Point point) {
        this.listFramePosition.setPoint(point);
    }

    @XmlTransient
    public final Point getMainFramePosition() {
        return this.mainFramePosition.getPoint();
    }

    public final void setMainFramePosition(Point point) {
        this.mainFramePosition.setPoint(point);
    }

    public void setOverlapComposite(float f) {
        this.overlapComposite = f;
    }

    public float getOverlapComposite() {
        return this.overlapComposite;
    }

    public int[] getFilterSettings() {
        return this.filterSettings;
    }

    public void setFilterSettings(int[] nArray) {
        this.filterSettings = nArray;
    }

    public float[][] getFilterBands() {
        return this.filterBands;
    }

    public void setFilterBands(float[][] fArray) {
        float[][] fArray2 = this.filterBands;
        this.filterBands = fArray;
        this.firePropertyChange("filterBands", fArray2, fArray);
    }

    public TraceViewState.FilterType getZoomFilterSettings() {
        return this.zoomFilterSettings;
    }

    public void setZoomFilterSettings(TraceViewState.FilterType filterType) {
        this.zoomFilterSettings = filterType;
    }

    public boolean isShowTimeLineMarkers() {
        return this.showTimeLineMarkers;
    }

    public void setShowTimeLineMarkers(boolean bl) {
        this.showTimeLineMarkers = bl;
    }

    public int getJbases() {
        return this.jbases;
    }

    public void setJbases(int n) {
        this.jbases = n;
    }

    public boolean isTraceViewOpen() {
        return this.traceViewOpen;
    }

    @XmlElement(required=true, nillable=false)
    public void setTraceViewOpen(boolean bl) {
        this.traceViewOpen = bl;
    }

    public boolean isEventListOpen() {
        return this.eventListOpen;
    }

    @XmlElement(required=true, nillable=false)
    public void setEventListOpen(boolean bl) {
        this.eventListOpen = bl;
    }

    public double getOverlapMinFactorDynamic() {
        return this.overlapMinFactorDynamic;
    }

    @XmlElement(name="overlapMinFactorDynamic", required=true, nillable=false)
    public void setOverlapMinFactorDynamic(double d) {
        this.overlapMinFactorDynamic = d;
    }

    public float getScreensRenderedDynamic() {
        return this.screensRenderedDynamic;
    }

    @XmlElement(name="screensRenderedDynamic", required=true, nillable=false)
    public void setScreensRenderedDynamic(float f) {
        this.screensRenderedDynamic = f;
    }

    public int getRoundSecondsPerRowDynamic() {
        return this.roundSecondsPerRowDynamic;
    }

    @XmlElement(name="roundSecondsPerRowDynamic", required=true, nillable=false)
    public void setRoundSecondsPerRowDynamic(int n) {
        this.roundSecondsPerRowDynamic = n;
    }

    public int getMilliSecondsPerRowDynamic() {
        return this.milliSecondsPerRowDynamic;
    }

    @XmlElement(required=true, nillable=false)
    public int getSelectionLenghthIndex() {
        return this.selectionLengthIndex;
    }

    public void setSelectionLengthIndex(int n) {
        this.selectionLengthIndex = n;
    }

    @XmlTransient
    public void setMilliSecondsPerRowDynamic(int n) {
        this.milliSecondsPerRowDynamic = n;
    }

    public float getMilliSecondsPerRowSamplingRateDynamic() {
        return this.milliSecondsPerRowSamplingRateDynamic;
    }

    @XmlTransient
    public void setMilliSecondsPerRowSamplingRateDynamic(float f) {
        this.milliSecondsPerRowSamplingRateDynamic = f;
    }

    public int getOverlapMilliSecondsDynamic() {
        return this.overlapMilliSecondsDynamic;
    }

    @XmlTransient
    public void setOverlapMilliSecondsDynamic(int n) {
        this.overlapMilliSecondsDynamic = n;
    }

    public int getDisplayedRowsDynamic() {
        return this.displayedRowsDynamic;
    }

    @XmlTransient
    public void setDisplayedRowsDynamic(int n) {
        this.displayedRowsDynamic = n;
    }

    @XmlTransient
    public int getDynAwarePrefetchedRows() {
        return this.dynamicSize ? this.displayedRowsDynamic : this.prefetchedRows;
    }

    @XmlTransient
    public int getDynAwareMilliSecondsPerRow() {
        return this.dynamicSize ? this.milliSecondsPerRowDynamic : this.milliSecondsPerRow;
    }

    @XmlTransient
    public int getDynAwareOverlapMilliSeconds() {
        return this.dynamicSize ? this.overlapMilliSecondsDynamic : this.overlapMilliSeconds;
    }

    @XmlTransient
    public int getDynAwareDisplayedRows() {
        return this.dynamicSize ? this.displayedRowsDynamic : this.displayedRows;
    }

    @XmlTransient
    public float getDynAwareMilliSecondsPerRowSamplingRate() {
        return this.dynamicSize ? this.milliSecondsPerRowSamplingRateDynamic : this.milliSecondsPerRowSamplingRate;
    }

    public long getSelectionStart() {
        return this.selectionStart;
    }

    public void setSelectionStart(long l) {
        this.selectionStart = l;
    }

    public SonoViewPick getSelectionPick() {
        return this.selectionPick;
    }

    public void setSelectionPick(SonoViewPick sonoViewPick) {
        this.selectionPick = sonoViewPick;
    }

    public long getSelectionLength() {
        return this.selectionLength;
    }

    public void setSelectionLength(long l) {
        this.selectionLength = l;
    }

    public long getLastPageStart() {
        return this.lastPageStart;
    }

    public void setLastPageStart(long l) {
        this.lastPageStart = l;
    }

    public boolean isSonoviewFirstStart() {
        return this.sonoviewFirstStart;
    }

    public void setSonoviewFirstStart(boolean bl) {
        this.sonoviewFirstStart = bl;
    }
}

