/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview;

import edu.geophys.commons.detection.AbstractDetection;
import edu.geophys.commons.detection.SonoViewDetection;
import edu.geophys.commons.detection.SonoViewPick;
import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.resamplingmodes.DefaultResamplingModes;
import edu.geophys.commons.resamplingmodes.ResamplingMode;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.DefaultBoundedLongRangeModel;
import edu.geophys.commons.ui.FramePositionHelper;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.sonoview.DataManager;
import edu.geophys.sonoview.PickedLongRangeModel;
import edu.geophys.sonoview.SettingsManager;
import edu.geophys.sonoview.SonoViewConfiguration;
import edu.geophys.sonoview.swing.EventList;
import edu.geophys.sonoview.swing.JPreferencesPanel;
import edu.geophys.sonoview.swing.JSonoViewMainFrame;
import edu.geophys.sonoview.swing.SonoViewHelp;
import edu.geophys.sonoview.swing.SonoViewHotkeyFactory;
import edu.geophys.sonoview.swing.largesonogram.DefaultLargeSonogramModel;
import edu.geophys.sonoview.traceview.TraceView;
import edu.geophys.sonoview.traceview.swing.TraceViewFrame;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class SonoViewManager {
    private static SonoViewManager instance;
    private final JSonoViewMainFrame mainFrame;
    private final TraceView traceView;
    private final SonoViewHelp helpFrame;
    private final EventList eventList;
    private boolean running = true;
    private AbstractDetection currentPattern = null;
    private final ChangeListener suiteDataChangeListener = new ChangeListener(){
        private boolean lock = false;

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!this.lock) {
                this.lock = true;
                SonoViewManager.this.onDataChanged();
                this.lock = false;
            }
        }
    };
    private final PropertyChangeListener eventWindowIntercomListener = new PropertyChangeListener(){
        private boolean lock = false;

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!this.lock) {
                this.lock = true;
                SonoViewManager.this.pullSelectionBeginFromSuite();
                this.lock = false;
            }
        }
    };

    public SonoViewManager() {
        instance = this;
        this.mainFrame = new JSonoViewMainFrame();
        this.traceView = new TraceView();
        this.helpFrame = new SonoViewHelp();
        this.eventList = new EventList();
        SonoViewHotkeyFactory sonoViewHotkeyFactory = new SonoViewHotkeyFactory(this.mainFrame, this.traceView, this.eventList);
        sonoViewHotkeyFactory.register(this.mainFrame);
        sonoViewHotkeyFactory.register(this.traceView.getFrame());
        sonoViewHotkeyFactory.register(this.eventList);
    }

    public static final SonoViewManager getInstance() {
        return instance;
    }

    public final SettingsManager getSettingsManager() {
        return SettingsManager.getInstance();
    }

    public final DataManager getDataManager() {
        return DataManager.getInstance();
    }

    final void startup() {
        SonoViewConfiguration sonoViewConfiguration = this.getSettingsManager().getUserConfiguration();
        sonoViewConfiguration.updateKnowbaseFolder();
        sonoViewConfiguration.load();
        this.updateLargeSonogram(true);
        this.mainFrame.setPreferredSize(sonoViewConfiguration.getMainFrameSize());
        this.mainFrame.setSize(sonoViewConfiguration.getMainFrameSize());
        this.mainFrame.setLocation(sonoViewConfiguration.getMainFramePosition());
        FramePositionHelper.ensureFrameOnScreen((JFrame)this.mainFrame);
        this.traceView.getFrame().setPreferredSize(sonoViewConfiguration.getTraceFrameSize());
        this.traceView.getFrame().setSize(sonoViewConfiguration.getTraceFrameSize());
        this.traceView.getFrame().setLocation(sonoViewConfiguration.getTraceFramePosition());
        FramePositionHelper.ensureFrameOnScreen((JFrame)this.traceView.getFrame());
        this.eventList.setPreferredSize(sonoViewConfiguration.getListFrameSize());
        this.eventList.setSize(sonoViewConfiguration.getListFrameSize());
        this.eventList.setLocation(sonoViewConfiguration.getListFramePosition());
        FramePositionHelper.ensureFrameOnScreen((JFrame)this.eventList);
        this.mainFrame.setVisible(true);
        this.mainFrame.updateModeButtons();
        this.eventList.setVisible(sonoViewConfiguration.isEventListOpen());
        SuiteManager.INSTANCE.addDataChangeListener(this.suiteDataChangeListener);
        SuiteManager.INSTANCE.getGlobalEventWindowModel().addPropertyChangeListener(this.eventWindowIntercomListener);
    }

    private final void shutdown() {
        if (!this.mainFrame.isVisible()) {
            return;
        }
        this.running = false;
        SuiteManager.INSTANCE.removeDataChangeListener(this.suiteDataChangeListener);
        SonoViewConfiguration sonoViewConfiguration = this.getSettingsManager().getUserConfiguration();
        sonoViewConfiguration.setMainFrameSize(this.mainFrame.getSize());
        sonoViewConfiguration.setMainFramePosition(this.mainFrame.getLocation());
        TraceViewFrame traceViewFrame = this.getTraceView().getFrame();
        sonoViewConfiguration.setTraceFrameSize(traceViewFrame.getSize());
        sonoViewConfiguration.setTraceFramePosition(traceViewFrame.getLocation());
        sonoViewConfiguration.setTraceViewOpen(traceViewFrame.isVisible());
        sonoViewConfiguration.setListFramePosition(this.eventList.getLocation());
        sonoViewConfiguration.setListFrameSize(this.eventList.getSize());
        sonoViewConfiguration.setEventListOpen(this.eventList.isVisible());
        BoundedLongRangeModel boundedLongRangeModel = this.mainFrame.getSelectionModel();
        sonoViewConfiguration.setSelectionStart(boundedLongRangeModel.getValue());
        sonoViewConfiguration.setSelectionLength(boundedLongRangeModel.getExtent());
        if (boundedLongRangeModel instanceof PickedLongRangeModel) {
            sonoViewConfiguration.setSelectionPick(((PickedLongRangeModel)boundedLongRangeModel).getPick());
        }
        traceViewFrame.setVisible(false);
        traceViewFrame.dispose();
        this.eventList.setVisible(false);
        this.eventList.dispose();
        this.getSettingsManager().setUserConfiguration(sonoViewConfiguration);
        this.getSettingsManager().getUserConfiguration().store();
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
    }

    public final void onShutdownRequest() {
        this.shutdown();
    }

    public final void onDataChanged() {
        this.updateLargeSonogram(false);
        this.mainFrame.updateModeButtons();
    }

    public final void onWindowSizeChanged() {
        this.updateLargeSonogram(false);
    }

    public final void pullSelectionBeginFromSuite() {
        this.mainFrame.getSelectionModel().setValue(SuiteManager.INSTANCE.getGlobalEventWindowModel().getStartEpochTimeMs());
        this.updateTraceView();
    }

    public final void pullSelectionLengthFromSuite() {
        this.mainFrame.getSelectionModel().setExtent(SuiteManager.INSTANCE.getGlobalEventWindowModel().getLength());
        this.updateTraceView();
    }

    public final void pushSelectionBeginToSuite() {
        SuiteManager.INSTANCE.getGlobalEventWindowModel().setStartEpochTimeMs(this.mainFrame.getSelectionModel().getValue());
    }

    public final void pushSelectionLengthToSuite() {
        SuiteManager.INSTANCE.getGlobalEventWindowModel().setLength(this.mainFrame.getSelectionModel().getExtent());
    }

    public final void onDisplayPreferences() {
        SonoViewConfiguration sonoViewConfiguration = new SonoViewConfiguration(this.getSettingsManager().getUserConfiguration());
        int n = JPreferencesPanel.showPreferencesDialog(this.mainFrame, sonoViewConfiguration);
        if (n == 0) {
            this.getSettingsManager().setUserConfiguration(sonoViewConfiguration);
            this.updateTraceView();
        }
    }

    private void updateLargeSonogram(boolean bl) {
        long l;
        long l2;
        SonoViewConfiguration sonoViewConfiguration = this.getSettingsManager().getUserConfiguration();
        CampaignKnowledge campaignKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
        StationsKnowledge stationsKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge();
        DefaultLargeSonogramModel defaultLargeSonogramModel = this.mainFrame.getModel();
        if (defaultLargeSonogramModel != null) {
            defaultLargeSonogramModel.destroyWorkers();
        }
        if (stationsKnowledge.getAllActiveSNS().length <= 0) {
            LogUtil.debug(this.getClass(), (String)"No SNS stations found. Either no or a corrupt config file was provided.");
            this.mainFrame.setModel(null);
            return;
        }
        ResamplingMode resamplingMode = DefaultResamplingModes.getModeByIndex((int)SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getResamplingMode());
        if (sonoViewConfiguration.getDynamicSize()) {
            l2 = sonoViewConfiguration.getMilliSecondsPerRowDynamic();
            l = sonoViewConfiguration.getOverlapMilliSecondsDynamic();
        } else {
            ResamplingMode resamplingMode2 = DefaultResamplingModes.getModeByFrequency((float)sonoViewConfiguration.getMilliSecondsPerRowSamplingRate());
            double d = resamplingMode.getSonoPxFactor(resamplingMode2);
            l2 = (long)(d * (double)sonoViewConfiguration.getMilliSecondsPerRow());
            l = (long)(d * (double)sonoViewConfiguration.getOverlapMilliSeconds());
        }
        long l3 = MathUtil.floor((long)campaignKnowledge.getCampaignEpochStart(), (long)l2);
        long l4 = l2 * (long)sonoViewConfiguration.getDynAwareDisplayedRows();
        long l5 = l3;
        long l6 = Math.max(l3 + l4, campaignKnowledge.getCampaignEpochEnd());
        long l7 = l3;
        long l8 = bl ? this.getSettingsManager().getUserConfiguration().getSelectionStart() : SuiteManager.INSTANCE.getGlobalEventWindowModel().getStartEpochTimeMs();
        if (l8 > l5 && l8 < l6) {
            l7 = l8;
        }
        long l9 = MathUtil.floor((long)l7, (long)l2);
        DefaultBoundedLongRangeModel defaultBoundedLongRangeModel = new DefaultBoundedLongRangeModel(l9, l4, l5, l6, l2);
        final DefaultLargeSonogramModel defaultLargeSonogramModel2 = new DefaultLargeSonogramModel(stationsKnowledge.getAllActiveSNS(), (BoundedLongRangeModel)defaultBoundedLongRangeModel, DataManager.createSonogramProvider(), sonoViewConfiguration.getDynAwarePrefetchedRows(), l);
        if (defaultLargeSonogramModel != null && !bl) {
            defaultLargeSonogramModel2.getTimeRangeModel().setValue(defaultLargeSonogramModel.getTimeRangeModel().getValue());
        }
        defaultLargeSonogramModel2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SuiteManager.INSTANCE.setSonoViewTimeModel(defaultLargeSonogramModel2.getTimeRangeModel());
            }
        });
        this.mainFrame.setModel(defaultLargeSonogramModel2);
        PickedLongRangeModel pickedLongRangeModel = new PickedLongRangeModel(l7, SuiteManager.INSTANCE.getGlobalEventWindowModel().getLength(), 0L, Long.MAX_VALUE, 1L);
        long l10 = sonoViewConfiguration.getSelectionStart();
        SonoViewPick sonoViewPick = sonoViewConfiguration.getSelectionPick();
        long l11 = sonoViewConfiguration.getSelectionLength();
        int n = sonoViewConfiguration.getSelectionLenghthIndex();
        if (sonoViewPick == null || l11 == 0L) {
            pickedLongRangeModel.setValue(l10);
            pickedLongRangeModel.setPick(sonoViewPick);
            pickedLongRangeModel.setExtent(resamplingMode.getSelectionLengthMs(n));
        } else {
            double d = (double)(sonoViewPick.getTimeMs() - l10) / (double)l11;
            long l12 = resamplingMode.getSelectionLengthMs(n);
            pickedLongRangeModel.setValue(sonoViewPick.getTimeMs() - (long)(d * (double)l12));
            pickedLongRangeModel.setPick(sonoViewPick);
            pickedLongRangeModel.setExtent(resamplingMode.getSelectionLengthMs(n));
        }
        this.mainFrame.setSelectionModel((BoundedLongRangeModel)pickedLongRangeModel);
        pickedLongRangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SonoViewManager.this.pushSelectionBeginToSuite();
            }
        });
        this.pushSelectionBeginToSuite();
        this.mainFrame.getWindowSizeListener().componentResized(null);
    }

    public JSonoViewMainFrame getMainFrame() {
        return this.mainFrame;
    }

    public TraceView getTraceView() {
        return this.traceView;
    }

    public void updateTraceView() {
        BoundedLongRangeModel boundedLongRangeModel = this.mainFrame.getSelectionModel();
        this.getTraceView().setSelection(boundedLongRangeModel);
        this.getTraceView().update();
    }

    public boolean isUseTraceViewFrame() {
        return this.traceView.getFrame().isVisible();
    }

    public void setUseTraceViewFrame(boolean bl) {
        this.traceView.getFrame().setVisible(bl);
        this.getMainFrame().repaint();
    }

    public AbstractDetection getCurrentPattern() {
        return this.currentPattern;
    }

    public void setCurrentPattern(AbstractDetection abstractDetection) {
        this.currentPattern = abstractDetection;
    }

    public void addTraceViewStateToCurrentPattern() {
        if (this.currentPattern instanceof SonoViewDetection) {
            ((SonoViewDetection)this.currentPattern).setTraceViewState(this.traceView.getTraceViewModel().getState().clone());
            SuiteManager.INSTANCE.getEventFileManager().writeDetectionXml();
        }
    }

    public void forceOpenTraceView() {
        if (!this.isUseTraceViewFrame()) {
            this.setUseTraceViewFrame(true);
        } else {
            this.updateTraceView();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TraceViewFrame traceViewFrame = SonoViewManager.this.traceView.getFrame();
                if (traceViewFrame != null) {
                    traceViewFrame.toFront();
                    traceViewFrame.repaint();
                }
            }
        });
    }

    public void forceOpenEventList() {
        if (!this.eventList.isVisible()) {
            this.eventList.setVisible(true);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventList eventList = SonoViewManager.this.eventList;
                if (eventList != null) {
                    eventList.toFront();
                    eventList.repaint();
                }
            }
        });
    }

    public void forceOpenHelpFrame() {
        if (!this.helpFrame.isVisible()) {
            this.helpFrame.setVisible(true);
        } else {
            this.helpFrame.blink();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SonoViewManager.this.helpFrame != null) {
                    SonoViewManager.this.helpFrame.toFront();
                    SonoViewManager.this.helpFrame.repaint();
                }
            }
        });
    }

    public void updateEventList() {
        this.eventList.updateModel();
    }

    public boolean isRunning() {
        return this.running;
    }
}

