/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.sonogramMemory;

import edu.geophys.commons.util.Sonolib;

public class MemoryObj {
    private final Sonolib lib = new Sonolib();
    public double startEpochTime;
    public double endEpochTime;
    public float[] internalNoiseXmedian;
    public float[] internalNoiseXsigma;
    public float[] externalNoiseXmedian;
    public float[] externalNoiseXsigma;
    public float[] xpsdf;
    public boolean sETset;
    public boolean eETset;
    public boolean eNXmset;
    public boolean eNXsset;
    public boolean iNXmset;
    public boolean inXsset;
    public boolean xset;
    public boolean extNoiseIsValid;

    public MemoryObj() {
        this.xset = false;
        this.inXsset = false;
        this.iNXmset = false;
        this.eNXsset = false;
        this.eNXmset = false;
        this.eETset = false;
        this.sETset = false;
    }

    public MemoryObj(MemoryObj memoryObj) {
        this.startEpochTime = memoryObj.startEpochTime;
        this.endEpochTime = memoryObj.endEpochTime;
        this.externalNoiseXmedian = (float[])memoryObj.externalNoiseXmedian.clone();
        this.externalNoiseXsigma = (float[])memoryObj.externalNoiseXsigma.clone();
        this.internalNoiseXmedian = (float[])memoryObj.internalNoiseXmedian.clone();
        this.internalNoiseXsigma = (float[])memoryObj.internalNoiseXsigma.clone();
        this.xpsdf = (float[])memoryObj.xpsdf.clone();
        this.xset = true;
        this.inXsset = true;
        this.iNXmset = true;
        this.eNXsset = true;
        this.eNXmset = true;
        this.eETset = true;
        this.sETset = true;
        this.extNoiseIsValid = this.externalNoiseXmedian != null && this.externalNoiseXsigma != null;
    }

    public MemoryObj(double d, double d2, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, float[] fArray7) {
        this.startEpochTime = d;
        this.endEpochTime = d2;
        this.externalNoiseXmedian = (float[])fArray.clone();
        this.externalNoiseXsigma = (float[])fArray2.clone();
        this.internalNoiseXmedian = (float[])fArray3.clone();
        this.internalNoiseXsigma = (float[])fArray4.clone();
        this.xpsdf = (float[])fArray5.clone();
        this.xset = true;
        this.inXsset = true;
        this.iNXmset = true;
        this.eNXsset = true;
        this.eNXmset = true;
        this.eETset = true;
        this.sETset = true;
        this.extNoiseIsValid = this.externalNoiseXmedian != null && this.externalNoiseXsigma != null;
    }

    public void setEpochTimes(double d, double d2) {
        this.startEpochTime = d;
        this.endEpochTime = d2;
        this.eETset = true;
        this.sETset = true;
    }

    public void setInternalNoise(float[] fArray, float[] fArray2) {
        this.internalNoiseXmedian = fArray != null ? (float[])fArray.clone() : null;
        this.internalNoiseXsigma = fArray2 != null ? (float[])fArray2.clone() : null;
        this.inXsset = true;
        this.iNXmset = true;
    }

    public void setExternalNoise(float[] fArray, float[] fArray2) {
        this.externalNoiseXmedian = fArray != null ? (float[])fArray.clone() : null;
        this.externalNoiseXsigma = fArray2 != null ? (float[])fArray2.clone() : null;
        this.eNXsset = true;
        this.eNXmset = true;
        this.extNoiseIsValid = this.externalNoiseXmedian != null && this.externalNoiseXsigma != null;
    }

    public void setFftData(float[] fArray) {
        this.xpsdf = fArray != null ? (float[])fArray.clone() : null;
        this.xset = true;
    }

    public boolean isValid() {
        return this.sETset && this.eETset && this.eNXmset && this.eNXsset && this.iNXmset && this.inXsset && this.xset;
    }
}

