/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing;

import edu.geophys.commons.resamplingmodes.DefaultResamplingModes;
import edu.geophys.commons.resamplingmodes.ResamplingMode;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.sonoview.SonoViewConfiguration;
import edu.geophys.sonoview.SonoViewManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import layout.TableLayout;

public class JPreferencesPanel
extends JPanel {
    private static final long serialVersionUID = -1800372772804023390L;
    private final SonoViewConfiguration userConfig;

    public static final int showPreferencesDialog(Frame frame, SonoViewConfiguration sonoViewConfiguration) {
        try {
            JPreferencesPanel jPreferencesPanel = new JPreferencesPanel(sonoViewConfiguration);
            return JOptionPane.showOptionDialog(frame, jPreferencesPanel, "Configuration", 2, -1, null, null, null);
        }
        catch (Exception exception) {
            LogUtil.fatal(frame.getClass(), (String)"Illegal values in sonoview.xml. Delete to switch to default value.", (boolean)true);
            return -1;
        }
    }

    public JPreferencesPanel(SonoViewConfiguration sonoViewConfiguration) {
        this.userConfig = sonoViewConfiguration;
        this.initComponents();
    }

    private void initComponents() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Fixed View", null, this.getFixedViewConfig(), "Set parameters for fixed view");
        jTabbedPane.addTab("Dynamic View", null, this.getDynamicViewConfig(), "Set parameters for dynamic view");
        jTabbedPane.addTab("Trace View", null, this.getTraceViewConfig(), "Set parameters for TraceView");
        jTabbedPane.addTab("Advanced configuration", null, this.getAdvancedConfig(), "Set advanced configuration parameters");
        this.add(jTabbedPane);
    }

    private JPanel getFixedViewConfig() {
        JPanel jPanel = new JPanel();
        final JSpinner jSpinner = new JSpinner();
        final JSpinner jSpinner2 = new JSpinner();
        final JSpinner jSpinner3 = new JSpinner();
        final JSpinner jSpinner4 = new JSpinner();
        ResamplingMode resamplingMode = DefaultResamplingModes.getModeByFrequency((float)this.userConfig.getMilliSecondsPerRowSamplingRate());
        final ResamplingMode resamplingMode2 = DefaultResamplingModes.getModeByIndex((int)SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getResamplingMode());
        double d = resamplingMode2.getSonoPxFactor(resamplingMode);
        long l = SonoViewManager.getInstance().getMainFrame().getScreenWidthMilliseconds() / 1000L;
        int n = this.userConfig.getMilliSecondsPerRow() / 1000;
        int n2 = this.userConfig.getOverlapMilliSeconds() / 1000;
        JLabel jLabel = new JLabel(n + "s in " + resamplingMode.getMasterSamplingRate() + "Hz Mode");
        JLabel jLabel2 = new JLabel(n2 + "s in " + resamplingMode.getMasterSamplingRate() + "Hz Mode");
        jSpinner.setModel(new SpinnerNumberModel((Number)((int)((double)n * d)), Integer.valueOf(1), null, (Number)1));
        jSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Integer n = (Integer)jSpinner.getValue();
                JPreferencesPanel.this.userConfig.setMilliSecondsPerRow(n * 1000);
                Integer n2 = (Integer)jSpinner2.getValue();
                JPreferencesPanel.this.userConfig.setOverlapMilliSeconds(n2 * 1000);
                JPreferencesPanel.this.userConfig.setMilliSecondsPerRowSamplingRate(resamplingMode2.getMasterSamplingRate());
            }
        });
        jSpinner2.setModel(new SpinnerNumberModel((Number)((int)((double)n2 * d)), Integer.valueOf(0), null, (Number)1));
        jSpinner2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Integer n = (Integer)jSpinner.getValue();
                JPreferencesPanel.this.userConfig.setMilliSecondsPerRow(n * 1000);
                Integer n2 = (Integer)jSpinner2.getValue();
                JPreferencesPanel.this.userConfig.setOverlapMilliSeconds(n2 * 1000);
                JPreferencesPanel.this.userConfig.setMilliSecondsPerRowSamplingRate(resamplingMode2.getMasterSamplingRate());
            }
        });
        jSpinner3.setModel(new SpinnerNumberModel((Number)this.userConfig.getDisplayedRows(), Integer.valueOf(1), null, (Number)1));
        jSpinner3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Integer n = (Integer)jSpinner3.getValue();
                JPreferencesPanel.this.userConfig.setDisplayedRows(n);
            }
        });
        jSpinner4.setModel(new SpinnerNumberModel((Number)this.userConfig.getPrefetchedRows(), Integer.valueOf(0), null, (Number)1));
        jSpinner4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Integer n = (Integer)jSpinner4.getValue();
                JPreferencesPanel.this.userConfig.setPrefetchedRows(n);
            }
        });
        int n3 = 5;
        int n4 = 30;
        TableLayout tableLayout = new TableLayout((double[][])new double[][]{{n3, -1.0, n3, -1.0, n3, -3.0, n3}, {n3, -3.0, n3, -3.0, n4, -3.0, n3, -3.0, n4, -3.0, n4, -3.0, n3, -3.0, n3, -3.0, n3}});
        jPanel.setLayout((LayoutManager)tableLayout);
        jPanel.add((Component)new JLabel("Sonogram row length at current sampling rate"), "1, 1");
        jPanel.add((Component)jSpinner, "3, 1");
        jPanel.add((Component)new JLabel("s in " + resamplingMode2.getMasterSamplingRate() + "Hz Mode"), "5, 1");
        jPanel.add((Component)jLabel, "3, 3");
        jPanel.add((Component)new JLabel("Previously set sonogram row length"), "1, 3");
        jPanel.add((Component)new JLabel("Overlap to nextrow at current sampling rate"), "1, 5");
        jPanel.add((Component)jSpinner2, "3, 5");
        jPanel.add((Component)new JLabel("s in " + resamplingMode2.getMasterSamplingRate() + "Hz Mode"), "5, 5");
        jPanel.add((Component)new JLabel("Previously set overlap"), "1, 7");
        jPanel.add((Component)jLabel2, "3, 7");
        jPanel.add((Component)new JLabel("Screen width at current sampling rate"), "1, 9");
        jPanel.add((Component)new JLabel(l + "s in " + resamplingMode2.getMasterSamplingRate() + "Hz Mode"), "3, 9");
        jPanel.add((Component)new JLabel("Number of rows rendered"), "1, 11");
        jPanel.add((Component)jSpinner3, "3, 11");
        jPanel.add((Component)new JLabel("Preloaded rows"), "1, 13");
        jPanel.add((Component)jSpinner4, "3, 13");
        return jPanel;
    }

    private JPanel getDynamicViewConfig() {
        JPanel jPanel = new JPanel();
        final JSpinner jSpinner = new JSpinner();
        jSpinner.setModel(new SpinnerNumberModel(this.userConfig.getOverlapMinFactorDynamic() * 100.0, 0.0, 50.0, 1.0));
        jSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Double d = (Double)jSpinner.getValue();
                JPreferencesPanel.this.userConfig.setOverlapMinFactorDynamic((double)d.floatValue() / 100.0);
            }
        });
        final JSpinner jSpinner2 = new JSpinner();
        jSpinner2.setModel(new SpinnerNumberModel(Float.valueOf(this.userConfig.getScreensRenderedDynamic()), Float.valueOf(1.0f), null, (Number)1));
        jSpinner2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Float f = (Float)jSpinner2.getValue();
                JPreferencesPanel.this.userConfig.setScreensRenderedDynamic(f.floatValue());
            }
        });
        final JSpinner jSpinner3 = new JSpinner();
        jSpinner3.setModel(new SpinnerNumberModel((Number)this.userConfig.getRoundSecondsPerRowDynamic(), Integer.valueOf(0), null, (Number)1));
        jSpinner3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Integer n = (Integer)jSpinner3.getValue();
                JPreferencesPanel.this.userConfig.setRoundSecondsPerRowDynamic(n);
            }
        });
        final JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(this.userConfig.getDynamicSize());
        jCheckBox.setText("Use dynamic view");
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPreferencesPanel.this.userConfig.setDynamicSize(jCheckBox.isSelected());
            }
        });
        int n = 5;
        TableLayout tableLayout = new TableLayout((double[][])new double[][]{{n, -1.0, n, -1.0, n, -3.0, n}, {n, -3.0, n, -3.0, n, -3.0, n}});
        jPanel.setLayout((LayoutManager)tableLayout);
        jPanel.add((Component)new JLabel("Relative length of next row overlap"), "1, 1");
        jPanel.add((Component)jSpinner, "3, 1");
        jPanel.add((Component)new JLabel("%"), "5, 1");
        jPanel.add((Component)new JLabel("Round row length to multiples of"), "1, 3");
        jPanel.add((Component)jSpinner3, "3, 3");
        jPanel.add((Component)new JLabel("s"), "5, 3");
        jPanel.add((Component)new JLabel("Number of rendered screens per page"), "1,5");
        jPanel.add((Component)jSpinner2, "3, 5");
        return jPanel;
    }

    private JPanel getTraceViewConfig() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        jLabel.setText("<html><large>Filter bands:</large><br><small>first value 0 -> lowpass<br>second value 0 -> highpass</small></html>");
        int n = 5;
        JPanel jPanel2 = new JPanel((LayoutManager)new TableLayout((double[][])new double[][]{{n, -1.0, n, -1.0, n}, {n, -3.0, n, -3.0, n, -3.0, n, -3.0, n, -3.0, n}}));
        final float[][] fArray = this.userConfig.getFilterBands();
        final JSpinner[] jSpinnerArray = new JSpinner[10];
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                final int n2 = i;
                final int n3 = j;
                jSpinnerArray[i * 5 + j] = new JSpinner();
                double d = fArray[i][j];
                jSpinnerArray[i * 5 + j].setModel(new SpinnerNumberModel((Number)d, Double.valueOf(0.0), null, (Number)1.0));
                jSpinnerArray[i * 5 + j].addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        Double d = (Double)jSpinnerArray[n2 * 5 + n3].getValue();
                        fArray[n2][n3] = d.floatValue();
                        JPreferencesPanel.this.userConfig.setFilterBands(fArray);
                    }
                });
                jPanel2.add((Component)jSpinnerArray[i * 5 + j], i * 2 + 1 + ", " + (j * 2 + 1));
            }
        }
        TableLayout tableLayout = new TableLayout((double[][])new double[][]{{n, -1.0, n, -1.0, n}, {n, -3.0, n, -3.0, n, -3.0, n, -3.0, n, -3.0, n}});
        jPanel.setLayout((LayoutManager)tableLayout);
        jPanel.add((Component)jLabel, "1, 1");
        jPanel.add((Component)jPanel2, "3, 1");
        return jPanel;
    }

    private JPanel getAdvancedConfig() {
        int n;
        JRadioButton[] jRadioButtonArray;
        JPanel jPanel = new JPanel();
        final JSpinner jSpinner = new JSpinner();
        jSpinner.setModel(new SpinnerNumberModel(this.userConfig.getOverlapComposite(), 0.0, 1.0, 0.1));
        jSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Double d = (Double)jSpinner.getValue();
                JPreferencesPanel.this.userConfig.setOverlapComposite(d.floatValue());
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton[] jRadioButtonArray2 = jRadioButtonArray = new JRadioButton[]{new JRadioButton("<html>2 <small>(default)</small></html> "), new JRadioButton("4"), new JRadioButton("8")};
        int n2 = jRadioButtonArray2.length;
        for (n = 0; n < n2; ++n) {
            JRadioButton jRadioButton = jRadioButtonArray2[n];
            jPanel2.add(jRadioButton);
            buttonGroup.add(jRadioButton);
        }
        int n3 = this.userConfig.getJbases();
        for (n2 = 0; n2 < jRadioButtonArray.length; ++n2) {
            n = n2;
            if (n2 == n3) {
                jRadioButtonArray[n2].setSelected(true);
            }
            jRadioButtonArray[n2].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JPreferencesPanel.this.userConfig.setJbases(n);
                }
            });
        }
        n2 = 5;
        TableLayout tableLayout = new TableLayout((double[][])new double[][]{{n2, -1.0, n2, -1.0, n2}, {n2, -3.0, n2, -3.0, n2, -3.0, n2}});
        jPanel.setLayout((LayoutManager)tableLayout);
        jPanel.add((Component)new JLabel("Overlap gray level:"), "1, 1");
        jPanel.add((Component)jSpinner, "3, 1");
        jPanel.add((Component)new JLabel("Quantization step of log (PSD energy)"), "1, 3");
        jPanel.add((Component)jPanel2, "3, 3");
        return jPanel;
    }
}

