/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing;

import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.range.JTimeRangeSelection;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.sonoview.SonoViewManager;
import edu.geophys.sonoview.swing.AbstractCommonComponent;
import edu.geophys.sonoview.swing.SonoViewBorderFactory;
import edu.geophys.sonoview.swing.largesonogram.RowDimensonModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class JSonoviewTimeSelection
extends AbstractCommonComponent {
    private static final long serialVersionUID = -3575710214924609399L;
    private final JLabel dateLabel = new JLabel(DateTimeUtil.formatDateISO((long)0L));
    private final JPanel datePanel = new JPanel();
    private final JPanel buttonPanel = new JPanel();
    private final JTimeRangeSelection timeRangeSelection = new JTimeRangeSelection();
    private JButton buttonLeft;
    private JButton buttonRight;
    private JButton buttonFrameLeft;
    private JButton buttonFrameRight;

    public JSonoviewTimeSelection() {
        this.initComponent();
    }

    private void initComponent() {
        this.buttonLeft = new JButton("<");
        this.buttonLeft.setMargin(new Insets(2, 5, 2, 5));
        this.buttonLeft.setFocusable(false);
        this.buttonLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSonoviewTimeSelection.this.onButtonLeftPressed();
            }
        });
        this.buttonRight = new JButton(">");
        this.buttonRight.setMargin(new Insets(2, 5, 2, 5));
        this.buttonRight.setFocusable(false);
        this.buttonRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSonoviewTimeSelection.this.onButtonRightPressed();
            }
        });
        this.buttonFrameLeft = new JButton("<<");
        this.buttonFrameLeft.setMargin(new Insets(2, 5, 2, 5));
        this.buttonFrameLeft.setFocusable(false);
        this.buttonFrameLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSonoviewTimeSelection.this.onButtonFrameLeftPressed();
            }
        });
        this.buttonFrameRight = new JButton(">>");
        this.buttonFrameRight.setMargin(new Insets(2, 5, 2, 5));
        this.buttonFrameRight.setFocusable(false);
        this.buttonFrameRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSonoviewTimeSelection.this.onButtonFrameRightPressed();
            }
        });
        this.buttonPanel.setLayout(new GridLayout(1, 5, 0, 0));
        this.buttonPanel.add(this.buttonFrameLeft);
        this.buttonPanel.add(this.buttonLeft);
        this.buttonPanel.add(this.buttonRight);
        this.buttonPanel.add(this.buttonFrameRight);
        this.datePanel.setLayout(new GridBagLayout());
        this.datePanel.setBorder(SonoViewBorderFactory.getSonoViewBorder());
        this.datePanel.add(this.dateLabel);
        this.timeRangeSelection.setBorder(SonoViewBorderFactory.getSonoViewBorder());
        Dimension dimension = new Dimension(500, 35);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        springLayout.putConstraint("North", (Component)this.datePanel, 0, "North", (Component)this);
        springLayout.putConstraint("South", (Component)this.datePanel, 0, "South", (Component)this);
        springLayout.putConstraint("West", (Component)this.datePanel, 0, "West", (Component)this);
        this.add(this.datePanel);
        springLayout.putConstraint("North", (Component)this.buttonPanel, 0, "North", (Component)this);
        springLayout.putConstraint("South", (Component)this.buttonPanel, 0, "South", (Component)this);
        springLayout.putConstraint("East", (Component)this.buttonPanel, 0, "East", (Component)this);
        this.add(this.buttonPanel);
        springLayout.putConstraint("North", (Component)this.timeRangeSelection, 0, "North", (Component)this);
        springLayout.putConstraint("South", (Component)this.timeRangeSelection, 0, "South", (Component)this);
        springLayout.putConstraint("West", (Component)this.timeRangeSelection, 0, "East", (Component)this.datePanel);
        springLayout.putConstraint("East", (Component)this.timeRangeSelection, 0, "West", (Component)this.buttonPanel);
        this.add((Component)this.timeRangeSelection);
        this.setAxisModel(this.getAxisModel());
        this.setRowDimension(this.getRowDimension());
    }

    @Override
    public void setAxisModel(BoundedLongRangeModel boundedLongRangeModel) {
        super.setAxisModel(boundedLongRangeModel);
        this.timeRangeSelection.setModel(boundedLongRangeModel);
        this.onAxisModelChanged();
    }

    @Override
    public void setRowDimension(RowDimensonModel rowDimensonModel) {
        super.setRowDimension(rowDimensonModel);
        this.onRowDimensionChanged();
    }

    protected void onButtonLeftPressed() {
        SonoViewManager.getInstance().getMainFrame().oneLineUpActionPerformed();
    }

    protected void onButtonRightPressed() {
        SonoViewManager.getInstance().getMainFrame().oneLineDownActionPerformed();
    }

    protected void onButtonFrameLeftPressed() {
        SonoViewManager.getInstance().getMainFrame().onePageUpActionPerformed();
    }

    protected void onButtonFrameRightPressed() {
        SonoViewManager.getInstance().getMainFrame().onePageDownActionPerformed();
    }

    protected void onButtonUpdatingPressed() {
        SuiteManager.INSTANCE.getGlobalEventWindowModel().setUpdating(true);
    }

    @Override
    protected void onAxisModelChanged() {
        this.upgradeBackground();
        this.dateLabel.setText(DateTimeUtil.formatDateISO((long)this.getAxisModel().getValue()));
    }

    @Override
    protected void onRowDimensionChanged() {
        Dimension dimension = new Dimension(this.getRowDimension().getAxisComponentWidth(), this.datePanel.getPreferredSize().height);
        this.datePanel.setMinimumSize(dimension);
        this.datePanel.setPreferredSize(dimension);
        this.datePanel.setMaximumSize(dimension);
        Dimension dimension2 = new Dimension(this.getRowDimension().getSonogramComponentWidth(), this.timeRangeSelection.getPreferredSize().height);
        this.timeRangeSelection.setMinimumSize(dimension2);
        this.timeRangeSelection.setPreferredSize(dimension2);
        this.timeRangeSelection.setMaximumSize(dimension2);
    }

    @Override
    protected void onSelectionModelChanged() {
    }

    private void upgradeBackground() {
        if (SonoViewManager.getInstance() != null) {
            this.timeRangeSelection.setShowEventMarkers(SonoViewManager.getInstance().getSettingsManager().getUserConfiguration().isShowTimeLineMarkers());
        }
    }
}

