/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing.largesonogram;

import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.sonoview.SettingsManager;
import edu.geophys.sonoview.swing.largesonogram.AbstractLargeSonogram;
import edu.geophys.sonoview.swing.largesonogram.DefaultLargeSonogramModel;
import edu.geophys.sonoview.swing.largesonogram.JSonogramList;
import edu.geophys.sonoview.swing.largesonogram.JSonogramListFooter;
import edu.geophys.sonoview.swing.largesonogram.RowDimensonModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import layout.TableLayout;

public class JLargeSonogram
extends AbstractLargeSonogram {
    private static final long serialVersionUID = 3859227760528306242L;
    public static final String PROPERTY_SONOGRAM_MODEL = "sonogramModel";
    private JScrollPane scrollPane;
    private JSonogramList rowsList;
    private JSonogramListFooter rowsFooter;
    private JFrame parent;
    private boolean horizontalScrollbarWarningShown = false;
    private static final String H_SCROLL_WARNING = "<html>Sonograms are longer than the window size. Use scrolling to view remaining part,<br>adjust the fixed view settings in the preferences menu or switch to dynamic view.</html>";
    private boolean resetAxisModelToModelDefaultLock = false;

    public JLargeSonogram(JFrame jFrame) {
        this.parent = jFrame;
        this.initialize();
    }

    private void initialize() {
        this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0, -3.0}}));
        this.add((Component)this.getScrollPane(), "0, 0");
        this.add((Component)this.getRowsFooter(), "0, 1");
        this.setRowDimension(this.getRowDimension());
        this.setSelectionModel(this.getSelectionModel());
        this.setAxisModel(this.getAxisModel());
    }

    private void resetAxisModelToModelDefault() {
        if (this.resetAxisModelToModelDefaultLock) {
            return;
        }
        this.resetAxisModelToModelDefaultLock = true;
        BoundedLongRangeModel boundedLongRangeModel = this.getAxisModel();
        DefaultLargeSonogramModel defaultLargeSonogramModel = this.getModel();
        if (boundedLongRangeModel.getExtent() <= 0L && defaultLargeSonogramModel != null) {
            BoundedLongRangeModel boundedLongRangeModel2 = defaultLargeSonogramModel.getTimeRangeModel();
            boundedLongRangeModel.setRangeProperties(boundedLongRangeModel2.getValue(), boundedLongRangeModel.getExtent(), boundedLongRangeModel2.getValue(), boundedLongRangeModel2.getValue() + boundedLongRangeModel2.getIncrement(), boundedLongRangeModel.getIncrement(), false);
        }
        this.resetAxisModelToModelDefaultLock = false;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.rowsList != null) {
            this.rowsList.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.rowsList != null) {
            this.rowsList.setForeground(color);
        }
        this.getRowsFooter().setForeground(color);
    }

    public final JSonogramList getRowsList() {
        if (this.rowsList == null) {
            this.rowsList = new JSonogramList(this);
            this.rowsList.setBackground(this.getBackground());
            this.rowsList.setForeground(this.getForeground());
            this.rowsList.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.rowsList;
    }

    public final JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getRowsList(), 20, 30);
            this.scrollPane.getHorizontalScrollBar().setUnitIncrement(16);
            this.scrollPane.getHorizontalScrollBar().setVisible(false);
            this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            this.scrollPane.setFocusable(false);
            this.scrollPane.getInputMap(0).clear();
            this.scrollPane.getInputMap(2).clear();
            this.scrollPane.getInputMap(1).clear();
            final JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
            jScrollBar.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    SuiteManager.INSTANCE.getGlobalEventWindowModel().firePropertyChange("scrollbarPosition", null, (Object)jScrollBar.getModel());
                }
            });
            this.scrollPane.getViewport().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    boolean bl = JLargeSonogram.this.scrollPane.getHorizontalScrollBar().isVisible();
                    if (!SettingsManager.getInstance().getUserConfiguration().getDynamicSize() && JLargeSonogram.this.rowsList.getChildComponents().size() > 0 && bl && !JLargeSonogram.this.horizontalScrollbarWarningShown) {
                        JLargeSonogram.this.horizontalScrollbarWarningShown = true;
                        LogUtil.warn(this.getClass(), (String)JLargeSonogram.H_SCROLL_WARNING, (boolean)true);
                    }
                }
            });
        }
        return this.scrollPane;
    }

    public final JSonogramListFooter getRowsFooter() {
        if (this.rowsFooter == null) {
            this.rowsFooter = new JSonogramListFooter();
            this.rowsFooter.setVisible(false);
        }
        return this.rowsFooter;
    }

    @Override
    public void setModel(DefaultLargeSonogramModel defaultLargeSonogramModel) {
        super.setModel(defaultLargeSonogramModel);
        if (defaultLargeSonogramModel != null) {
            this.getRowsFooter().setModel(defaultLargeSonogramModel);
            this.getRowsList().setModel(defaultLargeSonogramModel);
            this.resetAxisModelToModelDefault();
            this.getRowsFooter().setVisible(true);
            this.getScrollPane().setVisible(true);
        } else {
            this.getRowsFooter().setVisible(false);
            this.getScrollPane().setVisible(false);
            this.getRowsFooter().setModel(null);
            this.getRowsList().setModel(null);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setAxisModel(BoundedLongRangeModel boundedLongRangeModel) {
        super.setAxisModel(boundedLongRangeModel);
        this.getRowsFooter().setAxisModel(boundedLongRangeModel);
        this.getRowsList().setAxisModel(boundedLongRangeModel);
    }

    @Override
    public void setSelectionModel(BoundedLongRangeModel boundedLongRangeModel) {
        super.setSelectionModel(boundedLongRangeModel);
        this.getRowsFooter().setSelectionModel(boundedLongRangeModel);
        this.getRowsList().setSelectionModel(boundedLongRangeModel);
    }

    @Override
    public void setRowDimension(RowDimensonModel rowDimensonModel) {
        super.setRowDimension(rowDimensonModel);
        this.getRowsFooter().setRowDimension(rowDimensonModel);
        this.getRowsList().setRowDimension(rowDimensonModel);
    }

    @Override
    protected void onModelStateChanged() {
        Dimension dimension = this.getRowsFooter().getMinimumSize();
        dimension.width = this.getRowsList().getMinimumSize().width;
        this.getRowsFooter().setMinimumSize(dimension);
        this.getRowsFooter().setPreferredSize(dimension);
    }

    @Override
    protected void onAxisModelChanged() {
    }

    @Override
    protected void onSelectionModelChanged() {
    }

    @Override
    protected void onRowDimensionChanged() {
    }

    public void scrollTop() {
        this.scrollPane.getVerticalScrollBar().setValue(0);
    }

    public void scrollBottom() {
        this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
    }
}

