/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing.largesonogram;

import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.sonoview.swing.SonoViewBorderFactory;
import edu.geophys.sonoview.swing.largesonogram.AbstractRowComponent;
import edu.geophys.sonoview.swing.largesonogram.JRowDateTime;
import edu.geophys.sonoview.swing.largesonogram.JRowSonogram;
import edu.geophys.sonoview.swing.largesonogram.JSonogramListFooter;
import edu.geophys.sonoview.swing.largesonogram.RowDimensonModel;
import edu.geophys.sonoview.swing.largesonogram.RowSonogramModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.SpringLayout;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public final class JRow
extends AbstractRowComponent {
    private static final long serialVersionUID = 8439747044175636995L;
    private JRowSonogram sonogram;
    private JRowDateTime rowAxis;
    private JSonogramListFooter rowsFooter;
    public static final int DEFAULT_SPACE_BETWEEN_CHILDS = 3;
    private final MouseAdapter axisMouseEnterAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JRow.this.getSonogramComponent().setStationNamesVisible(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JRow.this.getSonogramComponent().setStationNamesVisible(false);
        }
    };

    public JRow() {
        this.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        springLayout.putConstraint("North", (Component)this.getRowAxisComponent(), 0, "North", (Component)this);
        springLayout.putConstraint("South", (Component)this.getRowAxisComponent(), 0, "South", (Component)this);
        springLayout.putConstraint("West", (Component)this.getRowAxisComponent(), 0, "West", (Component)this);
        this.add(this.getRowAxisComponent());
        springLayout.putConstraint("North", (Component)this.getSonogramComponent(), 0, "North", (Component)this);
        springLayout.putConstraint("East", (Component)this.getSonogramComponent(), 0, "East", (Component)this);
        springLayout.putConstraint("South", (Component)this.getSonogramComponent(), 0, "South", (Component)this);
        springLayout.putConstraint("West", (Component)this.getSonogramComponent(), 0, "East", (Component)this.getRowAxisComponent());
        this.add(this.getSonogramComponent());
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.getSonogramComponent().setBackground(color);
    }

    public void setAxisBackground(Color color) {
        this.getRowAxisComponent().setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.getSonogramComponent().setForeground(color);
        this.getRowAxisComponent().setForeground(color);
    }

    public final JSonogramListFooter getRowsFooter() {
        if (this.rowsFooter == null) {
            this.rowsFooter = new JSonogramListFooter();
        }
        return this.rowsFooter;
    }

    private void updateMinimumSizeFromState() {
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        if (this.getModel() != null) {
            Dimension dimension2 = this.getRowAxisComponent().getMinimumSize();
            Dimension dimension3 = this.getSonogramComponent().getMinimumSize();
            dimension.width += dimension2.width + dimension3.width;
            dimension.height += dimension3.height;
        }
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
    }

    public final JRowSonogram getSonogramComponent() {
        if (this.sonogram == null) {
            this.sonogram = new JRowSonogram();
            this.sonogram.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 0), SonoViewBorderFactory.getSonoViewBorder()));
        }
        return this.sonogram;
    }

    public final JRowDateTime getRowAxisComponent() {
        if (this.rowAxis == null) {
            this.rowAxis = new JRowDateTime();
        }
        return this.rowAxis;
    }

    @Override
    public void setModel(RowSonogramModel rowSonogramModel) {
        super.setModel(rowSonogramModel);
        JRowDateTime jRowDateTime = this.getRowAxisComponent();
        for (MouseListener mouseListener : jRowDateTime.getMouseListeners()) {
            jRowDateTime.removeMouseListener(mouseListener);
        }
        jRowDateTime.setModel(rowSonogramModel);
        this.getSonogramComponent().setModel(rowSonogramModel);
        jRowDateTime.addMouseListener(this.axisMouseEnterAdapter);
        this.updateMinimumSizeFromState();
    }

    @Override
    public void setAxisModel(BoundedLongRangeModel boundedLongRangeModel) {
        super.setAxisModel(boundedLongRangeModel);
        this.getSonogramComponent().setAxisModel(boundedLongRangeModel);
    }

    @Override
    public void setSelectionModel(BoundedLongRangeModel boundedLongRangeModel) {
        super.setSelectionModel(boundedLongRangeModel);
        this.getSonogramComponent().setSelectionModel(this.getSelectionModel());
    }

    @Override
    public void setRowDimension(RowDimensonModel rowDimensonModel) {
        super.setRowDimension(rowDimensonModel);
        this.getRowAxisComponent().setRowDimension(rowDimensonModel);
        this.getSonogramComponent().setRowDimension(rowDimensonModel);
    }

    @Override
    protected void onAxisModelChanged() {
        this.repaint();
    }

    @Override
    protected void onSelectionModelChanged() {
    }

    @Override
    protected void onRowDimensionChanged() {
    }
}

