/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing.largesonogram;

import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.sonoview.swing.SonoViewBorderFactory;
import edu.geophys.sonoview.swing.largesonogram.AbstractRowComponent;
import edu.geophys.sonoview.swing.largesonogram.RowDimensonModel;
import edu.geophys.sonoview.swing.largesonogram.RowSonogramModel;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.JLabel;

final class JRowDateTime
extends AbstractRowComponent {
    private static final long serialVersionUID = 6183129560554607122L;
    private JLabel label = null;

    public JRowDateTime() {
        this.setOpaque(true);
        this.setBorder(SonoViewBorderFactory.getSonoViewBorder());
        this.setLayout(new GridBagLayout());
        this.add(this.getLabel());
        this.updateSize();
    }

    @Override
    public void setModel(RowSonogramModel rowSonogramModel) {
        super.setModel(rowSonogramModel);
        this.updateLabelText();
    }

    public JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel();
        }
        return this.label;
    }

    @Override
    public void setRowDimension(RowDimensonModel rowDimensonModel) {
        super.setRowDimension(rowDimensonModel);
        this.updateSize();
    }

    private void updateSize() {
        Dimension dimension = new Dimension(this.getRowDimension().getAxisComponentWidth(), 20);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
    }

    private void updateLabelText() {
        RowSonogramModel rowSonogramModel = this.getModel();
        if (rowSonogramModel != null) {
            long l;
            long l2 = rowSonogramModel.getStartEpochMs();
            if (MathUtil.floor((long)(l2 - (long)(0.9 * (double)(l = rowSonogramModel.getFullLengthMs() - rowSonogramModel.getOverlapMs()))), (long)86400000L) != MathUtil.floor((long)l2, (long)86400000L)) {
                if (rowSonogramModel.size() == 1) {
                    this.getLabel().setText("<html><center><small>" + DateTimeUtil.formatDateISO((long)l2) + "<br>" + DateTimeUtil.formatTime((long)l2) + "</small></center></html>");
                } else {
                    this.getLabel().setText("<html><center>" + DateTimeUtil.formatDateISO((long)l2) + "<br>" + DateTimeUtil.formatTime((long)l2) + "</center></html>");
                }
            } else {
                this.getLabel().setText(DateTimeUtil.formatTime((long)l2));
            }
        }
    }

    @Override
    protected void onAxisModelChanged() {
        this.updateLabelText();
    }

    @Override
    protected void onRowDimensionChanged() {
        this.updateSize();
    }

    @Override
    protected void onSelectionModelChanged() {
    }
}

