/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.swing.largesonogram;

import edu.geophys.commons.detection.AbstractDetection;
import edu.geophys.commons.detection.interfaces.HasBoxMarker;
import edu.geophys.commons.detection.interfaces.HasLineMarker;
import edu.geophys.commons.suite.EventFileManager;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.DefaultBoundedLongRangeModel;
import edu.geophys.commons.ui.sonogram.JStationSonogram;
import edu.geophys.sonoview.SonoViewManager;
import edu.geophys.sonoview.swing.largesonogram.AbstractRowComponent;
import edu.geophys.sonoview.swing.largesonogram.RowSonogramModel;
import edu.geophys.sonoview.swing.largesonogram.SonoViewStationSonogram;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class JRowSonogram
extends AbstractRowComponent {
    private static final long serialVersionUID = -363762163563298004L;
    private boolean stationNamesVisible = false;
    private static final int MARKER_WIDTH = 3;
    private static final int MARKER_TICK_LENGTH = 8;
    private static final int LINE_WIDTH_SELECTION_DEFAULT = 2;
    public static final int DEFAULT_SPACE_BETWEEN_CHILDS = 1;
    private EventFileManager eventFileManager;
    private final ArrayList<SonoViewStationSonogram> childComponents = new ArrayList();
    private List<AbstractDetection> detections = new ArrayList<AbstractDetection>();
    private AbstractDetection hoveredDetection = null;
    final BoundedLongRangeModel childCursorModel = new DefaultBoundedLongRangeModel();
    final ChangeListener cursorModelListener = new ChangeListener(){
        private boolean listenerLock = false;

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.listenerLock) {
                return;
            }
            this.listenerLock = true;
            if (changeEvent.getSource() == JRowSonogram.this.childCursorModel) {
                JRowSonogram.this.getAxisModel().setRangeProperties(JRowSonogram.this.childCursorModel);
            } else {
                JRowSonogram.this.childCursorModel.setExtent(-1L);
            }
            this.listenerLock = false;
        }
    };
    private final MouseAdapter childMouseAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            SonoViewStationSonogram sonoViewStationSonogram = (SonoViewStationSonogram)((Object)mouseEvent.getComponent());
            sonoViewStationSonogram.setCursorColor(ThemeManager.getInstance().getTheme().getAxisColor());
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            SonoViewStationSonogram sonoViewStationSonogram = (SonoViewStationSonogram)((Object)mouseEvent.getComponent());
            sonoViewStationSonogram.setCursorColor(ThemeManager.getInstance().getTheme().getAxisColor());
            JRowSonogram.this.hoveredDetection = null;
        }
    };

    public JRowSonogram() {
        this.eventFileManager = SuiteManager.INSTANCE.getEventFileManager();
        BoxLayout boxLayout = new BoxLayout(this, 1);
        this.setLayout(boxLayout);
        this.childCursorModel.addChangeListener(this.cursorModelListener);
        this.getAxisModel().addChangeListener(this.cursorModelListener);
        SuiteManager.INSTANCE.getGlobalEventWindowModel().addPropertyChangeListener("eventMarkers", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (JRowSonogram.this.getModel() != null) {
                    JRowSonogram.this.updateChilds();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                JRowSonogram.this.hoveredDetection = JRowSonogram.this.getEventBeginningAt(mouseEvent.getPoint());
            }
        });
    }

    public void setStationNamesVisible(boolean bl) {
        if (bl == this.stationNamesVisible) {
            return;
        }
        this.stationNamesVisible = bl;
        for (SonoViewStationSonogram sonoViewStationSonogram : this.getChildComponents()) {
            sonoViewStationSonogram.setStationNameVisible(this.stationNamesVisible);
        }
    }

    private void adjustChildAmount() {
        int n;
        RowSonogramModel rowSonogramModel = this.getModel();
        for (n = this.getChildComponents().size() - 1; n > rowSonogramModel.size(); --n) {
            this.remove((Component)((Object)this.getChildComponents().get(n)));
        }
        for (n = this.getChildComponents().size(); n < rowSonogramModel.size(); ++n) {
            SonoViewStationSonogram sonoViewStationSonogram = new SonoViewStationSonogram(this);
            sonoViewStationSonogram.addMouseListener(this.childMouseAdapter);
            sonoViewStationSonogram.addMouseMotionListener(this.childMouseAdapter);
            sonoViewStationSonogram.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
            this.getChildComponents().add(sonoViewStationSonogram);
        }
        for (n = this.getComponentCount(); n < rowSonogramModel.size(); ++n) {
            this.add((Component)((Object)this.getChildComponents().get(n)));
        }
    }

    void updateChilds() {
        RowSonogramModel rowSonogramModel = this.getModel();
        this.adjustChildAmount();
        this.detections = this.eventFileManager.getAllDetectionsInTimeWindow(rowSonogramModel.get(0).getStartEpochTime(), rowSonogramModel.get(0).getEndEpochTime());
        for (int i = 0; i < rowSonogramModel.size(); ++i) {
            SonoViewStationSonogram sonoViewStationSonogram = this.getChildComponents().get(i);
            sonoViewStationSonogram.setModel(rowSonogramModel.get(i));
            sonoViewStationSonogram.setTrainingEntries(this.detections);
            sonoViewStationSonogram.setSelectionModel(this.getSelectionModel());
            sonoViewStationSonogram.setCursorModel(this.childCursorModel);
            sonoViewStationSonogram.setSelectionColor(ThemeManager.getInstance().getTheme().getHypolineRed());
            sonoViewStationSonogram.setSelectionAlpha(1.0f);
            sonoViewStationSonogram.setSelectionLineWidth(2);
            sonoViewStationSonogram.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    JRowSonogram.this.dispatchEvent(mouseEvent);
                }
            });
        }
    }

    private void updateMinimumSizeFromState() {
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        if (this.getModel().size() > 0) {
            Dimension dimension2 = this.getChildComponents().get(0).getMinimumSize();
            dimension.width += dimension2.width;
            for (int i = 0; i < this.getModel().size(); ++i) {
                dimension2 = this.getChildComponents().get(i).getMinimumSize();
                dimension.height += dimension2.height;
            }
        }
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.getRowDimension().setSonogramComponentWidth(dimension.width);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        boolean bl = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration().getShowMarkers();
        for (AbstractDetection object2 : this.detections) {
            boolean bl2;
            boolean bl3 = bl2 = object2.getSource() != null;
            if (bl2 && !bl) continue;
            if (object2 instanceof HasBoxMarker) {
                this.drawBoxMarker(graphics2D, object2.getColor(), object2.getStartTimeMs(), object2.getDurationMs(), true);
            }
            if (!(object2 instanceof HasLineMarker)) continue;
            this.drawLineMarker(graphics2D, object2.getColor(), ((HasLineMarker)object2).getLineMs(), 3);
        }
        if (this.hoveredDetection != null) {
            this.drawEventText(graphics2D, this.hoveredDetection, this.hoveredDetection.getColor());
        }
        BoundedLongRangeModel boundedLongRangeModel = this.getSelectionModel();
        if (SonoViewManager.getInstance().isUseTraceViewFrame()) {
            this.drawBoxMarker(graphics2D, Color.RED, boundedLongRangeModel.getValue(), (int)boundedLongRangeModel.getExtent(), false);
            AbstractDetection abstractDetection = SonoViewManager.getInstance().getCurrentPattern();
            if (abstractDetection instanceof HasBoxMarker) {
                this.drawCorner(graphics2D, abstractDetection.getColor(), abstractDetection.getStartTimeMs(), abstractDetection.getDurationMs());
            }
        }
        if (this.detections.size() > 0) {
            JComponent jComponent = (JComponent)SwingUtilities.getAncestorOfClass(JComponent.class, this);
            jComponent.revalidate();
            jComponent.repaint();
        }
    }

    private AbstractDetection getEventBeginningAt(Point point) {
        for (AbstractDetection abstractDetection : this.detections) {
            SonoViewStationSonogram sonoViewStationSonogram = this.childComponents.get(0);
            if (sonoViewStationSonogram == null) {
                return null;
            }
            long l = abstractDetection.getStartTimeMs();
            int n = (int)Math.max(abstractDetection.getDurationMs(), 1L);
            DefaultBoundedLongRangeModel defaultBoundedLongRangeModel = new DefaultBoundedLongRangeModel(l, (long)n, l, l + (long)n, 1L);
            Rectangle2D rectangle2D = sonoViewStationSonogram.getAreaInSonogram((BoundedLongRangeModel)defaultBoundedLongRangeModel);
            if (!(point.getX() > rectangle2D.getMinX()) || !(point.getX() < rectangle2D.getMinX() + 20.0)) continue;
            return abstractDetection;
        }
        return null;
    }

    private void drawEventText(Graphics2D graphics2D, AbstractDetection abstractDetection, Color color) {
        SonoViewStationSonogram sonoViewStationSonogram = this.childComponents.get(0);
        if (sonoViewStationSonogram == null || abstractDetection == null) {
            return;
        }
        long l = abstractDetection.getIndexTimeMs();
        DefaultBoundedLongRangeModel defaultBoundedLongRangeModel = new DefaultBoundedLongRangeModel(l, 1L, l, l + 1L, 1L);
        Rectangle2D rectangle2D = sonoViewStationSonogram.getAreaInSonogram((BoundedLongRangeModel)defaultBoundedLongRangeModel);
        graphics2D.setFont(graphics2D.getFont().deriveFont(1, 14.0f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (abstractDetection != null) {
            String string = abstractDetection.getLabel();
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.drawString(string, 5 + (int)rectangle2D.getX(), this.getHeight() - 9);
            graphics2D.setColor(color);
            graphics2D.drawString(string, 4 + (int)rectangle2D.getX(), this.getHeight() - 10);
        }
    }

    private void drawBoxMarker(Graphics2D graphics2D, Color color, long l, long l2, boolean bl) {
        this.drawBoxMarker(graphics2D, color, l, l2, bl, 3);
    }

    private void drawBoxMarker(Graphics2D graphics2D, Color color, long l, long l2, boolean bl, int n) {
        DefaultBoundedLongRangeModel defaultBoundedLongRangeModel;
        int n2 = l2 < 1L ? 1000 : (int)Math.min(l2, Integer.MAX_VALUE);
        SonoViewStationSonogram sonoViewStationSonogram = this.childComponents.get(0);
        Rectangle2D rectangle2D = sonoViewStationSonogram.getAreaInSonogram((BoundedLongRangeModel)(defaultBoundedLongRangeModel = new DefaultBoundedLongRangeModel(l, (long)n2, l, l + (long)n2, 1L)));
        if (rectangle2D == null) {
            return;
        }
        boolean[] blArray = sonoViewStationSonogram.isAreaInSonogramCropped((BoundedLongRangeModel)defaultBoundedLongRangeModel);
        int n3 = (int)rectangle2D.getMinX();
        int n4 = (int)rectangle2D.getWidth();
        int n5 = this.getHeight();
        graphics2D.setColor(color);
        graphics2D.fillRect(n3, 0, n4, n);
        graphics2D.fillRect(n3, n5 - n, n4, n);
        if (bl) {
            int n6;
            int n7 = this.childComponents.size();
            int n8 = n5 / n7;
            if (!blArray[0]) {
                graphics2D.fillRect(n3, 0, n, 8);
                graphics2D.fillRect(n3, n5 - 8, n, 8);
                for (n6 = 1; n6 < n7; ++n6) {
                    graphics2D.fillRect(n3, n6 * n8 - 1 - 4, n, 10);
                }
            }
            if (!blArray[1]) {
                graphics2D.fillRect(n3 + n4 - n, 0, n, 8);
                graphics2D.fillRect(n3 + n4 - n, n5 - 8, n, 8);
                for (n6 = 1; n6 < n7; ++n6) {
                    graphics2D.fillRect(n3 + n4 - n, n6 * n8 - 1 - 4, n, 10);
                }
            }
        } else {
            if (!blArray[0]) {
                graphics2D.fillRect(n3, 0, n, n5);
            }
            if (!blArray[1]) {
                graphics2D.fillRect(n3 + n4 - n, 0, n, n5);
            }
        }
    }

    private void drawLineMarker(Graphics2D graphics2D, Color color, long l, int n) {
        DefaultBoundedLongRangeModel defaultBoundedLongRangeModel;
        SonoViewStationSonogram sonoViewStationSonogram = this.childComponents.get(0);
        Rectangle2D rectangle2D = sonoViewStationSonogram.getAreaInSonogram((BoundedLongRangeModel)(defaultBoundedLongRangeModel = new DefaultBoundedLongRangeModel(l, (long)n, l, l + (long)n, 1L)));
        if (rectangle2D == null) {
            return;
        }
        int n2 = (int)rectangle2D.getMinX();
        int n3 = (int)rectangle2D.getWidth();
        int n4 = this.getHeight();
        graphics2D.setColor(color);
        graphics2D.fillRect(n2, 0, n3, n4);
    }

    private void drawCorner(Graphics2D graphics2D, Color color, long l, long l2) {
        this.drawCorner(graphics2D, color, l, l2, 3);
    }

    private void drawCorner(Graphics2D graphics2D, Color color, long l, long l2, int n) {
        DefaultBoundedLongRangeModel defaultBoundedLongRangeModel;
        int n2 = (int)Math.max(l2, 1L);
        SonoViewStationSonogram sonoViewStationSonogram = this.childComponents.get(0);
        Rectangle2D rectangle2D = sonoViewStationSonogram.getAreaInSonogram((BoundedLongRangeModel)(defaultBoundedLongRangeModel = new DefaultBoundedLongRangeModel(l, (long)n2, l, l + (long)n2, 1L)));
        if (rectangle2D == null) {
            return;
        }
        boolean[] blArray = sonoViewStationSonogram.isAreaInSonogramCropped((BoundedLongRangeModel)defaultBoundedLongRangeModel);
        int n3 = (int)rectangle2D.getMinX();
        int n4 = (int)rectangle2D.getWidth();
        int n5 = this.getHeight();
        graphics2D.setColor(color);
        if (!blArray[0]) {
            graphics2D.fillRect(n3, 0, 3 * n, n);
            graphics2D.fillRect(n3, 0, n, 2 * n);
            graphics2D.fillRect(n3, n5 - n, 3 * n, n);
            graphics2D.fillRect(n3, n5 - 2 * n, n, 2 * n);
        }
        if (!blArray[1]) {
            graphics2D.fillRect(n3 + n4 - 3 * n, 0, 3 * n, n);
            graphics2D.fillRect(n3 + n4 - n, 0, n, 2 * n);
            graphics2D.fillRect(n3 + n4 - 3 * n, n5 - n, 3 * n, n);
            graphics2D.fillRect(n3 + n4 - n, n5 - 2 * n, n, 2 * n);
        }
    }

    @Override
    public void setModel(RowSonogramModel rowSonogramModel) {
        super.setModel(rowSonogramModel);
        if (rowSonogramModel == null) {
            this.removeAll();
            this.getChildComponents().clear();
        } else {
            this.updateChilds();
        }
        this.updateMinimumSizeFromState();
    }

    @Override
    public void setSelectionModel(BoundedLongRangeModel boundedLongRangeModel) {
        super.setSelectionModel(boundedLongRangeModel);
        for (JStationSonogram jStationSonogram : this.getChildComponents()) {
            jStationSonogram.setSelectionModel(boundedLongRangeModel);
        }
    }

    @Override
    public void setAxisModel(BoundedLongRangeModel boundedLongRangeModel) {
        this.getAxisModel().removeChangeListener(this.cursorModelListener);
        super.setAxisModel(boundedLongRangeModel);
        this.getAxisModel().addChangeListener(this.cursorModelListener);
    }

    @Override
    protected void onAxisModelChanged() {
    }

    @Override
    protected void onRowDimensionChanged() {
    }

    @Override
    protected void onSelectionModelChanged() {
        this.repaint();
    }

    public ArrayList<SonoViewStationSonogram> getChildComponents() {
        return this.childComponents;
    }
}

