/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.traceview.swing;

import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.DefaultBoundedLongRangeModel;
import edu.geophys.commons.ui.time.JCursorTimeAxis;
import edu.geophys.commons.ui.time.JTimeAxis;
import edu.geophys.commons.util.SiPrefixedValue;
import edu.geophys.sonoview.traceview.TraceViewSnsModel;
import edu.geophys.sonoview.traceview.swing.TraceViewScaleBar;
import edu.geophys.sonoview.traceview.swing.TraceViewSnsLabel;
import edu.geophys.sonoview.traceview.swing.TraceViewSnsPlot;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import layout.TableLayout;

public class TraceViewSnsPanel
extends JPanel {
    private final TraceViewSnsPlot snsPlot;
    private final JLabel scaleLabel;
    private static final int SPACING = 2;
    private static final int LABEL_WIDTH = 70;

    public TraceViewSnsPanel(TraceViewSnsModel traceViewSnsModel) {
        this.setPreferredSize(new Dimension(300, 130));
        this.setMinimumSize(new Dimension(300, 130));
        this.setBorder(new CompoundBorder(new LineBorder(ThemeManager.getInstance().getTheme().getUIBorderColor(), 1), new EmptyBorder(1, 1, 1, 1)));
        double[][] dArrayArray = new double[][]{{70.0, 2.0, -3.0, 2.0, -1.0}, {-1.0, 2.0, -3.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
        this.setOpaque(false);
        this.add((Component)new TraceViewSnsLabel(traceViewSnsModel), "0,0");
        this.snsPlot = new TraceViewSnsPlot(traceViewSnsModel);
        this.add((Component)this.snsPlot, "4,0");
        JCursorTimeAxis jCursorTimeAxis = new JCursorTimeAxis(JTimeAxis.Alignment.NORTH);
        BoundedLongRangeModel boundedLongRangeModel = traceViewSnsModel.getTraceViewModel().getTraceView().getSelection();
        jCursorTimeAxis.setModel((BoundedLongRangeModel)new DefaultBoundedLongRangeModel(boundedLongRangeModel.getValue(), 0L, boundedLongRangeModel.getValue(), boundedLongRangeModel.getValue() + boundedLongRangeModel.getExtent(), 1L));
        jCursorTimeAxis.setOpaque(false);
        jCursorTimeAxis.setPreferredSize(new Dimension(100, 20));
        this.add((Component)jCursorTimeAxis, "4,2");
        this.scaleLabel = new JLabel(String.format("%.2f", Float.valueOf(2.0f / this.snsPlot.getScale())));
        TraceViewScaleBar traceViewScaleBar = new TraceViewScaleBar(this.snsPlot);
        this.add((Component)traceViewScaleBar, "2,0");
        SiPrefixedValue siPrefixedValue = new SiPrefixedValue((Number)(traceViewScaleBar.getLenBarNMS() * 1.0E-9));
        String string = String.format("%d", (int)siPrefixedValue.getPrefixedValue()) + siPrefixedValue.getPrefix() + "m/s";
        this.add((Component)new JLabel(string, 4), "0,2");
    }
}

