/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.sonoview.traceview.swing;

import edu.geophys.commons.detection.TraceViewState;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.SiPrefixedValue;
import edu.geophys.sonoview.SonoViewManager;
import edu.geophys.sonoview.traceview.TraceViewModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import layout.TableLayout;

public class TraceViewStatusbar
extends JPanel {
    private final TraceViewModel traceViewModel;
    private final JLabel filteringLabel;
    private final JLabel timeLabel;
    private final JLabel amplitudeLabel;
    private static final int SHORT_LABELS = 550;
    private static final Border border = new CompoundBorder(new LineBorder(ThemeManager.getInstance().getTheme().getUIBorderColor(), 2), new EmptyBorder(1, 1, 2, 2));

    public TraceViewStatusbar(TraceViewModel traceViewModel) {
        this.traceViewModel = traceViewModel;
        double[][] dArrayArray = new double[][]{{-1.0, -1.0, -1.0}, {-3.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
        this.filteringLabel = new JLabel("");
        this.filteringLabel.setBorder(border);
        this.add((Component)this.filteringLabel, "0,0");
        this.timeLabel = new JLabel();
        this.clearTimeLabel();
        this.timeLabel.setBorder(border);
        this.timeLabel.setMinimumSize(new Dimension(300, 2));
        this.timeLabel.setPreferredSize(new Dimension(300, 2));
        this.add((Component)this.timeLabel, "1,0");
        this.amplitudeLabel = new JLabel();
        this.clearAmplitudeLabel();
        this.amplitudeLabel.setBorder(border);
        this.amplitudeLabel.setMinimumSize(new Dimension(300, 2));
        this.amplitudeLabel.setPreferredSize(new Dimension(300, 2));
        this.add((Component)this.amplitudeLabel, "2,0");
        this.update();
    }

    public void updateFilter() {
        TraceViewState.FilterType filterType = this.traceViewModel.getFilter();
        float[][] fArray = SonoViewManager.getInstance().getSettingsManager().getUserConfiguration().getFilterBands();
        boolean bl = false;
        float f = 0.0f;
        float f2 = 0.0f;
        switch (filterType) {
            case NONE: {
                bl = true;
                break;
            }
            case FIRST: {
                f = fArray[0][0];
                f2 = fArray[1][0];
                break;
            }
            case SECOND: {
                f = fArray[0][1];
                f2 = fArray[1][1];
                break;
            }
            case THIRD: {
                f = fArray[0][2];
                f2 = fArray[1][2];
                break;
            }
            case FOURTH: {
                f = fArray[0][3];
                f2 = fArray[1][3];
                break;
            }
            case FIFTH: {
                f = fArray[0][4];
                f2 = fArray[1][4];
            }
        }
        String string = this.getWidth() > 550 ? "Filter: " : "F:";
        if (bl || f2 == 0.0f && f == 0.0f) {
            this.filteringLabel.setText(string + "None");
        } else if (f <= 0.0f) {
            this.filteringLabel.setText(string + "LP <" + f2 + "Hz");
        } else if (f2 <= 0.0f) {
            this.filteringLabel.setText(string + "HP >" + f + "Hz");
        } else {
            this.filteringLabel.setText(string + f + "Hz - " + f2 + "Hz");
        }
    }

    public void update() {
        this.updateFilter();
    }

    public void clearTimeLabel() {
        this.timeLabel.setText("");
    }

    public void clearAmplitudeLabel() {
        this.timeLabel.setText("");
    }

    public void updateTimeLabel(long l) {
        if (this.getWidth() > 550) {
            this.timeLabel.setText(DateTimeUtil.formatDateTimeISOHighPrecision((long)l));
        } else {
            this.timeLabel.setText(DateTimeUtil.formatTimeHighPrecision((long)l));
        }
    }

    public void updateAmplitudeLabel(float f) {
        SiPrefixedValue siPrefixedValue = new SiPrefixedValue((Number)Float.valueOf(f * 1.0E-9f));
        this.amplitudeLabel.setText(String.format("%5.2f", Float.valueOf(siPrefixedValue.getPrefixedValue())) + siPrefixedValue.getPrefix() + "m/s");
    }
}

