/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.detection;

import edu.geophys.commons.detection.AbstractDetection;
import edu.geophys.commons.detection.interfaces.HasLineMarker;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.PlatformUtil;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;

public class TimestringDetection
extends AbstractDetection
implements HasLineMarker {
    private static final String REGEXP_COMMENT = "#";
    private static final String REGEXP_SEPARATOR = "[,\\t]";
    private static final Color COLOR = Color.decode("#9b15a4");
    private final long timeMs;
    private final String comment;

    public TimestringDetection(long l, String string, File file) {
        this.comment = string;
        this.timeMs = l;
        this.setSource(file);
    }

    @Override
    public long getIndexTimeMs() {
        return this.timeMs;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getLabel() {
        try {
            if (this.comment.isEmpty()) {
                return "from .." + PlatformUtil.getSeparator() + this.getSource().getParentFile().getName() + PlatformUtil.getSeparator() + this.getSource().getName();
            }
            return this.comment;
        }
        catch (Exception exception) {
            LogUtil.warn(this.getClass(), "could not create label for " + this);
            return "*";
        }
    }

    public static ArrayList<TimestringDetection> readFromFile(File file) {
        ArrayList<TimestringDetection> arrayList = new ArrayList<TimestringDetection>();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                long l;
                ++n;
                if (string.matches(REGEXP_COMMENT)) continue;
                String[] stringArray = string.split(REGEXP_SEPARATOR, 2);
                try {
                    l = DateTimeUtil.parseDateTime(stringArray[0]).getTimeInMillis();
                }
                catch (Exception exception) {
                    LogUtil.error(TimestringDetection.class, "Invalid date " + stringArray[0] + " in " + file.getAbsolutePath() + ":" + n);
                    continue;
                }
                String string2 = stringArray.length > 1 ? stringArray[1].trim() : "";
                TimestringDetection timestringDetection = new TimestringDetection(l, string2, file);
                arrayList.add(timestringDetection);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            LogUtil.error(TimestringDetection.class, exception.toString());
            return null;
        }
        return arrayList;
    }

    @Override
    public Color getColor() {
        return COLOR;
    }

    @Override
    public long getStartTimeMs() {
        return this.timeMs;
    }

    @Override
    public long getDurationMs() {
        return 0L;
    }

    @Override
    public long getEndTimeMs() {
        return this.getStartTimeMs() + this.getDurationMs();
    }

    @Override
    public long getLineMs() {
        return this.timeMs;
    }
}

