/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.headerfiles;

import edu.geophys.commons.model.headerfiles.AbstractHeaderReader;
import edu.geophys.commons.model.tracefiles.AbstractTraceFile;
import edu.geophys.commons.util.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;

public class HardcodedHeaderRepository {
    public static List<AbstractTraceFile> loadHeader(File file) throws FileNotFoundException {
        List<AbstractTraceFile> list;
        String string = null;
        try {
            String string2;
            list = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader((Reader)((Object)list));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split(":");
                if (!stringArray[0].matches("static_header")) continue;
                string = stringArray[1];
                break;
            }
            bufferedReader.close();
            ((InputStreamReader)((Object)list)).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (string.toLowerCase().matches("basel_demo")) {
            list = HardcodedHeaderRepository.generateBaselDemoEntries(file);
        } else if (string.toLowerCase().matches("grsn_demo")) {
            list = HardcodedHeaderRepository.generateGrsnDemoEntries(file);
        } else if (string.toLowerCase().matches("dgmk20161218")) {
            list = HardcodedHeaderRepository.generateDgmk20161218Entries(file);
        } else if (string.toLowerCase().matches("dgmk20170204")) {
            list = HardcodedHeaderRepository.generateDgmk20170204Entries(file);
        } else {
            LogUtil.error(HardcodedHeaderRepository.class, "Static dataset <" + string + "> is unknown to this version of SeisServ.", true);
            return null;
        }
        if (list.contains(null)) {
            LogUtil.error(HardcodedHeaderRepository.class, "Files referenced by dataset <" + string + "> not found on System.", true);
            return null;
        }
        return list;
    }

    private static final AbstractTraceFile entry(File file, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        try {
            return AbstractHeaderReader.createEntryChecked(file, string2, string3, string, string4, string5, string6, string7, string8, string9, string10, string11);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static List<AbstractTraceFile> generateBaselEntries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1165431600.00500", "BALST", "HHE", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHE.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00500", "BALST", "HHE", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHE.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00500", "BALST", "HHE", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHE.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00500", "BALST", "HHE", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHE.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00500", "BALST", "HHE", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHE.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00500", "BALST", "HHN", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHN.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00500", "BALST", "HHN", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHN.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00500", "BALST", "HHN", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHN.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00500", "BALST", "HHN", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHN.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00500", "BALST", "HHN", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHN.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00500", "BALST", "HHZ", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHZ.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00500", "BALST", "HHZ", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHZ.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00500", "BALST", "HHZ", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHZ.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00500", "BALST", "HHZ", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHZ.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00500", "BALST", "HHZ", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061206", "CH.BALST..HHZ.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00800", "OTER1", "EHA", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHA.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00800", "OTER1", "EHA", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHA.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00800", "OTER1", "EHA", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHA.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00800", "OTER1", "EHA", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHA.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00800", "OTER1", "EHA", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHA.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00000", "OTER1", "EHB", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHB.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00000", "OTER1", "EHB", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHB.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00000", "OTER1", "EHB", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHB.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00000", "OTER1", "EHB", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHB.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00000", "OTER1", "EHB", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHB.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00800", "OTER1", "EHC", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHC.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00800", "OTER1", "EHC", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHC.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00800", "OTER1", "EHC", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHC.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00800", "OTER1", "EHC", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHC.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00800", "OTER1", "EHC", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061206", "CH.OTER1..EHC.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00000", "S2C", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SE.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00000", "S2C", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SE.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00000", "S2C", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SE.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00000", "S2C", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SE.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00000", "S2C", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SE.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00000", "S2C", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SN.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00000", "S2C", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SN.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00000", "S2C", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SN.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00000", "S2C", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SN.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00000", "S2C", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SN.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00000", "S2C", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SZ.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00000", "S2C", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SZ.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00000", "S2C", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SZ.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00000", "S2C", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SZ.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00000", "S2C", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2C..SZ.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00000", "S2E", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2E..SZ.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00000", "S2E", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2E..SZ.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00000", "S2E", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2E..SZ.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00000", "S2E", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2E..SZ.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00000", "S2E", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2E..SZ.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00000", "S2N", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2N..SZ.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00000", "S2N", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2N..SZ.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00000", "S2N", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2N..SZ.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00000", "S2N", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2N..SZ.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00000", "S2N", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2N..SZ.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00000", "S2W", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2W..SZ.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00000", "S2W", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2W..SZ.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00000", "S2W", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2W..SZ.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00000", "S2W", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2W..SZ.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00000", "S2W", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.S2W..SZ.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00000", "SNC", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SE.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00000", "SNC", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SE.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00000", "SNC", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SE.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00000", "SNC", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SE.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00000", "SNC", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SE.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00000", "SNC", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SN.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00000", "SNC", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SN.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00000", "SNC", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SN.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00000", "SNC", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SN.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00000", "SNC", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SN.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00000", "SNC", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SZ.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00000", "SNC", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SZ.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00000", "SNC", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SZ.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00000", "SNC", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SZ.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00000", "SNC", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNC..SZ.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00000", "SNE", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNE..SZ.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00000", "SNE", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNE..SZ.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00000", "SNE", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNE..SZ.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00000", "SNE", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNE..SZ.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00000", "SNE", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNE..SZ.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00000", "SNN", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNN..SZ.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00000", "SNN", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNN..SZ.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00000", "SNN", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNN..SZ.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00000", "SNN", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNN..SZ.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00000", "SNN", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNN..SZ.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165431600.00000", "SNW", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNW..SZ.20061206T1900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165435200.00000", "SNW", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNW..SZ.20061206T2000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165438800.00000", "SNW", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNW..SZ.20061206T2100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165442400.00000", "SNW", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNW..SZ.20061206T2200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165446000.00000", "SNW", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061206", "ST.SNW..SZ.20061206T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00500", "BALST", "HHE", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061207", "CH.BALST..HHE.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00500", "BALST", "HHE", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061207", "CH.BALST..HHE.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00500", "BALST", "HHE", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061207", "CH.BALST..HHE.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00500", "BALST", "HHN", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061207", "CH.BALST..HHN.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00500", "BALST", "HHN", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061207", "CH.BALST..HHN.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00500", "BALST", "HHN", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061207", "CH.BALST..HHN.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00500", "BALST", "HHZ", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061207", "CH.BALST..HHZ.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00500", "BALST", "HHZ", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061207", "CH.BALST..HHZ.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00500", "BALST", "HHZ", "432000", "120.00", "0.253587", "1.00000", "m42", "./data/20061207", "CH.BALST..HHZ.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "OTER1", "EHA", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061207", "CH.OTER1..EHA.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "OTER1", "EHA", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061207", "CH.OTER1..EHA.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "OTER1", "EHA", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061207", "CH.OTER1..EHA.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "OTER1", "EHB", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061207", "CH.OTER1..EHB.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "OTER1", "EHB", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061207", "CH.OTER1..EHB.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "OTER1", "EHB", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061207", "CH.OTER1..EHB.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00800", "OTER1", "EHC", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061207", "CH.OTER1..EHC.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00800", "OTER1", "EHC", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061207", "CH.OTER1..EHC.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00800", "OTER1", "EHC", "432000", "120.00", "0.70462", "1.00000", "m42", "./data/20061207", "CH.OTER1..EHC.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "S2C", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2C..SE.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "S2C", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2C..SE.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "S2C", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2C..SE.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "S2C", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2C..SN.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "S2C", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2C..SN.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "S2C", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2C..SN.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "S2C", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2C..SZ.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "S2C", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2C..SZ.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "S2C", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2C..SZ.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "S2E", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2E..SZ.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "S2E", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2E..SZ.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "S2E", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2E..SZ.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "S2N", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2N..SZ.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "S2N", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2N..SZ.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "S2N", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2N..SZ.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "S2W", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2W..SZ.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "S2W", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2W..SZ.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "S2W", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.S2W..SZ.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "SNC", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNC..SE.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "SNC", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNC..SE.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "SNC", "SE", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNC..SE.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "SNC", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNC..SN.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "SNC", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNC..SN.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "SNC", "SN", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNC..SN.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "SNC", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNC..SZ.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "SNC", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNC..SZ.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "SNC", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNC..SZ.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "SNE", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNE..SZ.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "SNE", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNE..SZ.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "SNE", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNE..SZ.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "SNN", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNN..SZ.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "SNN", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNN..SZ.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "SNN", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNN..SZ.20061207T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165449600.00000", "SNW", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNW..SZ.20061207T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165453200.00000", "SNW", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNW..SZ.20061207T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165456800.00000", "SNW", "SZ", "1440000", "400.00", "0.00185", "1.00000", "m42", "./data/20061207", "ST.SNW..SZ.20061207T0200.mseed", "0"));
    }

    private static List<AbstractTraceFile> generateGrsnEntries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1457409600.00840", "BFO", "HHE", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHE.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00840", "BFO", "HHE", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHE.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00840", "BFO", "HHE", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHE.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00840", "BFO", "HHE", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHE.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00840", "BFO", "HHE", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHE.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00840", "BFO", "HHE", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHE.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00840", "BFO", "HHE", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHE.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00840", "BFO", "HHE", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHE.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00840", "BFO", "HHN", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHN.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00840", "BFO", "HHN", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHN.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00840", "BFO", "HHN", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHN.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00840", "BFO", "HHN", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHN.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00840", "BFO", "HHN", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHN.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00840", "BFO", "HHN", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHN.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00840", "BFO", "HHN", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHN.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00840", "BFO", "HHN", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHN.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00840", "BFO", "HHZ", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHZ.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00840", "BFO", "HHZ", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHZ.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00840", "BFO", "HHZ", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHZ.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00840", "BFO", "HHZ", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHZ.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00840", "BFO", "HHZ", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHZ.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00840", "BFO", "HHZ", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHZ.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00840", "BFO", "HHZ", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHZ.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00840", "BFO", "HHZ", "360000", "100.00", "0.0632323", "1.00000", "m42", "./data/20160308", "GR.BFO..HHZ.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "CLL", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHE.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "CLL", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHE.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "CLL", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHE.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "CLL", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHE.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "CLL", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHE.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "CLL", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHE.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "CLL", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHE.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "CLL", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHE.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "CLL", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHN.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "CLL", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHN.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "CLL", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHN.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "CLL", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHN.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "CLL", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHN.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "CLL", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHN.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "CLL", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHN.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "CLL", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHN.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "CLL", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHZ.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "CLL", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHZ.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "CLL", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHZ.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "CLL", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHZ.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "CLL", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHZ.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "CLL", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHZ.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "CLL", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHZ.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "CLL", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLL..HHZ.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "CLZ", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHE.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "CLZ", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHE.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "CLZ", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHE.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "CLZ", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHE.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "CLZ", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHE.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "CLZ", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHE.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "CLZ", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHE.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "CLZ", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHE.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "CLZ", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHN.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "CLZ", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHN.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "CLZ", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHN.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "CLZ", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHN.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "CLZ", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHN.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "CLZ", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHN.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "CLZ", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHN.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "CLZ", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHN.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "CLZ", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHZ.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "CLZ", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHZ.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "CLZ", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHZ.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "CLZ", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHZ.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "CLZ", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHZ.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "CLZ", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHZ.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "CLZ", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHZ.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "CLZ", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.CLZ..HHZ.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "GRA1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHE.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "GRA1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHE.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "GRA1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHE.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "GRA1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHE.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "GRA1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHE.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "GRA1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHE.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "GRA1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHE.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "GRA1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHE.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "GRA1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHN.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "GRA1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHN.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "GRA1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHN.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "GRA1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHN.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "GRA1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHN.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "GRA1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHN.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "GRA1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHN.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "GRA1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHN.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "GRA1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHZ.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "GRA1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHZ.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "GRA1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHZ.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "GRA1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHZ.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "GRA1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHZ.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "GRA1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHZ.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "GRA1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHZ.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "GRA1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRA1..HHZ.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "GRB1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHE.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "GRB1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHE.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "GRB1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHE.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "GRB1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHE.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "GRB1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHE.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "GRB1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHE.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "GRB1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHE.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "GRB1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHE.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "GRB1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHN.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "GRB1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHN.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "GRB1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHN.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "GRB1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHN.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "GRB1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHN.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "GRB1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHN.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "GRB1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHN.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "GRB1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHN.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "GRB1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHZ.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "GRB1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHZ.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "GRB1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHZ.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "GRB1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHZ.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "GRB1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHZ.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "GRB1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHZ.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "GRB1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHZ.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "GRB1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRB1..HHZ.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "GRC1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHE.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "GRC1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHE.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "GRC1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHE.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "GRC1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHE.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "GRC1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHE.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "GRC1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHE.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "GRC1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHE.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "GRC1", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHE.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "GRC1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHN.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "GRC1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHN.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "GRC1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHN.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "GRC1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHN.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "GRC1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHN.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "GRC1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHN.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "GRC1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHN.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "GRC1", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHN.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "GRC1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHZ.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "GRC1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHZ.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "GRC1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHZ.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "GRC1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHZ.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "GRC1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHZ.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "GRC1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHZ.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "GRC1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHZ.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "GRC1", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.GRC1..HHZ.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00840", "MOX", "HHE", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHE.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00840", "MOX", "HHE", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHE.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00840", "MOX", "HHE", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHE.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00840", "MOX", "HHE", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHE.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00840", "MOX", "HHE", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHE.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00840", "MOX", "HHE", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHE.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00840", "MOX", "HHE", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHE.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00840", "MOX", "HHE", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHE.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00840", "MOX", "HHN", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHN.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00840", "MOX", "HHN", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHN.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00840", "MOX", "HHN", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHN.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00840", "MOX", "HHN", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHN.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00840", "MOX", "HHN", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHN.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00840", "MOX", "HHN", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHN.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00840", "MOX", "HHN", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHN.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00840", "MOX", "HHN", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHN.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00840", "MOX", "HHZ", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHZ.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00840", "MOX", "HHZ", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHZ.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00840", "MOX", "HHZ", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHZ.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00840", "MOX", "HHZ", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHZ.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00840", "MOX", "HHZ", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHZ.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00840", "MOX", "HHZ", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHZ.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00840", "MOX", "HHZ", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHZ.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00840", "MOX", "HHZ", "360000", "100.00", "0.063237", "1.00000", "m42", "./data/20160308", "GR.MOX..HHZ.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "TNS", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHE.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "TNS", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHE.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "TNS", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHE.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "TNS", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHE.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "TNS", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHE.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "TNS", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHE.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "TNS", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHE.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "TNS", "HHE", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHE.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "TNS", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHN.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "TNS", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHN.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "TNS", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHN.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "TNS", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHN.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "TNS", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHN.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "TNS", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHN.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "TNS", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHN.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "TNS", "HHN", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHN.20160308T1100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457409600.00500", "TNS", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHZ.20160308T0400.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457413200.00500", "TNS", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHZ.20160308T0500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457416800.00500", "TNS", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHZ.20160308T0600.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457420400.00500", "TNS", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHZ.20160308T0700.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457424000.00500", "TNS", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHZ.20160308T0800.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457427600.00500", "TNS", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHZ.20160308T0900.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457431200.00500", "TNS", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHZ.20160308T1000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1457434800.00500", "TNS", "HHZ", "360000", "100.00", "0.168593", "1.00000", "m42", "./data/20160308", "GR.TNS..HHZ.20160308T1100.mseed", "0"));
    }

    private static List<AbstractTraceFile> generateIfe20141112_1330Entries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ01C", "she", "900000", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..she_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ01C", "shn", "900000", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..shn_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ01C", "shz", "900000", "500.000000", "0.019954", "1.000000", "m42", "./data", "IF.SJ01C..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ01E", "shz", "900000", "500.000000", "0.019906", "1.000000", "m42", "./data", "IF.SJ01E..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ01N", "shz", "900000", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ01N..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ01W", "shz", "900000", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ01W..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ11C", "she", "807970", "500.000000", "0.019687", "1.000000", "m42", "./data", "IF.SJ11C..she_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415800615.940000", "SJ11C", "she", "92031", "500.000000", "0.019687", "1.000000", "m42", "./data", "IF.SJ11C..she_20141112_135655.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ11C", "shn", "807970", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ11C..shn_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415800615.940000", "SJ11C", "shn", "92031", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ11C..shn_20141112_135655.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ11C", "shz", "807970", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ11C..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415800615.940000", "SJ11C", "shz", "92031", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ11C..shz_20141112_135655.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ11E", "shz", "807970", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11E..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415800615.940000", "SJ11E", "shz", "92031", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11E..shz_20141112_135655.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ11N", "shz", "807970", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11N..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415800615.940000", "SJ11N", "shz", "92031", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11N..shz_20141112_135655.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ11W", "shz", "807970", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ11W..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415800615.940000", "SJ11W", "shz", "92031", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ11W..shz_20141112_135655.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ12C", "she", "900000", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ12C..she_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ12C", "shn", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shn_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ12C", "shz", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ12E", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12E..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ12N", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12N..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ12W", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12W..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ22C", "she", "242970", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ22C..she_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799485.940000", "SJ22C", "she", "657031", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ22C..she_20141112_133805.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ22C", "shn", "242970", "500.000000", "0.019656", "1.000000", "m42", "./data", "IF.SJ22C..shn_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799485.940000", "SJ22C", "shn", "657031", "500.000000", "0.019656", "1.000000", "m42", "./data", "IF.SJ22C..shn_20141112_133805.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ22C", "shz", "242970", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ22C..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799485.940000", "SJ22C", "shz", "657031", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ22C..shz_20141112_133805.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ31C", "she", "738409", "500.000000", "0.631447", "1.000000", "m42", "./data", "IF.SJ31C..she_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415800476.818000", "SJ31C", "she", "161592", "500.000000", "0.631447", "1.000000", "m42", "./data", "IF.SJ31C..she_20141112_135436.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ31C", "shn", "738409", "500.000000", "0.631049", "1.000000", "m42", "./data", "IF.SJ31C..shn_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415800476.818000", "SJ31C", "shn", "161592", "500.000000", "0.631049", "1.000000", "m42", "./data", "IF.SJ31C..shn_20141112_135436.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ31C", "shz", "738409", "500.000000", "0.631845", "1.000000", "m42", "./data", "IF.SJ31C..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415800476.818000", "SJ31C", "shz", "161592", "500.000000", "0.631845", "1.000000", "m42", "./data", "IF.SJ31C..shz_20141112_135436.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ31E", "shz", "738409", "500.000000", "0.631049", "1.000000", "m42", "./data", "IF.SJ31E..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415800476.818000", "SJ31E", "shz", "161592", "500.000000", "0.631049", "1.000000", "m42", "./data", "IF.SJ31E..shz_20141112_135436.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ31N", "shz", "738409", "500.000000", "0.631049", "1.000000", "m42", "./data", "IF.SJ31N..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415800476.818000", "SJ31N", "shz", "161592", "500.000000", "0.631049", "1.000000", "m42", "./data", "IF.SJ31N..shz_20141112_135436.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415799000.000000", "SJ31W", "shz", "738409", "500.000000", "0.631049", "1.000000", "m42", "./data", "IF.SJ31W..shz_20141112_133000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1415800476.818000", "SJ31W", "shz", "161592", "500.000000", "0.631049", "1.000000", "m42", "./data", "IF.SJ31W..shz_20141112_135436.mseed", "0"));
    }

    private static List<AbstractTraceFile> generateIfe20141116_1400Entries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ01C", "she", "900001", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..she_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ01C", "shn", "900001", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..shn_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ01C", "shz", "900001", "500.000000", "0.019954", "1.000000", "m42", "./data", "IF.SJ01C..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ01E", "shz", "900001", "500.000000", "0.019906", "1.000000", "m42", "./data", "IF.SJ01E..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ01N", "shz", "900001", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ01N..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ01W", "shz", "900001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ01W..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ02C", "she", "289634", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02C..she_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146979.268000", "SJ02C", "she", "610367", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02C..she_20141116_140939.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ02C", "shn", "289634", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shn_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146979.268000", "SJ02C", "shn", "610367", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shn_20141116_140939.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ02C", "shz", "289634", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146979.268000", "SJ02C", "shz", "610367", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shz_20141116_140939.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ02E", "shz", "289634", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ02E..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146979.268000", "SJ02E", "shz", "610367", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ02E..shz_20141116_140939.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ02N", "shz", "289634", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ02N..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146979.268000", "SJ02N", "shz", "610367", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ02N..shz_20141116_140939.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ02W", "shz", "289634", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02W..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146979.268000", "SJ02W", "shz", "610367", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02W..shz_20141116_140939.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ03C", "she", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ03C..she_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ03C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ03C..shn_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ03C", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ03C..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ03E", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03E..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ03N", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03N..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ03W", "shz", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ03W..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ04C", "she", "900001", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ04C..she_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ04C", "shn", "900001", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ04C..shn_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ04C", "shz", "900001", "500.000000", "0.019699", "1.000000", "m42", "./data", "IF.SJ04C..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ04E", "shz", "900001", "500.000000", "0.019715", "1.000000", "m42", "./data", "IF.SJ04E..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ04N", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ04N..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ04W", "shz", "900001", "500.000000", "0.019727", "1.000000", "m42", "./data", "IF.SJ04W..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ05C", "she", "900001", "500.000000", "0.019978", "1.000000", "m42", "./data", "IF.SJ05C..she_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ05C", "shn", "900001", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ05C..shn_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ05C", "shz", "900001", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ05C..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ05E", "shz", "900001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ05E..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ05N", "shz", "900001", "500.000000", "0.019950", "1.000000", "m42", "./data", "IF.SJ05N..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ05W", "shz", "900001", "500.000000", "0.019942", "1.000000", "m42", "./data", "IF.SJ05W..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ11C", "she", "595470", "500.000000", "0.019687", "1.000000", "m42", "./data", "IF.SJ11C..she_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416147590.940000", "SJ11C", "she", "304531", "500.000000", "0.019687", "1.000000", "m42", "./data", "IF.SJ11C..she_20141116_141950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ11C", "shn", "595470", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ11C..shn_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416147590.940000", "SJ11C", "shn", "304531", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ11C..shn_20141116_141950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ11C", "shz", "595470", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ11C..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416147590.940000", "SJ11C", "shz", "304531", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ11C..shz_20141116_141950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ11E", "shz", "595470", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11E..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416147590.940000", "SJ11E", "shz", "304531", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11E..shz_20141116_141950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ11N", "shz", "595470", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11N..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416147590.940000", "SJ11N", "shz", "304531", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11N..shz_20141116_141950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ11W", "shz", "595470", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ11W..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416147590.940000", "SJ11W", "shz", "304531", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ11W..shz_20141116_141950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ12C", "she", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ12C..she_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ12C", "shn", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shn_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ12C", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ12E", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12E..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ12N", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12N..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ12W", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12W..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ13C", "she", "900001", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ13C..she_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ13C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ13C..shn_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ13C", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13C..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ13E", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13E..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ13N", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13N..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ13W", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13W..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ14C", "she", "1634413", "1000.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ14C..she_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416148034.413000", "SJ14C", "she", "165588", "1000.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ14C..she_20141116_142714.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ14C", "shn", "1634413", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14C..shn_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416148034.413000", "SJ14C", "shn", "165588", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14C..shn_20141116_142714.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ14C", "shz", "1634413", "1000.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ14C..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416148034.413000", "SJ14C", "shz", "165588", "1000.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ14C..shz_20141116_142714.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ14E", "shz", "1634413", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14E..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416148034.413000", "SJ14E", "shz", "165588", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14E..shz_20141116_142714.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ14N", "shz", "1634413", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14N..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416148034.413000", "SJ14N", "shz", "165588", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14N..shz_20141116_142714.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ14W", "shz", "1634413", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14W..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416148034.413000", "SJ14W", "shz", "165588", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14W..shz_20141116_142714.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ20C", "she", "900001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..she_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ20C", "shn", "900001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..shn_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ20C", "shz", "900001", "500.000000", "0.019910", "1.000000", "m42", "./data", "IF.SJ20C..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ20E", "shz", "900001", "500.000000", "0.019922", "1.000000", "m42", "./data", "IF.SJ20E..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ20N", "shz", "900001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20N..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ20W", "shz", "900001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20W..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ21C", "she", "270691", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ21C..she_20141116_135959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146941.382000", "SJ21C", "she", "629310", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ21C..she_20141116_140901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ21C", "shn", "270691", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21C..shn_20141116_135959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146941.382000", "SJ21C", "shn", "629310", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21C..shn_20141116_140901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ21C", "shz", "270691", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21C..shz_20141116_135959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146941.382000", "SJ21C", "shz", "629310", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21C..shz_20141116_140901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ21E", "shz", "270691", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21E..shz_20141116_135959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146941.382000", "SJ21E", "shz", "629310", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21E..shz_20141116_140901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ21N", "shz", "270691", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21N..shz_20141116_135959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146941.382000", "SJ21N", "shz", "629310", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21N..shz_20141116_140901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ21W", "shz", "270691", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21W..shz_20141116_135959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146941.382000", "SJ21W", "shz", "629310", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21W..shz_20141116_140901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ22C", "she", "900001", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ22C..she_20141116_135959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ22C", "shn", "900001", "500.000000", "0.019656", "1.000000", "m42", "./data", "IF.SJ22C..shn_20141116_135959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ22C", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ22C..shz_20141116_135959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ31C", "she", "276938", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ31C..she_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146953.876000", "SJ31C", "she", "623063", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ31C..she_20141116_140913.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ31C", "shn", "276938", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ31C..shn_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146953.876000", "SJ31C", "shn", "623063", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ31C..shn_20141116_140913.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ31C", "shz", "276938", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ31C..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146953.876000", "SJ31C", "shz", "623063", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ31C..shz_20141116_140913.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ31E", "shz", "276938", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31E..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146953.876000", "SJ31E", "shz", "623063", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31E..shz_20141116_140913.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ31N", "shz", "276938", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ31N..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146953.876000", "SJ31N", "shz", "623063", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ31N..shz_20141116_140913.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ31W", "shz", "276938", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31W..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146953.876000", "SJ31W", "shz", "623063", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31W..shz_20141116_140913.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ32C", "she", "358970", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ32C..she_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416147117.940000", "SJ32C", "she", "541031", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ32C..she_20141116_141157.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ32C", "shn", "358970", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ32C..shn_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416147117.940000", "SJ32C", "shn", "541031", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ32C..shn_20141116_141157.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ32C", "shz", "358970", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ32C..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416147117.940000", "SJ32C", "shz", "541031", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ32C..shz_20141116_141157.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ32E", "shz", "358970", "500.000000", "0.019640", "1.000000", "m42", "./data", "IF.SJ32E..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416147117.940000", "SJ32E", "shz", "541031", "500.000000", "0.019640", "1.000000", "m42", "./data", "IF.SJ32E..shz_20141116_141157.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ32N", "shz", "358970", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32N..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416147117.940000", "SJ32N", "shz", "541031", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32N..shz_20141116_141157.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416146400.000000", "SJ32W", "shz", "358970", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32W..shz_20141116_140000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416147117.940000", "SJ32W", "shz", "541031", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32W..shz_20141116_141157.mseed", "0"));
    }

    private static List<AbstractTraceFile> generateIfe20141115_0230Entries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ01C", "she", "900000", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..she_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ01C", "shn", "900000", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..shn_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ01C", "shz", "900000", "500.000000", "0.019954", "1.000000", "m42", "./data", "IF.SJ01C..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ01E", "shz", "900000", "500.000000", "0.019906", "1.000000", "m42", "./data", "IF.SJ01E..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ01N", "shz", "900000", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ01N..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ01W", "shz", "900000", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ01W..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ02C", "she", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02C..she_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ02C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shn_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ02C", "shz", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ02E", "shz", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ02E..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ02N", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ02N..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ02W", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02W..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ11C", "she", "140470", "500.000000", "0.019687", "1.000000", "m42", "./data", "IF.SJ11C..she_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018880.940000", "SJ11C", "she", "759531", "500.000000", "0.019687", "1.000000", "m42", "./data", "IF.SJ11C..she_20141115_023440.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ11C", "shn", "140470", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ11C..shn_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018880.940000", "SJ11C", "shn", "759531", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ11C..shn_20141115_023440.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ11C", "shz", "140470", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ11C..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018880.940000", "SJ11C", "shz", "759531", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ11C..shz_20141115_023440.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ11E", "shz", "140470", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11E..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018880.940000", "SJ11E", "shz", "759531", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11E..shz_20141115_023440.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ11N", "shz", "140470", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11N..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018880.940000", "SJ11N", "shz", "759531", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11N..shz_20141115_023440.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ11W", "shz", "140470", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ11W..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018880.940000", "SJ11W", "shz", "759531", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ11W..shz_20141115_023440.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ12C", "she", "900000", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ12C..she_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ12C", "shn", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shn_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ12C", "shz", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ12E", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12E..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ12N", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12N..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ12W", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12W..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ13C", "she", "900000", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ13C..she_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ13C", "shn", "900000", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ13C..shn_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ13C", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13C..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ13E", "shz", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13E..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ13N", "shz", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13N..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ13W", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13W..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ21C", "she", "646470", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ21C..she_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416019892.940000", "SJ21C", "she", "253531", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ21C..she_20141115_025132.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ21C", "shn", "646470", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21C..shn_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416019892.940000", "SJ21C", "shn", "253531", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21C..shn_20141115_025132.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ21C", "shz", "646470", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21C..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416019892.940000", "SJ21C", "shz", "253531", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21C..shz_20141115_025132.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ21E", "shz", "646470", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21E..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416019892.940000", "SJ21E", "shz", "253531", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21E..shz_20141115_025132.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ21N", "shz", "646470", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21N..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416019892.940000", "SJ21N", "shz", "253531", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21N..shz_20141115_025132.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ21W", "shz", "646470", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21W..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416019892.940000", "SJ21W", "shz", "253531", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21W..shz_20141115_025132.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ22C", "she", "41435", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ22C..she_20141115_022959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018682.870000", "SJ22C", "she", "858566", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ22C..she_20141115_023122.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ22C", "shn", "41435", "500.000000", "0.019656", "1.000000", "m42", "./data", "IF.SJ22C..shn_20141115_022959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018682.870000", "SJ22C", "shn", "858566", "500.000000", "0.019656", "1.000000", "m42", "./data", "IF.SJ22C..shn_20141115_023122.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ22C", "shz", "41435", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ22C..shz_20141115_022959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018682.870000", "SJ22C", "shz", "858566", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ22C..shz_20141115_023122.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ31C", "she", "111970", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ31C..she_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018823.940000", "SJ31C", "she", "788031", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ31C..she_20141115_023343.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ31C", "shn", "111970", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ31C..shn_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018823.940000", "SJ31C", "shn", "788031", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ31C..shn_20141115_023343.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ31C", "shz", "111970", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ31C..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018823.940000", "SJ31C", "shz", "788031", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ31C..shz_20141115_023343.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ31E", "shz", "111970", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31E..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018823.940000", "SJ31E", "shz", "788031", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31E..shz_20141115_023343.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ31N", "shz", "111970", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ31N..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018823.940000", "SJ31N", "shz", "788031", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ31N..shz_20141115_023343.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ31W", "shz", "111970", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31W..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018823.940000", "SJ31W", "shz", "788031", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31W..shz_20141115_023343.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ32C", "she", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ32C..she_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ32C", "shn", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ32C..shn_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ32C", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ32C..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ32E", "shz", "900001", "500.000000", "0.019640", "1.000000", "m42", "./data", "IF.SJ32E..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ32N", "shz", "900001", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32N..shz_20141115_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416018600.000000", "SJ32W", "shz", "900001", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32W..shz_20141115_023000.mseed", "0"));
    }

    private static List<AbstractTraceFile> generateIfe20141117_0230Entries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ01C", "she", "900000", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..she_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ01C", "shn", "900000", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..shn_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ01C", "shz", "900000", "500.000000", "0.019954", "1.000000", "m42", "./data", "IF.SJ01C..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ01E", "shz", "900000", "500.000000", "0.019906", "1.000000", "m42", "./data", "IF.SJ01E..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ01N", "shz", "900000", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ01N..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ01W", "shz", "900000", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ01W..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ02C", "she", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02C..she_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ02C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shn_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ02C", "shz", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ02E", "shz", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ02E..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ02N", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ02N..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ02W", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02W..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ03C", "she", "400970", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ03C..she_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416192201.940000", "SJ03C", "she", "499031", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ03C..she_20141117_024321.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ03C", "shn", "400970", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ03C..shn_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416192201.940000", "SJ03C", "shn", "499031", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ03C..shn_20141117_024321.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ03C", "shz", "400970", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ03C..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416192201.940000", "SJ03C", "shz", "499031", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ03C..shz_20141117_024321.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ03E", "shz", "400970", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03E..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416192201.940000", "SJ03E", "shz", "499031", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03E..shz_20141117_024321.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ03N", "shz", "400970", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03N..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416192201.940000", "SJ03N", "shz", "499031", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03N..shz_20141117_024321.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ03W", "shz", "400970", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ03W..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416192201.940000", "SJ03W", "shz", "499031", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ03W..shz_20141117_024321.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ04C", "she", "813970", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ04C..she_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416193027.940000", "SJ04C", "she", "86031", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ04C..she_20141117_025707.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ04C", "shn", "813970", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ04C..shn_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416193027.940000", "SJ04C", "shn", "86031", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ04C..shn_20141117_025707.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ04C", "shz", "813970", "500.000000", "0.019699", "1.000000", "m42", "./data", "IF.SJ04C..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416193027.940000", "SJ04C", "shz", "86031", "500.000000", "0.019699", "1.000000", "m42", "./data", "IF.SJ04C..shz_20141117_025707.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ04E", "shz", "813970", "500.000000", "0.019715", "1.000000", "m42", "./data", "IF.SJ04E..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416193027.940000", "SJ04E", "shz", "86031", "500.000000", "0.019715", "1.000000", "m42", "./data", "IF.SJ04E..shz_20141117_025707.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ04N", "shz", "813970", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ04N..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416193027.940000", "SJ04N", "shz", "86031", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ04N..shz_20141117_025707.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ04W", "shz", "813970", "500.000000", "0.019727", "1.000000", "m42", "./data", "IF.SJ04W..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416193027.940000", "SJ04W", "shz", "86031", "500.000000", "0.019727", "1.000000", "m42", "./data", "IF.SJ04W..shz_20141117_025707.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ05C", "she", "900000", "500.000000", "0.019978", "1.000000", "m42", "./data", "IF.SJ05C..she_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ05C", "shn", "900000", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ05C..shn_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ05C", "shz", "900000", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ05C..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ05E", "shz", "900000", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ05E..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ05N", "shz", "900000", "500.000000", "0.019950", "1.000000", "m42", "./data", "IF.SJ05N..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ05W", "shz", "900000", "500.000000", "0.019942", "1.000000", "m42", "./data", "IF.SJ05W..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ11C", "she", "900001", "500.000000", "0.019687", "1.000000", "m42", "./data", "IF.SJ11C..she_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ11C", "shn", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ11C..shn_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ11C", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ11C..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ11E", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11E..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ11N", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11N..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ11W", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ11W..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ12C", "she", "900000", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ12C..she_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ12C", "shn", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shn_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ12C", "shz", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ12E", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12E..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ12N", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12N..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ12W", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12W..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ13C", "she", "900000", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ13C..she_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ13C", "shn", "900000", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ13C..shn_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ13C", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13C..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ13E", "shz", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13E..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ13N", "shz", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13N..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ13W", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13W..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ14C", "she", "1800001", "1000.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ14C..she_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ14C", "shn", "1800001", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14C..shn_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ14C", "shz", "1800001", "1000.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ14C..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ14E", "shz", "1800001", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14E..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ14N", "shz", "1800001", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14N..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ14W", "shz", "1800001", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14W..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ20C", "she", "900000", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..she_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ20C", "shn", "900000", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..shn_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ20C", "shz", "900000", "500.000000", "0.019910", "1.000000", "m42", "./data", "IF.SJ20C..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ20E", "shz", "900000", "500.000000", "0.019922", "1.000000", "m42", "./data", "IF.SJ20E..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ20N", "shz", "900000", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20N..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ20W", "shz", "900000", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20W..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ21C", "she", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ21C..she_20141117_022959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ21C", "shn", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21C..shn_20141117_022959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ21C", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21C..shz_20141117_022959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ21E", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21E..shz_20141117_022959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ21N", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21N..shz_20141117_022959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ21W", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21W..shz_20141117_022959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ22C", "she", "41435", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ22C..she_20141117_022959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191482.870000", "SJ22C", "she", "858566", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ22C..she_20141117_023122.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ22C", "shn", "41435", "500.000000", "0.019656", "1.000000", "m42", "./data", "IF.SJ22C..shn_20141117_022959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191482.870000", "SJ22C", "shn", "858566", "500.000000", "0.019656", "1.000000", "m42", "./data", "IF.SJ22C..shn_20141117_023122.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ22C", "shz", "41435", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ22C..shz_20141117_022959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191482.870000", "SJ22C", "shz", "858566", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ22C..shz_20141117_023122.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ31C", "she", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ31C..she_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ31C", "shn", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ31C..shn_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ31C", "shz", "900001", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ31C..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ31E", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31E..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ31N", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ31N..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ31W", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31W..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ32C", "she", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ32C..she_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ32C", "shn", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ32C..shn_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ32C", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ32C..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ32E", "shz", "900001", "500.000000", "0.019640", "1.000000", "m42", "./data", "IF.SJ32E..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ32N", "shz", "900001", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32N..shz_20141117_023000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416191400.000000", "SJ32W", "shz", "900001", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32W..shz_20141117_023000.mseed", "0"));
    }

    private static List<AbstractTraceFile> generateIfe20141117_0715Entries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ01C", "she", "900001", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..she_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ01C", "shn", "900001", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..shn_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ01C", "shz", "900001", "500.000000", "0.019954", "1.000000", "m42", "./data", "IF.SJ01C..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ01E", "shz", "900001", "500.000000", "0.019906", "1.000000", "m42", "./data", "IF.SJ01E..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ01N", "shz", "900001", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ01N..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ01W", "shz", "900001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ01W..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ02C", "she", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02C..she_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ02C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shn_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ02C", "shz", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ02E", "shz", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ02E..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ02N", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ02N..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ02W", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02W..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ03C", "she", "850970", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ03C..she_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416210201.940000", "SJ03C", "she", "49031", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ03C..she_20141117_074321.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ03C", "shn", "850970", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ03C..shn_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416210201.940000", "SJ03C", "shn", "49031", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ03C..shn_20141117_074321.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ03C", "shz", "850970", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ03C..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416210201.940000", "SJ03C", "shz", "49031", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ03C..shz_20141117_074321.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ03E", "shz", "850970", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03E..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416210201.940000", "SJ03E", "shz", "49031", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03E..shz_20141117_074321.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ03N", "shz", "850970", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03N..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416210201.940000", "SJ03N", "shz", "49031", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03N..shz_20141117_074321.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ03W", "shz", "850970", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ03W..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416210201.940000", "SJ03W", "shz", "49031", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ03W..shz_20141117_074321.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ04C", "she", "900001", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ04C..she_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ04C", "shn", "900001", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ04C..shn_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ04C", "shz", "900001", "500.000000", "0.019699", "1.000000", "m42", "./data", "IF.SJ04C..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ04E", "shz", "900001", "500.000000", "0.019715", "1.000000", "m42", "./data", "IF.SJ04E..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ04N", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ04N..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ04W", "shz", "900001", "500.000000", "0.019727", "1.000000", "m42", "./data", "IF.SJ04W..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ05C", "she", "900001", "500.000000", "0.019978", "1.000000", "m42", "./data", "IF.SJ05C..she_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ05C", "shn", "900001", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ05C..shn_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ05C", "shz", "900001", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ05C..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ05E", "shz", "900001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ05E..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ05N", "shz", "900001", "500.000000", "0.019950", "1.000000", "m42", "./data", "IF.SJ05N..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ05W", "shz", "900001", "500.000000", "0.019942", "1.000000", "m42", "./data", "IF.SJ05W..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ11C", "she", "145470", "500.000000", "0.019687", "1.000000", "m42", "./data", "IF.SJ11C..she_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208790.940000", "SJ11C", "she", "754531", "500.000000", "0.019687", "1.000000", "m42", "./data", "IF.SJ11C..she_20141117_071950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ11C", "shn", "145470", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ11C..shn_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208790.940000", "SJ11C", "shn", "754531", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ11C..shn_20141117_071950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ11C", "shz", "145470", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ11C..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208790.940000", "SJ11C", "shz", "754531", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ11C..shz_20141117_071950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ11E", "shz", "145470", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11E..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208790.940000", "SJ11E", "shz", "754531", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11E..shz_20141117_071950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ11N", "shz", "145470", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11N..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208790.940000", "SJ11N", "shz", "754531", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11N..shz_20141117_071950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ11W", "shz", "145470", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ11W..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208790.940000", "SJ11W", "shz", "754531", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ11W..shz_20141117_071950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ12C", "she", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ12C..she_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ12C", "shn", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shn_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ12C", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ12E", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12E..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ12N", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12N..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ12W", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12W..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ13C", "she", "900001", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ13C..she_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ13C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ13C..shn_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ13C", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13C..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ13E", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13E..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ13N", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13N..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ13W", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13W..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ14C", "she", "734413", "1000.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ14C..she_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416209234.413000", "SJ14C", "she", "1065588", "1000.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ14C..she_20141117_072714.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ14C", "shn", "734413", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14C..shn_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416209234.413000", "SJ14C", "shn", "1065588", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14C..shn_20141117_072714.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ14C", "shz", "734413", "1000.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ14C..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416209234.413000", "SJ14C", "shz", "1065588", "1000.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ14C..shz_20141117_072714.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ14E", "shz", "734413", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14E..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416209234.413000", "SJ14E", "shz", "1065588", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14E..shz_20141117_072714.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ14N", "shz", "734413", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14N..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416209234.413000", "SJ14N", "shz", "1065588", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14N..shz_20141117_072714.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ14W", "shz", "734413", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14W..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416209234.413000", "SJ14W", "shz", "1065588", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14W..shz_20141117_072714.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ20C", "she", "900001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..she_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ20C", "shn", "900001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..shn_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ20C", "shz", "900001", "500.000000", "0.019910", "1.000000", "m42", "./data", "IF.SJ20C..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ20E", "shz", "900001", "500.000000", "0.019922", "1.000000", "m42", "./data", "IF.SJ20E..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ20N", "shz", "900001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20N..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ20W", "shz", "900001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20W..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ21C", "she", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ21C..she_20141117_071459.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ21C", "shn", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21C..shn_20141117_071459.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ21C", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21C..shz_20141117_071459.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ21E", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21E..shz_20141117_071459.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ21N", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21N..shz_20141117_071459.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ21W", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21W..shz_20141117_071459.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ22C", "she", "491435", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ22C..she_20141117_071459.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416209482.870000", "SJ22C", "she", "408566", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ22C..she_20141117_073122.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ22C", "shn", "491435", "500.000000", "0.019656", "1.000000", "m42", "./data", "IF.SJ22C..shn_20141117_071459.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416209482.870000", "SJ22C", "shn", "408566", "500.000000", "0.019656", "1.000000", "m42", "./data", "IF.SJ22C..shn_20141117_073122.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ22C", "shz", "491435", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ22C..shz_20141117_071459.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416209482.870000", "SJ22C", "shz", "408566", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ22C..shz_20141117_073122.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ31C", "she", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ31C..she_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ31C", "shn", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ31C..shn_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ31C", "shz", "900001", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ31C..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ31E", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31E..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ31N", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ31N..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ31W", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31W..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ32C", "she", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ32C..she_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ32C", "shn", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ32C..shn_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ32C", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ32C..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ32E", "shz", "900001", "500.000000", "0.019640", "1.000000", "m42", "./data", "IF.SJ32E..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ32N", "shz", "900001", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32N..shz_20141117_071500.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416208500.000000", "SJ32W", "shz", "900001", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32W..shz_20141117_071500.mseed", "0"));
    }

    private static List<AbstractTraceFile> generateIfe20141117_1000Entries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ01C", "she", "900001", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..she_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ01C", "shn", "900001", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..shn_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ01C", "shz", "900001", "500.000000", "0.019954", "1.000000", "m42", "./data", "IF.SJ01C..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ01E", "shz", "900001", "500.000000", "0.019906", "1.000000", "m42", "./data", "IF.SJ01E..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ01N", "shz", "900001", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ01N..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ01W", "shz", "900001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ01W..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ02C", "she", "289634", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02C..she_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218979.268000", "SJ02C", "she", "610367", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02C..she_20141117_100939.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ02C", "shn", "289634", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shn_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218979.268000", "SJ02C", "shn", "610367", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shn_20141117_100939.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ02C", "shz", "289634", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218979.268000", "SJ02C", "shz", "610367", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shz_20141117_100939.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ02E", "shz", "289634", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ02E..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218979.268000", "SJ02E", "shz", "610367", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ02E..shz_20141117_100939.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ02N", "shz", "289634", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ02N..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218979.268000", "SJ02N", "shz", "610367", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ02N..shz_20141117_100939.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ02W", "shz", "289634", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02W..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218979.268000", "SJ02W", "shz", "610367", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02W..shz_20141117_100939.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ03C", "she", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ03C..she_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ03C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ03C..shn_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ03C", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ03C..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ03E", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03E..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ03N", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03N..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ03W", "shz", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ03W..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ04C", "she", "900001", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ04C..she_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ04C", "shn", "900001", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ04C..shn_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ04C", "shz", "900001", "500.000000", "0.019699", "1.000000", "m42", "./data", "IF.SJ04C..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ04E", "shz", "900001", "500.000000", "0.019715", "1.000000", "m42", "./data", "IF.SJ04E..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ04N", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ04N..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ04W", "shz", "900001", "500.000000", "0.019727", "1.000000", "m42", "./data", "IF.SJ04W..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ05C", "she", "900001", "500.000000", "0.019978", "1.000000", "m42", "./data", "IF.SJ05C..she_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ05C", "shn", "900001", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ05C..shn_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ05C", "shz", "900001", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ05C..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ05E", "shz", "900001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ05E..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ05N", "shz", "900001", "500.000000", "0.019950", "1.000000", "m42", "./data", "IF.SJ05N..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ05W", "shz", "900001", "500.000000", "0.019942", "1.000000", "m42", "./data", "IF.SJ05W..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ06C", "she", "900001", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ06C..she_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ06C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ06C..shn_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ06C", "shz", "900001", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ06C..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ06E", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ06E..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ06N", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ06N..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ06W", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ06W..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ11C", "she", "595470", "500.000000", "0.019687", "1.000000", "m42", "./data", "IF.SJ11C..she_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416219590.940000", "SJ11C", "she", "304531", "500.000000", "0.019687", "1.000000", "m42", "./data", "IF.SJ11C..she_20141117_101950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ11C", "shn", "595470", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ11C..shn_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416219590.940000", "SJ11C", "shn", "304531", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ11C..shn_20141117_101950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ11C", "shz", "595470", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ11C..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416219590.940000", "SJ11C", "shz", "304531", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ11C..shz_20141117_101950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ11E", "shz", "595470", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11E..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416219590.940000", "SJ11E", "shz", "304531", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11E..shz_20141117_101950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ11N", "shz", "595470", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11N..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416219590.940000", "SJ11N", "shz", "304531", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11N..shz_20141117_101950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ11W", "shz", "595470", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ11W..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416219590.940000", "SJ11W", "shz", "304531", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ11W..shz_20141117_101950.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ12C", "she", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ12C..she_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ12C", "shn", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shn_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ12C", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ12E", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12E..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ12N", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12N..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ12W", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12W..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ13C", "she", "900001", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ13C..she_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ13C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ13C..shn_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ13C", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13C..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ13E", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13E..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ13N", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13N..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ13W", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13W..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ14C", "she", "1800001", "1000.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ14C..she_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ14C", "shn", "1800001", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14C..shn_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ14C", "shz", "1800001", "1000.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ14C..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ14E", "shz", "1800001", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14E..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ14N", "shz", "1800001", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14N..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ14W", "shz", "1800001", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14W..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ20C", "she", "900001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..she_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ20C", "shn", "900001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..shn_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ20C", "shz", "900001", "500.000000", "0.019910", "1.000000", "m42", "./data", "IF.SJ20C..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ20E", "shz", "900001", "500.000000", "0.019922", "1.000000", "m42", "./data", "IF.SJ20E..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ20N", "shz", "900001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20N..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ20W", "shz", "900001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20W..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ21C", "she", "270691", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ21C..she_20141117_095959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218941.382000", "SJ21C", "she", "629310", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ21C..she_20141117_100901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ21C", "shn", "270691", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21C..shn_20141117_095959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218941.382000", "SJ21C", "shn", "629310", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21C..shn_20141117_100901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ21C", "shz", "270691", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21C..shz_20141117_095959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218941.382000", "SJ21C", "shz", "629310", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21C..shz_20141117_100901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ21E", "shz", "270691", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21E..shz_20141117_095959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218941.382000", "SJ21E", "shz", "629310", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21E..shz_20141117_100901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ21N", "shz", "270691", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21N..shz_20141117_095959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218941.382000", "SJ21N", "shz", "629310", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21N..shz_20141117_100901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ21W", "shz", "270691", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21W..shz_20141117_095959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218941.382000", "SJ21W", "shz", "629310", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21W..shz_20141117_100901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ22C", "she", "900001", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ22C..she_20141117_095959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ22C", "shn", "900001", "500.000000", "0.019656", "1.000000", "m42", "./data", "IF.SJ22C..shn_20141117_095959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ22C", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ22C..shz_20141117_095959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ31C", "she", "61870", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ31C..she_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218523.740000", "SJ31C", "she", "838131", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ31C..she_20141117_100203.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ31C", "shn", "61870", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ31C..shn_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218523.740000", "SJ31C", "shn", "838131", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ31C..shn_20141117_100203.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ31C", "shz", "61870", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ31C..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218523.740000", "SJ31C", "shz", "838131", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ31C..shz_20141117_100203.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ31E", "shz", "61870", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31E..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218523.740000", "SJ31E", "shz", "838131", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31E..shz_20141117_100203.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ31N", "shz", "61870", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ31N..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218523.740000", "SJ31N", "shz", "838131", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ31N..shz_20141117_100203.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ31W", "shz", "61870", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31W..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218523.740000", "SJ31W", "shz", "838131", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31W..shz_20141117_100203.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ32C", "she", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ32C..she_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ32C", "shn", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ32C..shn_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ32C", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ32C..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ32E", "shz", "900001", "500.000000", "0.019640", "1.000000", "m42", "./data", "IF.SJ32E..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ32N", "shz", "900001", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32N..shz_20141117_100000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416218400.000000", "SJ32W", "shz", "900001", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32W..shz_20141117_100000.mseed", "0"));
    }

    private static List<AbstractTraceFile> generateIfe20141117_1200Entries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ01C", "she", "900001", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..she_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ01C", "shn", "900001", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..shn_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ01C", "shz", "900001", "500.000000", "0.019954", "1.000000", "m42", "./data", "IF.SJ01C..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ01E", "shz", "900001", "500.000000", "0.019906", "1.000000", "m42", "./data", "IF.SJ01E..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ01N", "shz", "900001", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ01N..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ01W", "shz", "900001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ01W..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225827.268000", "SJ02C", "she", "786367", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02C..she_20141117_120347.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225827.268000", "SJ02C", "shn", "786367", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shn_20141117_120347.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225827.268000", "SJ02C", "shz", "786367", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shz_20141117_120347.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225827.268000", "SJ02E", "shz", "786367", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ02E..shz_20141117_120347.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225827.268000", "SJ02N", "shz", "786367", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ02N..shz_20141117_120347.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225827.268000", "SJ02W", "shz", "786367", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02W..shz_20141117_120347.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ03C", "she", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ03C..she_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ03C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ03C..shn_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ03C", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ03C..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ03E", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03E..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ03N", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03N..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ03W", "shz", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ03W..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ04C", "she", "900001", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ04C..she_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ04C", "shn", "900001", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ04C..shn_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ04C", "shz", "900001", "500.000000", "0.019699", "1.000000", "m42", "./data", "IF.SJ04C..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ04E", "shz", "900001", "500.000000", "0.019715", "1.000000", "m42", "./data", "IF.SJ04E..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ04N", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ04N..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ04W", "shz", "900001", "500.000000", "0.019727", "1.000000", "m42", "./data", "IF.SJ04W..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ05C", "she", "900001", "500.000000", "0.019978", "1.000000", "m42", "./data", "IF.SJ05C..she_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ05C", "shn", "900001", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ05C..shn_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ05C", "shz", "900001", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ05C..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ05E", "shz", "900001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ05E..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ05N", "shz", "900001", "500.000000", "0.019950", "1.000000", "m42", "./data", "IF.SJ05N..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ05W", "shz", "900001", "500.000000", "0.019942", "1.000000", "m42", "./data", "IF.SJ05W..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ06C", "she", "900001", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ06C..she_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ06C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ06C..shn_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ06C", "shz", "900001", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ06C..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ06E", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ06E..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ06N", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ06N..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ06W", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ06W..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ11C", "she", "900001", "500.000000", "0.019687", "1.000000", "m42", "./data", "IF.SJ11C..she_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ11C", "shn", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ11C..shn_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ11C", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ11C..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ11E", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11E..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ11N", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11N..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ11W", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ11W..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ12C", "she", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ12C..she_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ12C", "shn", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shn_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ12C", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ12E", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12E..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ12N", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12N..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ12W", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12W..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ13C", "she", "900001", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ13C..she_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ13C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ13C..shn_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ13C", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13C..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ13E", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13E..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ13N", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13N..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ13W", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13W..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ14C", "she", "1800001", "1000.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ14C..she_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ14C", "shn", "1800001", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14C..shn_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ14C", "shz", "1800001", "1000.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ14C..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ14E", "shz", "1800001", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14E..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ14N", "shz", "1800001", "1000.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ14N..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ14W", "shz", "1800001", "1000.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ14W..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ20C", "she", "900001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..she_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ20C", "shn", "900001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..shn_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ20C", "shz", "900001", "500.000000", "0.019910", "1.000000", "m42", "./data", "IF.SJ20C..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ20E", "shz", "900001", "500.000000", "0.019922", "1.000000", "m42", "./data", "IF.SJ20E..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ20N", "shz", "900001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20N..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ20W", "shz", "900001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20W..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ21C", "she", "270691", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ21C..she_20141117_115959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416226141.382000", "SJ21C", "she", "629310", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ21C..she_20141117_120901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ21C", "shn", "270691", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21C..shn_20141117_115959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416226141.382000", "SJ21C", "shn", "629310", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21C..shn_20141117_120901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ21C", "shz", "270691", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21C..shz_20141117_115959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416226141.382000", "SJ21C", "shz", "629310", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21C..shz_20141117_120901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ21E", "shz", "270691", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21E..shz_20141117_115959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416226141.382000", "SJ21E", "shz", "629310", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21E..shz_20141117_120901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ21N", "shz", "270691", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21N..shz_20141117_115959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416226141.382000", "SJ21N", "shz", "629310", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21N..shz_20141117_120901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ21W", "shz", "270691", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21W..shz_20141117_115959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416226141.382000", "SJ21W", "shz", "629310", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21W..shz_20141117_120901.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ22C", "she", "900001", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ22C..she_20141117_115959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ22C", "shn", "900001", "500.000000", "0.019656", "1.000000", "m42", "./data", "IF.SJ22C..shn_20141117_115959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ22C", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ22C..shz_20141117_115959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ23C", "she", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ23C..she_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ23C", "shn", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ23C..shn_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ23C", "shz", "900001", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ23C..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ23E", "shz", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ23E..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ23N", "shz", "900001", "500.000000", "0.315525", "1.000000", "m42", "./data", "IF.SJ23N..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ23W", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ23W..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ31C", "she", "61870", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ31C..she_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225723.740000", "SJ31C", "she", "838131", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ31C..she_20141117_120203.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ31C", "shn", "61870", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ31C..shn_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225723.740000", "SJ31C", "shn", "838131", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ31C..shn_20141117_120203.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ31C", "shz", "61870", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ31C..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225723.740000", "SJ31C", "shz", "838131", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ31C..shz_20141117_120203.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ31E", "shz", "61870", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31E..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225723.740000", "SJ31E", "shz", "838131", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31E..shz_20141117_120203.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ31N", "shz", "61870", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ31N..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225723.740000", "SJ31N", "shz", "838131", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ31N..shz_20141117_120203.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ31W", "shz", "61870", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31W..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225723.740000", "SJ31W", "shz", "838131", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ31W..shz_20141117_120203.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ32C", "she", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ32C..she_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ32C", "shn", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ32C..shn_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ32C", "shz", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ32C..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ32E", "shz", "900001", "500.000000", "0.019640", "1.000000", "m42", "./data", "IF.SJ32E..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ32N", "shz", "900001", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32N..shz_20141117_120000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416225600.000000", "SJ32W", "shz", "900001", "500.000000", "0.019648", "1.000000", "m42", "./data", "IF.SJ32W..shz_20141117_120000.mseed", "0"));
    }

    private static List<AbstractTraceFile> generateIfe20141125_1030Entries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ01C", "she", "900000", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..she_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ01C", "shn", "900000", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ01C..shn_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ01C", "shz", "900000", "500.000000", "0.019954", "1.000000", "m42", "./data", "IF.SJ01C..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ01E", "shz", "900000", "500.000000", "0.019906", "1.000000", "m42", "./data", "IF.SJ01E..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ01N", "shz", "900000", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ01N..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ01W", "shz", "900000", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ01W..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ02C", "she", "66723", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02C..she_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911533.446000", "SJ02C", "she", "833278", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02C..she_20141125_103213.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ02C", "shn", "66723", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shn_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911533.446000", "SJ02C", "shn", "833278", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shn_20141125_103213.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ02C", "shz", "66723", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911533.446000", "SJ02C", "shz", "833278", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ02C..shz_20141125_103213.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ02E", "shz", "66723", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ02E..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911533.446000", "SJ02E", "shz", "833278", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ02E..shz_20141125_103213.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ02N", "shz", "66723", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ02N..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911533.446000", "SJ02N", "shz", "833278", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ02N..shz_20141125_103213.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ02W", "shz", "66723", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02W..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911533.446000", "SJ02W", "shz", "833278", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ02W..shz_20141125_103213.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ03C", "she", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ03C..she_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ03C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ03C..shn_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ03C", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ03C..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ03E", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03E..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ03N", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03N..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ03W", "shz", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ03W..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ04C", "she", "102652", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ04C..she_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911605.304000", "SJ04C", "she", "797349", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ04C..she_20141125_103325.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ04C", "shn", "102652", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ04C..shn_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911605.304000", "SJ04C", "shn", "797349", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ04C..shn_20141125_103325.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ04C", "shz", "102652", "500.000000", "0.019699", "1.000000", "m42", "./data", "IF.SJ04C..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911605.304000", "SJ04C", "shz", "797349", "500.000000", "0.019699", "1.000000", "m42", "./data", "IF.SJ04C..shz_20141125_103325.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ04E", "shz", "102652", "500.000000", "0.019715", "1.000000", "m42", "./data", "IF.SJ04E..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911605.304000", "SJ04E", "shz", "797349", "500.000000", "0.019715", "1.000000", "m42", "./data", "IF.SJ04E..shz_20141125_103325.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ04N", "shz", "102652", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ04N..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911605.304000", "SJ04N", "shz", "797349", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ04N..shz_20141125_103325.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ04W", "shz", "102652", "500.000000", "0.019727", "1.000000", "m42", "./data", "IF.SJ04W..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911605.304000", "SJ04W", "shz", "797349", "500.000000", "0.019727", "1.000000", "m42", "./data", "IF.SJ04W..shz_20141125_103325.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ05C", "she", "900000", "500.000000", "0.019978", "1.000000", "m42", "./data", "IF.SJ05C..she_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ05C", "shn", "900000", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ05C..shn_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ05C", "shz", "900000", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ05C..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ05E", "shz", "900000", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ05E..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ05N", "shz", "900000", "500.000000", "0.019950", "1.000000", "m42", "./data", "IF.SJ05N..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ05W", "shz", "900000", "500.000000", "0.019942", "1.000000", "m42", "./data", "IF.SJ05W..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ06C", "she", "900000", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ06C..she_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ06C", "shn", "900000", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ06C..shn_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ06C", "shz", "900000", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ06C..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ06E", "shz", "900000", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ06E..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ06N", "shz", "900000", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ06N..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ06W", "shz", "900000", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ06W..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ11C", "she", "900001", "500.000000", "0.019687", "1.000000", "m42", "./data", "IF.SJ11C..she_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ11C", "shn", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ11C..shn_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ11C", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ11C..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ11E", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11E..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ11N", "shz", "900001", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ11N..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ11W", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ11W..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ12C", "she", "900000", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ12C..she_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ12C", "shn", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shn_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ12C", "shz", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ12C..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ12E", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12E..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ12N", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12N..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ12W", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ12W..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ13C", "she", "900000", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ13C..she_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ13C", "shn", "900000", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ13C..shn_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ13C", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13C..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ13E", "shz", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13E..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ13N", "shz", "900000", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ13N..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ13W", "shz", "900000", "500.000000", "0.019676", "1.000000", "m42", "./data", "IF.SJ13W..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ20C", "she", "599000", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..she_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416912586.000000", "SJ20C", "she", "307001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..she_20141125_104946.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ20C", "shn", "599000", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..shn_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416912586.000000", "SJ20C", "shn", "307001", "500.000000", "0.019958", "1.000000", "m42", "./data", "IF.SJ20C..shn_20141125_104946.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ20C", "shz", "599000", "500.000000", "0.019910", "1.000000", "m42", "./data", "IF.SJ20C..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416912586.000000", "SJ20C", "shz", "307001", "500.000000", "0.019910", "1.000000", "m42", "./data", "IF.SJ20C..shz_20141125_104946.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ20E", "shz", "599000", "500.000000", "0.019922", "1.000000", "m42", "./data", "IF.SJ20E..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416912586.000000", "SJ20E", "shz", "307001", "500.000000", "0.019922", "1.000000", "m42", "./data", "IF.SJ20E..shz_20141125_104946.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ20N", "shz", "599000", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20N..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416912586.000000", "SJ20N", "shz", "307001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20N..shz_20141125_104946.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ20W", "shz", "599000", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20W..shz_20141125_103000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416912586.000000", "SJ20W", "shz", "307001", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ20W..shz_20141125_104946.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ21C", "she", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ21C..she_20141125_102959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ21C", "shn", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21C..shn_20141125_102959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ21C", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21C..shz_20141125_102959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ21E", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21E..shz_20141125_102959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ21N", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ21N..shz_20141125_102959.mseed", "0"), HardcodedHeaderRepository.entry(file, "1416911400.000000", "SJ21W", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ21W..shz_20141125_102959.mseed", "0"));
    }

    private static List<AbstractTraceFile> generateIfe20141127_2330Entries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ03C", "she", "900001", "500.000000", "0.019672", "1.000000", "m42", "./data", "IF.SJ03C..she_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ03C", "shn", "900001", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ03C..shn_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ03C", "shz", "900001", "500.000000", "0.019668", "1.000000", "m42", "./data", "IF.SJ03C..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ03E", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03E..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ03N", "shz", "900001", "500.000000", "0.019664", "1.000000", "m42", "./data", "IF.SJ03N..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ03W", "shz", "900001", "500.000000", "0.019680", "1.000000", "m42", "./data", "IF.SJ03W..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ04C", "she", "900001", "500.000000", "0.019695", "1.000000", "m42", "./data", "IF.SJ04C..she_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ04C", "shn", "900001", "500.000000", "0.019691", "1.000000", "m42", "./data", "IF.SJ04C..shn_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ04C", "shz", "900001", "500.000000", "0.019699", "1.000000", "m42", "./data", "IF.SJ04C..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ04E", "shz", "900001", "500.000000", "0.019715", "1.000000", "m42", "./data", "IF.SJ04E..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ04N", "shz", "900001", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ04N..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ04W", "shz", "900001", "500.000000", "0.019727", "1.000000", "m42", "./data", "IF.SJ04W..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ05C", "she", "900000", "500.000000", "0.019978", "1.000000", "m42", "./data", "IF.SJ05C..she_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ05C", "shn", "900000", "500.000000", "0.019934", "1.000000", "m42", "./data", "IF.SJ05C..shn_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ05C", "shz", "900000", "500.000000", "0.019930", "1.000000", "m42", "./data", "IF.SJ05C..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ05E", "shz", "900000", "500.000000", "0.019918", "1.000000", "m42", "./data", "IF.SJ05E..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ05N", "shz", "900000", "500.000000", "0.019950", "1.000000", "m42", "./data", "IF.SJ05N..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ05W", "shz", "900000", "500.000000", "0.019942", "1.000000", "m42", "./data", "IF.SJ05W..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ06C", "she", "900000", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ06C..she_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ06C", "shn", "900000", "500.000000", "0.019660", "1.000000", "m42", "./data", "IF.SJ06C..shn_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ06C", "shz", "900000", "500.000000", "0.019652", "1.000000", "m42", "./data", "IF.SJ06C..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ06E", "shz", "900000", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ06E..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ06N", "shz", "900000", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ06N..shz_20141127_233000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1417131000.000000", "SJ06W", "shz", "900000", "500.000000", "0.019683", "1.000000", "m42", "./data", "IF.SJ06W..shz_20141127_233000.mseed", "0"));
    }

    private static List<AbstractTraceFile> generateBaselDemoEntries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1165536000.00500", "BALST", "HHE", "432000", "120.0", "0.253587", "1.0", "m42", "./data/20061208", "CH.BALST..HHE.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00500", "BALST", "HHE", "432000", "120.0", "0.253587", "1.0", "m42", "./data/20061208", "CH.BALST..HHE.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00500", "BALST", "HHE", "432000", "120.0", "0.253587", "1.0", "m42", "./data/20061208", "CH.BALST..HHE.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00500", "BALST", "HHN", "432000", "120.0", "0.253587", "1.0", "m42", "./data/20061208", "CH.BALST..HHN.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00500", "BALST", "HHN", "432000", "120.0", "0.253587", "1.0", "m42", "./data/20061208", "CH.BALST..HHN.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00500", "BALST", "HHN", "432000", "120.0", "0.253587", "1.0", "m42", "./data/20061208", "CH.BALST..HHN.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00500", "BALST", "HHZ", "432000", "120.0", "0.253587", "1.0", "m42", "./data/20061208", "CH.BALST..HHZ.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00500", "BALST", "HHZ", "432000", "120.0", "0.253587", "1.0", "m42", "./data/20061208", "CH.BALST..HHZ.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00500", "BALST", "HHZ", "432000", "120.0", "0.253587", "1.0", "m42", "./data/20061208", "CH.BALST..HHZ.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "OTER1", "EHA", "432000", "120.0", "0.70462", "1.0", "m42", "./data/20061208", "CH.OTER1..EHA.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "OTER1", "EHA", "432000", "120.0", "0.70462", "1.0", "m42", "./data/20061208", "CH.OTER1..EHA.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "OTER1", "EHA", "432000", "120.0", "0.70462", "1.0", "m42", "./data/20061208", "CH.OTER1..EHA.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "OTER1", "EHB", "432000", "120.0", "0.70462", "1.0", "m42", "./data/20061208", "CH.OTER1..EHB.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "OTER1", "EHB", "432000", "120.0", "0.70462", "1.0", "m42", "./data/20061208", "CH.OTER1..EHB.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "OTER1", "EHB", "432000", "120.0", "0.70462", "1.0", "m42", "./data/20061208", "CH.OTER1..EHB.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "OTER1", "EHC", "432000", "120.0", "0.70462", "1.0", "m42", "./data/20061208", "CH.OTER1..EHC.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "OTER1", "EHC", "432000", "120.0", "0.70462", "1.0", "m42", "./data/20061208", "CH.OTER1..EHC.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "OTER1", "EHC", "432000", "120.0", "0.70462", "1.0", "m42", "./data/20061208", "CH.OTER1..EHC.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "S2C", "SE", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2C..SE.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "S2C", "SE", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2C..SE.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "S2C", "SE", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2C..SE.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "S2C", "SN", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2C..SN.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "S2C", "SN", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2C..SN.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "S2C", "SN", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2C..SN.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "S2C", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2C..SZ.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "S2C", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2C..SZ.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "S2C", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2C..SZ.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "S2E", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2E..SZ.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "S2E", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2E..SZ.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "S2E", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2E..SZ.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "S2N", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2N..SZ.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "S2N", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2N..SZ.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "S2N", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2N..SZ.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "S2W", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2W..SZ.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "S2W", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2W..SZ.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "S2W", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.S2W..SZ.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "SNC", "SE", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNC..SE.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "SNC", "SE", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNC..SE.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "SNC", "SE", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNC..SE.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "SNC", "SN", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNC..SN.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "SNC", "SN", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNC..SN.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "SNC", "SN", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNC..SN.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "SNC", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNC..SZ.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "SNC", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNC..SZ.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "SNC", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNC..SZ.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "SNE", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNE..SZ.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "SNE", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNE..SZ.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "SNE", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNE..SZ.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "SNN", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNN..SZ.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "SNN", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNN..SZ.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "SNN", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNN..SZ.20061208T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165536000.00000", "SNW", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNW..SZ.20061208T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165539600.00000", "SNW", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNW..SZ.20061208T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1165543200.00000", "SNW", "SZ", "1440000", "400.0", "0.00185", "1.0", "m42", "./data/20061208", "ST.SNW..SZ.20061208T0200.mseed", "0"));
    }

    private static List<AbstractTraceFile> generateGrsnDemoEntries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1625009400.00000", "ROMAN", "HH2", "360000", "200.0", "0.331153", "1.0", "m42", "./data/20210629", "CH.ROMAN.BT.HH2.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00000", "ROMAN", "HH3", "360000", "200.0", "0.331153", "1.0", "m42", "./data/20210629", "CH.ROMAN.BT.HH3.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00000", "ROMAN", "HHZ", "360000", "200.0", "0.331153", "1.0", "m42", "./data/20210629", "CH.ROMAN.BT.HHZ.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00500", "HOHE", "HH1", "359999", "200.0", "0.03945", "1.0", "m42", "./data/20210629", "FR.HOHE.00.HH1.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00500", "HOHE", "HH2", "359999", "200.0", "0.03945", "1.0", "m42", "./data/20210629", "FR.HOHE.00.HH2.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00500", "HOHE", "HHZ", "359999", "200.0", "0.03945", "1.0", "m42", "./data/20210629", "FR.HOHE.00.HHZ.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00000", "STU", "HHE", "180000", "100.0", "0.104131", "1.0", "m42", "./data/20210629", "GE.STU..HHE.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00000", "STU", "HHN", "180000", "100.0", "0.104131", "1.0", "m42", "./data/20210629", "GE.STU..HHN.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00000", "STU", "HHZ", "180000", "100.0", "0.104131", "1.0", "m42", "./data/20210629", "GE.STU..HHZ.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00840", "BFO", "HHE", "180000", "100.0", "0.0632323", "1.0", "m42", "./data/20210629", "GR.BFO..HHE.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00840", "BFO", "HHN", "180000", "100.0", "0.0632323", "1.0", "m42", "./data/20210629", "GR.BFO..HHN.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00840", "BFO", "HHZ", "180000", "100.0", "0.0632323", "1.0", "m42", "./data/20210629", "GR.BFO..HHZ.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00500", "FUR", "HHE", "180000", "100.0", "0.168593", "1.0", "m42", "./data/20210629", "GR.FUR..HHE.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00500", "FUR", "HHN", "180000", "100.0", "0.168593", "1.0", "m42", "./data/20210629", "GR.FUR..HHN.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00500", "FUR", "HHZ", "180000", "100.0", "0.168593", "1.0", "m42", "./data/20210629", "GR.FUR..HHZ.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00500", "TNS", "HHE", "180000", "100.0", "0.168593", "1.0", "m42", "./data/20210629", "GR.TNS..HHE.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00500", "TNS", "HHN", "180000", "100.0", "0.168593", "1.0", "m42", "./data/20210629", "GR.TNS..HHN.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625009400.00500", "TNS", "HHZ", "180000", "100.0", "0.168593", "1.0", "m42", "./data/20210629", "GR.TNS..HHZ.20210629T2300.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00000", "ROMAN", "HH2", "720000", "200.0", "0.331153", "1.0", "m42", "./data/20210630", "CH.ROMAN.BT.HH2.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00000", "ROMAN", "HH2", "720000", "200.0", "0.331153", "1.0", "m42", "./data/20210630", "CH.ROMAN.BT.HH2.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00000", "ROMAN", "HH2", "360001", "200.0", "0.331153", "1.0", "m42", "./data/20210630", "CH.ROMAN.BT.HH2.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00000", "ROMAN", "HH3", "720000", "200.0", "0.331153", "1.0", "m42", "./data/20210630", "CH.ROMAN.BT.HH3.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00000", "ROMAN", "HH3", "720000", "200.0", "0.331153", "1.0", "m42", "./data/20210630", "CH.ROMAN.BT.HH3.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00000", "ROMAN", "HH3", "360001", "200.0", "0.331153", "1.0", "m42", "./data/20210630", "CH.ROMAN.BT.HH3.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00000", "ROMAN", "HHZ", "720000", "200.0", "0.331153", "1.0", "m42", "./data/20210630", "CH.ROMAN.BT.HHZ.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00000", "ROMAN", "HHZ", "720000", "200.0", "0.331153", "1.0", "m42", "./data/20210630", "CH.ROMAN.BT.HHZ.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00000", "ROMAN", "HHZ", "360001", "200.0", "0.331153", "1.0", "m42", "./data/20210630", "CH.ROMAN.BT.HHZ.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00500", "HOHE", "HH1", "719999", "200.0", "0.03945", "1.0", "m42", "./data/20210630", "FR.HOHE.00.HH1.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00500", "HOHE", "HH1", "719999", "200.0", "0.03945", "1.0", "m42", "./data/20210630", "FR.HOHE.00.HH1.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00500", "HOHE", "HH1", "360000", "200.0", "0.03945", "1.0", "m42", "./data/20210630", "FR.HOHE.00.HH1.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00500", "HOHE", "HH2", "719999", "200.0", "0.03945", "1.0", "m42", "./data/20210630", "FR.HOHE.00.HH2.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00500", "HOHE", "HH2", "719999", "200.0", "0.03945", "1.0", "m42", "./data/20210630", "FR.HOHE.00.HH2.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00500", "HOHE", "HH2", "360000", "200.0", "0.03945", "1.0", "m42", "./data/20210630", "FR.HOHE.00.HH2.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00500", "HOHE", "HHZ", "719999", "200.0", "0.03945", "1.0", "m42", "./data/20210630", "FR.HOHE.00.HHZ.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00500", "HOHE", "HHZ", "719999", "200.0", "0.03945", "1.0", "m42", "./data/20210630", "FR.HOHE.00.HHZ.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00500", "HOHE", "HHZ", "360000", "200.0", "0.03945", "1.0", "m42", "./data/20210630", "FR.HOHE.00.HHZ.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00000", "STU", "HHE", "360000", "100.0", "0.104131", "1.0", "m42", "./data/20210630", "GE.STU..HHE.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00000", "STU", "HHE", "360000", "100.0", "0.104131", "1.0", "m42", "./data/20210630", "GE.STU..HHE.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00000", "STU", "HHE", "180001", "100.0", "0.104131", "1.0", "m42", "./data/20210630", "GE.STU..HHE.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00000", "STU", "HHN", "360000", "100.0", "0.104131", "1.0", "m42", "./data/20210630", "GE.STU..HHN.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00000", "STU", "HHN", "360000", "100.0", "0.104131", "1.0", "m42", "./data/20210630", "GE.STU..HHN.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00000", "STU", "HHN", "180001", "100.0", "0.104131", "1.0", "m42", "./data/20210630", "GE.STU..HHN.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00000", "STU", "HHZ", "360000", "100.0", "0.104131", "1.0", "m42", "./data/20210630", "GE.STU..HHZ.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00000", "STU", "HHZ", "360000", "100.0", "0.104131", "1.0", "m42", "./data/20210630", "GE.STU..HHZ.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00000", "STU", "HHZ", "180001", "100.0", "0.104131", "1.0", "m42", "./data/20210630", "GE.STU..HHZ.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00840", "BFO", "HHE", "360000", "100.0", "0.0632323", "1.0", "m42", "./data/20210630", "GR.BFO..HHE.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00840", "BFO", "HHE", "360000", "100.0", "0.0632323", "1.0", "m42", "./data/20210630", "GR.BFO..HHE.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00840", "BFO", "HHE", "180000", "100.0", "0.0632323", "1.0", "m42", "./data/20210630", "GR.BFO..HHE.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00840", "BFO", "HHN", "360000", "100.0", "0.0632323", "1.0", "m42", "./data/20210630", "GR.BFO..HHN.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00840", "BFO", "HHN", "360000", "100.0", "0.0632323", "1.0", "m42", "./data/20210630", "GR.BFO..HHN.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00840", "BFO", "HHN", "180000", "100.0", "0.0632323", "1.0", "m42", "./data/20210630", "GR.BFO..HHN.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00840", "BFO", "HHZ", "360000", "100.0", "0.0632323", "1.0", "m42", "./data/20210630", "GR.BFO..HHZ.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00840", "BFO", "HHZ", "360000", "100.0", "0.0632323", "1.0", "m42", "./data/20210630", "GR.BFO..HHZ.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00840", "BFO", "HHZ", "180000", "100.0", "0.0632323", "1.0", "m42", "./data/20210630", "GR.BFO..HHZ.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00500", "FUR", "HHE", "360000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.FUR..HHE.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00500", "FUR", "HHE", "360000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.FUR..HHE.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00500", "FUR", "HHE", "180000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.FUR..HHE.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00500", "FUR", "HHN", "360000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.FUR..HHN.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00500", "FUR", "HHN", "360000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.FUR..HHN.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00500", "FUR", "HHN", "180000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.FUR..HHN.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00500", "FUR", "HHZ", "360000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.FUR..HHZ.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00500", "FUR", "HHZ", "360000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.FUR..HHZ.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00500", "FUR", "HHZ", "180000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.FUR..HHZ.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00500", "TNS", "HHE", "360000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.TNS..HHE.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00500", "TNS", "HHE", "360000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.TNS..HHE.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00500", "TNS", "HHE", "180000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.TNS..HHE.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00500", "TNS", "HHN", "360000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.TNS..HHN.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00500", "TNS", "HHN", "360000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.TNS..HHN.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00500", "TNS", "HHN", "180000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.TNS..HHN.20210630T0200.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625011200.00500", "TNS", "HHZ", "360000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.TNS..HHZ.20210630T0000.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625014800.00500", "TNS", "HHZ", "360000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.TNS..HHZ.20210630T0100.mseed", "0"), HardcodedHeaderRepository.entry(file, "1625018400.00500", "TNS", "HHZ", "180000", "100.0", "0.168593", "1.0", "m42", "./data/20210630", "GR.TNS..HHZ.20210630T0200.mseed", "0"));
    }

    private static List<AbstractTraceFile> generateDgmk20161218Entries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1482018240.000000", "BELLC", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "BELLCS01.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "BELLC", "SE", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "BELLCS02.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "BELLC", "SN", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "BELLCS03.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "BELLN", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "BELLNS04.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "BELLW", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "BELLWS05.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "BELLE", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "BELLES06.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "KIR1C", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "KIR1CS07.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "KIR1C", "SE", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "KIR1CS08.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "KIR1C", "SN", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "KIR1CS09.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "KIR204", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "KIR20410.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "KIR205", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "KIR20511.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "KIR203", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "KIR20312.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "LOEV1C", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "LOEV1C13.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "LOEV1C", "SE", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "LOEV1C14.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "LOEV1C", "SN", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "LOEV1C15.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "LOEV1N", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "LOEV1N16.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "LOEV1W", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "LOEV1W17.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "LOEV1E", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "LOEV1E18.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "WIEDC", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "WIEDCS25.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "WIEDC", "SE", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "WIEDCS26.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "WIEDC", "SN", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "WIEDCS27.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "WIEDN", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "WIEDNS28.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "WIEDW", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "WIEDWS29.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "WIEDE", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "WIEDES30.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "BEHNC", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "BEHNCS31.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "BEHNC", "SE", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "BEHNCS32.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "BEHNC", "SN", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "BEHNCS33.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "HIDDC", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "HIDDCS37.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "HIDDC", "SE", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "HIDDCS38.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "HIDDC", "SN", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "HIDDCS39.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "NBREC", "SZ", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "NBRECS40.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "NBREC", "SE", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "NBRECS41.DAT", "9"), HardcodedHeaderRepository.entry(file, "1482018240.000000", "NBREC", "SN", "75000", "500.00", "0.159155", "1.000000", "d0", "./data", "NBRECS42.DAT", "9"));
    }

    private static List<AbstractTraceFile> generateDgmk20170204Entries(File file) {
        return Arrays.asList(HardcodedHeaderRepository.entry(file, "1486183020.000000", "BELLC", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "BELLCS01.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "BELLC", "SE", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "BELLCS02.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "BELLC", "SN", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "BELLCS03.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "BELLN", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "BELLNS04.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "BELLW", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "BELLWS05.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "BELLE", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "BELLES06.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "KIR1C", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "KIR1CS07.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "KIR1C", "SE", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "KIR1CS08.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "KIR1C", "SN", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "KIR1CS09.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "KIR204", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "KIR20410.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "KIR205", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "KIR20511.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "KIR203", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "KIR20312.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "LOEV1C", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "LOEV1C13.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "LOEV1C", "SE", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "LOEV1C14.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "LOEV1C", "SN", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "LOEV1C15.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "LOEV1N", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "LOEV1N16.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "LOEV1W", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "LOEV1W17.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "LOEV1E", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "LOEV1E18.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "WIEDC", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "WIEDCS31.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "WIEDC", "SE", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "WIEDCS32.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "WIEDC", "SN", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "WIEDCS33.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "WIEDN", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "WIEDNS34.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "WIEDW", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "WIEDWS35.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "WIEDE", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "WIEDES36.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "BEHNC", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "BEHNCS37.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "BEHNC", "SE", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "BEHNCS38.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "BEHNC", "SN", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "BEHNCS39.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "HIDDC", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "HIDDCS46.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "HIDDC", "SE", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "HIDDCS47.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "HIDDC", "SN", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "HIDDCS48.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "NBREC", "SZ", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "NBRECS49.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "NBREC", "SE", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "NBRECS50.DAT", "9"), HardcodedHeaderRepository.entry(file, "1486183020.000000", "NBREC", "SN", "60000", "500.00", "0.159155", "1.000000", "d0", "./data", "NBRECS51.DAT", "9"));
    }
}

