/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.knowledgebase;

import edu.geophys.commons.model.TraceMetadata;
import edu.geophys.commons.model.knowledgebase.AbstractKnowledge;
import edu.geophys.commons.resamplingmodes.DefaultResamplingModes;
import edu.geophys.commons.resamplingmodes.ResamplingMode;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.File;
import java.text.ParseException;

@XmlRootElement(name="campaign")
@XmlType(name="tCampaignKnowledge", propOrder={"campaignStart", "campaignEnd", "resamplingMode", "referencePoint", "stationMap", "sFKMap", "pFKMap", "repeatingValuesNan"})
public final class CampaignKnowledge
extends AbstractKnowledge<CampaignKnowledge> {
    private static final long serialVersionUID = 8291123127694049085L;
    private static final String CAMPAIGN_RELATIVE_FILENAME = "campaign.xml";
    private long campaignEpochStart = 0L;
    private long campaignEpochEnd = 0L;
    private float globalSamplerate = 400.0f;
    private int resamplingMode = 1;
    private String campaignName = "";
    private MapPoint referencePoint = new MapPoint();
    private FKMap pFKMap = new FKMap();
    private FKMap sFKMap = new FKMap();
    private StationOffset stationMap = new StationOffset();
    private boolean repeatingValuesNan;

    public CampaignKnowledge() {
        super(CampaignKnowledge.class, null);
    }

    public CampaignKnowledge(File file) {
        super(CampaignKnowledge.class, file);
    }

    @Override
    protected String getRelativeFilename() {
        return CAMPAIGN_RELATIVE_FILENAME;
    }

    @Override
    public void setValues(CampaignKnowledge campaignKnowledge) {
        this.campaignEpochStart = campaignKnowledge.campaignEpochStart;
        this.campaignEpochEnd = campaignKnowledge.campaignEpochEnd;
        this.globalSamplerate = campaignKnowledge.globalSamplerate;
        this.resamplingMode = campaignKnowledge.resamplingMode;
        this.campaignName = campaignKnowledge.campaignName;
        this.referencePoint = campaignKnowledge.referencePoint;
        this.stationMap = campaignKnowledge.stationMap;
        this.pFKMap = campaignKnowledge.pFKMap;
        this.sFKMap = campaignKnowledge.sFKMap;
        this.repeatingValuesNan = campaignKnowledge.repeatingValuesNan;
    }

    @Override
    public void setValuesByValue(CampaignKnowledge campaignKnowledge) {
        this.setValues(campaignKnowledge);
        this.referencePoint = new MapPoint(this.referencePoint);
        this.stationMap = new StationOffset(this.stationMap);
        this.pFKMap = new FKMap(this.pFKMap);
        this.sFKMap = new FKMap(this.sFKMap);
    }

    @XmlElement(name="campaignstart")
    public final String getCampaignStart() {
        return DateTimeUtil.formatDateTimeISO(this.campaignEpochStart);
    }

    public final void setCampaignStart(String string) {
        try {
            this.setCampaignEpochStart(DateTimeUtil.parseDateTime(string).getTimeInMillis());
        }
        catch (ParseException parseException) {
            LogUtil.error(this.getClass(), "Bad date format: " + string, true);
        }
    }

    @XmlElement(name="campaignend")
    public final String getCampaignEnd() {
        return DateTimeUtil.formatDateTimeISO(this.campaignEpochEnd);
    }

    public final void setCampaignEnd(String string) {
        try {
            this.setCampaignEpochEnd(DateTimeUtil.parseDateTime(string).getTimeInMillis());
        }
        catch (ParseException parseException) {
            LogUtil.error(this.getClass(), "Bad date format: " + string, true);
        }
    }

    @XmlTransient
    public final long getCampaignEpochStart() {
        return this.campaignEpochStart;
    }

    public final void setCampaignEpochStart(long l) {
        this.campaignEpochStart = l;
    }

    @XmlTransient
    public final long getCampaignEpochEnd() {
        return this.campaignEpochEnd;
    }

    public final void setCampaignEpochEnd(long l) {
        this.campaignEpochEnd = l;
    }

    @XmlTransient
    public final float getGlobalSamplerate() {
        ResamplingMode resamplingMode = DefaultResamplingModes.getModeByIndex(this.resamplingMode);
        return resamplingMode.getMasterSamplingRate();
    }

    @XmlElement(name="resamplingmode")
    public final int getResamplingMode() {
        return this.resamplingMode;
    }

    public final void setResamplingMode(int n) {
        this.resamplingMode = n;
    }

    @XmlElement(name="referencepoint", required=true)
    public MapPoint getReferencePoint() {
        return this.referencePoint;
    }

    public void setReferencePoint(MapPoint mapPoint) {
        this.referencePoint = mapPoint;
    }

    @XmlElement(name="stationmap", required=true)
    public StationOffset getStationMap() {
        return this.stationMap;
    }

    public void setStationMap(StationOffset stationOffset) {
        this.stationMap = stationOffset;
    }

    @XmlAttribute(name="name", required=false)
    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String string) {
        this.campaignName = string;
    }

    @Override
    public void createDefault() {
        this.campaignEpochStart = Long.MAX_VALUE;
        this.campaignEpochEnd = Long.MIN_VALUE;
        this.globalSamplerate = Float.MAX_VALUE;
        for (TraceMetadata traceMetadata : SuiteManager.INSTANCE.getTraceProvider().requestMetadata(SuiteManager.INSTANCE.getTraceProvider().listTraces())) {
            if (traceMetadata.getOriginalSamplerate() < this.globalSamplerate) {
                this.globalSamplerate = traceMetadata.getOriginalSamplerate();
            }
            if (traceMetadata.getStartEpochTime() * 1000.0 < (double)this.campaignEpochStart) {
                this.campaignEpochStart = (long)traceMetadata.getStartEpochTime() * 1000L;
            }
            if (!(traceMetadata.getEndEpochTime() * 1000.0 > (double)this.campaignEpochEnd)) continue;
            this.campaignEpochEnd = (long)traceMetadata.getEndEpochTime() * 1000L;
        }
    }

    @XmlElement(name="pfkmap", required=true)
    public FKMap getpFKMap() {
        return this.pFKMap;
    }

    public void setpFKMap(FKMap fKMap) {
        this.pFKMap = fKMap;
    }

    @XmlElement(name="sfkmap", required=true)
    public FKMap getsFKMap() {
        return this.sFKMap;
    }

    public void setfsKMap(FKMap fKMap) {
        this.sFKMap = fKMap;
    }

    @XmlElement(name="repeatingValuesNan")
    public boolean getRepeatingValuesNan() {
        return this.repeatingValuesNan;
    }

    public void setRepeatingValuesNan(boolean bl) {
        this.repeatingValuesNan = bl;
    }

    @XmlType(name="MapPoint", propOrder={"latitude", "longitude", "height"})
    public static class MapPoint {
        private double latitude = 0.0;
        private double longitude = 0.0;
        private double height = 0.0;

        public MapPoint() {
        }

        public MapPoint(MapPoint mapPoint) {
            this();
            this.setValues(mapPoint);
        }

        public double getLatitude() {
            return this.latitude;
        }

        public void setLatitude(double d) {
            this.latitude = d;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public void setLongitude(double d) {
            this.longitude = d;
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double d) {
            this.height = d;
        }

        public void setValues(MapPoint mapPoint) {
            this.height = mapPoint.getHeight();
            this.latitude = mapPoint.getLatitude();
            this.longitude = mapPoint.getLongitude();
        }
    }

    @XmlType(name="FKMap", propOrder={"length", "shift", "flow", "fup"})
    public static class FKMap {
        private double length = 1.0;
        private double shift = 3.0;
        private double flow = 2.0;
        private double fup = 4.0;

        public FKMap() {
        }

        public FKMap(FKMap fKMap) {
            this();
            this.setValues(fKMap);
        }

        public void setValues(FKMap fKMap) {
            this.length = fKMap.length;
            this.shift = fKMap.shift;
            this.flow = fKMap.flow;
            this.fup = fKMap.fup;
        }

        public double getLength() {
            return this.length;
        }

        public void setLength(double d) {
            this.length = d;
        }

        public double getShift() {
            return this.shift;
        }

        public void setShift(double d) {
            this.shift = d;
        }

        public double getFlow() {
            return this.flow;
        }

        public void setFlow(double d) {
            this.flow = d;
        }

        public double getFup() {
            return this.fup;
        }

        public void setFup(double d) {
            this.fup = d;
        }
    }

    @XmlType(name="StationOffset", propOrder={"halfsize", "XOffset", "YOffset"})
    public static class StationOffset {
        private double xOffset = 0.0;
        private double yOffset = 0.0;
        private double halfsize = 2.0;

        public StationOffset() {
        }

        public StationOffset(StationOffset stationOffset) {
            this();
            this.setValues(stationOffset);
        }

        @XmlElement(name="x-offset")
        public double getXOffset() {
            return this.xOffset;
        }

        public void setXOffset(double d) {
            this.xOffset = d;
        }

        @XmlElement(name="y-offset")
        public double getYOffset() {
            return this.yOffset;
        }

        public void setYOffset(double d) {
            this.yOffset = d;
        }

        public double getHalfsize() {
            return this.halfsize;
        }

        public void setHalfsize(double d) {
            this.halfsize = d;
        }

        public void setValues(StationOffset stationOffset) {
            this.xOffset = stationOffset.getXOffset();
            this.yOffset = stationOffset.getYOffset();
            this.halfsize = stationOffset.getHalfsize();
        }
    }
}

