/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.layer;

import java.text.ParseException;
import java.util.LinkedList;

public class Layer {
    public static final String CSV_HEADER = "# Thickness [km], vP [km/s], (vS [km/s]), (Wavetype [pn|pg])";
    private double d = -1.0;
    private double vP = 8.0;
    private double vS = -1.0;
    private WaveType wavetype = WaveType.Unknown;

    public Layer() {
    }

    public Layer(double d, double d2, double d3, WaveType waveType) {
        this.d = d;
        this.vP = d2;
        this.vS = d3;
        this.wavetype = waveType;
    }

    public Layer clone() {
        return new Layer(this.d, this.vP, this.vS, this.wavetype);
    }

    public static Layer fromCsv(String[] stringArray) throws ParseException, NumberFormatException {
        WaveType waveType;
        Layer layer = new Layer();
        int n = stringArray.length;
        if (n < 2 || n > 4) {
            throw new ParseException(String.format("layer description contains bad number of fields (%d). Min:2 Max:4", n), 0);
        }
        layer.setD(Double.parseDouble(stringArray[0].strip()));
        layer.setVp(Double.parseDouble(stringArray[1].strip()));
        if (n == 2) {
            return layer;
        }
        try {
            double d = Double.parseDouble(stringArray[2].strip());
            layer.setVs(d);
        }
        catch (NumberFormatException numberFormatException) {
            waveType = WaveType.parseCaseInsensitive(stringArray[2].strip());
            if (waveType == null) {
                throw new ParseException("third field does contain neither wavetype nor vS velocity", 2);
            }
            layer.setWavetype(waveType);
        }
        if (n == 3) {
            return layer;
        }
        waveType = WaveType.parseCaseInsensitive(stringArray[3].strip());
        if (waveType == null) {
            throw new ParseException("fourth field does contain known wavetype ", 3);
        }
        layer.setWavetype(waveType);
        return layer;
    }

    public double getD() {
        return this.d;
    }

    public void setD(double d) {
        this.d = d;
    }

    public double getVp() {
        return this.vP;
    }

    public void setVp(double d) {
        this.vP = d;
    }

    public double getVs() {
        return this.vS;
    }

    public void setVs(double d) {
        this.vS = d;
    }

    public WaveType getWavetype() {
        return this.wavetype;
    }

    public void setWavetype(WaveType waveType) {
        this.wavetype = waveType;
    }

    public boolean hasVs() {
        return this.vS > 0.0 && !Double.isNaN(this.vS);
    }

    public boolean isHalfspace() {
        return this.d <= 0.0;
    }

    public String toString() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add("d[km]: " + (this.isHalfspace() ? "  inf" : String.format("%5.3f", this.d)));
        linkedList.add(String.format("vp[km/s]: %5.3f", this.vP));
        if (!Double.isNaN(this.vS) && this.vS > 0.0) {
            linkedList.add(String.format("vs[km/s]: %5.3f", this.vS));
        }
        if (this.wavetype != WaveType.Unknown) {
            linkedList.add(this.wavetype.name());
        }
        return String.join((CharSequence)", ", linkedList);
    }

    public String toCsvString() {
        Object object = String.format("%.2f, %.2f", this.d, this.vP);
        if (this.hasVs()) {
            object = (String)object + String.format(", %.2f", this.vS);
        }
        if (this.wavetype != WaveType.Unknown) {
            object = (String)object + String.format(", %s", this.wavetype.name());
        }
        return object;
    }

    public double getVp2vs() {
        return this.hasVs() ? this.vP / this.vS : -1.0;
    }

    public static enum WaveType {
        Unknown,
        Pg,
        Pn;


        public static WaveType parseCaseInsensitive(String string) {
            if (string.isEmpty()) {
                return Unknown;
            }
            for (WaveType waveType : WaveType.values()) {
                if (!waveType.name().equalsIgnoreCase(string)) continue;
                return waveType;
            }
            return null;
        }
    }
}

