/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles.converters;

import edu.geophys.commons.model.tracefiles.NativeDataType;
import edu.geophys.commons.model.tracefiles.Utility;
import edu.geophys.commons.model.tracefiles.converters.HeaderLine;
import edu.geophys.commons.util.FileUtil;
import edu.geophys.commons.util.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.io.FileUtils;

public class MiniSeedToCSS {
    public List<HeaderLine> convert(File file, File file2, int n, boolean bl, float f, float f2, boolean bl2) {
        return this.convert(file, file2, n, bl, f, f2, bl2, WriteRule.CANCEL);
    }

    public List<HeaderLine> convert(File file, File file2, int n, boolean bl, float f, float f2, boolean bl2, WriteRule writeRule) {
        ArrayList<HeaderLine> arrayList = new ArrayList<HeaderLine>();
        if (!file.exists()) {
            LogUtil.error(this.getClass(), "Directory (" + file.getAbsolutePath() + ") does not exist.");
            return arrayList;
        }
        if (file2 != null && writeRule.equals((Object)WriteRule.CANCEL) && file2.exists()) {
            LogUtil.error(this.getClass(), "Headerfile (" + file2.getAbsolutePath() + ") already exists.");
            return arrayList;
        }
        if (n < 0) {
            LogUtil.error(this.getClass(), "Chunksize (" + n + ") smaller zero.");
            return arrayList;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder, Locale.US);
        ArrayList<File> arrayList2 = new ArrayList<File>();
        if (file.isDirectory()) {
            arrayList2.addAll(FileUtils.listFiles((File)file, null, (boolean)bl2));
            Collections.sort(arrayList2);
        } else {
            arrayList2.add(file);
        }
        for (File object : arrayList2) {
            if (object.isDirectory()) continue;
            LogUtil.info(this.getClass(), "Processing file " + object.getName());
            List<HeaderLine> list = this.probeFile(object, f2, f, n, bl);
            for (HeaderLine headerLine : list) {
                arrayList.add(headerLine);
                formatter.format("%s %.5f %s %s %s %.1f %.2f %s %s %s %s %s \n", headerLine.getDate(), headerLine.getEpoch(), headerLine.getStat(), headerLine.getChan(), headerLine.getNsamp(), Float.valueOf(headerLine.getSamprate()), Float.valueOf(headerLine.getCalibm()), Float.valueOf(headerLine.getCalper()), headerLine.getDattyp(), headerLine.getDirectory(), headerLine.getFilename(), headerLine.getByteOffset());
                LogUtil.info(this.getClass(), stringBuilder.toString());
            }
        }
        if (file2 != null) {
            LogUtil.info(this.getClass(), "Writing header.");
            if (stringBuilder.length() != 0) {
                try {
                    boolean bl3 = writeRule.equals((Object)WriteRule.APPEND);
                    PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file2, bl3)));
                    printWriter.append(stringBuilder);
                    printWriter.close();
                    LogUtil.info(this.getClass(), "Created header " + file2.getAbsolutePath() + ".");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                LogUtil.info(this.getClass(), "Empty header, so no header created.", true);
            }
        } else {
            LogUtil.info(this.getClass(), "No header file given, so no header created.", false);
        }
        formatter.close();
        return arrayList;
    }

    public List<HeaderLine> probeFile(File file) {
        return this.probeFile(file, 1.0f, 1.0f, 60, false);
    }

    public List<HeaderLine> probeFile(File file, float f, float f2, int n, boolean bl) {
        ArrayList<HeaderLine> arrayList = new ArrayList<HeaderLine>();
        LogUtil.info(this.getClass(), "Processing file " + file.getName());
        String string = "";
        double d = 0.0;
        double d2 = 0.0;
        String string2 = "";
        String string3 = "";
        float f3 = 0.0f;
        String string4 = "";
        String string5 = "";
        float f4 = 0.0f;
        long l = 0L;
        long l2 = 0L;
        String string6 = file.getParent();
        String string7 = file.getName();
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        byte[] byArray = new byte[64];
        double d3 = 0.0;
        String string8 = "";
        double d4 = 0.0;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        try {
            Calendar calendar;
            String string9;
            boolean bl6;
            int n2;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            NativeDataType nativeDataType = null;
            while (true) {
                dataInputStream.readFully(byArray);
                if (nativeDataType == null && (nativeDataType = this.getFileformat(byArray)) == null) {
                    LogUtil.error(this.getClass(), "No valid miniSEED file " + file.getName());
                    throw new EOFException();
                }
                n2 = nativeDataType.byteSize;
                bl6 = nativeDataType.byteOrder.equals(ByteOrder.LITTLE_ENDIAN);
                string9 = nativeDataType.name();
                FileUtil.skipFully(dataInputStream, n2 - byArray.length);
                calendar = MiniSeedToCSS.getCalFromMSEED(byArray, bl6);
                double d5 = (double)Utility.bytesToInt(byArray[28], byArray[29], bl6) / 10000.0;
                d = (double)(calendar.getTimeInMillis() / 1000L) + d5;
                l = Utility.bytesToShort(byArray[30], byArray[31], bl6);
                byte[] byArray2 = new byte[5];
                System.arraycopy(byArray, 8, byArray2, 0, byArray2.length);
                string2 = new String(byArray2).trim();
                byte[] byArray3 = new byte[3];
                System.arraycopy(byArray, 15, byArray3, 0, byArray3.length);
                string3 = new String(byArray3).trim();
                f3 = MiniSeedToCSS.getSampleRate(Utility.bytesToShort(byArray[32], byArray[33], bl6), Utility.bytesToShort(byArray[34], byArray[35], bl6));
                if (d + 1.0E-4 < d2) {
                    bl3 = true;
                }
                if (!bl2 && d > d2 + 1.0E-4) {
                    bl3 = true;
                }
                double d6 = (float)l / f3;
                d2 = d + d6;
                if (!string5.equals(string3) || !string4.equals(string2) || f4 != f3) {
                    if (!bl2) {
                        bl3 = true;
                        bl4 = true;
                    }
                    d4 = d;
                    string = String.format("%04d%03d", calendar.get(1), calendar.get(6));
                }
                if (bl3) {
                    l4 = l3;
                }
                if (bl2) {
                    d3 = d;
                    string8 = String.format("%04d%03d", calendar.get(1), calendar.get(6));
                    d4 = d;
                    string5 = string3;
                    string4 = string2;
                    f4 = f3;
                }
                if (n != 0 && d - d4 >= (double)(n * 60) && !bl3) {
                    bl4 = true;
                    d4 = d;
                }
                if (bl) break;
                if (bl3 || bl4 || file.length() - (long)n2 <= l3) {
                    if (file.length() - (long)n2 <= l3) {
                        l2 += l;
                    }
                    arrayList.add(new HeaderLine(string8, d3, string4, string5, l2, f4, f, f2, string9, string6, string7, l5));
                    l2 = 0L;
                    l5 = l4;
                    d3 = d;
                    string8 = String.format("%04d%03d", calendar.get(1), calendar.get(6));
                    bl3 = false;
                    if (bl4) {
                        l5 = l3;
                        string = String.format("%04d%03d", calendar.get(1), calendar.get(6));
                        bl4 = false;
                    }
                }
                l3 += (long)n2;
                l2 += l;
                string5 = string3;
                string4 = string2;
                f4 = f3;
                bl2 = false;
            }
            MiniSeedToCSS.skipFully(dataInputStream, file.length() - (long)(2 * n2));
            dataInputStream.readFully(byArray);
            FileUtil.skipFully(dataInputStream, n2 - byArray.length);
            Calendar calendar2 = MiniSeedToCSS.getCalFromMSEED(byArray, bl6);
            long l6 = Utility.bytesToShort(byArray[30], byArray[31], bl6);
            l = (long)((float)(calendar2.getTimeInMillis() - calendar.getTimeInMillis()) / 1000.0f * f3) + l6;
            arrayList.add(new HeaderLine(string, d, string2, string3, l, f3, f, f2, string9, string6, string7, l3));
        }
        catch (EOFException eOFException) {
            LogUtil.info(this.getClass(), "End of file " + file.getName() + " reached.");
            bl5 = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (!bl5) {
            LogUtil.error(this.getClass(), "<html>Import did not reach end of file: " + file.getName() + "<br>This can mean that the file contains multiple traces which is not supported yet.<html>");
        }
        return arrayList;
    }

    public NativeDataType getFileformat(byte[] byArray) {
        ByteOrder byteOrder;
        boolean bl = false;
        Calendar calendar = MiniSeedToCSS.getCalFromMSEED(byArray, bl);
        if (!this.checkCalendar(calendar)) {
            bl = true;
            calendar = MiniSeedToCSS.getCalFromMSEED(byArray, bl);
        }
        if (!this.checkCalendar(calendar)) {
            LogUtil.error(this.getClass(), "No valid miniSEED file.");
            return null;
        }
        LogUtil.info(this.getClass(), "Header swapbytes (false Big Endian, true Little Endian): " + bl);
        int n = 48;
        short s = Utility.bytesToShort(byArray[0 + n], byArray[1 + n], bl);
        if (s == 1001) {
            s = Utility.bytesToShort(byArray[0 + (n += 8)], byArray[1 + n], bl);
        }
        int n2 = Utility.bytesToInt(byArray[4 + n]);
        int n3 = Utility.bytesToInt(byArray[5 + n]);
        int n4 = Utility.bytesToInt(byArray[6 + n]);
        n4 = (int)Math.round(Math.pow(2.0, n4));
        LogUtil.info(this.getClass(), "Blockette type - 1000: " + s);
        LogUtil.info(this.getClass(), "Encoding format (10 Steim1, 11 Steim2): " + n2);
        LogUtil.info(this.getClass(), "Word order (0 little-eandian, 1 big-endian): " + n3);
        LogUtil.info(this.getClass(), "Data record length: " + n4);
        if (s != 1000) {
            LogUtil.error(this.getClass(), "Only miniseed blockette number 1000 is supported: " + s);
            return null;
        }
        if (n2 != 10 && n2 != 11) {
            LogUtil.error(this.getClass(), "Only STEIM1 and STEIM2 encoding is supported: " + n2);
            return null;
        }
        if (n4 != 512 && n4 != 1024 && n4 != 4096) {
            LogUtil.error(this.getClass(), "Only record lengths 512, 1024 and 4096 are supported: " + n4);
        }
        ByteOrder byteOrder2 = byteOrder = bl ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        if (n3 != 0 && n3 != 1) {
            LogUtil.warn(this.getClass(), "Invalid word order, we use the one from the header: " + n3);
        } else {
            byteOrder = n3 == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        }
        NativeDataType.CompressionFormat compressionFormat = n2 == 10 ? NativeDataType.CompressionFormat.STEIM1 : NativeDataType.CompressionFormat.STEIM2;
        NativeDataType nativeDataType = MiniSeedToCSS.getNativeDataType(n4, compressionFormat, byteOrder);
        return nativeDataType;
    }

    private boolean checkCalendar(Calendar calendar) {
        return calendar.get(1) >= 1900 && calendar.get(1) <= 2100;
    }

    public static float getSampleRate(double d, double d2) {
        float f = 10000.0f;
        if (d * d2 != 0.0) {
            f = (float)(Math.pow(Math.abs(d), d / Math.abs(d)) * Math.pow(Math.abs(d2), d2 / Math.abs(d2)));
        }
        return f;
    }

    private static Calendar getCalFromMSEED(byte[] byArray, boolean bl) {
        short s = Utility.bytesToShort(byArray[20], byArray[21], bl);
        short s2 = Utility.bytesToShort(byArray[22], byArray[23], bl);
        int n = Utility.bytesToInt(byArray[24]);
        int n2 = Utility.bytesToInt(byArray[25]);
        int n3 = Utility.bytesToInt(byArray[26]);
        int n4 = Utility.bytesToInt(byArray[28], byArray[29], bl);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.set(1, s);
        calendar.set(6, s2);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, n4 / 10);
        return calendar;
    }

    public static void skipFully(DataInputStream dataInputStream, long l) throws IOException {
        long l2;
        for (long i = l; i != 0L; i -= l2) {
            l2 = dataInputStream.skip(i);
            if (l2 != 0L) continue;
            throw new EOFException();
        }
    }

    public static NativeDataType getNativeDataType(int n, NativeDataType.CompressionFormat compressionFormat, ByteOrder byteOrder) {
        NativeDataType nativeDataType = NativeDataType.d0;
        if (n == 512) {
            if (compressionFormat == NativeDataType.CompressionFormat.STEIM1) {
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    nativeDataType = NativeDataType.ms;
                } else if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    nativeDataType = NativeDataType.msl;
                }
            } else if (compressionFormat == NativeDataType.CompressionFormat.STEIM2) {
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    nativeDataType = NativeDataType.ms2;
                } else if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    nativeDataType = NativeDataType.ms2l;
                }
            }
        } else if (n == 1024) {
            if (compressionFormat == NativeDataType.CompressionFormat.STEIM1) {
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    nativeDataType = NativeDataType.m1;
                } else if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    nativeDataType = NativeDataType.m1l;
                }
            } else if (compressionFormat == NativeDataType.CompressionFormat.STEIM2) {
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    nativeDataType = NativeDataType.m12;
                } else if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    nativeDataType = NativeDataType.m12l;
                }
            }
        } else if (n == 4096) {
            if (compressionFormat == NativeDataType.CompressionFormat.STEIM1) {
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    nativeDataType = NativeDataType.m4;
                } else if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    nativeDataType = NativeDataType.m4l;
                }
            } else if (compressionFormat == NativeDataType.CompressionFormat.STEIM2) {
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    nativeDataType = NativeDataType.m42;
                } else if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    nativeDataType = NativeDataType.m42l;
                }
            }
        }
        return nativeDataType;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            stringArray = new String[]{"/home/peter/mseed/BRANT.HHZ.2014-07-30.mseed"};
        }
        File file = new File(".").getAbsoluteFile();
        int n = 0;
        boolean bl = false;
        float f = 1.0f;
        float f2 = 1.0f;
        for (String string : stringArray) {
            string = string.trim();
            try {
                if (string.startsWith("--")) {
                    if (string.startsWith("--help") || string.startsWith("-h")) {
                        System.out.println("Usage:\njava -jar MiniSeedToCSS.jar [--chunksize=0 --fast --calper=1.0 --calibm=1.0 directory]\nAll arguments are optional, the default is given above.\nchunksize: minutes\nfast: for fast encoding (potentially dangerous!)\ncalper: float value\ncalibm: float value\ndirectory: default is to use the current directory\nAbsolutely no warranty, for questions contact benjamin.sick@gmail.com");
                        System.exit(0);
                        continue;
                    }
                    if (string.startsWith("--chunksize=")) {
                        n = Integer.parseInt(string.substring("--chunksize=".length()));
                        continue;
                    }
                    if (string.startsWith("--fast")) {
                        bl = true;
                        continue;
                    }
                    if (string.startsWith("--calper")) {
                        f = Float.parseFloat(string);
                        continue;
                    }
                    if (!string.startsWith("--calibm")) continue;
                    f2 = Float.parseFloat(string);
                    continue;
                }
                file = new File(string);
                if (file.canRead() && file.canWrite()) continue;
                System.err.println("Directory invalid or no read or write permissions.");
                System.exit(0);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Invalid chunk size, calper, calibm or data type values.");
                System.exit(0);
            }
        }
        File file2 = file.isDirectory() ? new File(file.getAbsoluteFile() + File.separator + "header.sht") : new File(file.getParentFile().getAbsoluteFile() + File.separator + "header.sht");
        if (file2.exists()) {
            System.err.println("Headerfile header.sht already exists.");
            System.exit(0);
        }
        new MiniSeedToCSS().convert(file, file2, n, bl, f, f2, true);
    }

    public static enum WriteRule {
        CANCEL,
        APPEND,
        OVERWRITE;

    }
}

