/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles.converters.m24;

import edu.geophys.commons.model.tracefiles.converters.TimeHelper;
import edu.geophys.commons.model.tracefiles.converters.m24.M24TraceMetaModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class M24File
extends RandomAccessFile {
    private final int START = 0;
    private final int REC_NUMBER = 8;
    private final int TRACE_NUMBER = 12;
    private final int ID_CODE = 28;
    private final int NUMBER_OF_SAMPLES = 228;
    private final int SAMPLE_INTERVAL = 200;
    private final int DATA_BLOCK_START = 240;
    private final int DATE_BLOCK = 156;
    private boolean _valid = false;

    public M24File(File file) throws FileNotFoundException, IOException {
        super(file, "r");
        this.seek(28L);
        this._valid = Short.reverseBytes(this.readShort()) == 1;
    }

    private M24File(File file, String string) throws FileNotFoundException {
        super(file, string);
    }

    private M24File(String string, String string2) throws FileNotFoundException {
        super(string, string2);
    }

    public boolean isValid() {
        return this._valid;
    }

    private M24TraceMetaModel readTraceHeader() throws IOException {
        M24TraceMetaModel m24TraceMetaModel = new M24TraceMetaModel();
        this.seek(0L);
        this.seek(8L);
        this.seek(12L);
        this.seek(228L);
        int n = Integer.reverseBytes(this.readInt());
        this.seek(200L);
        short s = Short.reverseBytes(this.readShort());
        this.seek(156L);
        short s2 = Short.reverseBytes(this.readShort());
        short s3 = Short.reverseBytes(this.readShort());
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.set(1, s2);
        gregorianCalendar.set(6, s3 + 1);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        double d = TimeHelper.calendarToEpoch(gregorianCalendar);
        double d2 = 1.0 / (double)s * 1000000.0;
        m24TraceMetaModel.setOffset(240);
        m24TraceMetaModel.setSamples(n);
        m24TraceMetaModel.setSamplerate(d2);
        m24TraceMetaModel.setAcquisitionStartYearDay(String.format("%d%03d", s2, s3));
        m24TraceMetaModel.setAcquisitionStart(d);
        return m24TraceMetaModel;
    }

    public M24TraceMetaModel readMetaData() throws IOException {
        return this.readTraceHeader();
    }
}

