/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles.converters.seg2;

import edu.geophys.commons.model.tracefiles.converters.TimeHelper;
import edu.geophys.commons.model.tracefiles.converters.seg2.Seg2TraceMetaModel;
import edu.geophys.commons.util.LogUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class Seg2MetaModel
implements Comparable<Seg2MetaModel> {
    private static final String KEY_ACQUISITION_DATE_UTC = "ACQUISITION_DATE_UTC";
    private static final String KEY_ACQUISITION_TIME_UTC = "ACQUISITION_TIME_UTC";
    private static final String KEY_ACQUISITION_TIME_MICROSECONDS = "ACQUISITION_TIME_MICROSECONDS";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MMM/yyyy HH:mm:ss", Locale.ENGLISH);
    private ArrayList<Seg2TraceMetaModel> _childs = new ArrayList();
    private Map<String, String> _fileDescription;
    private int _revision;
    private double _acquisitionStart;

    public Seg2MetaModel(int n) {
        for (int i = 0; i < n; ++i) {
            this._childs.add(new Seg2TraceMetaModel(this));
        }
    }

    public Seg2TraceMetaModel getChild(int n) {
        return this._childs.get(n);
    }

    public final ArrayList<Seg2TraceMetaModel> getChilds() {
        return this._childs;
    }

    public final void setChilds(ArrayList<Seg2TraceMetaModel> arrayList) {
        this._childs = arrayList;
    }

    public final Map<String, String> getFileDescription() {
        return this._fileDescription;
    }

    public final void setFileDescription(Map<String, String> map) {
        this._fileDescription = map;
        Object object = "";
        try {
            object = this._fileDescription.get(KEY_ACQUISITION_DATE_UTC) + " " + this._fileDescription.get(KEY_ACQUISITION_TIME_UTC);
            Date date = DATE_FORMAT.parse((String)object);
            double d = Double.parseDouble(this._fileDescription.get(KEY_ACQUISITION_TIME_MICROSECONDS));
            this._acquisitionStart = TimeHelper.longMillisecondsToDoubleSeconds(date.getTime());
            this._acquisitionStart = (this._acquisitionStart * 1000000.0 + d) / 1000000.0;
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            LogUtil.error(this.getClass(), "Could not parse date " + (String)object);
        }
    }

    public final int getRevision() {
        return this._revision;
    }

    public final void setRevision(int n) {
        this._revision = n;
    }

    public int numberOfTraces() {
        return this._childs.size();
    }

    public String getInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format(" File Revision: %d\n", this.getRevision()));
        stringBuffer.append(String.format(" Number of Traces: %d\n", this.numberOfTraces()));
        stringBuffer.append(String.format(" File description:\n", new Object[0]));
        for (String string : this.getFileDescription().keySet()) {
            stringBuffer.append(String.format("   %s: %s\n", string, this.getFileDescription().get(string)));
        }
        for (int i = 0; i < this._childs.size(); ++i) {
            stringBuffer.append(String.format(" Trace No. %d:\n", i + 1));
            stringBuffer.append(this._childs.get(i).getInfo());
        }
        return stringBuffer.toString();
    }

    public String getSHTPart(String[] stringArray, String string, String string2, float f, float f2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._childs.size(); ++i) {
            if (i >= stringArray.length || stringArray[i] == null) continue;
            String string3 = stringArray[i].split("-")[0];
            String string4 = stringArray[i].split("-")[1];
            stringBuffer.append(this._childs.get(i).getSHTLine(string3, string4, string, string2, f, f2, n));
        }
        return stringBuffer.toString();
    }

    public double getAcquisitionStart() {
        return this._acquisitionStart;
    }

    @Override
    public int compareTo(Seg2MetaModel seg2MetaModel) {
        int n = Double.compare(this.getAcquisitionStart(), seg2MetaModel.getAcquisitionStart());
        return n == 0 ? 1 : n;
    }

    static {
        DATE_FORMAT.setTimeZone(TimeHelper.TIMEZONE_UTC);
    }
}

