/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.range;

import edu.geophys.commons.range.DefaultRangeMarkerModel;
import edu.geophys.commons.range.RangeDataEvent;
import edu.geophys.commons.range.RangeDataListener;
import edu.geophys.commons.range.RangeMarker;
import edu.geophys.commons.range.RangeMarkerModel;
import edu.geophys.commons.range.RangeMarkerModelChild;
import edu.geophys.commons.util.MathUtil;

public class DefaultRangeMarkerModelChild<E>
extends DefaultRangeMarkerModel<E>
implements RangeMarkerModelChild<E>,
RangeDataListener {
    protected final RangeMarkerModel<E> _parent;
    protected final String _startId;
    protected final String _endId;
    protected double _startInParentSpace;
    protected double _endInParentSpace;
    protected double _deltaInParentSpace;

    private DefaultRangeMarkerModelChild() {
        throw new IllegalArgumentException("not yet implementet");
    }

    DefaultRangeMarkerModelChild(RangeMarkerModel<E> rangeMarkerModel, String string, String string2) {
        this._parent = rangeMarkerModel;
        this._startId = string;
        this._endId = string2;
        this.updateRange();
        rangeMarkerModel.addMarkerDataListener(this);
    }

    private boolean containsMarker(double d) {
        return d >= this._startInParentSpace && d <= this._endInParentSpace;
    }

    private double convertToParent(double d) {
        return this._startInParentSpace + d * this._deltaInParentSpace;
    }

    private double convertFromParent(double d) {
        return MathUtil.convertToRelative(d - this._startInParentSpace, this._deltaInParentSpace);
    }

    private void updateRange() {
        this._startInParentSpace = this._parent.getMarker(this._startId).getPosition();
        this._endInParentSpace = this._parent.getMarker(this._endId).getPosition();
        this._deltaInParentSpace = this._endInParentSpace - this._startInParentSpace;
        this.clearAllMarkers();
        for (RangeMarker rangeMarker : this._parent.getSortedMarkers()) {
            this.addNewMarker(rangeMarker.getID(), this.convertFromParent(rangeMarker.getPosition()), rangeMarker.getValue());
        }
        this.fireAllChanged();
    }

    @Override
    public void moveMarker(double d, String ... stringArray) {
        this._parent.moveMarker(d, stringArray);
    }

    @Override
    public void clearMarker(String string) {
        this._parent.clearMarker(string);
    }

    @Override
    public void setMarker(String string, double d, E e) {
        this._parent.setMarker(string, this.convertToParent(d), e);
    }

    @Override
    public final String getEndId() {
        return this._endId;
    }

    @Override
    public final RangeMarkerModel<E> getParent() {
        return this._parent;
    }

    @Override
    public final String getStartId() {
        return this._startId;
    }

    @Override
    public void markerAdded(RangeDataEvent rangeDataEvent) {
        super.setMarker(rangeDataEvent.getMarker().getID(), this.convertFromParent(rangeDataEvent.getMarker().getPosition()), rangeDataEvent.getMarker().getValue());
    }

    @Override
    public void markerRemoved(RangeDataEvent rangeDataEvent) {
        super.clearMarker(rangeDataEvent.getMarker().getID());
    }

    @Override
    public void positionChanged(RangeDataEvent rangeDataEvent) {
        if (rangeDataEvent.getMarker().getID().compareTo(this._startId) == 0 || rangeDataEvent.getMarker().getID().compareTo(this._endId) == 0) {
            this.updateRange();
        } else {
            super.setMarker(rangeDataEvent.getMarker().getID(), this.convertFromParent(rangeDataEvent.getMarker().getPosition()), rangeDataEvent.getMarker().getValue());
        }
    }

    @Override
    public void valueChanged(RangeDataEvent rangeDataEvent) {
        super.setMarker(rangeDataEvent.getMarker().getID(), this.convertFromParent(rangeDataEvent.getMarker().getPosition()), rangeDataEvent.getMarker().getValue());
    }

    @Override
    public void allChanged(RangeDataEvent rangeDataEvent) {
        this.updateRange();
    }
}

