/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.range;

import edu.geophys.commons.range.RangeMarkerModel;
import java.util.Comparator;

public class RangeMarker<E>
implements Comparable<RangeMarker> {
    public static final Comparator<RangeMarker> DEFAULT_COMPARATOR = new RangeMarkerNaturalOrder();
    private double _position;
    private String _id;
    private E _value;
    private RangeMarkerModel _model;

    public RangeMarker(RangeMarkerModel rangeMarkerModel, String string) {
        this._model = rangeMarkerModel;
        this._id = string;
    }

    public RangeMarker(RangeMarkerModel rangeMarkerModel, String string, double d, E e) {
        this._model = rangeMarkerModel;
        this._id = string;
        this._position = d;
        this._value = e;
    }

    public final double getPosition() {
        return this._position;
    }

    public final String getID() {
        return this._id;
    }

    void setPosition(double d) {
        this._position = d;
    }

    public E getValue() {
        return this._value;
    }

    void setValue(E e) {
        this._value = e;
    }

    @Override
    public int compareTo(RangeMarker rangeMarker) {
        return DEFAULT_COMPARATOR.compare(this, rangeMarker);
    }

    public static class RangeMarkerNaturalOrder<T>
    implements Comparator<RangeMarker<T>> {
        @Override
        public int compare(RangeMarker<T> rangeMarker, RangeMarker<T> rangeMarker2) {
            int n = (int)Math.signum(rangeMarker.getPosition() - rangeMarker2.getPosition());
            if (n == 0) {
                n = rangeMarker.getID().compareTo(rangeMarker2.getID());
            }
            return n;
        }
    }
}

