/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.suite;

import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.model.TraceMetadata;
import edu.geophys.commons.model.headerfiles.HeaderDatabase;
import edu.geophys.commons.suite.TraceProvider;

public class DefaultTraceProvider
implements TraceProvider {
    private final HeaderDatabase _database;

    public DefaultTraceProvider(HeaderDatabase headerDatabase) {
        this._database = headerDatabase;
    }

    public final HeaderDatabase getDatabase() {
        return this._database;
    }

    @Override
    public boolean isReady() {
        return this.getDatabase() != null && this.getDatabase().sizeHeaders() >= 1;
    }

    @Override
    public String[] listTraces() {
        String[] stringArray = this.getDatabase().listTraces();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Override
    public boolean[] hasStation(String ... stringArray) throws IllegalArgumentException {
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            blArray[i] = this.getDatabase().hasStation(stringArray[i]);
        }
        return blArray;
    }

    @Override
    public double startOfStation(String ... stringArray) throws IllegalArgumentException {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.getDatabase().hasStation(stringArray[i])) continue;
            d = StrictMath.min(d, this.getDatabase().getStartOfStationData(stringArray[i]));
        }
        if (d == Double.MAX_VALUE) {
            d = -1.0;
        }
        return d;
    }

    @Override
    public double endOfStation(String ... stringArray) throws IllegalArgumentException {
        double d = Double.MIN_VALUE;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.getDatabase().hasStation(stringArray[i])) continue;
            d = StrictMath.max(d, this.getDatabase().getEndOfStationData(stringArray[i]));
        }
        if (d == Double.MIN_VALUE) {
            d = -1.0;
        }
        return d;
    }

    @Override
    public TraceMetadata[] requestMetadata(String ... stringArray) throws IllegalArgumentException {
        TraceMetadata[] traceMetadataArray = new TraceMetadata[stringArray.length];
        for (int i = 0; i < traceMetadataArray.length; ++i) {
            traceMetadataArray[i] = this.getDatabase().getMetadata(stringArray[i]);
        }
        return traceMetadataArray;
    }

    @Override
    public DefaultTrace[] requestTrace(double d, double d2, float f, String ... stringArray) throws IllegalArgumentException {
        DefaultTrace[] defaultTraceArray = new DefaultTrace[stringArray.length];
        for (int i = 0; i < defaultTraceArray.length; ++i) {
            defaultTraceArray[i] = this.getDatabase().getTrace(stringArray[i], d, d2, f);
        }
        return defaultTraceArray;
    }

    @Override
    public DefaultTrace[] requestTrace(double d, int n, float f, String ... stringArray) throws IllegalArgumentException {
        DefaultTrace[] defaultTraceArray = new DefaultTrace[stringArray.length];
        for (int i = 0; i < defaultTraceArray.length; ++i) {
            defaultTraceArray[i] = this.getDatabase().getTrace(stringArray[i], d, n, f);
        }
        return defaultTraceArray;
    }
}

