/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.themes;

import com.formdev.flatlaf.FlatDarkLaf;
import edu.geophys.commons.themes.SuiteTheme;
import java.awt.Color;

class DarkTheme
extends SuiteTheme {
    private static final Color[] PALETTE = new Color[]{new Color(0, 223, 162), new Color(153, 235, 1), new Color(255, 128, 0), new Color(0, 153, 198), new Color(171, 125, 255), new Color(193, 131, 0)};
    private static final Color HYPOLINE_RED = Color.decode("#FF2222");
    private static final Color HYPOLINE_BLUE = Color.decode("#0080FF");
    private static final Color HYPOLINE_GREEN = Color.decode("#009400");
    private static final Color HYPOLINE_GOLD = Color.decode("#E0C600");
    private static final Color Z_CENTER_COLOR = Color.decode("#F0F0F0");
    private static final Color H_CENTER_COLOR = Color.decode("#3c8c3c");
    private static final Color Z_SATTELITE_COLOR = Color.decode("#1eb7e6");
    private static final Color ME_COLOR = Color.decode("#FF00FF");
    private static final Color AXIS_COLOR = Color.GRAY;
    private static Color plotBackgroundColor = null;
    private static Color plotForegroundColor = null;
    private static Color UIBorderColor = null;
    private static Color secondaryUIBorderColor = null;
    private static Color colorInactive = null;

    public DarkTheme() {
        this.lookAndFeel = new FlatDarkLaf();
    }

    @Override
    public void customInit() {
        plotBackgroundColor = this.lookAndFeel.getDefaults().getColor("Panel.background");
        plotForegroundColor = this.lookAndFeel.getDefaults().getColor("Button.foreground");
        UIBorderColor = this.lookAndFeel.getDefaults().getColor("Component.borderColor");
        secondaryUIBorderColor = this.lookAndFeel.getDefaults().getColor("Component.borderColor");
        colorInactive = this.lookAndFeel.getDefaults().getColor("Button.disabledBackground");
    }

    @Override
    public Color getPaletteColor(int n) {
        return PALETTE[n % PALETTE.length];
    }

    @Override
    public Color getHypolineRed() {
        return HYPOLINE_RED;
    }

    @Override
    public Color getHypolineBlue() {
        return HYPOLINE_BLUE;
    }

    @Override
    public Color getHypolineGreen() {
        return HYPOLINE_GREEN;
    }

    @Override
    public Color getHypolineGold() {
        return HYPOLINE_GOLD;
    }

    @Override
    public Color getZCenterColor() {
        return Z_CENTER_COLOR;
    }

    @Override
    public Color getHCenterColor() {
        return H_CENTER_COLOR;
    }

    @Override
    public Color getZSatteliteColor() {
        return Z_SATTELITE_COLOR;
    }

    @Override
    public Color getMEColor() {
        return ME_COLOR;
    }

    @Override
    public Color getAxisColor() {
        return AXIS_COLOR;
    }

    @Override
    public Color getPlotBackgroundColor() {
        return plotBackgroundColor;
    }

    @Override
    public Color getPlotForegroundColor() {
        return plotForegroundColor;
    }

    @Override
    public Color[] getPalette() {
        return PALETTE;
    }

    @Override
    public Color getUIBorderColor() {
        return UIBorderColor;
    }

    @Override
    public Color getSecondaryUIBorderColor() {
        return secondaryUIBorderColor;
    }

    @Override
    public Color getColorInactive() {
        return colorInactive;
    }

    @Override
    public Color getMapBackgroundColor() {
        return this.getPlotBackgroundColor();
    }

    @Override
    public Color getAltered(Color color) {
        return color.brighter();
    }

    @Override
    public Color getAlteredInverse(Color color) {
        return color.darker();
    }
}

