/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.themes;

import java.awt.Color;
import java.awt.Window;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public abstract class SuiteTheme {
    protected LookAndFeel lookAndFeel;

    public final void init() {
        try {
            UIManager.setLookAndFeel(this.lookAndFeel);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        this.customInit();
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    public abstract void customInit();

    public abstract Color getHypolineRed();

    public abstract Color getHypolineBlue();

    public abstract Color getHypolineGreen();

    public abstract Color getHypolineGold();

    public abstract Color getZCenterColor();

    public abstract Color getHCenterColor();

    public abstract Color getZSatteliteColor();

    public abstract Color getColorInactive();

    public abstract Color getMEColor();

    public abstract Color getAxisColor();

    public abstract Color getPlotBackgroundColor();

    public abstract Color getPlotForegroundColor();

    public abstract Color getMapBackgroundColor();

    public abstract Color getUIBorderColor();

    public abstract Color getSecondaryUIBorderColor();

    public abstract Color getPaletteColor(int var1);

    public abstract Color[] getPalette();

    public abstract Color getAltered(Color var1);

    public abstract Color getAlteredInverse(Color var1);
}

